comment
{
  The fractal types in this file are standard fractal types. Please do not modify this file!
}

Mandelbrot {
parameter complex start;
parameter complex power;
parameter real bailout;

	void init(void)
	{
		z=start;
	}
	void loop(void)
	{
		z=z^power + pixel;
	}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}
	void description(void)
	{
		this.title = "Mandelbrot";
		this.center = (-0.5, 0);
		this.magn = 1;
   
		start.caption = "Starting Point";
		start.default = (0,0);
		start.hint = "To obtain a true mandelbrot set, set this value to the critical point of the iteration formula, i.e. the null point of the first derivation of the iteration formula.";
  
   
		power.caption = "Power";
		power.default = (2,0);
		power.hint = "Choose the exponent of the iteration formula for the Mandelbrot set. Higher (int-) values just lead to some kind of rotation symmetry. So try fractional or even complex numbers.";
  
   
		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
  
	}
}


Julia {
// Generic Julia set
parameter complex power;
parameter complex seed;
parameter real bailout;

	void init(void)
	{
		z = pixel;
	}
	void loop(void)
	{
		z = z^power + seed;
	}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}
	void description(void)
	{
		this.title = "Julia";
		this.center = (0, 0);
		this.magn = 1;
   
		seed.caption = "Julia seed";
		seed.default = (-1.25,0);
		seed.hint = "Change this value as you like. Interesting Julia sets have seeds near the border of the Mandelbrot set.";
     
		power.caption = "Power";
		power.default = (2,0);
		power.hint = "Choose the exponent of the iteration formula for the Julia set. Higher (int-) values just lead to some kind of rotation symmetry. So try fractional or even complex numbers.";
  
   
		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";

	}
}

FastMandel
{
parameter complex Start;
parameter real Bailout;
bool abort;

	void init(void)
	{
		z=Start;
	}
	void loop(void)
	{
		abort=|z|<=Bailout;
		z=z*z+pixel;
	}
	bool bailout(void)
	{
		return(abort);
	}
	void description(void)
	{
		this.title="UF-Fast Mandel";
		this.center=(-0.5,0);
		this.angle=0;
		this.maxiter=100;
		this.periodicity=3;
		this.helpfile="http://www.chaospro.de/formulas/formulas.html";
		Start.caption="Starting Point";
		Start.default=(0,0);
		Start.hint="Start value for iteration, also called perturbation";
		Bailout.caption="Bailout";
		Bailout.default=4;
		Bailout.hint="Bailout value to use";
	}
}


FastJulia
{
// The name is somehow misleading
// This fractal type is not really fast
// It simply should work exactly as in UltraFractal
// And the type in UF has been speeded up.
// In order to reproduce it in ChaosPro, the formula
// looks somehow strange...
parameter complex Seed;
parameter real Bailout;
bool abort;
complex z_new;

	void init(void)
	{
		z=0;
		z_new=pixel;
	}
	void loop(void)
	{
		// Lets iterate in z_new, z contains the value from
		// the previous iteration...
		abort=|z|<=Bailout;
		z=z_new;
		z_new=z_new*z_new+Seed;
	}
	bool bailout(void)
	{
		return(abort);
	}
	void description(void)
	{
		this.title="UF-Fast Julia";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=100;
		this.periodicity=3;
		this.helpfile="http://www.chaospro.de/formulas/formulas.html";
		Seed.caption="Starting Point";
		Seed.default=(-1.25,0);
		Seed.hint="Start value for iteration, also called perturbation";
		Bailout.caption="Bailout";
		Bailout.default=4;
		Bailout.hint="Bailout value to use";
	}
}
