comment
{
  Here you can find quaternion formulas for use with ChaosPro
}

Quaternions(QUATERNION) {
parameter complex power;
parameter real bailout;
parameter int frmltype;
parameter quaternion p,perturb;
parameter quaternion c;
quaternion oldz,zprev;

	void init(void)
	{
		z=perturb+pixel;
		oldz=0;
	}
	void loop(void)
	{
		if (frmltype=="z^2-c")
		{
			z=sqr(z)-c;
		}
		else if (frmltype=="z^2+c")
		{
			z=z*z+c;
		}
		else if (frmltype=="z^3-c")
		{
			z=sqr(z)*z-c;
		}
		else if (frmltype=="z^3+c")
		{
			z=sqr(z)*z+c;
		}
		else if (frmltype=="z^4-c")
		{
			z=sqr(sqr(z))-c;
		}
		else if (frmltype=="z^4+c")
		{
			z=sqr(sqr(z))+c;
		}
		else if (frmltype=="c*z*(1-z)")
		{
			z=c*z*(1-z);
		}
		else if (frmltype=="z*z+z*c")
		{
			z=sqr(z)+z*c;
		}
		else if (frmltype=="z^3-z^2+c")
		{
			z=sqr(z)*z-sqr(z)+c;
		}
		else if (frmltype=="z^2+c/z")
		{
			z=sqr(z)+c/z;
		}
		else if (frmltype=="(z-c)*(z^2+c)+z^2")
		{
			z=(z-c)*(sqr(z)+c)+sqr(z);
		}
		else if (frmltype=="z*(1-z)+c")
		{
			z=z*(1-z)+c;
		}
		else if (frmltype=="z*z+oldz+c")
		{
			zprev=z;
			z=z*z+oldz+c;
			oldz=zprev;
		}
		else if (frmltype=="z*ln(z)-c")
		{
			z=z*ln(z)-c;
		}
		else if (frmltype=="z^p-c")
		{
			z=z^p-c;
		}
	}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}

	void description(void)
	{
		this.title = "Quaternion";

		frmltype.caption="Formula";
		frmltype.enum="z^2-c\nz^2+c\nz^3-c\nz^3+c\nz^4-c\nz^4+c\nc*z*(1-z)\nz*z+z*c\nz^3-z^2+c\nz^2+c/z\n(z-c)*(z^2+c)+z^2\nz*(1-z)+c\nz*z+oldz+c\nz*ln(z)-c\nz^p-c";
		frmltype.hint = "Please select an iteration formula to use.";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
		
		c.caption="c";
		c.default=(0.3,-0.44,-0.57,0.3);
		c.hint="Parameter for this formula";
		
		p.caption="Power";
		p.default=(2,0,0,0);
		p.visible = frmltype=="z^p-c";
		p.hint="Lets you specify the exponent for the formula";

		perturb.caption = "Starting Point";
		perturb.default = (0,0,0,0);
		perturb.hint = "Starting point for the iteration";
	}
}



Mandel3D(QUATERNION) {
parameter complex power;
parameter real bailout;
parameter quaternion p,perturb;
parameter quaternion c;
parameter real radiusPower;
parameter int modx,mody,modz;
real sx,sy,sz,sw;
real nx,ny,nz,nw;
real r,theta,phi,r2,r3,a,b;
parameter int fractaltype;
real cr,ci,cj,ck;
real pixelr,pixeli,pixelj,pixelk;
parameter real n;
parameter bool juliaMode;

	void init(void)
	{
		if (juliaMode) {
			z=pixel;
		} else {
			z=c;
		}
		sx=part_r(z);
		sy=part_i(z);
		sz=part_j(z);
		sw=part_k(z);

		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);

		pixelr=part_r(pixel);
		pixeli=part_i(pixel);
		pixelj=part_j(pixel);
		pixelk=part_k(pixel);
	}
	void loop(void)
	{
		if (fractaltype=="Type 3") {
			// {x,y,z}^n = r^n{cos(n*theta)cos(n*phi),sin(n*theta)cos(n*phi),-sin(n*phi)}
			r2=sqrt(sx^2+sy^2+sz^2);
			theta=atan2(sx+flip(sy));
			phi=atan2(sqrt(sx^2+sy^2)+flip(sz));
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*cos(n*theta)*cos(n*phi);
			ny=r3*sin(n*theta)*cos(n*phi);
			nz=r3*-sin(n*phi);
			nw=sw;
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
			}
			z=quaternion(sx,sy,sz,sw);
		} else if (fractaltype=="Mandelbulb") {
			r2=sqrt(sx^2+sy^2+sz^2);
			theta=atan2(sqrt(sx^2+sy^2)+flip(sz));
			phi=atan2(sy+flip(sx));
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*sin(n*theta)*cos(n*phi);
			ny=r3*sin(n*theta)*sin(n*phi);
			nz=r3*cos(n*theta);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
			}
			z=quaternion(sx,sy,sz,0);
		} else if (fractaltype=="Nylander") {
			r2=sqrt(sx^2+sy^2+sz^2);
			theta=n*atan2(sy+flip(sx));
			phi=n*asin(sz/r2);
			
			if (n==2) {
				r3=r2*r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(sqr(r2));
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(sqr(r2))*sqr(r2);
			} else if (n==7) {
				r3=sqr(sqr(r2))*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^n;
			}
			nx=r3*cos(theta)*cos(phi);
			ny=r3*sin(theta)*cos(phi);
			nz=-r3*sin(phi);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
			}
			z=quaternion(sx,sy,sz,0);
		} else if (fractaltype=="DanielWhite") {
			if (radiusPower==0.5) {
				r2=sqrt(sx^2+sy^2+sz^2);
			} else {
				r2=(sx^2+sy^2+sz^2)^radiusPower;
			}
			theta=atan2(sz+flip(sqrt(sx^2+sy^2)));
			phi=atan2(sx+flip(sy));
			
			if (n==2) {
				r3=r2;
			} else if (n==3) {
				r3=r2*r2*r2;
			} else if (n==4) {
				r3=sqr(r2);
			} else if (n==5) {
				r3=sqr(sqr(r2))*r2;
			} else if (n==6) {
				r3=sqr(r2)*r2;
			} else if (n==7) {
				r3=sqr(r2)*sqr(r2)*r2;
			} else if (n==8) {
				r3=sqr(sqr(sqr(r2)));
			} else {
				r3=r2^(n/2);
			}
			if (modx=="Standard") {
				nx=r3*sin(n*theta)*cos(n*phi);
			}  else if (modx==1) {
				nx=r3*sin(n*theta)*tan(n*phi);
			} else if (modx==2) {
				nx=r3*sin(n*theta)*sin(n*phi);
			} else if (modx==3) {
				nx=r3*cos(n*theta)*sin(n*phi);
			} else if (modx==4) {
				nx=r3*cos(n*theta)*cos(n*phi);
			} else if (modx==5) {
				nx=r3*cos(n*theta)*tan(n*phi);
			} else if (modx==6) {
				nx=r3*tan(n*theta)*sin(n*phi);
			} else if (modx==7) {
				nx=r3*tan(n*theta)*cos(n*phi);
			} else if (modx==8) {
				nx=r3*tan(n*theta)*tan(n*phi);
			}
			if (mody=="Standard") {
				ny=r3*sin(n*theta)*sin(n*phi);
			} else if (mody==1) {
				ny=r3*sin(n*theta)*cos(n*phi);
			} else if (mody==2) {
				ny=r3*sin(n*theta)*tan(n*phi);
			} else if (mody==3) {
				ny=r3*cos(n*theta)*sin(n*phi);
			} else if (mody==4) {
				ny=r3*cos(n*theta)*cos(n*phi);
			} else if (mody==5) {
				ny=r3*cos(n*theta)*tan(n*phi);
			} else if (mody==6) {
				ny=r3*tan(n*theta)*sin(n*phi);
			} else if (mody==7) {
				ny=r3*tan(n*theta)*cos(n*phi);
			} else if (mody==8) {
				ny=r3*tan(n*theta)*tan(n*phi);
			}
			
			if (modz=="Standard") {
				nz=r3*cos(n*theta);
			} else if (modz==1) {
				nz=r3*sin(n*theta);
			} else if (modz==2) {
				nz=r3*tan(n*theta);
			}
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
			}
			z=quaternion(sx,sy,sz,0);
		} 
	}
	bool bailout(void)
	{
		return(sx*sx+sy*sy+sz*sz<bailout);
	}

	void description(void)
	{
		this.title = "Mandel 3D";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
		
		c.caption="c";
		c.default=(0.3,-0.44,-0.57,0.3);
		c.hint="Parameter for this formula";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Mandelbulb\nNylander\nType 3\nDanielWhite";
		fractaltype.default=0;
		
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		n.caption="Power";
		n.default=3;
		n.min=2;
		n.hint="Power: Choose 3 to 8 for faster calculation";
		
		radiusPower.caption="Radius Power";
		radiusPower.default=0.5;
		radiusPower.hint="Default is 0.5, thus the square root. You may modify it, lower values like 0.2 give hilly versions, higher values like 0.9 give smooth versions";
		
		modx.caption="Modification x";
		modx.enum="Standard\nType 1\nType 2\nType 3\nType 4\nType 5\nType 6\nType 7\nType 8";
		modx.default=0;
		modx.hint="Chooses another method of assigning newx";

		mody.caption="Modification y";
		mody.enum="Standard\nType 1\nType 2\nType 3\nType 4\nType 5\nType 6\nType 7\nType 8";
		mody.default=0;
		mody.hint="Chooses another method of assigning newy";

		modz.caption="Modification z";
		modz.enum="Standard\nType 1\nType 2";
		modz.default=0;
		modz.hint="Chooses another method of assigning newz";
	}
}


QuatSphere(QUATERNION) {
parameter real bailout;
real mx,my,mz;

	void init(void)
	{
		z=pixel;
		mx=0;
		my=0;
		mz=0;
	}
	void loop(void)
	{
		z=pixel;
	}
	bool bailout(void)
	{
		return(sqrt(sqr(part_r(z)-mx)+sqr(part_i(z)-my)+sqr(part_j(z)-mz))< bailout);
	}

	void description(void)
	{
		this.title = "Quaternion Sphere";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
	}
}

MandelbulbDistanceEstimation(QUATERNION) {
parameter bool useDE;
parameter bool starFix;
parameter int n;
parameter real bailout;
parameter complex ep;
real sx,sy,sz;
real dzx,dzy,dzz,Rdz,thdz,phdz;
real nx,ny,nz;
complex sincos_phdz_7_phi,sincos_thdz_7_theta,sincos_n_phi,sincos_n_theta;
real sin_phdz_7_phi,cos_phdz_7_phi,sin_thdz_7_theta,cos_thdz_7_theta;
real sin_n_phi,cos_n_phi,sin_n_theta,cos_n_theta;
real r,theta,phi,r2,r3,a,b;
real rp2,rp4;
real cr,ci,cj;
parameter real threshold;
parameter real accuracy;
parameter vector perturb,c;
parameter bool juliaMode;
real starFixMin;

	void init(void)
	{
		if (juliaMode) {
			z=pixel;
			cr=partx(c);
			ci=party(c);
			cj=partz(c);
		} else {
			z=quaternion(partx(perturb),party(perturb),partz(perturb),0);
			cr=part_r(pixel);
			ci=part_i(pixel);
			cj=part_j(pixel);
		}
		
		// we basically iterate sx/sy/sz instead of z...
		sx=part_r(z);
		sy=part_i(z);
		sz=part_j(z);

		dzx=1;
		dzy=0;
		dzz=0;
		starFixMin=0.5;
	}
	void loop(void)
	{
		r2=sqrt(sx^2+sy^2+sz^2);
		theta=atan2(sx+flip(sy));
		
		a=sqrt(sx*sx+sy*sy);
		phi=atan2(a+flip(sz));
		//phi=asin(sz/r2);
		
		if (useDE) {
			if (starFix) {
				a=sqrt(sx*sx+sy*sy);
				if (a<starFixMin && numiter>0 && a>threshold*0.5) {
					starFixMin=a;
				}
			}
			Rdz=sqrt(dzx^2+dzy^2+dzz^2);
			thdz=atan2(dzx+flip(dzy));
			
			//phdz=asin(dzz/Rdz);
			phdz=atan2(sqrt(dzx*dzx+dzy*dzy)+flip(dzz));
		
			// Let's iterate dzx/dzy/dzz: First calculate the coords of it

			r=n*Rdz*r2^(n-1);

			// Let's iterate dzx/dzy/dzz: And finally assign the new values to dzx/dzy/dzz
			sincos_phdz_7_phi=sincos(phdz+(n-1)*phi);
			sin_phdz_7_phi=real(sincos_phdz_7_phi);
			cos_phdz_7_phi=imag(sincos_phdz_7_phi);
			
			sincos_thdz_7_theta=sincos(thdz+(n-1)*theta);
			sin_thdz_7_theta=real(sincos_thdz_7_theta);
			cos_thdz_7_theta=imag(sincos_thdz_7_theta);
			
			if (juliaMode) {
				dzx= r*cos_phdz_7_phi*cos_thdz_7_theta;
			} else {
				dzx= r*cos_phdz_7_phi*cos_thdz_7_theta+1;
			}
			dzy= r*cos_phdz_7_phi*sin_thdz_7_theta;
			dzz= r*sin_phdz_7_phi;
		}
		
		// Iterate sx/sy/sz (i.e. z itself): Calculate intermediate values
		sincos_n_phi=sincos(n*phi);
		sincos_n_theta=sincos(n*theta);
		
		sin_n_phi=real(sincos_n_phi);
		cos_n_phi=imag(sincos_n_phi);
		sin_n_theta=real(sincos_n_theta);
		cos_n_theta=imag(sincos_n_theta);

		r2=r2^n;
		// Iterate sx/sy/sz (i.e. z itself): Assign them!
		sx= r2*cos_n_phi*cos_n_theta+cr;
		sy= r2*cos_n_phi*sin_n_theta+ci;
		sz= r2*sin_n_phi+cj;
		

		// Now distance estimation: In case the pixel bailed out, calculate distance
		if (sx*sx+sy*sy+sz*sz>bailout && useDE) {
			Rdz=sqrt(dzx*dzx+dzy*dzy+dzz*dzz);
			r2=sqrt(sx^2+sy^2+sz^2);

			if (juliaMode) {
				a = r2*log(r2)/Rdz;
			} else {
				a = 0.5*r2*log(r2)/Rdz;
			}
			
			// Done distance estimation...now just compare with the threshold...setting it to 0 tells ChaosPro
			// that object has been hit (same as if maxiter has been reached)
			if (a<threshold) {
				a=0;
			} else {
				if (starFix) {
					if (starFixMin<0.25) {
						a=a*starFixMin*2;
						a=a*0.6;
					} else {
						a=a*0.6;
					}
				} else {
					a=a*0.6;
				}
			}
			// assign it to the final variable...
			estimatedDistance=a/accuracy;
		}
		z=quaternion(sx,sy,sz,0);
	}
	bool bailout(void)
	{
		return(sx*sx+sy*sy+sz*sz<bailout);
	}

	void description(void)
	{
		this.title = "Mandelbulb DE";

		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="Check if you want to generate a Julia type fractal";

		perturb.caption="Perturbation";
		perturb.default=(0,0,0);
		perturb.hint="Starting value for iteration";
		perturb.visible=(!juliaMode);

		c.caption="Julia Seed";
		c.default=(0.3,0.7,-0.55);
		c.hint="Starting value for iteration";
		c.visible=(juliaMode);
		
		
		useDE.caption="Use DE";
		useDE.default=true;
		useDE.hint="Use Distance Estimation";
		
		starFix.caption="Star Fix";
		starFix.default=false;
		
		bailout.caption = "Bailout Value";
		bailout.default = 1024.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
		
		n.caption="Power";
		n.default=8;
		n.min=2;
		n.hint="Power: Choose 3 to 8 for faster calculation";
		
		threshold.caption="Threshold";
		threshold.default=0.001;
		threshold.min=0;
		threshold.max=10000;
		
		accuracy.caption="Accuracy";
		accuracy.default=1;
		accuracy.min=0;
		accuracy.hint="Accuracy, avoids overstepping. The higher, the more accurate, the slower the rendering";
	}
}


