

ComplexNewton
{
parameter shared complex Exponent;
parameter complex Root;
parameter real Error;

complex z0;

	void init(void)
	{
		z=pixel;
	}
	void loop(void)
	{
		z0=z;
		z=((Exponent-1)*z-Root/z^(Exponent-1))/Exponent;
	}
	bool bailout(void)
	{
		return(|z-z0|>Error);
	}
	void description(void)
	{
		this.title="ComplexNewton";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=30;
		this.periodicity=3;
		this.helpfile="formulas.html";
		
		Exponent.default=(3,0);
		Exponent.hint="Value of a in 'z^a+b'";
		Root.default=(-1,0);
		Root.hint="Value of b in 'z^a+b'";
		Error.default=0.001;
	}
}








GeneralNewton
{

parameter real Error;

parameter int n;
parameter array a[2] of int;

complex z0;

complex fx(complex z)
{
	return(3*z^-3-2*z-1);
}
complex dfx(complex z)
{
	return(9*z^2-2);
}

	void init(void)
	{
		z=pixel;
	}
	void loop(void)
	{
		z0=z;
		z=z-fx(z)/dfx(z);
	}
	bool bailout(void)
	{
		return(|z-z0|>Error);//error
	}
	void description(void)
	{
		this.title="PolynomialNewton";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=100;
		this.periodicity=0;
		this.helpfile="formulas.html";
		Error.default = 0.001;
	}
}


GeneralHalley
{

parameter real Error;

parameter int n;
parameter array a[2] of int;

complex z0;

complex fx(complex z)
{
	return(3*z^-3-2*z-1);
}
complex dfx(complex z)
{
	return(9*z^2-2);
}
complex d2fx(complex z)
{
	return(18*z);
}

	void init(void)
	{
		z=pixel;
	}
	void loop(void)
	{
		z0=z;
		z=z-fx(z)/(dfx(z)-fx(z)*d2fx(z)/dfx(z)/2);
	}
	bool bailout(void)
	{
		return(|z-z0|>Error);//faster
		//return(|fx(z)|>Error);//slower
	}
	void description(void)
	{
		this.title="Halley2";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=30;
		this.periodicity=0;
		this.helpfile="formulas.html";
		
		Error.default = 0.001;
	}
}


Halley
{
parameter shared complex Exponent;
parameter complex Root;
parameter real Error;

complex z0;

complex fx(complex z)
{
	return(z^Exponent+Root);
}
complex dfx(complex z)
{
	return(Exponent*z^(Exponent-1));
}
complex d2fx(complex z)
{
	return(Exponent*(Exponent-1)*z^(Exponent-2));
}

	void init(void)
	{
		z=pixel;
	}
	void loop(void)
	{
		z0=z;
		z=z-fx(z)/(dfx(z)-fx(z)*d2fx(z)/dfx(z)/2);
	}
	bool bailout(void)
	{
		return(|z-z0|>Error);
	}
	void description(void)
	{
		this.title="Halley";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=10;
		this.periodicity=0;
		this.helpfile="formulas.html";
		
		Exponent.default=(3,0);
		Exponent.hint="Value of a in 'z^Exponent+b'";
		Root.default=(-1,0);
		Root.hint="Value of b in 'z^a+b'";
		Error.default=0.001;

	}
}


Householder
{
parameter shared complex Exponent;
parameter complex Root;
parameter real Error;

complex z0;
int n;

complex fx(complex z)
{
	return(z^Exponent+Root);
}
complex dnfx(complex z,int n)
{
	return(factorial(Exponent)/factorial(n)*z^(Exponent-n));
}
int factorial(int n);

int factorial(int n)
{
	if(n<=1)
	{
		return(1);
	}
	else
	{
		return(n*factorial(n-1));
	}
}

	void init(void)
	{
		z=pixel;
	}
	void loop(void)
	{
		z0=z;
		z=z-fx(z)/(dfx(z)-fx(z)*d2fx(z)/dfx(z)/2);
	}
	bool bailout(void)
	{
		return(|z-z0|>Error);
	}
	void description(void)
	{
		this.title="Householder";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=10;
		this.periodicity=0;
		this.helpfile="formulas.html";
		
		Exponent.default=(3,0);
		Exponent.hint="Value of a in 'z^Exponent+b'";
		Root.default=(-1,0);
		Root.hint="Value of b in 'z^a+b'";
		Error.default=0.001;

	}
}
