// Found in wikipedia. + variations. by Edgars Malinovskis. 09.11.2001. Plain geometry so best with advanced colours.
Tricorn {
// Found in wikipedia. + variations. by Edgars Malinovskis. 09.11.2011. Plain geometry so best with advanced colours. 
//Quaternion Friendly!  23.11.2001 by Edgars Malinovskis. inverted quat julia 03.12.2011
// + 2 quaternin friendly formulas and unit vector generating grass features. 24.01.2011.
// + Julia seed in mandelbrot (map). 23.02.2012
// + rewritten UV addition formula backwards coz then it calculates faster. 05.03.2012.

parameter real bailout;
parameter int settype, Power;
parameter bool testInverted, vectored;
parameter complex julia, coefVector;
quaternion C;

void init(void)
 {
 	 if (testInverted==true && settype=="Julia Set")
	 {
	z = recip(pixel);
	 C = julia;
	}
     else if (settype=="Julia Set")
    {	
	z = pixel;
	C = julia;
    }
    else if (testInverted==true && settype=="Mandelbrot Set")
	 {
	 z = 0;
	 C= recip(pixel);
	 }
    else
    {
	z=0;
	C=pixel;
    }
}

void loop(void)	
{
		if (Power=="Tricorn")   
		{
		z= sqr(z);
		z= quaternion ( imag(z) , real(z), part_k(z), part_j(z) ) + C; //flip function for quaternion
		}
		else if (Power=="Quadrcorn")
		{
		z= sqr(z)*z;
		z= quaternion ( real(z) , -imag(z), part_j(z), -part_k(z) ) +C; //~conj function for quaternion
		}
		else if (Power=="Pentacorn")
		{
		z= sqr(z)*sqr(z);
		z= quaternion ( imag(z) , real(z), part_k(z), part_j(z) ) + C;
		}
		else if (Power=="Hexacorn")
		{
		z= sqr(z)*sqr(z)*z;
		z= quaternion ( real(z) , -imag(z), part_j(z), -part_k(z) ) +C;
		}
		else if (Power=="Heptacorn")
		{
		z= sqr(z)*sqr(z)*sqr(z);
		z= quaternion ( imag(z) , real(z), part_k(z), part_j(z) ) + C;
		}
		else if (Power=="Octacorn")
		{
		z= sqr(z)*sqr(z)*sqr(z)*z;
		z= quaternion ( real(z) , -imag(z), part_j(z), -part_k(z) ) +C;
		}
		else if (Power=="TenthPower")
		{
		z= sqr(z)*sqr(z)*sqr(z)*sqr(z)*sqr(z);
		z= quaternion ( imag(z) , real(z), part_k(z), part_j(z) ) + C;
		}

			else if (Power=="Bumblebrot 1")
			{
			z=sqr(sqr(z)/( (1,1)+z)   +C);
			z= quaternion ( imag(z) , real(z), part_k(z), part_j(z) );
			}
			else if (Power=="Bumblebrot 2")
			{
			z=sqr(z*z*z/( (1,1)+sqr(z))   +C);
			z= quaternion ( imag(z) , real(z), part_k(z), part_j(z) );
			}			
			
	if (vectored==true)
	{
	if (cabs(z)!=0)
	{
	z=z/cabs(z)*coefVector +z;
	}		
	else
	{
	z=z + 1.0E-15;
	}
	}
}

bool bailout(void)
	{
		return( |z| <= bailout);
	}
void description(void)
	{
		this.title = "Tricorn (Quaternion friendly)";
		this.helpfile="http://en.wikipedia.org/wiki/Tricorn_(mathematics)";

		bailout.caption = "Bailout Value";
		bailout.default = 64.0;
		bailout.min = 0.5;
		bailout.hint = "Defines the bailout radius: If pixel falls out of it, the iteration stops. Larger number increases details";

    Power.caption = "Corner Power";
    Power.enum = "Tricorn\nQuadrcorn\nPentacorn\nHexacorn\nHeptacorn\nOctacorn\nTenthPower\nBumblebrot 1\nBumblebrot 2";
    Power.default = 0;

    settype.caption = "Set type";
    settype.enum = "Mandelbrot Set\nJulia Set";
    settype.default = 0;

    testInverted.caption="Inverted Set";
    testInverted.default=false;

	vectored.caption="+ Unit Vector";
	vectored.default = false;
	
	coefVector.caption="Vector factor";
	coefVector.default = (0.2,0);
	coefVector.visible = (vectored==true);
	
	separator.label.caption  = "For Julia sets";
    julia.caption = "Julia Parameter";
    julia.default = (0.45,0.5);
    julia.hint = "Different values create different Julia Sets.";

	}
}