
// Generates menorah like figures. Hyperbolised spider + variables change. 28.10.2001 by Edgars Malinovskis.
Menorah_Fractal{
//Quaternion Friendly!  23.11.2001 by Edgars Malinovskis. Optimised 27.11.2011.
// + More powers. 20. 01. 2012.
// + fifth power = 4 sided fractal.

parameter int settype;
parameter real bailout, multi;
quaternion c, p;
complex w;
parameter int power;

	void init(void)
	{
	
		if (settype=="Real Coefficient")
    {	
    	 c = 1/pixel;
	 z = c;
	 p = c;		//allways 1/pixel.
	 w=multi*0.01+0.5;		//+-1/100 gives results.
    }
		else if (settype=="Imaginary Coefficient")
	 {
	 c = 1/pixel; 
	 z = c;
	 p = c;
	 w=multi*0.01i+0.5;
	}
		else 
	 {
	 c = recip(pixel); 
	 z = c;
	 p = c;
	 w=tan(multi)*0.01+0.5;
	}
}
	void loop(void)
	{
	if (power=="Square")
	{
		z=sqr(z)+c+p;		//spider formula + 1/pixel
		c=w*c+z;	
	}
	else if (power=="Cube")
	{
		z=sqr(z)*z+c+p;
		c=w*c+z;	
	}
	else if (power=="Forth")
	{
		z=sqr(sqr(z))+c+p;
		c=w*c+z;	
	}
	else if (power=="Fifth")
	{
		z=sqr(sqr(z))*z+c+p;
		c=w*c+z;	
	}	
	
	}
	bool bailout(void)
	{	
		return(  abs(real(z))+ abs(imag(z))<= bailout  );
	}
	void description(void)
	{
		this.title = "Menorah Fractal (Quaternion friendly)";
		this.magn = 0.25;

		power.caption = "Formula exponent";
		power.enum = "Square\nCube\nForth\nFifth";
		power.default = 0;
		
		bailout.caption = "Bailout";
		bailout.default = 7.0;
		bailout.min = 1;
		bailout.hint = "Defines the bailout radius: If pixel falls out of it, the iteration stops. Larger number increases details";

		multi.caption = "Menorah Coeff";
		multi.default = 0;
		multi.hint = "Increases multiplicator by 1/100. Changes fractal geometry.";

		settype.caption = "type(if MC is not 0)";
		settype.enum = "Real Coefficient\nImaginary Coefficient\nTan Coeff + Recip inverse";
		settype.default = 0;
		settype.hint = "Add real, imaginary or tangential value to the multiplicator of the Fractal. Only if the Menorah Coefficient is nonZero.";
		
	}
}
