// formula z=z*sinh(z)+C*C  09.11.2001 by Edgars Malinovskis, first in Fractal Explorer 5 years agou.
MalinovskyDecoFractal {
// formula z=z*sinh(z)+C*C  09.11.2001 by Edgars Malinovskis, first in turbo pascal 5 years agou.
// In soft it appeared with my name, but deco sound nice.
// + more exponents and C^2 are calculated before loop, so a bitt faster.
// + Julia seed in mandelbrot (map). 23.02.2012

// 05.11.2013.
//+ pixel mapping function.
//+ more bailout options, alsou then with oldz
//+ Phoenix/ Manowar version could be made, 
//+ fisheye.

parameter int settype, mwphoenix, bailoutcondition;
parameter complex julia;
parameter real bailout, lowerbailout;
complex C, oldz, oldestz;
parameter bool testBroken, Pixelstart, usefisheye,pixelstart;
parameter int power;
int zpower;
real fisheyeplus;
parameter real fishstrenght, distortion, distortion2;
bool bailed;


	void init_once(void)
	{
		zpower=power-1;
		fisheyeplus=fishstrenght+1;
	}

void init(void)
 {

//fish eye, C becomes temporary pixel.
C=pixel;	
if  (usefisheye)
{
C=(fishstrenght+cabs(C) )/fisheyeplus*C;
} 
C=func_post(C); 
 
	if (settype=="Julia Set")
	{	
	z = C;
	C = julia;
	}
	else if (settype=="Inverted Mandelbrot Set")
	 {
	 z= 0;
	 C= 1/C;
	 }
	 else if (testBroken==true) //recreates z=pixel features
	 {
	 z = (1,0.5);    //other values are useless
	 C= C;
	 }
	 else if (Pixelstart==true) // as original implementation in fractal explorer
	 {
	 z=C;
	 C=C;
	}
	 else
	{
	z= 0;
	C= C;
	}
C=C^power;  //to fasten up things
		bailed= false;
		oldz=z;
		oldestz=z;
}

void loop(void)
{

		oldestz=oldz;
		oldz=z;

		z= sinh(z)*z^zpower- C;

		if  (mwphoenix==1)
		{
			z=z+oldz;
		}
		else if  (mwphoenix==2)
		{
			z=z+oldz*distortion;
		}
		else if  (mwphoenix==3)
		{
			z=z+oldz*distortion+oldestz*distortion2;
		}


		//here comes bailout
		if  (bailoutcondition==0)
		{
			// this bailout generates leave pattern as do formula
			if  (abs(real(z))+abs(imag(z)) > bailout)
			{
				bailed=true;
			}
		}
		else if  (bailoutcondition==1)
		{

			if ( |z| > bailout)
			{
				bailed=true;
			}
		}
		else if  (bailoutcondition==2)
		{

			if (|z| > bailout|| |z- oldz| < lowerbailout)
			{
				bailed=true;
			}
		}
	}
	bool bailout(void)
	{
		return(bailed==false);
	}

void description(void)
	{
		this.title = "Malinovsky Deco Fractal";
		this.magn = 0.92;

	power.caption = "Set power";
	power.default=2;
	 
	Pixelstart.caption="initial z=pixel";
	Pixelstart.default=false;
	Pixelstart.visible = (settype=="Mandelbrot Set");

    settype.caption = "Set type";
    settype.enum = "Mandelbrot Set\nJulia Set\nInverted Mandelbrot Set";
    settype.default = 0;

		separator.label2.caption  = "bailouts";
 
		bailoutcondition.caption = "Bailout Type";
		bailoutcondition.default= 0;
		bailoutcondition.enum = "SumOfAbsolutes\nModulus (squared)\nDual";
		bailoutcondition.hint="Allows to chose bailout condition. Modulus squared |z| is a tradition from Fractint thus some color methods could work better with it. Dual is simmilar to that of magnet.";
 
		bailout.caption = "Bailout Value";
		bailout.default =  777;
		bailout.min = 1;
		bailout.hint = "This parameter defines how soon an orbit bails out while iterating. Large values reveals satelite julias.";
 
		lowerbailout.caption = "Convergent bailout";
		lowerbailout.default =  0.00005;
		lowerbailout.min = 0;
		lowerbailout.visible =  (bailoutcondition==2);
		lowerbailout.hint = "This parameter defines how soon a convergent orbit bails out while iterating. Smaller values give more precise results but usually require more iterations.";


	separator.label3.caption  = "For Julia sets";
    julia.caption = "Julia Parameter";
    julia.default = (0,0.5);
    julia.hint = "Different values create different Julia Sets.";

	separator.label4.caption  = "Mutations";
	
		mwphoenix.caption="Phoenix/Manowar";
		mwphoenix.default= 0;
		mwphoenix.enum="None\nManowar\nPhoenix\nSimurgh";
		mwphoenix.hint="Adds oldz, thus it works like Phoenix or Manowar formulas";
 
		distortion.visible= (mwphoenix==2 || mwphoenix==3);
		distortion.caption = "Distortion";
		distortion.default =  0.5;
		distortion.hint = "Sets how 'strong' the previous iteration's effect should be on the fractal. 1 is manowar.";
 
		distortion2.visible= ( mwphoenix==3);
		distortion2.caption = "Distortion";
		distortion2.default =  -0.25;
		distortion2.hint = "Sets how 'strong' the second previous iteration's effect should be on the fractal.";
 
    testBroken.caption="Broken Fractal";
    testBroken.default=false;
    testBroken.visible = (settype=="Mandelbrot Set");

		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		usefisheye.caption ="Fish Eye";
		usefisheye.default =  false;
		usefisheye.hint="Applies Fish Eye transformation to mapping (pixel values).";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (usefisheye);
		fishstrenght.default= 2;
		fishstrenght.hint="Denomintor, decreesing value increases effect.";

separator.label5.caption  = "http://edo555.deviantart.com/";

	}
}


