Formula_colection {
// Colection of sophisticated escapetime formulas. 
// Don't know all the authorship (all formulas are public) and implementing variables would be harder, so sorry.
// By Edgars Malinovskis 22.12.2011. + 2 formula 29.12.2011. +1 formula and variables 03.01.2012. 
// Changed 2 formulas to more usefull ones 07.01.2012.
// + Newtonian Moon, inverted version of good old FE formula. z=(K+1)*z- (z^N - z)/(N*z^(N-1)-1) + 1/c
// - division by zero. 20.01.2012.
// + Julia seed in mandelbrot (map). 23.02.2012

parameter real bailout;
parameter bool testInverted;
parameter int settype, formula, coefPow, coefPowMD;
parameter complex julia;
parameter double coefMG, coefTri, LunarVector, realD, imagD, fmD;
parameter complex coefTalis, coefTails,  coefMD, coefMoon;
complex c, v, zpixel, zone, z0, coefLunar, imagDi;
bool BailedOut;
real nwtbailout;
int Powminus1;

	void init(void)
{
 	 if (testInverted==true && settype=="Julia Set")
	 {
	 z = recip (pixel);
	zpixel = z;
	 c = julia;
	 zone=z; 
	}
     else if (settype=="Julia Set")
    {	
	z = pixel;
	zpixel = z;
	c = julia;
	zone=z; 
    }
    else if (testInverted==true && settype=="Mandelbrot Set")
	 {
	 z = 0;
	 zpixel = pixel;
	 c= recip(pixel);
	 zone=1; 
	 }
    else
    {
	z = 0;
	zpixel = pixel;
	c = pixel;
	zone=1; 
    }
	coefLunar= coefMoon+1;   //trying to fasten up calculations
	nwtbailout= 0.0001/bailout;
	Powminus1= coefPow-1;
	imagDi=imagD*1i;
}
	void loop(void)
	{
	
		if (formula == "z=z^2*c^0.1+c Peterson")
		{
		z=z^2 * c^0.1 + c;
		}
		
	else if (formula == "Tails z=z+K/z+c")
	{
	zone = (zone+coefTails/zone) + c; //tails initial z=1
	z=zone;   //Fractal Explorer formula
	}
		
		else if (formula == "Newtonian Moon")
		{
		z0=z;  //Based on Fractal Explorer formula
		z=coefLunar*z- (z^coefPow-z)/(coefPow*z^(Powminus1)-1) + 1/c;
		if (LunarVector!=0)
		{
		z=z+LunarVector*(z/(1+cabs(z))); //unit vector for newton
		}
		}
		 
	else if (formula == "Carlson continiued fraction function")
	 {
	 v = z^coefPow + c; 
	 z = v - (1/(v + 1/(v + 1/(v + 1/(v + 1/(v + 1))))));
	}
		
		else if (formula == "Kaliset z=abs(zC+D)+1/abs(zC+D)")
		{
		//by Pablo Roman Andrioli.
		zpixel= abs(zpixel*c+fmD)+ 1/abs(zpixel*c+fmD);
		z=zpixel;
		}
		
	else if (formula == "z=z^z-z^5+c")
	{
	z = z^z - z^5 + c;  //by Clifford A. Pickover
	}
		
		else if (formula == "Kaliset z=abs(z)/c+c")
		{
		z=abs(z)/c+c;  //by Pablo Roman Andrioli. He have his own software
		}
		
	else if (formula == "Fm z=(z*z*C+D)+1/(z*z*C+D)")
	{
	//by Fracmonk aka Jeffrey Barthelmes http://www.fractalforums.com/index.php?topic=4881.msg25998#msg25998 
	z=z*z*c+fmD+1/(z*z*c+fmD);
	}
	
		else if (formula == "Secant Sea z=(r(z)/cos(i(z)),i(z)/cos(r(z)))+c")
		{
		z = complex(real(z)/cos(imag(z)), imag(z)/cos(real(z))) + c; //thorn fractal aka "Secant Sea"
		}
		
	else if (formula == "Szegedi Butterfly z=(i(z)^2-sqrt(abs(r(z))),r(z)^2-sqrt(abs(i(z))))+c")	
	{
	z = complex(imag(z)^2 - sqrt(abs(real(z))), real(z)^2 - sqrt(abs(imag(z))) ) + c;  //Szegedi Butterfly
	}
		
		else if (formula == "Fractovia z=0.9z*atanh(z)+c")		
		{
		z = 0.9*z*atanh(z) + c;
		}

	else if (formula == "Pinwheels z=(1,0.5)sin(z)+c")
	{		
	z = complex(1, 0.5) * sin(z) + c;
	}
		
		else if (formula == "z=z^2N-2*z^N+c")
		{
	   	z = z^(2*coefPow) - 2*z^coefPow + c; 
		}
		
	else if (formula == "z=z^4-(K*z+1.5)/c Trilobite")
	{
	z= z^4 - (coefTri*z + 1.5)/c; //by Edgars Malinovskis
	}

		else if (formula=="Kaliset z=abs(z)/(z+D+C)+C")
		{
		z=abs(z)/(z+fmD+c) + c;	//by Edgar Malinovsky
		}

	else if  (formula == "Talis z=z*z/(K+z)+c")
	{	// from Fractal Explorer
	z=z^coefPow/(coefTalis+z^Powminus1) +c;
	}
			
		else if  (formula == "z=z/K-z^7+1/c Star")
		{
		 z=z/coefMD-z^coefPowMD+ 1/c; //by Edgar Malinovsky
		}
			
	else if  (formula == "z=sinh(abs(z^-1))+c")
	{
	z=sinh(abs(z^-1))+c; //Kaliset variations
	}
			
		else if (formula=="Collatz Conjecture")
		{
		c=0.25*(2+7*c-(2+5*c)*cos(pi*c));
		z=c;
		}
			
	else if (formula == "z=(((((z^2c)+D)^2)-D)^2)-D")
	{
	z=(((((z^2*c)+realD)^2)-realD)^2)-realD; //by Fracmonk aka Jeffrey Barthelmes http://www.fractalforums.com/index.php?topic=4881.msg25998#msg25998 
	}
			
		else if (formula=="z=(((((z^3)c+D)^3)+D)^3)+D")
		{
		z= (((((z^3)*c+imagDi)^3)+imagDi)^3)+imagDi;  //by Fracmonk aka Jeffrey Barthelmes http://www.fractalforums.com/index.php?topic=4881.msg27524#msg27524 
		}
			
	else if (formula=="MandelGrassBrot")
	{
	z= z^coefPow+c;
	if (cabs(z)!=0)
	{
	z=z + coefMG*z/cabs(z);	//by Edgars Malinovskis
	}
	else
	{
	z=z+0.1;
	}
	// "+" coeff generates flora like outsides "-" generates rings, with julia use -1
	}
// Newton and mandel bailout
		if (formula == "Newtonian Moon")
		{
				if(|z-z0|>nwtbailout)
				{
				BailedOut=true;
				}
				else
				{
				BailedOut=false;
				}
		}
		else
		{
				if(  |z|  <= bailout)
				{
				BailedOut=true;
				}
				else
				{
				BailedOut=false;
				}
		}	
	}
	bool bailout(void)
	{
		return(BailedOut);
	}
	void description(void)
	{
		this.title="Formula 2D colection";
		this.helpfile="http://www.fractalforums.com/new-theories-and-research/is-there-anything-novel-left-to-do-in-m-like-escape-time-fractals-in-2d/";
		this.periodicity=0;
		
		bailout.caption = "Bailout Value";
		bailout.default = 15.0;
		bailout.min = 0.5;
    
    formula.caption = "Use Formula";
    formula.enum = "z=z^2*c^0.1+c Peterson\nTails z=z+K/z+c\nNewtonian Moon\nCarlson continiued fraction function\nKaliset z=abs(zC+D)+1/abs(zC+D)\nz=z^z-z^5+c\nKaliset z=abs(z)/c+c\nFm z=(z*z*C+D)+1/(z*z*C+D)\nSecant Sea z=(r(z)/cos(i(z)),i(z)/cos(r(z)))+c\nSzegedi Butterfly z=(i(z)^2-sqrt(abs(r(z))),r(z)^2-sqrt(abs(i(z))))+c\nFractovia z=0.9z*atanh(z)+c\nPinwheels z=(1,0.5)sin(z)+c\nz=z^2N-2*z^N+c\nz=z^4-(K*z+1.5)/c Trilobite\nKaliset z=abs(z)/(z+D+C)+C\nTalis z=z*z/(K+z)+c\nz=z/K-z^7+1/c Star\nz=sinh(abs(z^-1))+c\nCollatz Conjecture\nz=(((((z^2c)+D)^2)-D)^2)-D\nz=(((((z^3)c+D)^3)+D)^3)+D\nMandelGrassBrot";
    formula.default = 0;	 
	 
    settype.caption = "Set type";
    settype.enum = "Mandelbrot Set\nJulia Set";
    settype.default = 0;
	 
	realD.caption = "real D";
	realD.default = 1.0;
	realD.visible = (formula=="z=(((((z^2c)+D)^2)-D)^2)-D");		 
	
	imagD.caption = "imaginary D";
	imagD.default = 1.0;
	imagD.visible = (formula=="z=(((((z^3)c+D)^3)+D)^3)+D");	
	
	fmD.caption = "determinant D";
	fmD.default = 1.0;
	fmD.visible = (formula=="Kaliset z=abs(zC+D)+1/abs(zC+D)" ||formula=="Fm z=(z*z*C+D)+1/(z*z*C+D)" || formula=="Kaliset z=abs(z)/(z+D+C)+C");
	 
    testInverted.caption="Inverted Set";
    testInverted.default=false;
	 
	coefMG.caption = "Grassiness Coeff";
	coefMG.default = -0.5;
	coefMG.visible = (formula=="MandelGrassBrot");
	
	coefTalis.caption = "Talis Coefficient K";
	coefTalis.default = (1,0);
	coefTalis.visible = (formula=="Talis z=z*z/(K+z)+c");
	coefTalis.max = 2;
	
	coefTails.caption = "Tails Coefficient K";
	coefTails.default = (1.0,0);
	coefTails.visible = (formula=="Tails z=z+K/z+c");
	coefTails.min = 0;
	
	coefPow.caption = "Power N";
	coefPow.default = 2;
	coefPow.visible = (formula=="Carlson continiued fraction function" || formula=="z=z^2N-2*z^N+c" || formula=="MandelGrassBrot" || formula=="Talis z=z*z/(K+z)+c" ||formula=="Newtonian Moon");
	coefPow.min = 2;
	coefPow.max = 7;
	
	coefPowMD.caption = "Power N";
	coefPowMD.default = 7;
	coefPowMD.visible = (formula=="z=z/K-z^7+1/c Star");
	
	coefMoon.caption = "Lunar geometry";
	coefMoon.default = (0,0);
	coefMoon.visible = (formula=="Newtonian Moon");	
	
	LunarVector.caption = "+Unit Vector";
	LunarVector.default = 0;
	LunarVector.visible = (formula=="Newtonian Moon");	
	
	coefTri.caption = "Trilobite Coefficient K";
	coefTri.default = 2.3;
	coefTri.visible = (formula=="z=z^4-(K*z+1.5)/c Trilobite");

	coefMD.caption = "MogenDavid Coef K";
	coefMD.default = (2,0);
	coefMD.visible = (formula=="z=z/K-z^7+1/c Star");
	
	separator.label.caption  = "For Julia sets";
    julia.caption = "Julia Parameter";
    julia.default = (-0.5,0.5);
	}
}

UVectorMandelBrot {
// Mandelbrot variation, in each iteration adding value to the unit vector
// Factor 0.15 generates grass like fractals, -0.3 mandelbrots with rings
// -1 reveals julias made out of rings.
// Added ideas found in Tobby Marshall implementation "Unit Vector Explorer"
// And in Kerry Mitchell "Unit Vector Tweaked Mandelbrot". 
// Still, original idea are mine;)

// Interesting enought, cabs |modulus function| using 8 power creates different results than standart square cabs.
// by Edgars Malinovskis 7.02.2012
// + Julia seed in mandelbrot (map). 23.02.2012
// + rewritten UV addition formula backwards coz then calculates faster. 05.03.2012.
//You may redistribute this algorithm, modify, derivate or use comercialy
// as you wish as long as you give proper credits.

parameter bool testInverted;
complex C;
parameter complex start;
parameter int settype;
parameter double power;
parameter int vectype;
parameter real bailout;
parameter complex julia, vfactor;

	void init(void)
	{

 	 if (testInverted==true && settype=="Julia Set")
	 {
	z = recip (pixel);
	 C = julia;
	}
     else if (settype=="Julia Set")
    {	
	z = pixel;
	C = julia;
    }
    else if (testInverted==true && settype=="Mandelbrot Set")
	 {
	 z = 0;
	 C= recip(pixel);
	 }
    else
    {
	C=pixel;
	z=0;
    }

	}
	void loop(void)
{
z= z^power+ C;

		if  (vectype=="+Z/cabs(Z)" && cabs(z) != 0)
		{
		z= z/cabs(z)*vfactor +z;
		}
		
		else if  (vectype=="+Z/abs(r)+abs(i)" && abs(real(z))+abs(imag(z)) != 0)
		{
		z=z/(abs(real(z))+abs(imag(z)))*vfactor +z;
		}
		
		else if  (vectype=="+cosZ/cabs(Z)" && cabs(z) != 0)
		{
		z= cos(z/cabs(z) )*vfactor +z;
		}
		
		else if  (vectype=="+Z/power 8 modulus" && (real(z)^8+imag(z)^8)^0.125 != 0)
		{
		z=z/( (real(z)^8+imag(z)^8)^0.125 )*vfactor +z;
		// why does cabs function using power 8 gives result other than using 2??? 
		}
		 
		else if (vectype=="+Z/conj(Z)" && (z)!=0)
		{
		z=z/conj(z)*vfactor +z;
		}
		
		else if (vectype=="+Z/sqr(Z)" && sqr(z)!=0)
		{
		z=z/sqr(z)*vfactor +z;
		}
			
		else if (vectype=="+Z/recip(Z)" && recip(z)!=0)
		{
		z=z/recip(z)*vfactor +z;
		}
		
		else if (vectype=="+Z/abs(Z)" && abs(z)!=0)
		{
		z=z/abs(z)*vfactor + z;
		}
		
		else if (vectype=="+Z/ln(Z)" && ln(z)!=0)
		{
		z=z/ln(z)*vfactor + z;
		}
		
		else if (vectype=="+Z/exp(Z)" && exp(z)!=0)
		{
		z=z/exp(z)*vfactor +z;
		}
		
		else if (vectype=="+Z/acosh(Z)" && acosh(z)!=0)
		{
		z=z/acosh(z)*vfactor +z;
		}
		
		else if (vectype=="xZ/cabs(z)" && cabs(z)!=0)
		{
		z=z/cabs(z)*z;
		}
		
		else
		{
		z=z+1.0E-15;
		}
}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}
	void description(void)
	{
		this.title = "UnitVector MandelBrot";
		this.center = (-0.5, 0);
		this.periodicity = 0;
		this.helpfile="http://www.fractalforums.com/new-theories-and-research/is-there-anything-novel-left-to-do-in-m-like-escape-time-fractals-in-2d/";
		
	settype.caption = "Set type";
	settype.enum = "Mandelbrot Set\nJulia Set";
	settype.default = 0; 
 
		power.caption = "Power";
		power.default =  2;
		power.hint = "This parameter sets the exponent for the formula.";
 
		bailout.caption = "Bailout Value";
		bailout.default =  100.0;
		bailout.min = 1.0;
 
		vectype.caption="Unit Vector Addition";
		vectype.default= 0;
		vectype.enum="+Z/cabs(Z)\n+Z/abs(r)+abs(i)\n+cosZ/cabs(Z)\n+Z/power 8 modulus\n+Z/conj(Z)\n+Z/sqr(Z)\n+Z/recip(Z)\n+Z/abs(Z)\n+Z/ln(Z)\n+Z/exp(Z)\n+Z/acosh(Z)\nxZ/cabs(z)";
 
		vfactor.caption = "Vector Tweak Factor";
		vfactor.default= (0.15,0);
		vfactor.visible= (vectype!="xZ/Cabs(Z)");
 
    testInverted.caption="Inverted Set";
    testInverted.default=false;

	separator.label.caption  = "For Julia sets";
    julia.caption = "Julia Parameter";
    julia.default = (-0.45,0.5);
    julia.hint = "Different values create different Julia Sets.";
 
		start.caption = "Starting Point";
		start.default =  (0,0);
		start.hint = "The starting point parameter can be used to distort the set.";
	}
}


Zuzubrot {
// Made this by trying to implement version of true 3D mandelbrot set 
// and making a mistake. Based on work of Francisco de Asis Fernandes Diaz
// about cyclic numbers and little bit of mine.
// http://www.fractalforums.com/index.php?topic=9842.0

// Similar to kalisets, but of chekuer squares and crosses.
// As with kalisets, details is revealed by exponent
// smoothing or twin lamps with small (colour) iteration values.  

// by Edgar Malinovsky 12.02.2012.
// + Julia seed in mandelbrot (map). 23.02.2012
// You may redistribute this algorithm, modify, derivate or use comercialy as you wish as long as you give proper credits.

//04.09.2013 + few more functions of z.

parameter real bailout;
parameter int settype, function;
parameter bool testInverted;
parameter complex julia, perturb;
complex C;
real zx, zy, zzx, zzy, zzw, Cx, Cy;
parameter float talisfactor;

void init(void)
 {
 	 if (testInverted==true && settype=="Julia Set")
	 {
	z = recip(pixel);
	C = julia;
	}
     else if (settype=="Julia Set")
    {	
	z = pixel;
	C = julia;
    }
    else if (testInverted==true && settype=="Mandelbrot Set")
	 {
	 z= perturb;
	 C= recip(pixel);
	 }
    else
    {
	z= perturb;
	C= pixel;
    } 

		Cx=real(C);
		Cy=imag(C);
				
}		
void loop(void)	
{

		zx=real(z);
		zy=imag(z);		  
	 //replication of my mistake I made implementing in 3D;              
								
	zzx=zx*zx+zy*zy+Cx;
	zzw=12*zx*zy+12*zy*zy; // just for a half-newton bailout.
	zzy=2*zy*zx+Cy;

	  zx=zzx;
	  zy=zzy;
z= complex(zzx, zzy);

		if  (function=="Abs")
		{
			z=abs(z);
		}
		else if  (function=="Conj")
		{
			z=conj(z);
		}
		else if  (function=="Naked singularity")
		{
			z=z;
		}
		else if  (function=="Square")
		{
			z=sqr(z);
		}
		else if  (function=="Talis")
		{
			z=sqr(z)/(z+talisfactor);
		}
		else if  (function=="Perpendicular Ru")
		{
			z= abs(real(z))-flip(imag(z));
		}

}
bool bailout(void)
	{
	return(  abs(zzx-zzw)+ abs(zzy)  <= bailout );
	}
void description(void)
	{
		this.title = "Zuzubrot";
		this.helpfile="http://www.fractalforums.com/index.php?topic=9842.0";

		bailout.caption = "Bailout Value";
		bailout.default = 12.0;
		bailout.min = 0.5;
		bailout.hint = "Larger number increases detalisation";

    settype.caption = "Set type";
    settype.enum = "Mandelbrot Set\nJulia Set";
    settype.default = 0;

    testInverted.caption="Inverted set";
    testInverted.default=false;
	 
		function.caption="Post function";
		function.default= 0;
		function.enum="Naked singularity\nAbs\nConj\nSquare\nTalis\nPerpendicular Ru";
 
		talisfactor.caption="Talis Factor";
		talisfactor.visible =  (function==4);
		talisfactor.default= 0.4;
		talisfactor.hint="Factor n for z=z*z/(z+n)";

    perturb.caption = "Calculation Start";
    perturb.default = (0.5,0);
    perturb.hint = "Starts calculation with this number. 4th value is unused";
    perturb.visible = (settype=="Mandelbrot Set");
	 
	separator.label.caption  = "For Julia sets";
    julia.caption = "Julia Parameter";
    julia.default = (-1.6,0);
	}
}


QuadraticGen	{
//by Jos Hendriks, origianally in Fractint, about 1990       	
// Implementation by Edgar Malinovsky 09.04.2012.
// Generalisation of Mandelbrot, Tricorn, my Zuzubrot and
// everything quadratic in between. Good for square patterns. 
// X = K*X^2 + L*Y^2 + M*X*Y  + C			
// Y = O*X^2 + P*Y^2 + Q*X*Y  + C			
// Coefficients 1,-1,0,0,0,2 generates Mandelbrot set.  
// -1,1,0,0,0,2 are Tricorn fractal.

// From fractalforums thread:
// http://www.fractalforums.com/index.php?topic=11008.0
// Try inside colouring and julias or left of Mset
// or with Abs and bottom of Mset.
// Goes better with analytical colour methods.	

//04.09.2013 + few more functions of z.

real zx,zy, zzx,zzy;
complex c;
real unit;
parameter int settype;
parameter bool inverted;
parameter complex julia;
parameter real p1,p2,p3,p4,p5,p6;
parameter int function, vectype;
parameter complex vfactor;
parameter real bailout;
parameter float talisfactor;

	void init(void)
	{

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=1/pixel;
			}
			else
			{
				c=pixel;
			}
			z=0;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				z= 1/pixel;
			}
			else
			{
				z= pixel;
			}
			c=julia;
		}

	}
	void loop(void)
	{
		zx=real(z);
		zy=imag(z);

		zzx=sqr(zx)*p1+ sqr(zy)* p2+ p3*zx*zy;
		zzy=sqr(zx)*p4+ sqr(zy)*p5+ p6*zx*zy;
		z=complex(zzx,zzy) + c;
             
		if  (function=="Abs")
		{
			z=abs(z);
		}
		else if  (function=="Conj")
		{
			z=conj(z);
		}
		else if  (function=="None")
		{
		}
		else if  (function=="Square")
		{
			z= sqr(z);
		}
		else if  (function=="Talis")
		{
			z=sqr(z)/(z+talisfactor);
		}
		else if  (function=="SZA Butterfly")
		{
			z=complex( sqr(imag(z)) - sqrt(abs(real(z))) , sqr(real(z)) - sqrt(abs(imag(z) )));
		}
		else if  (function=="Perpendicular Ru")
		{
			z=complex( abs(real(z)),-imag(z));
		}
		else if  (function=="Celtic")
		{
			z=z-c;
			z=z- real(z) + abs(real(z)) - c;
		}

		if  (vectype== "z/modulus(z)")
		{
			unit= cabs(z);
			if  (unit!= 0)
			{
				z=z/unit* vfactor+ z;
			}
		}
	}
	bool bailout(void)
	{
		return(|z|< bailout);
	}
	void description(void)
	{
		this.title = "Quadratic General";
		this.magn = 1;
		this.center = (-0.5, 0);
		this.periodicity = 0;
		this.helpfile="http://www.fractalforums.com/index.php?topic=11008.0";
 
		bailout.caption = "Bailout Value";
		bailout.default =  128;
		bailout.min = 0.5;
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		inverted.caption ="Inverted Set";
		inverted.default =  false;
		inverted.hint="The same as circle inverse but implemented in equation.";

		separator.label2.caption  = "Polynimial Coefficients.";
 
		p1.caption = "X= coef K* x^2";
		p1.default= 1.0;
 
		p2.caption = "X= coef L* y^2";
		p2.default= 1.0;
 
		p3.caption = "X= coef M* xy";
		p3.default= 0;
 
		p4.caption = "Y= coef O* x^2";
		p4.default= 0;
 
		p5.caption = "Y= coef P* y^2";
		p5.default= 0;
 
		p6.caption = "Y= coef Q* xy";
		p6.default= 2.4;
 
 		separator.label3.caption  = "After modifications."; 

		function.caption="Post function";
		function.default= 0;
		function.enum="None\nAbs\nConj\nSquare\nTalis\nSZA Butterfly\nPerpendicular Ru\nCeltic";
 
		talisfactor.caption="Talis Factor";
		talisfactor.visible =  (function==4);
		talisfactor.default= 0.4;
		talisfactor.hint="Factor n for z=z*z/(z+n)";
 
		vectype.caption="Unit Vector";
		vectype.default= 0;
		vectype.enum="None\nz/modulus(z)";
 
		vfactor.caption = "Vector add Factor";
		vfactor.default= (-0.3, 0);
		vfactor.visible =  (vectype=="z/modulus(z)");
		
 		separator.label4.caption  = "For Julia set";
		julia.caption="Julia Seed";
		julia.default= (-1.6, 0);
	}
}


Kalisetes_Sefirii	{

// Collection of kaliset type pattern formulas
// formulas 3,4,7 are my original inovation,
// rest were found in internet, mostly in softologyblog.
// Sefir stands for space filling rotation.

// All requires low maximum iteration value and
// inside colouring. 
// Formulas 3,4,7 are my own find, rest were 
// found in softologyblog, kaliset concept is
// based on work of Pablo Roman Andrioli. 

// Formulas 1 and 2 are the most typical kalisets, 1st one
// have 'outside' patterns in m-brot mode and a more complex julias,
// so I put it 1st. Formulas 3 and 4 (Sefir) are most fun to use.
// by Edgar Malinovsky 30.04.2012

// 24.09.2013
// + mixing together 2 formulas
// by alternation or random sequences.
// like in EA lucky and
// + asinh Ducky Lite as in Ed Algra's Lucky script.

real zerod, unit, modulus;
parameter real d, bailout;
complex c;
parameter int settype, equation, vectype,equation2,mode;
parameter complex julia, fscale, vfactor;
float fisheyeplus;
parameter float fishstrenght;
int formulapick;
parameter bool inverted;
int iter,seed;
parameter int seedinput;


	void init_once(void)
	{
		zerod=d-1;
		fisheyeplus=fishstrenght+1;
	}
	void init(void)
	{
		if  (mode==0)
		{
			formulapick=equation;
		}	
		iter=1;
		seed= seedinput;


		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
				c=func_post(c);
			}
			z=0;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				c=julia;
				z=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
			}
			else
			{

				c=julia;
				z= pixel;
			}
			z=func_post(z);
		}

	}
	void loop(void)
	{


		// formula alternation code
		if  (mode==1)
		{
			//alternation
			if  (iter==1)
			{
				formulapick=equation;
			}
			else
			{

				formulapick=equation2;
				iter=0;
			}

		}
		else if  (mode==2)
		{
			//random more cXaOTic
			seed= random(seed);
			iter= trunc( abs(seed) /(randomrange/2));

			//iter values alternates between 0 and 1.
			if  (iter==0)
			{
				formulapick=equation;
			}
			else
			{

				formulapick=equation2;
			}

		}
		else if  (mode==3)
		{
			//random more equal
			seed= random(seed);
			iter= abs (seed%2);

			//iter values alternates between 0 and 1.
			if  (iter==0)
			{
				formulapick=equation;
			}
			else
			{

				formulapick=equation2;
			}

		}
		else if  (mode==4)
		{
			//randomly chose one of 8 formulas
			seed= random(seed);
			formulapick= trunc( abs(seed) /(randomrange/8));

		}

		//here starts fractal formulas
		if  (formulapick==0)
		{
			z=abs(z+zerod)/c*fscale+c;
			//z=scale*abs(z+D-1)/c +c
		}
		else if  (formulapick==1)
		{
			// some formulas needs to be initialised with z=pixel.
			if  (z==0)
			{
				z=z+ pixel;  //1.0e-15   ;or else formula wount initialise.
			}

			z=abs(1/(z+zerod) )*fscale+ c;
			//z=scale*abs[1/(z+D-1)]+c
		}
		else if  (formulapick==2)
		{
			z=z+zerod;
			modulus= |z|;
			if  (modulus==0)
			{
				z=0;
			}
			else if  (modulus<1)
			{
				z=z/modulus;
			}
			z=z*c*fscale+c;
			//z=scale*circlefold (z+D-1)*c +c by Edgar Malinovsky
		}
		else if  (formulapick==3)
		{
			z=z+zerod;
			modulus= |z|;
			if  (modulus==0)
			{
				z=0;
			}
			else if  (modulus<1)
			{
				z=z/modulus;
			}
			z=z/c*fscale+ c;
			//z=scale*circlefold(z+D-1)/c+c by Edgar Malinovsky
		}
		else if  (formulapick==4)
		{

			if  (z==0)
			{
				z=z+ pixel;  //1.0e-15   ;or else formula wount initialise.
			}

			z=z+zerod;
			z= fscale/abs(z*z*z) + c;
			//z=scale/abs[(z+D-1)^3]+c
		}
		else if  (formulapick==5)
		{

			if  (z==0)
			{
				z=z+ pixel;  //1.0e-15  ;or else formula wount initialise.
			}

			z=(abs(z*c+d)+ 1/abs(z*c+d) )*fscale;
			//z=scale*[abs(z*c+D)+1/abs(z*c+D)]
		}
		else if  (formulapick==6)
		{
			z=abs(z)/(z+ d+ c)*fscale+ c;
			//z=scale*abs(z)/(z+D+c)+c  by Edgar Malinovsky
		}
		else if  (formulapick==7)
		{
			z= asinh(abs(z+zerod))*fscale+ c;
			//z = asinh(abs(z)) + c     As in Ed Algra Lucky.
		}
		

		if  (vectype== "z/modulus(z)")
		{
			unit= cabs(z);
			if  (unit!= 0)
			{
				z=z/unit* vfactor+ z;
			}
		}
	
		iter=iter+1;	
	}
	bool bailout(void)
	{
		return(|z|< bailout);
	}
	void description(void)
	{
		this.title = "Kalisets n Sefir";
		this.maxiter = 40;
		this.periodicity = 0;

		separator.label2.caption  = "Use 'inside' colouring.";
		 separator.label3.caption  = "j - for julia set, mj - for julia and m-brot.";
		
		mode.caption="Formula Mode";
		mode.default= 0;
		mode.enum= "Single Formula\nAlternation\nRandom cXaOTic\nRandom Equal\nfoRMuLa cXaOs";
		mode.hint="Calculate just one formula, each iteration alternate between 2 formulas, or randomly pick which formula to use. Random numbers then could be with more chaotic and more equal distribution. Or just randomly chose between 7 formulas. Last version could be good with number -5.";
 
		seedinput.caption = "Lucky Number";
		seedinput.default =  0;
		seedinput.visible =  (mode==2 || mode==3|| mode==4);
		seedinput.hint = "Each seed will generate different fractal. Each seed generates different sequence of random numbers, and it don't depends, is it -1 or 600001. ";
 
		equation.caption="Fractal Formula";
		equation.default= 0;
		equation.visible =  (mode!=4);
		equation.hint="1-z=scale*abs(z+D-1)/c+c; 2-z=scale*abs[1/(z+D-1)]+c; 3-z=scale*circlefold(z+D-1)*c+c; 4-z=scale*circlefold(z+D-1)/c+c; 5-z=scale/abs[(z+D-1)^3]+c; 6-z=scale*[abs(z*c+D)+1/abs(z*c+D)]; 7-z=scale*abs(z)/(z+D+c)+c;  z = scale*asinh(abs(z + D-1)) + c;";
		equation.enum="1- kaleido Kaliset j\n2- original Kaliset j\n3- Sefir mj\n4- Sefir mj\n5- power3 Kaliset j\n6- dual Kaliset mj\n7- Talis Kaliset mj\n8- Asinh Ducky j";
 
		equation2.caption="Second Formula";
		equation2.default= 1;
		equation2.visible =  (mode==1 || mode==2|| mode==3);
		equation2.hint="Contr- formula in some of iterations replacing first.";
		equation2.enum="1- kaleido Kaliset j\n2- original Kaliset j\n3- Sefir mj\n4- Sefir mj\n5- power3 Kaliset j\n6- dual Kaliset mj\n7- Talis Kaliset mj\n8- Asinh Ducky j";
 
		bailout.caption = "Bailout Value";
		bailout.default =  777000;
		bailout.min = 0.5;
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";

		 separator.label4.caption  = "For Julia set.";		
		julia.caption="Julia Seed";
		julia.default= (-0.52, 0.52);

		separator.label5.caption  = "Fractal pattern depends on iteration value.";
 
		d.caption = "determinant D";
		d.default= 1.0;
		d.hint="Depending on formula adds to z this number or D-1 value. Talis like coefficient for finetuning of fractal.";
 
 		fscale.caption = "Scale";
		fscale.default= (1.0,0);
		fscale.hint="Multiplicator applied to formula before adding c-constant value. Mandelbox like factor for tuning of fractal.";
 
 		separator.label6.caption  = "Mutations";
 
		inverted.caption ="Fish eye";
		inverted.default =  false;
		inverted.hint="Fish eye transform of screen pixels.";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (inverted);
		fishstrenght.default= 1;
		fishstrenght.hint="Strenght of Fish Eye. Stronger Fish Eye effect is 0 - 1, larger facor decreeses strenght. Large negative values <-3.5 generates an opposite effect.";
		func_post.caption="Mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves the plane, on which fractal is drawn, so only ident m-brot set is map for julia sets. Recip works as circle inverse.";

		vectype.caption="Unit Vector addition";
		vectype.default= 0;
		vectype.hint="Modification applied after main equation. Depending on formula negative factor could generate rings, positive shrunks the fractal, and imaginary value rotates it. With kalisets this can change curves.";
		vectype.enum="None\nz/modulus(z)";
 
		vfactor.caption = "Vector add Factor";
		vfactor.default= (-0.31, -0.41);
		vfactor.visible =  (vectype=="z/modulus(z)");
		
	}
}


Swirlbrot {
// Formula based on kram1032 found transformation.
// Used for calculation of gravitational waves
// Of 2 rotating neutron stars.
// First made for buddhabrot.
// + multiplication by iterations for more variance.
// and few other formulas exept Mbrot.
// by Edgar Malinovsky 12.12.2012
// Fish Eye instead of inverted 21.01.2012 

//04.09.2013 + few more functions of z.

complex c;
parameter int settype;
parameter bool inverted;
parameter complex julia;
int iter;
parameter float frequency, spin, itermult, bailout,talisfactor;
parameter int formula;
parameter int power;
parameter bool itermultiplied;

	void init(void)
	{
		c=0;

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(1+cabs(pixel) )/2*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
				c=func_post(c);
			}
			z=0;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				z=(1+cabs(pixel) )/2*pixel;
			}
			else
			{

				z=pixel;
			}
			c=julia;
			z=func_post(z);
		}

		iter=0;
	}
	void loop(void)
	{
		//Swirl transform
		z=exp(complex(0, frequency*cabs(z)+spin*atan2(z))  ) *z;

		//standart formula
		if  (formula==0)
		{
			z=z^power;
		}
		else if  (formula==1)
		{
			z=conj(z)^power;
		}
		else if  (formula==2)
		{
			z= z*0.5 - z^(power+5);
		}
		else if  (formula==3)
		{
			z=sinh(z)*z^(power-1);
		}
		else if  (formula==4)
		{
			z=z^power;
			z=sqr(z)/(z+talisfactor);
		}
		else if  (formula==5)
		{
			z=complex( sqr(imag(z)) - sqrt(abs(real(z))) , sqr(real(z)) - sqrt(abs(imag(z) )));
		}
		else if  (formula==6)
		{
			z=z^power;
			z=complex( abs(real(z)),-imag(z)) ;
		}
		else if  (formula==7)
		{
			z=z^power;
			z=z- real(z) + abs(real(z));
		}

		if   (itermultiplied)
		{
			z=z*iter*itermult;
		}
//adding c
		if  (formula==3)
		{
			z=z- c^power;
		}
		else if  (formula==7)
		{
			z=z-c;
		}
		else
		{

			z=z+c;
		}

		iter=iter+1;
	}
	bool bailout(void)
	{
		return(cabs(z) < bailout);
	}
	void description(void)
	{
		this.title = "Swirlbrot";
		this.periodicity = 0;
 
		bailout.caption = "Bailout Value";
		bailout.default =  1000.0;
		bailout.min = 1.0;
		bailout.hint = "This parameter defines how soon an orbit bails out while iterating.";
 
		power.caption = "Power";
		power.default =  2;
		power.hint = "This parameter sets the exponent for the formula.";
 
		formula.caption="Fractal Formula";
		formula.default= 0;
		formula.enum= "Mandelbrot\nTricorn\nStarbrot\nMalinovskyDeco\nTalis\nSZA Butterfly\nPerpendicular Ru\nCeltic";
 
		talisfactor.caption="Talis Factor";
		talisfactor.visible =  (formula==4);
		talisfactor.default= 0.5;
		talisfactor.hint="Factor n for z=z^pow; z=z*z/(z+n)";

		separator.label2.caption  = "Swirl";
  
		frequency.caption="Frequency";
		frequency.default= 0.5;
		frequency.hint="How strongly swirls.";
   
		spin.caption="Spin Number";
		spin.default= 0.5;
		spin.hint="Each 0.5 of spin gives additional simmetry axis.";

		separator.label3.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0.3, 0.6);

		separator.label4.caption  = "Mutations";
 
		itermultiplied.caption ="x Iterations";
		itermultiplied.default =  false;
		itermultiplied.hint="At each iteration multiplies result of formula by iteration number x coefficient. Don't works with Julia sets.";
 
		itermult.caption="multiplication factor";
		itermult.visible =  (itermultiplied);
		itermult.default= 0.05;
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		inverted.caption ="Fish Eye";
		inverted.default =  false;
		inverted.hint="Applies Fish Eye transformation to pixel values (mapping).";
	}
}


Pauldebrot {
//Complex 2-variable quadratic system
// by Paul Derbyshire aka Pauldebrot.
// http://www.fractalforums.com/ultrafractal/complex-2-variable-quadratic-experiment/
// implementation by Edgar Malinovsky 21.01.2013

//04.09.2013 + few more functions of z.

complex c, ws;
parameter int settype;
parameter bool inverted;
parameter complex seed, julia;
complex w;
parameter complex seed2;
parameter real wfactor;
parameter int zfunction;
parameter real bailout;
parameter int switchsettype;
parameter float talisfactor;

	void init(void)
	{

		c=0;
		ws=0;

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(2+cabs(pixel) )/3*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
				c=func_post(c);
			}
			z=seed;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				c=julia;
				z=(2+cabs(pixel) )/3*pixel;
			}
			else
			{

				c=julia;
				z=pixel;
			}
			z=func_post(z);
		}

		w= seed2;
	}
	void loop(void)
	{
		ws= sqr(w);
		w= w/z*(wfactor);
		z= sqr(z) + ws;

		//now adding c and introducing tricorn and burning ship versions
		if  (zfunction=="None")
		{
			z=z+c;
		}
		else if  (zfunction=="Tricorn")
		{
			z=conj(z)+c;
		}
		else if  (zfunction=="Burning Ship")
		{
			z=abs(z)+c;
		}
		else if  (zfunction=="Square")
		{
			z=sqr(z) +c;
		}
		else if  (zfunction=="Talis")
		{
			z=sqr(z)/(z+talisfactor)+c;
		}
		else if  (zfunction=="SZA Butterfly")
		{
			z=complex( sqr(imag(z)) - sqrt(abs(real(z))) , sqr(real(z)) - sqrt(abs(imag(z) ))) +c;
		}
		else if  (zfunction=="Perpendicular Ru")
		{
			z=complex( abs(real(z)),-imag(z)) +c;
		}
		else if  (zfunction=="Celtic")
		{
			z=z- real(z) + abs(real(z)) - c;
		}
	}
	bool bailout(void)
	{
		return(|z| < bailout);
	}
	void description(void)
	{
		this.center = (-0.5,0);
		this.maxiter = 250;
		this.periodicity = 0;
		this.title = "Pauldebrot";
		this.helpfile="http://www.fractalforums.com/ultrafractal/complex-2-variable-quadratic-experiment/";

		separator.label2.caption  = "Formula Block";
 
		seed.caption = "Mbrot Seed";
		seed.default =  (0,1);
		seed.visible =  (settype=="Mandelbrot");
 
		seed2.caption = "Seed of W";
		seed2.default =  (1,0);
 
		wfactor.caption = "Factor of W";
		wfactor.default =  0.5;
 
		bailout.caption = "Bailout";
		bailout.default =  10000.0;
		bailout.min = 0;
  
		separator.label3.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0.3, 0.6);

		separator.label4.caption  = "Mutations";
 
		zfunction.caption="Z function";
		zfunction.default= 0;
		zfunction.enum="None\nTricorn\nBurning Ship\nSquare\nTalis\nSZA Butterfly\nPerpendicular Ru\nCeltic";
 
		talisfactor.caption="Talis Factor";
		talisfactor.visible =  (zfunction==4);
		talisfactor.default= 0.25;
		talisfactor.hint="Factor n for z=z*z/(z+n)";
 
		inverted.caption ="Fish Eye";
		inverted.default =  false;
		inverted.hint="Applies Fish Eye transformation to pixel values (mapping)."; 
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
	}
}


LogicTurtle {
// by Edgar Malinovsky 02.04.2013
// z=z^2+-c
// Adds or substracts depending on comparision.
// If modulus of z is smaller than
// of c, c is added, if larger c is
// substracted. if equal it stays z^2.
// Fractal consists repeating finite elements, but is conformal.
// Hence logic and turtle.

//04.09.2013 + few more functions of z.

complex c;
parameter int settype;
parameter bool inverted;
parameter complex julia;
int iter;
parameter int formula;
float cabsz,cabsc;
parameter int power;
parameter bool itermultiplied;
parameter float itermult, bailout, talisfactor;

	void init(void)
	{
		c=0;

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(1+cabs(pixel) )/2*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
				c=func_post(c);
			}
			z=0;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				z=(1+cabs(pixel) )/2*pixel;
			}
			else
			{

				z= pixel;
			}
			c=julia;
			z=func_post(z);
		}

		iter=0;
	}
	void loop(void)
	{
		//Variations
		if  (formula==0)
		{
			//nothing
		}
		else if  (formula==1)
		{
			z=abs(z);
		}
		else if  (formula==2)
		{
			z= conj(z);
		}
		else if  (formula==3)
		{
			z=sqr(z)/(z+talisfactor);
		}
		else if  (formula==4)
		{
			z= complex(abs(real(z)),-imag(z));
		}
		else if  (formula==5)
		{
			z=z- real(z) + abs(real(z));
		}

		//formula starts here
		cabsz=cabs(z);
		cabsc=cabs(c);

		if  (cabsz< cabsc)
		{
			z= (z)^power+ c;
		}
		else if  (cabsz== cabsc)
		{
			z= (z)^power;
		}
		else
		{
			z= (z)^power- c;
		}

		//Variations
		if   (itermultiplied)
		{
			z=z*iter*itermult;
		}
		iter=iter+1;
	}
	bool bailout(void)
	{
		return(|z| < bailout);
	}
	void description(void)
	{
		this.title = "LogicTurtle";
		this.periodicity = 0;
		this.helpfile="http://www.fractalforums.com/mandelbrot-and-julia-set/shattered-fractal/";

		separator.label2.caption  = "Formula Block";
 
		bailout.caption = "Bailout Value";
		bailout.default =  1000.0;
		bailout.min = 1.0;
		bailout.hint = "This parameter defines how soon an orbit bails out while iterating.";
 
		power.caption = "Power";
		power.default =  2;
		power.hint = "This parameter sets the exponent for the formula.";

		separator.label3.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0.3, 0.6);

		separator.label4.caption  = "Mutations";
 
		formula.caption="Formula Variations";
		formula.default= 0;
		formula.enum= "Mandelbrot\nBurning Ship\nTricorn\nTalis\nPerpendicular Ru\nCeltic";
 
		talisfactor.caption="Talis Factor";
		talisfactor.visible =  (formula==3);
		talisfactor.default= 0.5;
		talisfactor.hint="Factor n for z=z*z/(z+n)";
 
		itermultiplied.caption ="x Iterations";
		itermultiplied.default =  false;
		itermultiplied.hint="At each iteration multiplies result of formula by iteration number x coefficient. Don't works with Julia sets.";
 
		itermult.caption="multiplication factor";
		itermult.visible =  (itermultiplied);
		itermult.default= 0.05;
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		inverted.caption ="Fish Eye";
		inverted.default =  false;
		inverted.hint="Applies Fish Eye transformation to pixel values (mapping).";

		separator.label5.caption  = "Z=Z^2+-C";
		// separator.label5.text ="Z=Z^2+-C If modulus of Z is smaller than of C, C is added, if larger C is substracted. If they are equal it stays Z^2. Fractal consists self simmilar finite elements and is conformal. Hence logic and turtle.";
	}
}


RandomPower {
// Iterates random power mandelbrot. UF
// random number generator isn't realy,
// hence fractal shape depends on seed.
// by Edgars Malinovskis 17. 04. 2013
//http://www.fractalforums.com/mandelbrot-and-julia-set/iterating-random-powers/ 

// 21.09.2012. Following changes:
// + with Minimal r it will generate real power julias, too.
// + Few more reflection based formulas.
// + minimal power value from which RND power starts.
// + another random sequence generator generating more equal distribution.

float fisheyeplus;
parameter float fishstrenght, minpower;
int seed;
parameter int power;
complex c, randpower;
parameter int settype, rndtype;
parameter bool inverted;
parameter complex julia;
int iter, rrandpower,irandpower;
parameter int rndpower, range, formula;
parameter bool itermultiplied;
parameter float itermult, bailout;


	void init_once(void)
	{
		fisheyeplus=fishstrenght+1;
	}
	void init(void)
	{
		seed= power;

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
				c=func_post(c);
			}
			z=0;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				c=julia;
				z=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
			}
			else
			{

				c=julia;
				z= pixel;
			}
			z=func_post(z);
		}

		iter=0;
	}
	void loop(void)
	{
		//random power
		rrandpower= seed= random(seed);
		irandpower= seed= random(seed);

		//ggenerates random power in range.
		if  (rndtype==0)
		{
			// more chaotic sequences.
			if  (rndpower==0)
			{
				randpower=complex( abs( (rrandpower) /(randomrange/range)) , abs( (irandpower) /(randomrange/range) )  )   +minpower;
			}
			else if  (rndpower==1)
			{
				randpower= abs( (rrandpower) /(randomrange/range))   +minpower;
			}
		}
		else if   (rndtype==1)
		{
			//more equaly distributed sequences.
			if  (rndpower==0)
			{
				randpower= complex(abs(rrandpower%range) , abs(irandpower%range)  )  +minpower;
			}
			else if  (rndpower==1)
			{
				randpower=  abs(rrandpower%range)  +minpower;
			}
		}
	
		//formula
		if  (formula==0)
		{
			//mandelbrot
			z=z^randpower;
		}
		else if  (formula==1)
		{
			//burning ship
			z=abs(z)^randpower;
		}
		else if  (formula==2)
		{
			//Perpendicular Ru
			z=z^randpower;
			z= abs(real(z))-flip(imag(z));
		}
		else if  (formula==3)
		{
			//Perpendicular Ru
			z= abs(real(z))-flip(imag(z));
			z=z^randpower;
		}
		else if  (formula==4)
		{
			//Celtic
			z=z^randpower;
			z=z- real(z) + abs(real(z)) - 2*c;
		}
		else if  (formula==5)
		{
			//SZA Butterfly
				z=  complex(imag(z),0)^randpower - complex(abs(real(z)),0)^recip(randpower)+  flip(  complex(real(z),0)^randpower  - complex(abs(imag(z) ),0)^recip(randpower ));
					}

		//mutation
		if   (itermultiplied)
		{
			z=z*iter*itermult;
		}
		//formula + c
		z=z+c;

		iter=iter+1;
	}
	bool bailout(void)
	{
		return(|z| < bailout);
	}
	void description(void)
	{
		this.title = "RandomPower";
		this.periodicity = 0;
		this.helpfile = "http://www.fractalforums.com/mandelbrot-and-julia-set/iterating-random-powers/";
 
		bailout.caption = "Bailout Value";
		bailout.default =  777000000000.0;
		bailout.min = 1.0;
		bailout.hint = "This parameter defines how soon an orbit bails out while iterating.";
 
 		separator.label1.caption  = "Formula Block";
		
		rndpower.caption="RND Power";
		rndpower.default= 0;
		rndpower.enum= "Complex\nReal";
		rndpower.hint = "Use real or complex numbers as powers of fractal.";
 
		rndtype.caption="RND Type";
		rndtype.default= 0;
		rndtype.enum= "cXaOTic\nEqual";
		rndtype.hint="Not all Random numbers are equaly random. One formula generates more chaotic distribution in range, another more equal. 1,2,2,2,5 vs 1,4,2,3,5. First one is more random."; 
 
		power.caption = "Random Seed";
		power.default =  0;
		power.hint = "Each seed will generate different fractal. Each seed generates different sequence of random numbers, and it don't depends, is it -1 or 600001. ";
 
		range.caption = "Power Range";
		range.default =  5;
		range.hint = "Maximal exponent values of both real and imaginary numbers. Should be kept simmilar to default.";
 
		minpower.caption = "Minimal r Power";
		minpower.default =  0;
		minpower.hint = "Minimal real power value. With Minimal r >0 it will generate real power julias as z^0 destroys julias. Real power values varies from minimal to minimal+range.";
 
		formula.caption="Fractal Formula";
		formula.default= 1;
		formula.hint="Mandelbrot + formulas introducing reflection + SZA butterfly.";
		formula.enum= "Mandelbrot\nBurningShip\nPerpendicular Ru after\nPerpendicular Ru before\nCeltic\nSZA Butterfly";

		separator.label2.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (-1.5, 0.1);

		separator.label3.caption  = "Mutations";
 
		inverted.caption ="Fish eye";
		inverted.default =  false;
		inverted.hint="Fish eye transform of screen pixels.";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (inverted);
		fishstrenght.default= 1;
		fishstrenght.hint="Strenght of Fish Eye. Stronger Fish Eye effect is 0 - 1, larger facor decreeses strenght. Large negative values <-3.5 generates an opposite effect.";
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		itermultiplied.caption ="x Iterations";
		itermultiplied.default =  false;
		itermultiplied.hint="At each iteration multiplies result of formula by iteration number x coefficient. Don't works with Julia sets.";
 
		itermult.caption="multiplication factor";
		itermult.visible =  (itermultiplied);
		itermult.default= 0.05;

//Iterates z=z^RND + c fractal with power chosen 
//randomly on each iteration in a range  
//0 < RND < Power Range. 
//Since (pseudo) random number sequences are determined 
//by random seed, each seed generates different 
//fractal. Probably the most interesting are Julia 
//sets with random complex powers. Good with Smooth 
//(Mandelbrot), Smooth Tanh or Wave Trichrome. 
// http://www.fractalforums.com/mandelbrot-and-julia-set/iterating-random-powers

	}
}


Crystalfractal {
//Barnsley fish like fractal formula by tyebillion. 
//+ a dual newton and mandelbrot bailot conditions 
//like of magnet formula.  Nice julia sets
//and a pretty ordinary mandelbrot set zooms, but 
//maybe someone can get something with inside colouring.       
//http://www.fractalforums.com/index.php?topic=14745.msg56868#msg56868";

//"Back in the nineties I wrote a fractal generator program called Minifrac, 
//written in Delphi which I never finished and never released.  
//The program was unremarkable except that it had two fractal variations 
//(Crystal 1 and Crystal 2) that I found myself, and also a nice palette generator.  
//Below is the Pascal code for the two Crystal fractals for anyone who is interested." :tyebillion
//http://www.fractalforums.com/index.php?topic=14745.msg56868#msg56868

//here by Egar Malinovsky 16.08.2013.

float fisheyeplus;
parameter float fishstrenght;
complex c;
float Var_x,Var_y, oldx,oldy, cx,cy, temp, olderx,oldery;
parameter int settype;
parameter bool inverted, riselast;
parameter complex julia;
complex oldz;
parameter float addval, riselastpower, bailout, lowerbailout;

	void init_once(void)
	{
		fisheyeplus=fishstrenght+1;
	}
	void init(void)
	{
		olderx=0;
		oldery=0;

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
				c=func_post(c);
			}
			z=0;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				c=julia;
				z=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
			}
			else
			{

				c=julia;
				z=pixel;
			}
			z=func_post(z);
		}

		cx=real(c);
		cy=imag(c);
		Var_x=real(z);
		Var_y=imag(z);

	}
	void loop(void)
	{
//formula
		oldz=z;

		oldx=Var_x;
		oldy=Var_y;

		if  (Var_x>= 0)
		{
			temp= Var_x- olderx;
			Var_y= Var_y- oldery;
			Var_x= cx*temp- cy*Var_y+ addval;
			Var_y= cx*Var_y+ cy*temp;
		}
		else
		{

			temp= Var_x+ olderx;
			Var_y= Var_y+ oldery;
			Var_x= cx*temp- cy*Var_y- addval;
			Var_y= cx*Var_y+ cy*temp;
		}

		olderx=oldx;
		oldery=oldy;

		z=complex(Var_x, Var_y);

//here starts mutations
		if   (riselast)
		{
			z=z^riselastpower;
		}
	}
	bool bailout(void)
	{
		return(|z| < bailout&& |z- oldz| > lowerbailout);
	}
	void description(void)
	{
		this.title = "Ytria Crystal";
		this.periodicity = 0;

		separator.label2.caption  = "Formula Block, good Julias";
 
		bailout.caption = "Bailout Value";
		bailout.default =  1000000.0;
		bailout.min = 1.0;
		bailout.hint = "This parameter defines how soon an orbit bails out while iterating.";
 
		lowerbailout.caption = "Convergent bailout";
		lowerbailout.default =  0.00005;
		lowerbailout.min = 0;
		lowerbailout.hint = "This parameter defines how soon a convergent orbit bails out while iterating. Smaller values give more precise results but usually require more iterations.";
 
		addval.caption = "Formula Seed";
		addval.default =  1;
		addval.hint = "Added barnsleyish value.";

		separator.label3.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0.875, 0.325);

		separator.label4.caption  = "Mutations";
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		inverted.caption ="Fish Eye";
		inverted.default =  false;
		inverted.hint="Applies Fish Eye transformation to pixel values (mapping).";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (inverted);
		fishstrenght.default= 1;
 
		riselast.caption ="last Z=Z^n";
		riselast.default =  false;
		riselast.hint="Before bailout rises in power z (z=z^n). Minor effect. Influences when does formula bails out and alsou colours if they are calculated by z value.";
 
		riselastpower.caption="n of Z^n";
		riselastpower.visible =  (riselast);
		riselastpower.default= 2;
		riselastpower.hint="value 1 is like no powers.";
	}
}


PerpendicularGrail {

//Perpendicular cutout of 3D mandelbor (Grail) candidate. 
//The most interesting are 3D version, but it have good 
//mandelbrot like zooms on the right.     
//http://www.fractalforums.com/new-theories-and-research/few-steps-behind-perfect-3d-mandelbrot/

// Full 3D formula is in Malinovsky3D
// Quaternion mandelbrot 3D. Alsou zoomable in 3D

//by Egar Malinovsky 16.08.2013.

//04.09.2013 + few more functions of z.

float fisheyeplus;
parameter float fishstrenght, bailout, talisfactor;
float zx,zy, zzx,zzy, zw, zzw, unit;
complex c;
parameter int settype, function, vectype;
parameter bool inverted;
parameter complex julia, vfactor;

	void init_once(void)
	{
		fisheyeplus=fishstrenght+1;
	}
	void init(void)
	{
		zzw=0;


		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
				c=func_post(c);
			}
			z=0;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				c=julia;
				z=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
			}
			else
			{

				c=julia;
				z=pixel;
			}
			z=func_post(z);
		}

	}
	void loop(void)
	{
// formula	
		zx=real(z);
		zy=imag(z);
		zw=zzw;

		zzx=zx*zx-2*zy*zy-zy*zw-1.25*zw*zw;
		zzy=2*zx*(zy+zw);
		zzw= zx*(zw- 2*zy);
		z=complex(zzx, zzy)+ c;

		//mutations:
		if  (function=="None")
		{
			//nothing
		}
		else if  (function=="Burning Ship")
		{
			z=abs(z);
		}
		else if  (function=="Tricorn")
		{
			z=conj(z);
		}
		else if  (function=="Talis")
		{
			z=sqr(z)/(z+talisfactor);
		}
		else if  (function=="Celtic")
		{
			z=z-c;
			z=z- real(z) + abs(real(z)) - c;
		}

		if  (vectype== "z/modulus(z)")
		{
			unit= cabs(z);
			if  (unit!= 0)
			{
				z=z/unit* vfactor+ z;
			}
		}
	}
	bool bailout(void)
	{
		return(|z|+|zzw|< bailout);
	}
	void description(void)
	{
		this.title = "Perpendicular Grail";
		this.periodicity = 0;
		this.maxiter = 250;
		this.helpfile = "http://www.fractalforums.com/new-theories-and-research/few-steps-behind-perfect-3d-mandelbrot/";

		separator.label2.caption  = "Formula Block, zoom at right";
 
		bailout.caption = "Bailout Value";
		bailout.default =  10000;
		bailout.min = 0.5;
 
		function.caption="Function";
		function.default= 0;
		function.enum="None\nBurning Ship\nTricorn\nTalis\nCeltic";
 
		talisfactor.caption="Talis Factor";
		talisfactor.visible =  (function==3);
		talisfactor.default= 0.25;
		talisfactor.hint="Factor n for z=z*z/(z+n)";
		
		separator.label3.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0.45, 0.27);

		separator.label4.caption  = "Mutations";
 
		inverted.caption ="Fish Eye";
		inverted.default =  false;
		inverted.hint="Applies Fish Eye transformation to pixel values (mapping).";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (inverted);
		fishstrenght.default= 1;
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		vectype.caption="Unit Vector";
		vectype.default= 0;
		vectype.enum="None\nz/modulus(z)";
 
		vfactor.caption = "Vector add Factor";
		vfactor.default= (-0.3, 0);
		vfactor.visible =  (vectype=="z/modulus(z)");
	}
}


Caerulator	{
//Patern generator mostly based on ideas from rotated mandelbox
//and Jos Henriks thread about fractals.
//Uses x and y functions instead of complex numbers.
//x= rotate(repeat(Scale*x*(x+ Add- transformation(x)) )+ Cx
//x= rotate(repeat(Scale*y*(y+ Add- transformation(y)) )+ Cy
//z=Zfunction(z)
//p.s. Transformation script are taken from Ed Algra code
//throught it's ultimate origin is Fractal Explorer source code.
// by Edgars Malinovskis 13.12.2013.

//18.12.2013. + small bugfix of scale params not switching and few more repeat functions.
//01.01.2014 + z complex function.

// Works with any of Lyapunovs, exponet smoothing, Smooth, log trichrome, statistics, elliptic harlequin colourings.

float radians, fisheyeplus;
parameter float rotation, addnumber, riselastpower, bailout, lowerbailout, fishstrenght;
float zzx,zzy, ux,uy, zx,zy;
complex c;
parameter int settype, trans, pattern;
parameter bool inverted, riselast, usefunction;
parameter complex julia, fscale;
complex oldz;

	void init_once(void)
	{
		radians= 2*pi/360 *rotation;
		fisheyeplus=fishstrenght+1;
	}
	void init(void)
	{

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
			}
			c=func_post(c);
			z=c;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				c=julia;
				z=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
			}
			else
			{

				c=julia;
				z=pixel;
			}
			z=func_post(z);
		}

		oldz=z;
		zx= real(z);
		zy= imag(z);
	}
	void loop(void)
	{
		oldz=z;

		//copy past from Ed Algra code exept Sign which were generated by mathematical error.
		if  (trans==1)  //                         					sin-sin | cos-sin
		{
			ux= 1.0E-15+sin(zx-(1.0E-15+sin(zy)));			uy= 1.0E-15+cos(zy-(1.0E-15+sin(zx)));
		}
		else if  (trans==2)  //                     					in+sin | cos+sin
		{
			ux= 1.0E-15+sin(zx+(1.0E-15+sin(zy)));			uy= 1.0E-15+cos(zy+(1.0E-15+sin(zx)));
		}
		else if  (trans==3)  //                     					atan
		{
			ux= 1.0E-15+atan(zy/(1.0E-15+zx));			uy= 1.0E-15+atan(zx/(1.0E-15+zy));
		}
		else if  (trans==4)  //                     					sin*sin | cos*sin
		{
			ux= 1.0E-15+sin(zx*(1.0E-15+sin(zy)));			uy= 1.0E-15+cos(zy*(1.0E-15+sin(zx)));
		}
		else if  (trans==5)  //                     					cos-sin | cos-sin
		{
			ux= 1.0E-15+cos(zx-(1.0E-15+sin(zy)));			uy= 1.0E-15+cos(zy-(1.0E-15+sin(zx)));
		}
		else if  (trans==6)  //                     					cos+sin | cos+sin
		{
			ux= 1.0E-15+cos(zx+(1.0E-15+sin(zy)));			uy= 1.0E-15+cos(zy-(1.0E-15+sin(zx)));
		}
		else if  (trans==7)  //                     					atan2
		{
			ux= 1.0E-15+atan(zy/(1.0E-15+zx));			uy= 1.0E-15+atan(zx/(1.0E-15+zy));
		}
		else if  (trans==8)  //                     					Sign (ex atan3)
		{
			if  (real(zy) > 0)
			{				ux= 0;			}
			else if  (real(zy) == 0)
			{				ux= -0.5 * pi;			}
			else
			{
				ux= -pi;			}
			if  (real(zx) > 0)
			{				uy= 0;			}
			else if  (real(zx) == 0)
			{				uy= -0.5 * pi;			}
			else
			{
				uy= -pi;			}

		}
		else if  (trans==9)  //                     					sin & recip
		{
			uy= 1.0E-15+abs(sin(zx*zx+zy*zy));
			ux= zx/uy;			uy= zy/uy;
		}
		else if  (trans==10)  //                    					sine stalks
		{
			ux= sin(zx)/(1.0E-15+sqrt(zx*zx+zy*zy));			uy= sin(zy)/(1.0E-15+sqrt(zx*zx+zy*zy));
		}
		else if  (trans==11)  //                    					ln stalks
		{
			uy= 1.0E-15+log(abs(zx*zx+zy*zy-1.0E-15));
			ux= log(abs(zx+1.0E-15))/uy;			uy= log(abs(zy+1.0E-15))/uy;
		}
		else if  (trans==12)  //                    					sine vibration
		{
			ux= sin(zx);			uy= sin(zy);
		}
		else if  (trans==13)  //                    					cosine vibration
		{
			ux= cos(zx);			uy= cos(zy);
		}
		else if  (trans==14)  //                    					tangens vibration
		{
			ux= sin(zx)/(abs(cos(zx))+1.0E-15);			uy= sin(zy)/(abs(cos(zy))+1.0E-15);
		}
		else if  (trans==15)  //                    					sin*cos
		{
			ux= sin(zx)*cos(zx);			uy= sin(zy)*cos(zy);
		}
		else
		{
			ux=0;			uy=0;
		}

		//generates square
		zzx=(zx* (zx+addnumber-ux) ) *real(fscale);
		zzy=(zy* (zy+addnumber-uy) ) *imag(fscale);

		//repeats pattern
		if  (pattern==1)
		{
			zzx=sin(zzx);
			zzy=sin(zzy);
		}
		else if  (pattern==2)
		{
			zzx=cos(zzx);
			zzy=cos(zzy);
		}
		else if  (pattern==3)
		{
			zzx=atan(zzx);
			zzy=atan(zzy);
		}
		else if  (pattern==4)
		{
			zzx=abs(abs(zzx*0.5-trunc(zzx*0.5)) )*2;
			zzy=abs(abs(zzy*0.5-trunc(zzy*0.5)) )*2;
		}
		else if  (pattern==5)
		{
			zzx=sqr(sin(zzx));
			zzy=sqr(sin(zzy));
		}
		else if  (pattern==6)
		{
			zx=sin(zzx)*cos(zzy);
			zzy=sin(zzy)*cos(zzx);
			zzx=zx;
		}
		else if  (pattern==7)
		{
			zx=sin(zzy);
			zzy=sin(zzx);
			zzx=zx;
		}

		//rotate in complex plane + c
		zx= (zzx*cos(radians) + zzy*sin(radians))  +real(c);
		zy= (zzx*sin(radians) + zzy*cos(radians))  +imag(c);

		//for colour
		z=flip(zy) + zx;
		
		if  (usefunction)
		{
			z= func_x(z);
			zx=real(z);
			zy=imag(z);
		}		
		
		if   (riselast)
		{
			z=z^riselastpower;
		}
	}
	bool bailout(void)
	{
		return(|z| < bailout&& |z- oldz| > lowerbailout);
	}
	void description(void)
	{
		this.title = "g Caerulator";
		this.magn = 0.5;
		this.center = (-0.5, 0);
		this.periodicity = 0;

		separator.label2.caption  = "Pattern script like Ducks / Kalisets or Popcorn";
		separator.label3.caption  = "Good Julias or Mandelbrot with Sign Transformation";
 
		pattern.caption="Repeat Function";
		pattern.enum= "none\nSin\nCos\nAtan\nTriangle\nSinSquared\nSineCosineMix\nFlipedXySin";
		pattern.default= 1;
		pattern.hint= "Wave functions for x and y coordinates. Good for Julias as creates infinite pattern but could hide parts of mandelbrot set.";
 
		rotation.caption="Rotation";
		rotation.default= 0;
		rotation.hint="Curves lines. Preferable range -10< Rot <10.";
 
		trans.caption = "Transformation";
		trans.hint= "from Fractal Explorer. Good mandelbrot with Sign.";
		trans.default =  0;
		trans.enum = "normal\nsin-sin | cos-sin\nsin+sin | cos+sin\natan\nsin*sin | cos*sin\ncos-sin | cos-sin\ncos+sin | cos+sin\natan2\nSign\nsin & recip\nsine stalks\nlog stalks\nsine vibration\ncosine vibration\ntangens vibration\nsin*cos";

		usefunction.caption ="Z Function";
		usefunction.default =  false;
		usefunction.hint="Use Z function for more patterns.";
 
		func_x.caption="Z Function";
		func_x.default="ident" ;
		func_x.visible =  (usefunction);

		separator.label4.caption  = "Bailouts";
 
		bailout.caption = "Bailout Value";
		bailout.default =  10000.0;
		bailout.min = 0.5;
 
		lowerbailout.caption = "Convergent bailout";
		lowerbailout.default =  0.000001;
		lowerbailout.min = 0;
		lowerbailout.hint = "This parameter defines how soon a convergent orbit bails out while iterating. Smaller values give more precise results but usually require more iterations.";

		separator.label5.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (-0.18, -0.18);
  
		separator.label6.caption  = "Arithmetics";
 
		addnumber.caption = "Add Number";
		addnumber.default= -0.5;
 
		fscale.caption = "Scale X Y";
		fscale.default= (1,1);
		fscale.hint="Streches and skews in X and Y  dimensions.";

		separator.label7.caption  = "Mapping Mutations";
 
		riselast.caption ="last Z=Z^n";
		riselast.default =  false;
		riselast.hint="Minor effect. Modifies colours and when formulas bails out by rising z in power (z=z^n) just before a bailout.";
 
		riselastpower.caption="n of Z^n";
		riselastpower.visible =  (riselast);
		riselastpower.default= 3;
		riselastpower.hint="value 1 is like no powers.";
 
		inverted.caption ="Fish Eye";
		inverted.default =  false;
		inverted.hint="Applies Fish Eye transformation to pixel values (mapping).";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (inverted);
		fishstrenght.default= 2;
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";

		separator.label8.caption  = "x= rotate(repeat(Scale*x*(x+ Add- transformation(x)) )+ c";
		separator.label9.caption  = "y= rotate(repeat(Scale*y*(y+ Add- transformation(y)) )+ c";
		separator.label10.caption  = "z=Zfunction(z)";
	}
}





DuckyGlyph	{
// Basicaly a combination of gnarl and ducky.
// Inspired by olympics.
// Uses Glyph by Samuel Monnier, 19.3.00
// which is modified Vine formula (from Mark Townsend)
// some ideas from Toby Marshall gnarls,
// and alsou all the duckies / luckies / kalisets.
//by Edgar Malinovsky 23.02.2014.
real radians, fisheyeplus, func, zzx,zzy, radius, zx,zy; 
parameter real rotation, fishstrenght;
complex c;
parameter shared int factround; 
parameter int settype;
parameter bool inverted;
parameter complex julia;
int iter, i;
parameter int cycles;
parameter real faster;
parameter int aritm;
parameter real scale1;
parameter int gnarl;
parameter real scale2;
parameter int mirror;
parameter complex mirrorxy;
parameter real smllradius;
parameter real bigradius;
parameter real fold;
parameter bool riselast;
parameter real riselastpower;
parameter int switchsettype;	

//Don't work:(
//real areas( real w) 
//{ 
//return(   (round(w*factround)/factround+ w)*0.5    );
//}

	void init_once(void)
	{
	
		radians= 2*pi/360 *rotation;
		fisheyeplus=fishstrenght+1;
	}
	void init(void)
	{

		if  (settype=="Mandelbrot")
		{
			if  (inverted)
			{
				c=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
				c=func_post(c);
			}
			else
			{

				c=pixel;
			}
			c=func_post(c);
			z=c;

		}
		else if  (settype=="Julia")
		{
			if  (inverted)
			{
				c=julia;
				z=(fishstrenght+cabs(pixel) )/fisheyeplus*pixel;
			}
			else
			{

				c=julia;
				z=pixel;
			}
			z=func_post(z);
		}

		zx= real(z);
		zy= imag(z);
		iter=0;
	}
	void loop(void)
	{	
	
		iter= iter+ 1;
		i= 0;

		//a gnarling cycle
		zzx=zy;
		zzy=zx;
		while  (i< cycles)
		{
			i= i+ 1;
			zzx=zzx*faster;
			zzy=zzy*faster;

			if  (aritm==0)
			{
				zzx= zy+ scale1*(sin(zzx) + cos(zzx));
				zzy= zx+ scale1*(sin(zzy) + cos(zzy));
			}
			else if  (aritm==1)
			{
				zzx= zy+ scale1*(sin(zzx) - cos(zzx));
				zzy= zx+ scale1*(sin(zzy) - cos(zzy));
			}
			else if  (aritm==2)
			{
				zzx= zy+ scale1*sin(zzx) *cos(zzx)*1.43;
				zzy= zx+ scale1*sin(zzy) *cos(zzy)*1.43;
			}
		}

		//different gnarls
		if  (gnarl==0)
		{
			//symmetric
			zzx=zzx*faster;
			zzy=zzy*faster;
			zx= zx+ scale2*(sin(zzx) + cos(zzx));
			zy= zy+ scale2*(sin(zzy) + cos(zzy));
		}
		else if  (gnarl==1)
		{
			//curls
			zzx=zzx*faster;
			zzy=zzy*faster;
			zx= zx+ scale2*cos(zzx) *tanh(zzx);
			zy= zy+ scale2*cos(zzy) *tanh(zzy);
		}
		else if  (gnarl==2)
		{
			//SAM's original glyph
			zx= zx- scale2*(sin(zzx) + cos(zzx));
			zy= zy+ scale2*(sin(zzy) + cos(zzy));
		}
		
//since function definition failed:(		
		
		else if  (gnarl==3)

	{
			//symmetric
			zzx=zzx*faster;
			zzy=zzy*faster;
			zx= zx+ scale2*((round(sin(zzx)*factround)/factround+ sin(zzx))*0.5 + (round(cos(zzx)*factround)/factround+ cos(zzx))*0.5);
			zy= zy+ scale2*((round(sin(zzy)*factround)/factround+ sin(zzy))*0.5 + (round(cos(zzy)*factround)/factround+ cos(zzy))*0.5);
		}
		else if  (gnarl==4)
		{
			//curls
			zzx=zzx*faster;
			zzy=zzy*faster;
			zx= zx+ scale2*(round(cos(zzx)*factround)/factround+ cos(zzx))*(round(tanh(zzx)*factround)/factround+ tanh(zzx))*0.25;
			zy= zy+ scale2*(round(cos(zzy)*factround)/factround+ cos(zzy))*(round(tanh(zzy)*factround)/factround+ tanh(zzy))*0.25;
		}
		else if  (gnarl==5)
		{
			//SAM's original glyph
			zx= zx- scale2*((round(sin(zzx)*factround)/factround+ sin(zzx))*0.5 + (round(cos(zzx)*factround)/factround+ cos(zzx))*0.5);
			zy= zy+ scale2*((round(sin(zzy)*factround)/factround+ sin(zzy))*0.5 + (round(cos(zzy)*factround)/factround+ cos(zzy))*0.5);
		}

		//rotate in plane + c
		zzx= (zx*cos(radians) + zy*sin(radians))  +real(c);
		zzy= (zx*sin(radians) + zy*cos(radians))  +imag(c);

		//ducks like mirrors
		if  (mirror==0)
		{
			zx=zzx;
			zy=zzy;
		}
		else if  (mirror==1)
		{
			//abs
			zx=abs(zzx-real(mirrorxy))+real(mirrorxy);
			zy=abs(zzy-imag(mirrorxy))+imag(mirrorxy);
		}
		else if  (mirror==2)
		{
			//sefir
			radius= sqr(zzx)+sqr(zzy);
			if  (radius==0)
			{
				zx=0;
				zy=0;
			}
			else if  (radius< (smllradius) )
			{
				zx=zzx/smllradius;
				zy=zzy/smllradius;
			}
			else if  (radius<bigradius)
			{
				zx=zzx/radius;
				zy=zzy/radius;
			}
		}
		else if  (mirror==3)
		{
			//spiral, in complex z=z*c
			zx=(zzx*real(c)-zzy*imag(c));
			zy=(zzy*real(c)+zzx*imag(c));

		}
		else if  (mirror==4)
		{
			//seamless boxfold
			zx= abs(zzx-fold) - abs(zzx+fold) + zzx;
			zy= abs(zzy-fold) - abs(zzy+fold) + zzy;
		}

		//goes to colourings
		z=flip(zy) + zx;

		if   (riselast)
		{
			z=z^riselastpower;
		}
	}
	bool bailout(void)
	{
		return(iter< maxiter);
	}
	void description(void)
	{
		this.title = "DuckyGlyph";
		this.periodicity = 0;
		this.maxiter = 20;
 
		separator.label2.caption  = "Use with non basic color methods";
		separator.label3.caption  = "lyapunovs, smooths or orbit traps";
 		separator.label4.caption  = "and search for julias.";
		 
		aritm.caption="Arithmetics";
		aritm.hint="Sin and cosine are eather + - or *.";
		aritm.default=  0;
		aritm.enum= "+\n-\n*";
 
		gnarl.caption="Gnarl";
		gnarl.hint="Gnarl trigonometry.";
		gnarl.default=  0;
		gnarl.enum="Symmetric\nCurls\nSAM\nareas Symmetric\nareas Curls\nareas SAM";
 
		factround.caption = "Rounding factor";
		factround.default =  3;
		factround.min=1;
		factround.visible =  (gnarl>2);
		factround.hint="The larger the factor the less angular will be the result aka less rounding.";
 
		mirror.caption="Mirror";
		mirror.hint="Introduces Ducks like character.";
		mirror.default=  1;
		mirror.enum="None\nAbs\nSefir\nSpiral\nBoxfold";
 
		fold.caption="Fold";
		fold.default= 1;
		fold.visible =  (mirror=="Boxfold");
 
		mirrorxy.caption="Mirror point";
		mirrorxy.default= (0,0);
		mirrorxy.visible =  (mirror=="Abs");
 
		smllradius.caption="Small radius";
		smllradius.default= 0.4;
		smllradius.visible =  (mirror=="Sefir");
 
		bigradius.caption="Big radius";
		bigradius.default= 1;
		bigradius.visible =  (mirror=="Sefir");

		separator.label5.caption  = "Glyph variables";
 
		cycles.caption = "Cycles";
		cycles.default =  2;
		cycles.min = 0;
		cycles.hint="Pattern density. How many times transformation is applied in each iteration.";
 
		faster.caption = "main Scale";
		faster.default =  2.7;
 
		scale1.caption = "Scale in Cycle";
		scale1.default =  0.7;
 
		scale2.caption = "Scale out Cycle";
		scale2.default =  0.05;
 
		rotation.caption="Rotation";
		rotation.default= 0;
		rotation.hint="Rotates z and not a fractal. Small values -2<0<2 or 90 and 180 degrees.";

		separator.label6.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default=  0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0, 0);
  
		separator.label7.caption  = "Mutations";
 
		riselast.caption ="last Z=Z^n";
		riselast.default =  false;
		riselast.hint="Minor effect. Strenghtens colours by rising z in power (z=z^n) just befor sending z to colour calculation.";
 
		riselastpower.caption="n of Z^n";
		riselastpower.visible =  (riselast);
		riselastpower.default= 3;
		riselastpower.hint="value 1 is like no powers.";
 
		inverted.caption ="Fish Eye";
		inverted.default =  false;
		inverted.hint="Applies Fish Eye transformation to pixel values (mapping).";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (inverted);
		fishstrenght.default= 2;
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
	}
}


Devaney {
// z=  z^n + C / (z - a)^d
// whose versions was much researched
// by Robert L. Devaney
// julia sets = Sierpinski carpet.
// http://math.bu.edu/people/bob/papers.html
// 09.09.2014.

// 20.09.2014. finaly normal critical points for mset.
// thanks to http://www.fractalforums.com/index.php?topic=18526.30
// not much compatibility with previous critical points, sorry.

real fisheyeplus;
parameter real fishstrenght, powern,powerd, itermult, bailout;
complex c;
parameter bool usefisheye, itermultiplied;
parameter int settype, criticalpoint, formula;
parameter complex julia, talis, startvalue;
int iter; 

	void init_once(void)
	{
		fisheyeplus=fishstrenght+1;
	}
	void init(void)
	{
		c=pixel;

		if  (usefisheye)
		{
			c=(fishstrenght+cabs(c) )/fisheyeplus*c;
		}
		c=func_post(c);

		if  (settype=="Mandelbrot")
		{

			if  (criticalpoint==0)
			{
				z=startvalue;
			}
			else if  (criticalpoint==1)
			{
				z=1-2/(powern+powerd);
			}
			else if  (criticalpoint==2)
			{
				z=(powerd*c/powern)^recip(powern+powerd);
			}

		}
		else if  (settype=="Julia")
		{
			z= c;
			c=julia;
		}

		iter=0;
	}
	void loop(void)
	{

		//formula starts here
		z= z^powern+ c/ (z- talis)^powerd;

		//Mutations
		if  (formula==0)
		{
		}
		else if  (formula==1)
		{
			z=abs(z);
		}
		else if  (formula==2)
		{
			z= conj(z);
		}
		else if  (formula==3)
		{
			z=z-c;
			z=z- real(z) + abs(real(z)) - c;
		}
		else if  (formula==4)
		{
			z=z- real(z) + abs(real(z));
		}
		else if  (formula==5)
		{
			z= abs(real(z))-flip(imag(z));
		}

		if   (itermultiplied)
		{
			z=iter*itermult+z;
		}


		iter=iter+1;
	}
	bool bailout(void)
	{
		return(|z| < bailout);
	}
	void description(void)
	{
		this.title = "Devaney";
		this.periodicity = 0;
		this.magn = 2;
		this.helpfile="http://math.bu.edu/people/bob/papers.html";

		separator.label2.caption  = "Z=  Z^n + C / (Z - Center)^d";
		separator.label3.caption  = "julias http://math.bu.edu/people/bob/papers.html";
 
		bailout.caption = "Bailout Value";
		bailout.default =  10000.0;
		bailout.min = 1.0;
		bailout.hint = "This parameter defines how soon an orbit bails out while iterating.";
 
		powern.caption = "Power n";
		powern.default =  2;
		powern.hint = "This parameter sets the exponent for the formula.";
 
		powerd.caption = "Power d";
		powerd.default =  2;
		powerd.hint = "This parameter sets the exponent for the formula.";
 
		criticalpoint.caption="Critical point";
		criticalpoint.default= 2;
		criticalpoint.visible =  (settype=="Mandelbrot");
		criticalpoint.hint="Starting value of z. Finaly found the mathematicaly correct version. Still probably only when Center=0.";
		criticalpoint.enum="manual\nboth\nCorrect Math";
 
		startvalue.caption = "Starting value";
		startvalue.default =  (0.5 ,0);
		startvalue.visible =  (criticalpoint=="manual" && settype=="Mandelbrot");
		startvalue.hint = "This needs starting z other than 0 and that depends on n / d values.";
 
		talis.caption = "Center";
		talis.default =  (0,0);
		talis.hint = "Talis like parameter.";

		separator.label4.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0.109, 0.0004);

		separator.label5.caption  = "Mutations";
 
		formula.caption="Mirror";
		formula.default= 0;
		formula.enum= "None\nBurning Ship\nTricorn\nCeltic\nAssimilated Celtic\nPerpendicular";
 
		itermultiplied.caption ="z+ IterationsxM";
		itermultiplied.default =  false;
		itermultiplied.hint="At each iteration to the result ads iteration number x coefficient. Hence orbits have no choice but to escape.";
 
		itermult.caption="multiplication factor M";
		itermult.visible =  (itermultiplied);
		itermult.default= 0.002;
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		usefisheye.caption ="Fish Eye";
		usefisheye.default =  false;
		usefisheye.hint="Applies Fish Eye transformation to mapping (pixel values).";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (usefisheye);
		fishstrenght.default= 2;
		fishstrenght.hint="Denomintor, decreesing value increases effect.";
	}
}


FractalusTechna {
// A transformation placed between the formula and +c.
// Shatters fractal into blocks of solids.
// z=formula(z)
// z=transform(z) repeated Cycles times
// z=z+c
// with transform z = z - z/round(z).
// This transformation would work in 3D as it was found using quaternion math and mandelbulb.
// Edgar Malinovsky
// 29.10.2014.

float fisheyeplus;
complex c, vectr;
parameter bool usefisheye;
parameter complex julia;
int iter, i, powminus;
parameter int power, cycles;
parameter float talisfactor, itermult, bailout, fishstrenght;
parameter int roundtype, formula, settype;
parameter bool itermultiplied;
 

	void init_once(void)
	{
		fisheyeplus=fishstrenght+1;
		powminus=power-1;
	}
	void init(void)
	{
		c=pixel;

		if  (usefisheye)
		{
			c=(fishstrenght+cabs(c) )/fisheyeplus*c;
		}
		c=func_post(c);

		if  (settype=="Mandelbrot")
		{
			z=0;

		}
		else if  (settype=="Julia")
		{
			z= c;
			c=julia;
		}
		iter=0;
	}
	void loop(void)
	{
		i= 0;

		if  (formula=="Burning Ship")
		{
			z=abs(z^power);
		}
		else if  (formula=="Talis")
		{
			z= (z^power)/(z^powminus + talisfactor);
		}
		else if  (formula=="MalinovskyDeco")
		{
			z=sinh(z)*z;
		}
		else
		{

			//good old mandelbrot
			z=z^power;
		}

		//a techno cycle
		while  (i< cycles)
		{
			i= i+ 1;
			if  (roundtype=="ceil")
			{
				vectr = ceil(z);
			}
			else if  (roundtype=="round")
			{
				vectr = round(z);
			}
			else if  (roundtype=="floor")
			{
				vectr = floor(z);
			}
			else if  (roundtype=="trunc")
			{
				vectr = trunc(z);
			}

			if  (vectr !=0)
			{
				vectr = z/vectr;
			}
			z=z-vectr;
		}

		if  (formula=="MalinovskyDeco")
		{
			//this formula requires exotic C.
			z=z-sqr(c);
		}
		else
		{

			z=z+c;
		}

		if   (itermultiplied)
		{
			z=iter*itermult+z;
		}

		iter=iter+1;
	}
	bool bailout(void)
	{
		return(|z| < bailout);
	}
	void description(void)
	{
		this.title = "Fractalus Techna";
		this.periodicity = 1;
		this.method = "multipass";
		this.magn = 0.8;

		separator.label2.caption  = "Transformation z = z - z/round(z) repeated Cycles times";

		separator.label3.caption  = "Shattering";
 
		cycles.caption = "Cycles";
		cycles.default =  1;
		cycles.min = 0;
		cycles.hint="How much times during iteration transformation is applied. 2 goes better for julia and 1 for mandelbrot zooms.";
 
		roundtype.caption="Rounding Type";
		roundtype.default= 0;
		roundtype.enum="ceil\nround\nfloor\ntrunc";

		separator.label4.caption  = "Formula";
 
		formula.caption="Formula";
		formula.default= 0;
		formula.enum="Mandelbrot\nBurning Ship\nTalis\nMalinovskyDeco";
 
		power.caption = "Power";
		power.default =  2;
		power.visible =  (formula=="Mandelbrot"||formula=="Burning Ship"||formula=="Talis");
 
		talisfactor.caption="Talis Factor";
		talisfactor.visible =  (formula=="Talis");
		talisfactor.default= 1;
		talisfactor.hint="Factor n for z=z*z/(z+n)";
 
		bailout.caption = "Bailout value";
		bailout.default =  10000;

		separator.label5.caption  = "Julia Block";
 
		settype.caption="Set type";
		settype.default= 0;
		settype.enum="Mandelbrot\nJulia";
 
		julia.caption="Julia Seed";
		julia.default= (0.7, -0.33);

		separator.label6.caption  = "Mutations";
 
		itermultiplied.caption ="z+ IterationsxM";
		itermultiplied.default =  false;
		itermultiplied.hint="At each iteration to the result ads iteration number x coefficient. Hence orbits have no choice but to escape.";
 
		itermult.caption="multiplication factor M";
		itermult.visible =  (itermultiplied);
		itermult.default= 0.002;
 
		func_post.caption="Pixel mapping function";
		func_post.default="ident" ;
		func_post.hint="Function applied during iteration initialisation. New coordinates of pixel = function(coordinates of pixel). This curves not c, but the plane, on which fractal is drawn, so only ident m-set is map for julia sets. Recip works as circle inverse.";
 
		usefisheye.caption ="Fish Eye";
		usefisheye.default =  false;
		usefisheye.hint="Applies Fish Eye transformation to mapping (pixel values).";
 
		fishstrenght.caption="Fisheye Factor";
		fishstrenght.visible =  (usefisheye);
		fishstrenght.default= 2;
		fishstrenght.hint="Denomintor, decreesing value increases effect.";
	}
}
