DavidsGrail (quaternion) {
//David Makin's 3D mandelbrot.
//Probably it's an actual 3D mandelbrot.
//Exept that it's a 4D.

//http://www.fractalforums.com/index.php?topic=19658.0

parameter real bailout;
quaternion C, newpixel;
real Cx, Cy, Cz, Cw, m, s, t;
parameter bool testInverted;
parameter quaternion julia;
parameter int settype, power;
complex newz, w, wtemp;
parameter real perturb;

// block for cutout.
parameter int iscuted;
parameter quaternion Ctaxis;
real autobailout, coordX, coordY, coordZ;


void init(void)
 {
newpixel=pixel+quaternion(0,0,0,perturb);	
	
 	 if (testInverted==true && settype=="Julia Set")
	 {
	z = recip(newpixel);
	C = julia;
	}
     else if (settype=="Julia Set")
    {	
	z = newpixel;
	C = julia;
    }
    else if (testInverted==true && settype=="Mandelbrot Set")
	 {
	 z= 0;
	 C= recip(newpixel);
	 }
    else
    {
	z= 0;
	C= newpixel;
    } 
	
		Cx=real(C);
		Cy=imag(C);
		Cz=part_j(C);	
		Cw=part_k(C);

		
//block for cutout. An unelegant code.
autobailout=0;
coordX= real(Ctaxis);
coordY= imag(Ctaxis);
coordZ= part_j(Ctaxis);
if (iscuted == "Larger than") 
{
	if (coordX!=0 && real(pixel) > coordX )
	{
	autobailout= bailout +1;
	}
	if (coordY!=0 && imag(pixel) > coordY )
	{
	autobailout= bailout +1;
	}
	if (coordZ!=0 && part_j(pixel) > coordZ )
	{
	autobailout= bailout +1;
	}
}	
else if (iscuted == "Smaller than")
{
	if (coordX!=0 && real(pixel) < coordX )
	{
	autobailout= bailout +1;
	}
	if (coordY!=0 && imag(pixel) < coordY )
	{
	autobailout= bailout +1;
	}
	if (coordZ!=0 && part_j(pixel) < coordZ )
	{
	autobailout= bailout +1;
	}
}	
	 

		w=complex(part_j(z), part_k(z));
		newz=complex ( real(z),  imag(z) ); 
}		
void loop(void)	
{
s=|newz|;
t=|w|;
m = s+t; //square of 4D mag
if (m!=0)  // Chaos pro eliminates but anyway
{
//calculate square

     wtemp = w;
     w = 2.0*newz*w;
	 if (s >= t)
	{
    newz = (1.0 - t/s)*sqr(newz);	 
	}
	 else
	{
    newz = (s/t-1.0)*sqr(wtemp);	
	}

	if (power=="Tesseract" ||power=="Octeract")
	{ 
//4th power, calculates next square
		wtemp = w;
		s=|newz|;
		t=|w|;
		w = 2.0*newz*w;
		if (s >= t)
		{
		newz = (1.0 - t/s)*sqr(newz);	 
		}
		else
		{
		newz = (s/t-1.0)*sqr(wtemp);	
		}
	}
	if (power=="Octeract")
	{
//8th power, 3r square
	 
		wtemp = w;
		s=|newz|;
		t=|w|;
		w = 2.0*newz*w;
		if (s >= t)
		{
		newz = (1.0 - t/s)*sqr(newz);	 
		}
		else
		{
		newz = (s/t-1.0)*sqr(wtemp);	
		}
	}

}
newz=newz+complex(Cx,Cy);
w=w+complex(Cz,Cw);
z=abs(newz)+abs(w); // for colouring

}
bool bailout(void)
	{
	return( |z|+ autobailout < bailout );
	}
void description(void)
	{
this.title = "DavidsGrail";
this.maxiter=20;
this.helpfile= "http://www.fractalforums.com/index.php?topic=19658.0";

separator.label1.caption  = "3D mandelbrot set.";

	bailout.caption = "Bailout Value";
	bailout.default = 777.0;
	bailout.hint = "Larger number increases detalisation";
   
    testInverted.caption="Inverted set";
    testInverted.default=false;
	 
    power.caption = "Power";
    power.enum = "Square\nTesseract\nOcteract";
    power.default = 0;

    perturb.caption = "4th dim slice";
    perturb.default = 0;

settype.caption = "Set type";
settype.enum = "Mandelbrot Set\nJulia Set";
settype.default = 0;

    julia.caption = "Julia Parameter";
    julia.default = (0.2,-0.3,0.27,0);
    julia.visible = (settype=="Julia Set");
	 
//block for a cutout.	 
separator.label2.caption  = "CUTS along NONZERO coordinates.";		
iscuted.caption="CUTTING";
iscuted.enum="None\nLarger than\nSmaller than";
iscuted.default= 0;
		
Ctaxis.caption ="Coordinates of cut";
Ctaxis.default= (0,0,0,0);
Ctaxis.visible = (iscuted=="Larger than" || iscuted=="Smaller than");		
	}
}
