BurningShipFractal {
//Quaternion Friendly!
// Found in wikipedia. + higher powers and julia set. by Edgars Malinovskis. 23.11.2001.
// + Julia seed in mandelbrot (map). 23.02.2012

parameter real bailout;
parameter int settype, Power;
parameter complex julia;
quaternion C;  //If don't work or to speed up change to complex C;

	void init(void)
 {
    if (settype=="Julia Set")
    {	
	z = pixel;
	C = julia;
    }
    else
    {
	z=0;
	C=pixel;
    }
}
	void loop(void)
	{
		if (Power=="Standart")   
		{
		z= sqr(abs(z)) +C;
		}
		else if (Power=="Cubed")
		{
		z= sqr(abs(z))*(abs(z)) +C;
		}
		else if (Power=="Forth")
		{
		z= sqr(abs(z))*sqr(abs(z)) +C;
		}
		else if (Power=="Fifth")
		{
		z= sqr(abs(z))*sqr(abs(z))*(abs(z)) +C;
		}
		else
		{
		z= sqr(abs(z))*sqr(abs(z))*sqr(abs(z))*(abs(z)) +C;
		}
	}
	bool bailout(void)
	{
		return(  |z|  <= bailout);
	}
	void description(void)
	{
		this.title="Burning Ship (Quaternion friendly)";
		this.helpfile = "http://en.wikipedia.org/wiki/Burning_Ship_fractal";
		this.angle=180;

		bailout.caption = "Bailout Value";
		bailout.default = 7.0;
		bailout.min = 0.5;
		bailout.hint = "Defines the bailout radius: If pixel falls out of it, the iteration stops. Larger number increases details";

    Power.caption = "Fractal Power";
    Power.enum = "Standart\nCubed\nForth\nFifth\nSeventh";
    Power.default = 0;

    settype.caption = "Set type";
    settype.enum = "Mandelbrot Set\nJulia Set";
    settype.default = 0;

	separator.label.caption  = "For Julia sets";
    julia.caption = "Julia Parameter";
    julia.default = (-0.09,0.25);
    julia.hint = "Different values create different Julia Sets.";

	}
}