comment
{
  Here you can find quaternion formulas for use with ChaosPro
}

HComplex(QUATERNION) {
parameter complex power;
parameter real bailout;
parameter int frmltype;
parameter quaternion p,perturb;
parameter quaternion c;
quaternion oldz,zprev,z1;
import Math.Hypercomplex as hmath;

	void init(void)
	{
		z=perturb+pixel;
		oldz=0;
	}
	void loop(void)
	{
		if (frmltype=="z^2-c")
		{
			z=hmath.mult(z,z)-c;
		}
		else if (frmltype=="z^2+c")
		{
			z=hmath.mult(z,z)+c;
		}
		else if (frmltype=="z^3-c")
		{
			z=hmath.mult( hmath.mult(z,z),z)-c;
		}
		else if (frmltype=="z^3+c")
		{
			z=hmath.mult( hmath.mult(z,z),z)+c;
		}
		else if (frmltype=="z^4-c")
		{
			z=hmath.mult(z,z);
			z=hmath.mult(z,z)-c;
		}
		else if (frmltype=="z^4+c")
		{
			z=hmath.mult(z,z);
			z=hmath.mult(z,z)+c;
		}
		else if (frmltype=="c*z*(1-z)")
		{
			z=hmath.mult(z,1-z);
			z=hmath.mult(c,z);
		}
		else if (frmltype=="z*z+z*c")
		{
			z= hmath.mult(z,z) + hmath.mult(z,c);
		}
		else if (frmltype=="z^3-z^2+c")
		{
			z= hmath.mult( hmath.mult(z,z),z) -hmath.mult(z,z)+c;
		}
		else if (frmltype=="z^2+c/z")
		{
			z=hmath.mult(z,z)+hmath.div(c,z);
		}
		else if (frmltype=="(z-c)*(z^2+c)+z^2")
		{
			z1=hmath.mult(z,z);
			z=hmath.mult(z-c,z1+c)+z1;
		}
		else if (frmltype=="z*(1-z)+c")
		{
			z=hmath.mult(z,1-z)+c;
		}
		else if (frmltype=="z*z+oldz+c")
		{
			zprev=z;
			z=hmath.mult(z,z)+oldz+c;
			oldz=zprev;
		}
		else if (frmltype=="z*ln(z)-c")
		{
			z=hmath.mult(z,ln(z))-c;
		}
		else if (frmltype=="z^p-c")
		{
			z=hmath.pow(z,p)-c;
			z=z^p-c;
		}
	}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}

	void description(void)
	{
		this.title = "Hypercomplex";

		frmltype.caption="Formula";
		frmltype.enum="z^2-c\nz^2+c\nz^3-c\nz^3+c\nz^4-c\nz^4+c\nc*z*(1-z)\nz*z+z*c\nz^3-z^2+c\nz^2+c/z\n(z-c)*(z^2+c)+z^2\nz*(1-z)+c\nz*z+oldz+c\nz*ln(z)-c\nz^p-c";
		frmltype.hint = "Please select an iteration formula to use.";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
		
		c.caption="c";
		c.default=(0.3,-0.44,-0.57,0.3);
		c.hint="Parameter for this formula";
		
		p.caption="Power";
		p.default=(2,0,0,0);
		p.visible = frmltype=="z^p-c";
		p.hint="Lets you specify the exponent for the formula";

		perturb.caption = "Starting Point";
		perturb.default = (0,0,0,0);
		perturb.hint = "Starting point for the iteration";

	}
}

