comment {
  
  * formula identifier must match the FractInt type name, replace "(" by 
    "_". The parameter names must be p1, p2,p3,p4,p5,p6, etc.
    ChaosPro will detect their types (int, real, complex) and assign the proper
    values of the "params="-string to it. So if p1=real, p2=complex, p3=real
    and params="1/2/3/4", then you'll end up with p1=1, p2=(2/3), p3=4!
    Same applies for functions, their names must be fn1, fn2,...
    
    The use of bailout and bailouttest parameters is also possible...
    Please note that the order of the enumeration in bailouttest must match!
    
    If the formula cannot be found, then the import functions from former versions
    of ChaosPro will try to import the file, but this most probably won't work (except for
    IFS, LSystem, Bifurcation,etc.)
}

lambda
{
parameter complex p1;
parameter real bailout;
parameter real bailin;
parameter int bailouttest;
shared real formulaBailout;
shared real rBiomorph;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
complex lz,cyc;
int Maxit_2;
real dmax,dmin,zabs;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		dmax=cabs(pixel)+bailin;
		dmin=cabs(pixel)-bailin;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z=p1*z*(1-z);
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="lauw") {
			if (testInf) {
				if (abs(real(z))+abs(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (abs(real(lz-z))+abs(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (abs(real(cyc-z))+abs(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="P-Ring") {
			zabs=cabs(z);
			if (zabs>dmin && zabs<dmax) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-lambda";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="c";
		p1.default=(0.85,0.6);
		p1.hint="Julia Parameter";
		
		bailout.caption="Bailout";
		bailout.default=0;

		bailouttest.caption="Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr\nlauw\nP-Ring";
		bailouttest.default=0;
		
		separator.label1.caption="Test for Attractor";
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
		
	}
}

mandelfn
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
real rqlim2;
function complex fn1;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=p1+pixel;
		bContinue=true;
		rqlim2=sqrt(formulaBailout);
		
		if (__fn1=="sin") {
			if (abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="sinh" || __fn1=="cosh") {
			if (abs(real(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="exp") {
			if (abs(real(z))>640 || abs(imag(z))>1.0E8) {
				bContinue=false;
			}
		}
		else {
			if (abs(real(z))>rqlim2 || abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
	}
	void loop(void)
	{
		z = pixel * fn1(z);
		if (__fn1=="sin") {
			if (abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="sinh" || __fn1=="cosh") {
			if (abs(real(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="exp") {
			if (abs(real(z))>640 || abs(imag(z))>1.0E8) {
				bContinue=false;
			}
		}
		else {
			if (abs(real(z))>rqlim2 || abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-mandelfn";
		this.center=(0,0);
		this.magn=0.25;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Start";
		p1.default=(0,0);
		p1.hint="Julia Parameter";
		
		fn1.caption="Function 1";
		fn1.default="sin";
		
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

julia
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;		
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^2+p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-Julia";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Start";
		p1.default=(0.3,0.6);
		p1.hint="Parameter 1";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

sqr_fn
{
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = sqr(fn1(z));
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-sqr(fn)";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}


sqr_1/fn
{
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = sqr(1/fn1(z));
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-sqr(1/fn)";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

lambdafn
{
parameter complex p1;
parameter real bailout;
bool bContinue;
complex lz;
shared real formulaBailout;
real rqlim2;
function complex fn1;
shared real rBiomorph;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
		lz=z;
		rqlim2=sqrt(formulaBailout);
	}
	void loop(void)
	{
		if (__fn1=="sin") {
			if (abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="sinh" || __fn1=="cosh") {
			if (abs(real(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="exp") {
			if (abs(real(z))>640 || abs(imag(z))>1.0E8) {
				bContinue=false;
			}
		}
		else {
			if (abs(real(z))>rqlim2 || abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
		if (bContinue!=false) {
			lz=z;
			z = p1 * fn1(z);
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-lambdafn";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Start";
		p1.default=(1,0.4);
		p1.hint="Julia Parameter";
		
		fn1.caption="Function 1";
		fn1.default="sin";
		
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

mandel
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^2+pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-mandel";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Start";
		p1.default=(0,0);
		p1.hint="Parameter 1";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

barnsleyj1
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (real(z)>=0) {
			z = (z - 1) * p1;
		}
		else {
			z = (z + 1) * p1;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-barnsleyj1";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Parameter 1";
		p1.default=(0.6,1.1);
		p1.hint="Julia Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

barnsleyj2
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (real(z)*imag(p1)+real(p1)*imag(z)>=0) {
			z = (z - 1) * p1;
		}
		else {
			z = (z + 1) * p1;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-barnsleyj2";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Parameter 1";
		p1.default=(0.6,1.1);
		p1.hint="Julia Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

barnsleyj3
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (real(z)>0) {
			z = sqr(z)-1;
		}
		else {
			z = sqr(z)-1 + p1*real(z);
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-barnsleyj3";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Parameter 1";
		p1.default=(0.6,1.1);
		p1.hint="Julia Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

barnsleym1
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (real(z)>=0) {
			z = (z - 1) * pixel;
		}
		else {
			z = (z + 1) * pixel;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-barnsleym1";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);
		p1.hint="Julia Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

barnsleym2
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (real(z)*imag(pixel)+real(pixel)*imag(z)>=0) {
			z = (z - 1) * pixel;
		}
		else {
			z = (z + 1) * pixel;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-barnsleym2";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);
		p1.hint="Julia Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

barnsleym3
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (real(z)>0) {
			z = sqr(z)-1;
		}
		else {
			z = sqr(z)-1 + pixel*real(z);
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-barnsleym3";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);
		p1.hint="Julia Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

lambdafn
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
real rqlim2;
function complex fn1;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
		rqlim2=sqrt(formulaBailout);
		
		if (__fn1=="sin") {
			if (abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="sinh" || __fn1=="cosh") {
			if (abs(real(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="exp") {
			if (abs(real(z))>640 || abs(imag(z))>1.0E8) {
				bContinue=false;
			}
		}
		else {
			if (abs(real(z))>rqlim2 || abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
	}
	void loop(void)
	{
		z = p1 * fn1(z);
		if (__fn1=="sin") {
			if (abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="sinh" || __fn1=="cosh") {
			if (abs(real(z))>rqlim2) {
				bContinue=false;
			}
		}
		else if (__fn1=="exp") {
			if (abs(real(z))>640 || abs(imag(z))>1.0E8) {
				bContinue=false;
			}
		}
		else {
			if (abs(real(z))>rqlim2 || abs(imag(z))>rqlim2) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-lambdafn";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Start";
		p1.default=(1,0.4);
		p1.hint="Julia Parameter";
		
		fn1.caption="Function 1";
		fn1.default="sin";
		
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

manowarj
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,z1;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		z1=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}

		z = z^2+z1+p1;
		z1=lz;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-manowarj";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Parameter";
		p1.default=(0,0);
		p1.hint="Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

manowar
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,z1;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		z1=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}

		z = z^2+z1+pixel;
		z1=lz;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-manowar";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);
		p1.hint="Parameter";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

cmplxmarksjul
{
parameter complex p1;
parameter complex p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,coeff;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
		coeff=p1^(p2-1);
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z=z^2*coeff+p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-cmplxmarksjul";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Parameter";
		p1.default=(0.3,0.6);

		p2.caption="Exponent";
		p2.default=(1,0);
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

cmplxmarksmand
{
parameter complex p1;
parameter complex p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,coeff;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
		coeff=pixel^(p2-1);
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z=z^2*coeff+pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-cmplxmarksmand";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);

		p2.caption="Exponent";
		p2.default=(1,0);
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

marksjulia
{
parameter complex p1;
parameter int p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,coeff;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
		coeff=p1^(p2-1);
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z=z^2*coeff+p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-marksjulia";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Parameter";
		p1.default=(0.1,0.9);

		p2.caption="Exponent";
		p2.default=1;

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

marksmandel
{
parameter complex p1;
parameter int p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,coeff;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
		if (cabs(imag(pixel))<0.0001) {
			coeff=(real(pixel)+flip(0.001))^(p2-1);
		} else {
			coeff=pixel^(p2-1);
		}
		
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z=z^2*coeff+pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-marksmandel";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);

		p2.caption="Exponent";
		p2.default=1;
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

marksmandelpwr
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,coeff;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
		coeff=z^(z-1);
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z=coeff * fn1(z) + pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-marksmandelpwr";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);

		fn1.caption="Function";
		fn1.default="sin";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

tim's_error
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc,coeff,tmp;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
		coeff=z^(z-1);
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		tmp=fn1(z);
		z=real(tmp)*real(coeff)-imag(tmp)*imag(coeff)+flip(real(tmp)*imag(coeff)-imag(tmp)*real(coeff))+pixel;

		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-tim's_error";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Perturbation";
		p1.default=(0,0);

		fn1.caption="Function";
		fn1.default="sin";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

complexbasin
{
parameter complex p1;
parameter complex p2;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
complex temp,tmp;
real mod;
shared real coloriter;

	void init(void)
	{
		if (rBiomorph>=0)
		{
			formulaBailout=100;
		}
		else
		{
			formulaBailout=4;
		}
		z=pixel;
		bContinue=true;
		if (|z^p1-p2|<=0.001)
		{
			bContinue=false;
			if(cabs(imag(z)) < 0.01) {
				z=real(z);
			}
			temp=log(z);
			tmp=temp*p1;
			mod = imag(tmp)/(2*pi);
			coloriter = mod;
			if(cabs(mod - coloriter) > 0.5) {
				if(mod < 0.0) {
					coloriter=coloriter-1;
				}
				else {
					coloriter=coloriter+1;
				}
			}
			coloriter=coloriter+2;
			if (coloriter < 0) {
				coloriter = coloriter+128;
			}
		}
	}
	void loop(void)
	{
		z=((p1-1)*z^p1+p2)/(p1*z^(p1-1));
		if (|z^p1-p2|<=0.001)
		{
			bContinue=false;
			if(cabs(imag(z)) < 0.01) {
				z=real(z);
			}
			temp=log(z);
			tmp=temp*p1;
			mod = imag(tmp)/(2*pi);
			coloriter = mod;
			if(cabs(mod - coloriter) > 0.5) {
				if(mod < 0.0) {
					coloriter=coloriter-1;
				}
				else {
					coloriter=coloriter+1;
				}
			}
			coloriter=coloriter+2;
			if (coloriter < 0) {
				coloriter = coloriter+128;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-complexbasin";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Degree";
		p1.default=(3,0);

		p2.caption="Root";
		p2.default=(1,0);
	}
}

complexnewton
{
parameter complex p1;
parameter complex p2;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;

	void init(void)
	{
		if (rBiomorph>=0)
		{
			formulaBailout=100;
		}
		else
		{
			formulaBailout=4;
		}
		z=pixel;
		bContinue=true;
		if (|z^p1-p2|<=0.001)
		{
			bContinue=false;
		}
	}
	void loop(void)
	{
		z=((p1-1)*z^p1+p2)/(p1*z^(p1-1));
		if (|z^p1-p2|<=0.001)
		{
			bContinue=false;
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-complexnewton";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Degree";
		p1.default=(3,0);

		p2.caption="Root";
		p2.default=(1,0);
	}
}

escher_julia
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
real testsize;
int testiter;
complex iz;
shared real coloriter;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		coloriter=0;
	}
	void loop(void)
	{
		z=z^2;
		coloriter=coloriter+1;
		for (testiter=0,testsize=0,iz=z*15;testsize <= formulaBailout && testiter < maxiter;testiter=testiter+1,testsize=|iz|)
		{
			iz=iz^2+p1;
		}
		if (testsize>formulaBailout)
		{
			if (|z|>formulaBailout)
			{
				bContinue=false;
			}
		}
		else
		{
			coloriter = ((3 * coloriter)%255)+1;
			bContinue=false;
		}			
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-escher_julia";
		this.center=(0,0);
		this.magn=1.25;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=0;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Parameter";
		p1.default=(0.32,0.043);
	}
}

fn_z+fn_pix
{
parameter real bailout;
parameter complex p1,p2;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
complex tmp;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
		tmp=p2*fn2(pixel);
	}
	void loop(void)
	{
		z = fn1(z) + tmp;
		if (bailouttest=="mod") {
			if (|z|>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="or") {
			if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="and") {
			if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manh") {
			if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manr") {
			if (sqr(real(z)+imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-fn(z)+fn(pix)";
		this.center=(0,0);
		this.magn=0.5555555555555;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);
		
		fn1.caption="Function 1";
		fn1.default="sin";

		fn2.caption="Function 2";
		fn2.default="sqr";

		p2.caption="Function 2:Coeff";
		p2.default=(1,0);
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

fn_z*z
{
parameter real bailout;
parameter complex p1;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		z = fn1(z*z);
		if (bailouttest=="mod") {
			if (|z|>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="or") {
			if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="and") {
			if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manh") {
			if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manr") {
			if (sqr(real(z)+imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-fn(z*z)";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);
		
		fn1.caption="Function 1";
		fn1.default="sin";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

fn*fn
{
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		z = fn1(z)*fn2(z);
		if (bailouttest=="mod") {
			if (|z|>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="or") {
			if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="and") {
			if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manh") {
			if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manr") {
			if (sqr(real(z)+imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-fn*fn";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		fn1.caption="Function 1";
		fn1.default="sin";

		fn2.caption="Function 2";
		fn2.default="sqr";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

fn*z+z
{
parameter real bailout;
parameter complex p1,p2;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
	}
	void loop(void)
	{
		z=p1*fn1(z)*z + p2*z;
		if (bailouttest=="mod") {
			if (|z|>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="or") {
			if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="and") {
			if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manh") {
			if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manr") {
			if (sqr(real(z)+imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-fn*z+z";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Coeff of Function 1";
		p1.default=(1,0);

		p2.caption="Coeff of Term 2";
		p2.default=(1,0);
		
		fn1.caption="Function 1";
		fn1.default="sin";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

fn+fn
{
parameter real bailout;
parameter complex p1,p2;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
	}
	void loop(void)
	{
		z=p1*fn1(z)+p2*fn2(z);
		if (bailouttest=="mod") {
			if (|z|>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="or") {
			if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="and") {
			if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manh") {
			if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manr") {
			if (sqr(real(z)+imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-fn+fn";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Coeff of Function 1";
		p1.default=(1,0);

		p2.caption="Coeff of Function 2";
		p2.default=(1,0);
		
		fn1.caption="Function 1";
		fn1.default="sin";

		fn2.caption="Function 2";
		fn2.default="sqr";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

spider
{
parameter real bailout;
parameter complex p1;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
complex c;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		c=pixel;
		bContinue=true;
	}
	void loop(void)
	{
		z=z^2+c;
		c=c*0.5+z;
		
		if (bailouttest=="mod") {
			if (|z|>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="or") {
			if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="and") {
			if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manh") {
			if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manr") {
			if (sqr(real(z)+imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-spider";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

tetrate
{
parameter real bailout;
parameter complex p1;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
	}
	void loop(void)
	{
		z=pixel^z;
		
		if (bailouttest=="mod") {
			if (|z|>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="or") {
			if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="and") {
			if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manh") {
			if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
				bContinue=false;
			}
		}
		else if (bailouttest=="manr") {
			if (sqr(real(z)+imag(z))>formulaBailout) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-tetrate";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

frothybasin
{
parameter real bailout;
parameter int p1;
parameter real p2;
parameter real p3;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
real sin_theta, cos_theta;
bool repeat_mapping,altcolor;
int attractors;
real x0,y0,halfa;
real top_x1,top_x2,top_x3,top_x4;
real left_x1,left_x2,left_x3,left_x4;
real right_x1,right_x2,right_x3,right_x4;
real shades;
int orbit_color;
real FROTH_CLOSE,FROTH_SLOPE;
int found_attractor;
shared real coloriter;

	real froth_top_x_mapping(real dx)
	{
		return(dx*dx-dx-3*p3*p3/4);
	}
	void init_once(void)
	{
		FROTH_CLOSE=1E-6;
		FROTH_SLOPE=1.732050807568877193;
		sin_theta=sin(2*pi/3);
		cos_theta=cos(2*pi/3);
		if (p1==2 || p1==6) {
			repeat_mapping=true;			
		} else {
			repeat_mapping=false;
		}
		if (p2!=0) {
			altcolor=true;
		} else {
			altcolor=false;
		}
		if (cabs(p3) <= 1.028713768218725)
		{
			if (repeat_mapping) {
				attractors=6;
			} else {
				attractors=3;
			}
		}
		else
		{
			if (repeat_mapping) {
				attractors=3;
			} else {
				attractors=2;
			}
		}
		x0 = 0.5;
		y0 = halfa = p3/2;
		top_x1 = froth_top_x_mapping(x0);
		top_x2 = froth_top_x_mapping(top_x1);
		top_x3 = froth_top_x_mapping(top_x2);
		top_x4 = froth_top_x_mapping(top_x3);

		left_x1 = top_x1 * cos_theta - y0 * sin_theta;
		left_x2 = top_x2 * cos_theta - y0 * sin_theta;
		left_x3 = top_x3 * cos_theta - y0 * sin_theta;
		left_x4 = top_x4 * cos_theta - y0 * sin_theta;

		right_x1 = top_x1 * cos_theta + y0 * sin_theta;
		right_x2 = top_x2 * cos_theta + y0 * sin_theta;
		right_x3 = top_x3 * cos_theta + y0 * sin_theta;
		right_x4 = top_x4 * cos_theta + y0 * sin_theta;
		
		if (attractors>3) {
			shades = (252-1) / attractors;
		} else {
			shades = (252-1) / 3;
		}
		if (attractors!=6) {
			orbit_color = (shades*2)+1;
		}
		else {
			orbit_color = 251;
		}
	}
	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=7;
			}
		}
		if (formulaBailout<7) {
			formulaBailout=7;
		}
		z=pixel;
		bContinue=true;
		found_attractor=0;
		coloriter=0.01;		
	}
	void loop(void)
	{
		z=z^2+conj(z*(-1+flip(p3)));
		if (repeat_mapping) {
			z=z^2+conj(z*(-1+flip(p3)));
		}
		if (cabs(halfa-imag(z)) < FROTH_CLOSE && real(z) >= top_x1 && real(z) <= top_x2)
		{
			if ((!repeat_mapping && attractors == 2) || (repeat_mapping && attractors == 3)) {
				found_attractor = 1;
			}
			else if (real(z) <= top_x3) {
				found_attractor = 1;
			}
			else if (real(z) >= top_x4) {
				if (!repeat_mapping) {
					found_attractor = 1;
				} else {
					found_attractor = 2;
				}
			}
		}
		else if (cabs(FROTH_SLOPE*real(z) - p3 - imag(z)) < FROTH_CLOSE && real(z) <= right_x1 && real(z) >= right_x2)
		{
			if (!repeat_mapping && attractors == 2) {
				found_attractor = 2;
			}
			else if (repeat_mapping && attractors == 3) {
				found_attractor = 3;
			}
			else if (real(z) >= right_x3) {
				if (!repeat_mapping) {
					found_attractor = 2;
				} else {
			 		found_attractor = 4;
				}
			}
			else if (real(z) <= right_x4) {
				if (!repeat_mapping) {
			 		found_attractor = 3;
				} else {
			 		found_attractor = 6;
				}
			}
		}
		else if (cabs(-FROTH_SLOPE*real(z) - p3 - imag(z)) < FROTH_CLOSE && real(z) <= left_x1 && real(z) >= left_x2)
		{
			if (!repeat_mapping && attractors == 2) {
				found_attractor = 2;
			}
			else if (repeat_mapping && attractors == 3) {
				found_attractor = 2;
			}
			else if (real(z) >= left_x3) {
				if (!repeat_mapping) {
					found_attractor = 3;
				} else {
					found_attractor = 5;
				}
			}
			else if (real(z) <= left_x4) {
				if (!repeat_mapping) {
					found_attractor = 2;
				} else {
					found_attractor = 3;
				}
			}
		}
		if (found_attractor>0 || |z|>=formulaBailout) {
			bContinue=false;
			coloriter=numiter;
			if (found_attractor>0) {
				if (!altcolor) {
					if (coloriter > shades) {
						coloriter = shades;
					}
				} else {
					coloriter = shades * coloriter / maxiter;
				}
				if (coloriter == 0) {
					coloriter = 1;
				}
				coloriter = coloriter+shades * (found_attractor-1);
			} else {
				coloriter=0.01;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-frothybasin";
		this.center=(0,-0.5);
		this.magn=0.714285;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Mapping";
		p1.default=1;
		
		p2.caption="Color Shading";
		p2.default=0;
		
		p3.caption="Imag c";
		p3.default=1.028713768218725;

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

halley
{
parameter int p1;
parameter real p2,p3,p4;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
int order;
real zmod,zmod_old;
complex z0,z1,z2;
complex f0,f1,f2;
complex Halnumber1,Halnumber2,Haldenom;
complex relax;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (rBiomorph>=0)
		{
			formulaBailout=100;
		}
		else
		{
			formulaBailout=0;
		}
		if (p1<2) {
			order=2;
		} else {
			order=p1;
		}
		z=pixel;
		relax=p2+flip(p4);
		bContinue=true;
		zmod=|z|;
		zmod_old=1E10;
	}
	void loop(void)
	{
		z0=z^(p1-1);
		z1=z0*z;
		z2=z1*z;

		f0=z2-z;
		f1=(p1+1)*z1-1;
		f2=(p1+1)*p1*z0;
		
		z=z-relax*f0/(f1-f0*f2/(2*f1));
		zmod_old=zmod;
		zmod=|z|;
	}
	bool bailout(void)
	{
		return(cabs(zmod-zmod_old)>=p3);
	}
	void description(void)
	{
		this.title="FractInt-halley";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Order";
		p1.default=6;

		p2.caption="Real Relax Coeff";
		p2.default=1;

		p3.caption="Epsilon";
		p3.default=0.0001;

		p4.caption="Imag Relax Coeff";
		p4.default=0;
	}
}

hypercomplex
{
parameter complex p1,p2;
parameter real bailout;
shared real formulaBailout;
shared real rBiomorph;
real qr,qi,qj,qk;
real zr,zi,zj,zk;
complex a,b;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		// We must use p1, otherwise it will be removed
		// by the optimizer. The following statement thus is
		// just a dummy statement.
		qr=p1;
		
		qr=real(pixel);
		qi=imag(pixel);
		qj=real(p2);
		qk=imag(p2);
		
		zr=zi=zj=zk=0;
	}
	void loop(void)
	{
		a=fn1( (zr - zk) + flip(zi + zj) );
		b=fn1( (zr + zk) + flip(zi - zj) );

		zr =  qr + (real(a) + real(b))/2;
		zi =  qi + (imag(a) + imag(b))/2;
		zj =  qj + (imag(a) - imag(b))/2;
		zk =  qk + (real(b) - real(a))/2;
	}
	bool bailout(void)
	{
		return(|zr|+|zi|+|zj|+|zk|<formulaBailout);
	}
	void description(void)
	{
		this.title="FractInt-hypercomplex";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Not Used";
		p1.default=(0,0);
		p1.visible=false;

		p2.caption="(cj,ck)";
		p2.default=(0,0);

		fn1.caption="First Function";
		fn1.default="sin";

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

hypercomplexj
{
parameter complex p1,p2,p3;
parameter real bailout;
shared real formulaBailout;
shared real rBiomorph;
real qr,qi,qj,qk;
complex zjk;
complex a,b;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		qr=real(p1);
		qi=imag(p1);
		qj=real(p2);
		qk=imag(p2);
		
		z=pixel;
		zjk=p3;
	}
	void loop(void)
	{
		a=fn1( z - imag(zjk) + flip(real(zjk)) );
		b=fn1( z + imag(zjk) - flip(real(zjk)) );

		z =  (a+b)/2 + p1;

		zjk =   (qj + (imag(a) - imag(b))/2) + 
		    flip(qk + (real(b) - real(a))/2);
	}
	bool bailout(void)
	{
		return(|z|+|zjk|<formulaBailout);
	}
	void description(void)
	{
		this.title="FractInt-hypercomplexj";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="(cr,ci)";
		p1.default=(-0.745,0);

		p2.caption="(cj,ck)";
		p2.default=(0.113,0.05);
		
		p3.caption="(zj,zk)";
		p3.default=(0,0);

		fn1.caption="First Function";
		fn1.default="sin";

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

julfn+exp
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = fn1(z) + exp(z) + p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-julfn+exp";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(0,0);
		
		fn1.caption="Function 1";
		fn1.default="sin";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

julfn+zsqrd
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = fn1(z) + z^2 + p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-julfn+zsqrd";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(-0.5, 0.5);
		
		fn1.caption="Function 1";
		fn1.default="sin";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

julia_fn||fn
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (|z|<p2) {
			z = fn1(z)+p1;
		} else {
			z = fn2(z)+p1;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-julia(fn||fn)";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(0,0);
		
		p2.caption="Function Shift";
		p2.default=8;
		
		fn1.caption="Function 1";
		fn1.default="sin";

		fn2.caption="Function 2";
		fn2.default="sqr";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

lambda_fn||fn
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (|z|<p2) {
			z = fn1(z)*p1;
		} else {
			z = fn2(z)*p1;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-lambda(fn||fn)";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(1, 0.1);
		
		p2.caption="Function Shift";
		p2.default=1;
		
		fn1.caption="Function 1";
		fn1.default="sin";

		fn2.caption="Function 2";
		fn2.default="sqr";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

mandel_fn||fn
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=p1+pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (|z|<p2) {
			z = fn1(z)+pixel;
		} else {
			z = fn2(z)+pixel;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-mandel(fn||fn)";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);
		
		p2.caption="Function Shift";
		p2.default=0.5;
		
		fn1.caption="Function 1";
		fn1.default="sin";

		fn2.caption="Function 2";
		fn2.default="sqr";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

manlam_fn||fn
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		z=p1+pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (|z|<p2) {
			z = fn1(z)*pixel;
		} else {
			z = fn2(z)*pixel;
		}
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-manlam(fn||fn)";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);
		
		p2.caption="Function Shift";
		p2.default=10;
		
		fn1.caption="Function 1";
		fn1.default="sin";

		fn2.caption="Function 2";
		fn2.default="sqr";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

manfn+zsqrd
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = fn1(z) + z^2 + pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-manfn+zsqrd";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(0,0);
		
		fn1.caption="Function 1";
		fn1.default="sin";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

julzpower
{
parameter complex p1,p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^p2+p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-julzpower";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(0.3,0.6);

		p2.caption="Exponent";
		p2.default=(2,0);
	
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

manzpower
{
parameter complex p1,p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^p2+pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-manzpower";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		p2.caption="Exponent";
		p2.default=(2,0);
	
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

julzzpwr
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^z+z^p2+p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-julzzpwr";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(-0.3, 0.3);

		p2.caption="Exponent";
		p2.default=2;
	
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

manzzpwr
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^z+z^p2+pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-manzzpwr";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		p2.caption="Exponent";
		p2.default=2;
	
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

manfn+exp
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel+p1;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = fn1(z) + exp(z) + pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-manfn+exp";
		this.center=(0,0);
		this.magn=0.25;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(0,0);
		
		fn1.caption="Function 1";
		fn1.default="sin";
		
		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

magnet1j
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
complex lz;
complex attr[20];
int attrperiod[20];
int attractors;
int iCnt;
real distx,disty;

	void getJuliaAttractor(complex startPoint)
	{
	int iMaxiter,curIter;
	complex z,result;
	real closenuff;
	
		closenuff=0.00001;
		iMaxiter=maxiter;
		if (iMaxiter < 500) {
			iMaxiter = 500;
		}
		z=startPoint;
		for (curIter=1;curIter<iMaxiter;curIter=curIter+1)
		{
			z = sqr((z^2+(p1-1)) / (2*z+(p1-2)));
			if(|z| >= formulaBailout) {
				break;
			}
		}
		if (curIter >= iMaxiter)      /* if orbit stays in the lake */
		{
			result =  z;
			for (iCnt=0;iCnt<10;iCnt=iCnt+1) {
				z = sqr((z^2+(p1-1)) / (2*z+(p1-2)));
				if (|z| < formulaBailout) {
					if(cabs(real(result)-real(z)) < closenuff && cabs(imag(result)-imag(z)) < closenuff) {
						attr[attractors] = z;
						attrperiod[attractors] = iCnt+1;
						attractors=attractors+1;   /* another attractor - coloured lakes ! */
						break;
					}
				} else {
					break;
				}
			}
		}
	}
	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=100;
			}
		}
		attr[0] =(1,0);
		attrperiod[0] = 1;
		attractors = 1;
		z=0;
		getJuliaAttractor(z);
		z=pixel;
		bContinue=true;
	}
	void loop(void)
	{
		lz=z;
		z = sqr((z^2+(p1-1)) / (2*z+(p1-2)));
		if (|z| >= formulaBailout) {
			bContinue=false;
		} else {
			for (iCnt = 0; iCnt < attractors; iCnt=iCnt+1)
			{
				distx = sqr(real(z) - real(attr[iCnt]));
				if (distx < 1/32768)
				{
					disty = sqr(imag(z) - imag(attr[iCnt]));
					if ( disty < 1/32768)
					{
						if ((distx + disty) < 1/32768)
						{
							bContinue=false;
							break;
						}
					}
				}
			}
		}		
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-magnet1j";
		this.center=(0,0);
		this.magn=0.25;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(0,0);

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

magnet1m
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
complex lz;
complex attr[20];
int attrperiod[20];
int attractors;
int iCnt;
real distx,disty;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=100;
			}
		}
		attr[0] =(1,0);
		attrperiod[0] = 1;
		attractors = 1;
		z=p1;
		bContinue=true;
	}
	void loop(void)
	{
		lz=z;
		z = sqr((z^2+(pixel-1)) / (2*z+(pixel-2)));
		if (|z| >= formulaBailout) {
			bContinue=false;
		} else {
			for (iCnt = 0; iCnt < attractors; iCnt=iCnt+1)
			{
				distx = sqr(real(z) - real(attr[iCnt]));
				if (distx < 1/32768)
				{
					disty = sqr(imag(z) - imag(attr[iCnt]));
					if ( disty < 1/32768)
					{
						if ((distx + disty) < 1/32768)
						{
							bContinue=false;
							break;
						}
					}
				}
			}
		}		
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-magnet1m";
		this.center=(0,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

magnet2j
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
complex lz;
complex attr[20];
int attrperiod[20];
int attractors;
int iCnt;
real distx,disty;

	void getJuliaAttractor(complex startPoint)
	{
	int iMaxiter,curIter;
	complex z,result;
	real closenuff;
	
		closenuff=0.00001;
		iMaxiter=maxiter;
		if (iMaxiter < 500) {
			iMaxiter = 500;
		}
		z=startPoint;
		for (curIter=1;curIter<iMaxiter;curIter=curIter+1)
		{
			z = sqr((z^2+(p1-1)) / (2*z+(p1-2)));
			if(|z| >= formulaBailout) {
				break;
			}
		}
		if (curIter >= iMaxiter)      /* if orbit stays in the lake */
		{
			result =  z;
			for (iCnt=0;iCnt<10;iCnt=iCnt+1) {
				z = sqr((z^2+(p1-1)) / (2*z+(p1-2)));
				if (|z| < formulaBailout) {
					if(cabs(real(result)-real(z)) < closenuff && cabs(imag(result)-imag(z)) < closenuff) {
						attr[attractors] = z;
						attrperiod[attractors] = iCnt+1;
						attractors=attractors+1;   /* another attractor - coloured lakes ! */
						break;
					}
				} else {
					break;
				}
			}
		}
	}
	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=100;
			}
		}
		attr[0] =(1,0);
		attrperiod[0] = 1;
		attractors = 1;
		z=0;
		getJuliaAttractor(z);
		z=pixel;
		bContinue=true;
	}
	void loop(void)
	{
		lz=z;
		z = sqr( (z^3 + 3*(p1-1)*z + (p1-1)*(p1-2)) / (3*z^2 + 3*(p1-2)*z + (p1-1)*(p1-2) + 1) );

		if (|z| >= formulaBailout) {
			bContinue=false;
		} else {
			for (iCnt = 0; iCnt < attractors; iCnt=iCnt+1)
			{
				distx = sqr(real(z) - real(attr[iCnt]));
				if (distx < 1/32768)
				{
					disty = sqr(imag(z) - imag(attr[iCnt]));
					if ( disty < 1/32768)
					{
						if ((distx + disty) < 1/32768)
						{
							bContinue=false;
							break;
						}
					}
				}
			}
		}		
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-magnet2j";
		this.center=(0,0);
		this.magn=0.25;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter";
		p1.default=(0,0);

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

magnet2m
{
parameter complex p1;
parameter real p2;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
complex lz;
complex attr[20];
int attrperiod[20];
int attractors;
int iCnt;
real distx,disty;

	void getJuliaAttractor(complex startPoint)
	{
	int iMaxiter,curIter;
	complex z,result;
	real closenuff;
	
		closenuff=0.00001;
		iMaxiter=maxiter;
		if (iMaxiter < 500) {
			iMaxiter = 500;
		}
		z=startPoint;
		for (curIter=1;curIter<iMaxiter;curIter=curIter+1)
		{
			z = sqr((z^2+(p1-1)) / (2*z+(p1-2)));
			if(|z| >= formulaBailout) {
				break;
			}
		}
		if (curIter >= iMaxiter)      /* if orbit stays in the lake */
		{
			result =  z;
			for (iCnt=0;iCnt<10;iCnt=iCnt+1) {
				z = sqr((z^2+(p1-1)) / (2*z+(p1-2)));
				if (|z| < formulaBailout) {
					if(cabs(real(result)-real(z)) < closenuff && cabs(imag(result)-imag(z)) < closenuff) {
						attr[attractors] = z;
						attrperiod[attractors] = iCnt+1;
						attractors=attractors+1;   /* another attractor - coloured lakes ! */
						break;
					}
				} else {
					break;
				}
			}
		}
	}
	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=100;
			}
		}
		attr[0] =(1,0);
		attrperiod[0] = 1;
		attractors = 1;
		z=p1;
		bContinue=true;
	}
	void loop(void)
	{
		lz=z;
		z = sqr( (z^3 + 3*(pixel-1)*z + (pixel-1)*(pixel-2)) / (3*z^2 + 3*(pixel-2)*z + (pixel-1)*(pixel-2) + 1) );

		if (|z| >= formulaBailout) {
			bContinue=false;
		} else {
			for (iCnt = 0; iCnt < attractors; iCnt=iCnt+1)
			{
				distx = sqr(real(z) - real(attr[iCnt]));
				if (distx < 1/32768)
				{
					disty = sqr(imag(z) - imag(attr[iCnt]));
					if ( disty < 1/32768)
					{
						if ((distx + disty) < 1/32768)
						{
							bContinue=false;
							break;
						}
					}
				}
			}
		}		
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-magnet2m";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

julia4
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^4+p1;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-julia4";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Start";
		p1.default=(0.6,0.55);
		p1.hint="Parameter 1";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

mandel4
{
parameter complex p1;
parameter real bailout;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
parameter int bailouttest;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter real bailin;
complex lz,cyc;
int Maxit_2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z = z^4+pixel;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-mandel4";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Start";
		p1.default=(0,0);
		p1.hint="Parameter 1";

		bailouttest.caption="Bailout Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
				
		bailout.caption="Bailout";
		bailout.default=0;

		separator.label1.caption="Test for Attractor";

		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

mandellambda
{
parameter complex p1;
parameter real bailout;
parameter real bailin;
parameter int bailouttest;
shared real formulaBailout;
shared real rBiomorph;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
complex lz,cyc;
int Maxit_2;
real dmax,dmin,zabs;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+(0.5,0);
		dmax=cabs(pixel)+bailin;
		dmin=cabs(pixel)-bailin;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		z=pixel*z*(1-z);
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-mandellambda";
		this.center=(1,0);
		this.magn=0.5;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);
		
		bailout.caption="Bailout";
		bailout.default=0;

		bailouttest.caption="Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
		
		separator.label1.caption="Test for Attractor";
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

mandphoenix
{
parameter complex p1;
parameter int p2;
parameter real bailout;
parameter real bailin;
parameter int bailouttest;
shared real formulaBailout;
shared real rBiomorph;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
complex lz,cyc;
int Maxit_2;
int degree;
real rPixel,iPixel;
complex cy;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		cy=0;
		bContinue=true;
		Maxit_2=maxiter/2;
		if (p2<2 && p2>-3) {
			degree = 0;
		} else {
			degree=p2;
		}
		rPixel=real(pixel);
		iPixel=imag(pixel);
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (degree==0) {
			/* z(n+1) = z(n)^2 + p + qy(n),  y(n+1) = z(n) */
			z=z^2+rPixel+iPixel*cy;
		} else if (degree>=2) {
			/* z(n+1) = z(n)^(degree-1) * (z(n) + p) + qy(n),  y(n+1) = z(n) */
			z=z^(degree-1)*(z+rPixel)+iPixel*cy;
		} else {
			/* z(n+1) = z(n)^(degree-2) * (z(n)^2 + p) + qy(n),  y(n+1) = z(n) */
			z=z^(cabs(degree)-2)*(z^2+rPixel)+iPixel*cy;
		}
		cy=lz;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-mandphoenix";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		p2.caption="Degree";
		p2.default=0;

		bailout.caption="Bailout";
		bailout.default=0;

		bailouttest.caption="Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
		
		separator.label1.caption="Test for Attractor";
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

phoenix
{
parameter complex p1;
parameter int p2;
parameter real bailout;
parameter real bailin;
parameter int bailouttest;
shared real formulaBailout;
shared real rBiomorph;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
complex lz,cyc;
int Maxit_2;
int degree;
real rPixel,iPixel;
complex cy;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		cy=0;
		bContinue=true;
		Maxit_2=maxiter/2;
		if (p2<2 && p2>-3) {
			degree = 0;
		} else {
			degree=p2;
		}
		rPixel=real(p1);
		iPixel=imag(p1);
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (degree==0) {
			/* z(n+1) = z(n)^2 + p + qy(n),  y(n+1) = z(n) */
			z=z^2+rPixel+iPixel*cy;
		} else if (degree>=2) {
			/* z(n+1) = z(n)^(degree-1) * (z(n) + p) + qy(n),  y(n+1) = z(n) */
			z=z^(degree-1)*(z+rPixel)+iPixel*cy;
		} else {
			/* z(n+1) = z(n)^(degree-2) * (z(n)^2 + p) + qy(n),  y(n+1) = z(n) */
			z=z^(cabs(degree)-2)*(z^2+rPixel)+iPixel*cy;
		}
		cy=lz;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-phoenix";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter 1";
		p1.default=(0.56667,-0.5);

		p2.caption="Degree";
		p2.default=0;

		bailout.caption="Bailout";
		bailout.default=0;

		bailouttest.caption="Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
		
		separator.label1.caption="Test for Attractor";
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

phoenixcplx
{
parameter complex p1,p2;
parameter int p3;
parameter real bailout;
parameter real bailin;
parameter int bailouttest;
shared real formulaBailout;
shared real rBiomorph;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
complex lz,cyc;
int Maxit_2;
int degree;
complex cy;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
		cy=0;
		bContinue=true;
		Maxit_2=maxiter/2;
		if (p3<2 && p3>-3) {
			degree = 0;
		} else {
			degree=p3;
		}
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (degree==0) {
			/* z(n+1) = z(n)^2 + p + qy(n),  y(n+1) = z(n) */
			z=z^2+p1+p2*cy;
		} else if (degree>=2) {
			/* z(n+1) = z(n)^(degree-1) * (z(n) + p) + qy(n),  y(n+1) = z(n) */
			z=z^(degree-1)*(z+p1)+p2*cy;
		} else {
			/* z(n+1) = z(n)^(degree-2) * (z(n)^2 + p) + qy(n),  y(n+1) = z(n) */
			z=z^(cabs(degree)-2)*(z^2+p1)+p2*cy;
		}
		cy=lz;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-phoenixcplx";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Parameter 1";
		p1.default=(0.2,0);

		p2.caption="Parameter 2";
		p2.default=(0.3,0);

		p3.caption="Degree";
		p3.default=0;

		bailout.caption="Bailout";
		bailout.default=0;

		bailouttest.caption="Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
		
		separator.label1.caption="Test for Attractor";
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

mandphoenixclx
{
parameter complex p1,p2;
parameter int p3;
parameter real bailout;
parameter real bailin;
parameter int bailouttest;
shared real formulaBailout;
shared real rBiomorph;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
complex lz,cyc;
int Maxit_2;
int degree;
complex cy;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=p1+pixel;
		cy=0;
		bContinue=true;
		Maxit_2=maxiter/2;
		if (p3<2 && p3>-3) {
			degree = 0;
		} else {
			degree=p3;
		}
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (degree==0) {
			/* z(n+1) = z(n)^2 + p + qy(n),  y(n+1) = z(n) */
			z=z^2+pixel+p2*cy;
		} else if (degree>=2) {
			/* z(n+1) = z(n)^(degree-1) * (z(n) + p) + qy(n),  y(n+1) = z(n) */
			z=z^(degree-1)*(z+pixel)+p2*cy;
		} else {
			/* z(n+1) = z(n)^(degree-2) * (z(n)^2 + p) + qy(n),  y(n+1) = z(n) */
			z=z^(cabs(degree)-2)*(z^2+pixel)+p2*cy;
		}
		cy=lz;
		if (bailouttest=="mod") {
			if (testInf) {
				if (|z|>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (|lz-z|<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && |cyc-z|<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="real") {
			if (sqr(real(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="imag") {
			if (sqr(imag(z))>formulaBailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="or") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout || sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="and") {
			if (testInf) {
				if (sqr(real(z))>formulaBailout && sqr(imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+abs(imag(z)))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailouttest=="manr") {
			if (testInf) {
				if (sqr(real(z)+imag(z))>formulaBailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-mandphoenixclx";
		this.center=(-0.5,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Perturbation";
		p1.default=(0,0);

		p2.caption="Parameter";
		p2.default=(0.5,0);

		p3.caption="Degree";
		p3.default=0;

		bailout.caption="Bailout";
		bailout.default=0;

		bailouttest.caption="Test";
		bailouttest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr";
		bailouttest.default=0;
		
		separator.label1.caption="Test for Attractor";
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;

		bailin.caption="Finite Basin";
		bailin.hint="Lets you specify the radius of the small circle around a finite attractor. If the pixel lies inside this circle, the pixel bails out.";
		bailin.default=0.000030517578125;
		bailin.visible=(testFin==true || testCyc==true);
	}
}

newtbasin
{
parameter int p1;
parameter bool p2;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
complex tmp,newz;
real mod;
shared real coloriter;
real tempcolor;
int degree;
real root;
complex roots[p1+10];
int iCnt;
real FLT_MIN;
real threshold,maxcolor;

	void init(void)
	{
		FLT_MIN=1.17549435E-38;
		if (rBiomorph>=0)
		{
			formulaBailout=100;
		}
		else
		{
			formulaBailout=0;
		}
		z=pixel;
		if (p1<2) {
			degree=3;
		} else {
			degree=p1;
		}
		for (iCnt=0;iCnt<degree;iCnt=iCnt+1) {
			roots[iCnt] = cos(2*iCnt*pi/degree) + flip( sin(2*iCnt*pi/degree));
		}
		maxcolor     = 0;
		threshold    = 0.3*pi/degree;
		root=1;
		bContinue=true;
	}
	void loop(void)
	{
		tmp=z^(degree-1);
		newz=z*tmp;
		
		if (|newz-1|<threshold) {
			tempcolor=-1;
			for(iCnt=0;iCnt<degree;iCnt=iCnt+1) {
				if (|roots[iCnt]-z| < threshold){
					if (p2) {
						tempcolor = 1+(iCnt%8)+(((numiter+1)%2)*8);
					} else {
						tempcolor = 1+iCnt;
					}
					break;
				}
			}
			if(tempcolor == -1) {
				coloriter = maxcolor;
			}else {
				coloriter = tempcolor;
			}
			bContinue=false;
		} else {
			mod=|tmp|;
			if (mod < FLT_MIN) {
				bContinue=false;
			} else {
				z=((degree-1)*newz+root)/(degree*tmp);
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-newtbasin";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Degree";
		p1.default=3;

		p2.caption="Stripes";
		p2.default=false;
	}
}

newton
{
parameter int p1;
bool bContinue;
shared real formulaBailout;
shared real rBiomorph;
complex tmp,newz;
real mod;
int degree;
real threshold;

	void init(void)
	{
		if (rBiomorph>=0)
		{
			formulaBailout=100;
		}
		else
		{
			formulaBailout=0;
		}
		z=pixel;
		if (p1<2) {
			degree=3;
		} else {
			degree=p1;
		}
		threshold    = 0.3*pi/degree;
		bContinue=true;
	}
	void loop(void)
	{
		tmp=z^(degree-1);
		newz=z*tmp;
		if (|newz-1|<threshold) {
			bContinue=false;
		} else {
			mod=|tmp|;
			if (mod < 1.17549435E-38) {
				bContinue=false;
			} else {
				z=((degree-1)*newz+1)/(degree*tmp);
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt-newton";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		p1.caption="Degree";
		p1.default=3;
	}
}

popcornjul
{
parameter complex p1,p2;
parameter real bailout;
shared real formulaBailout;
shared real rBiomorph;
real zx,zy,tmp;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=4;
			}
		}
		z=pixel;
	}
	void loop(void)
	{
		zx=real(z);
		zy=imag(z);
		tmp=zx - real(p1*fn1(zy+fn2(p2*zy))) - imag(p1*fn3(zx+fn4(p2*zx)));
		zy=zy - real(p1*fn3(zx+fn4(p2*zx))) - imag(p1*fn1(zy+fn2(p2*zy)));
		zx=tmp;
		
		z=zx+flip(zy);
	}
	bool bailout(void)
	{
		return(|z|<=formulaBailout && cabs(zx)<=formulaBailout && cabs(zy)<=formulaBailout);
	}
	void description(void)
	{
		this.title="FractInt-popcornjul";
		this.center=(0,0);
		this.magn=0.6666666666;
		this.angle=0;
		this.maxiter=149;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="Step Size";
		p1.default=(0.05,0);

		p2.caption="Constant C";
		p2.default=(3,0);

		fn1.caption="First Function";
		fn1.default="sin";

		fn2.caption="Second Function";
		fn2.default="tan";

		fn3.caption="Third Function";
		fn3.default="sin";

		fn4.caption="Fourth Function";
		fn4.default="tan";
		
		bailout.caption="Bailout";
		bailout.default=0;
	}
}

quatjul
{
parameter quaternion p1;
parameter complex p2;
parameter real bailout;
shared real formulaBailout;
shared real rBiomorph;
quaternion q;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		q=hiquat(pixel)+loquat(p2);
	}
	void loop(void)
	{
		q=q*q+p1;
	}
	bool bailout(void)
	{
		return(|q|<=formulaBailout);
	}
	void description(void)
	{
		this.title="FractInt-quatjul";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="(cr,ci,cj,ck)";
		p1.default=(-0.745, 0.0,0.113,0.05);

		p2.caption="(zj,zk)";
		p2.default=(0,0);

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

quat
{
parameter complex p1,p2;
parameter real bailout;
shared real formulaBailout;
shared real rBiomorph;
quaternion q,c;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=64;
			}
		}
		q=p1;
		c=hiquat(pixel)+loquat(p2);
		q=0;
	}
	void loop(void)
	{
		q=q*q+c;
	}
	bool bailout(void)
	{
		return(|q|<=formulaBailout);
	}
	void description(void)
	{
		this.title="FractInt-quat";
		this.center=(0,0);
		this.magn=1;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="not used";
		p1.default=(0,0);
		p1.enabled=false;

		p2.caption="(cj,ck)";
		p2.default=(0,0);

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

sierpinski
{
parameter real bailout;
shared real formulaBailout;
shared real rBiomorph;
real zx,zy,tmp;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=127;
			}
		}
		z=pixel;
	}
	void loop(void)
	{
		if (imag(z)>0.5) {
			z=2*z-1i;
		} else if (real(z)>0.5) {
			z=2*z-1;
		} else {
			z=2*z;
		}
	}
	bool bailout(void)
	{
		return(|z|<=formulaBailout);
	}
	void description(void)
	{
		this.title="FractInt-sierpinski";
		this.center=(0.4, 0.4);
		this.magn=1.153846;
		this.angle=0;
		this.maxiter=149;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";

		bailout.caption="Bailout";
		bailout.default=0;
	}
}

unity
{
shared real formulaBailout;
shared real rBiomorph;
real zx,zy,one;
real ddelmin,delxx,delxx2,delyy,delyy2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!
		if (rBiomorph>=0)
		{
			formulaBailout=100;
		}
		else
		{
			formulaBailout=0;
		}
		z=pixel;
		one=|z|;
		
		delxx  = (real(corner_rightbottom) - real(corner_lefttop)) / width;
		delyy  = (imag(corner_lefttop) - imag(corner_rightbottom)) / height;
		delxx2 = (real(corner_lefttop) - real(corner_lefttop)) / height;
		delyy2 = (imag(corner_rightbottom) - imag(corner_rightbottom)) / width;
		
		ddelmin = cabs(delxx);
		if (cabs(delxx2) > ddelmin) {
			ddelmin = cabs(delxx2);
		}
		if (cabs(delyy) > cabs(delyy2)) {
			if (cabs(delyy) < ddelmin) {
				ddelmin = cabs(delyy);
			}
		} else if (cabs(delyy2) < ddelmin) {
			ddelmin = cabs(delyy2);
		}
		//ddelmin=2/width;
	}
	void loop(void)
	{
		z=real(z)*(sqr(2-one)+flip(2-one));
		one=|z|;
	}
	bool bailout(void)
	{
		return((one <= 2.0) && (cabs(one - 1.0) >= ddelmin));
	}
	void description(void)
	{
		this.title="FractInt-unity";
		this.center=(0.4, 0.4);
		this.magn=1.153846;
		this.angle=0;
		this.maxiter=149;
		this.functionorder=1;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
	}
}

volterra-lotka
{
parameter real p1,p2;
parameter real bailout;
shared real formulaBailout;
shared real rBiomorph;
double h2,f1,g1,f2,g2;

	void init(void)
	{
		// Attention: The default bailout value depends on the Biomorph
		// setting!

		if (bailout>0)
		{
			formulaBailout=bailout;
		}
		else
		{
			if (rBiomorph>=0)
			{
				formulaBailout=100;
			}
			else
			{
				formulaBailout=256;
			}
		}
		z=pixel;
		h2=p1/2;
	}
	void loop(void)
	{
		f1 = real(z) - real(z)*imag(z);
		g1 = -imag(z) + real(z)*imag(z);
		
		f2 = real(z) + p2 * f1;
		g2 = imag(z) + p2 * g1;
		z =      real(z) + h2 * (f1 + (f2 - f2*g2)) + 
		   flip( imag(z) + h2 * (g1 + (-g2 + f2*g2))  );
		
	}
	bool bailout(void)
	{
		return(|z|<=formulaBailout);
	}
	void description(void)
	{
		this.title="FractInt-volterra-lotka";
		this.center=(3,2.25);
		this.magn=0.6666666666;
		this.angle=0;
		this.maxiter=149;

		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		p1.caption="h";
		p1.default=0.739;
		p1.min=0;
		p1.max=1;
		
		p2.caption="p";
		p2.default=0.739;
		p2.min=0;
		p2.max=1;

		bailout.caption="Bailout";
		bailout.default=0;
	}
}
