comment
{
  In this file there are two example formula files. They simply
  generate the stanard Mandelbrot or Julia fractal.
}

Mandelbrot {
parameter complex criticalpoint;
parameter complex power;
parameter real bailout;
real a,b,c;

	void init(void)
	{
		z=0;
		z=z^pixel;
	}
	void loop(void)
	{
		z=z^2 + pixel;
	}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}
	void description(void)
	{
		this.title = "Mandelbrot";
		this.helpfile = "dmj3\dmj3-pub-uf-ot.htm";

		power.caption = "Power";
		power.default = center+(2,3);
		power.hint = "Choose the exponent of the iteration formula for the Julia set.\nHigher (int-) values just lead to some kind of rotation symmetry. So try fractional or even complex numbers.";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
	}
}


Julia {
// Generic Julia set
parameter complex power;
parameter complex seed;
parameter real bailout;

	void init(void)
	{
		z = pixel;
	}
	void loop(void)
	{
		z = z^power + seed;
	}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}
	void description(void)
	{
		this.title = "Julia";
		this.center = (0, 0);
		this.magn = 1;

		seed.caption = "Julia seed";
		seed.default = (0.3,0.6);
		seed.hint = "Change this value as you like. Interesting Julia sets have seeds near the border of the Mandelbrot set.";

		power.caption = "Power";
		power.default = (2,0);
		power.hint = "Choose the exponent of the iteration formula for the Julia set. Higher (int-) values just lead to some kind of rotation symmetry. So try fractional or even complex numbers.";


		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";

	}
}

Hybrid(QUATERNION)
{
parameter real Bailout;
parameter quaternion c;

	void init(void)
	{
		z=pixel;
	}
	void loop(void)
	{
		z=z*z-c;
	}
	bool bailout(void)
	{
		return(|z| <= Bailout);
	}
	void description(void)
	{
		// this.helpfile="dd";
		c.default=(0.3,-0.44,-0.57,0.3);
		Bailout.default=16;
		this.maxiter=7;
	}
}


Juliobj(QUATERNION)
{
// A standard Mandelbrot set is a two dimensional
// object. One can change the initial value to
// obtain "pseudo" Mandelbrot sets.
// That means, the input value can be interpreted
// as a 4 dimensional value.
// And ChaosPro is able to calculate fractals
// based on 4 dimensional values.
// What I do here is to extract the inital quaternion
// into two complex numbers and calculate a Mandelbrot
// set based on those two numbers. Many other formulas
// can be adjusted like that to obtain true 3D images.
// Whether it makes sense, whether it produces
// beautilful images, you decide!
complex cPixel,cStart,cZ;
parameter real Bailout;
parameter real Slice;
parameter complex a1,a2;
complex c;
real w1,w2,w3;

	void init(void)
	{
		w1=real(hiquat(pixel));
		w2=imag(hiquat(pixel));
		w3=real(loquat(pixel));
		cStart=hiquat(pixel);
		c=a1+(a2-a1)*w3;
		cPixel=w2+flip(w1);
		cZ=cPixel;
		if (w3<-Slice)
		{
			cZ=Bailout;
		}
	}
	void loop(void)
	{
		cZ=cZ*cZ+c;
		z=hiquat(cZ)+c;
	}
	bool bailout(void)
	{
		return(|cZ| <= Bailout);
	}
	void description(void)
	{
		Bailout.default=16;
		this.maxiter=20;
		this.title="Julia Object";

		Slice.default=1;
		Slice.caption="Slice";
		Slice.hint="Lets you cut through the object...";

		a1.default=(0.3,0);
		a1.caption="Starting point";
		a1.hint="Specifies the starting position of slice";

		a2.default=(0.3,1);
		a2.caption="End point";
		a2.hint="Specifies the end position of slice";
	}
}


JuliaObject_3(QUATERNION)
{
// A standard Mandelbrot set is a two dimensional
// object. One can change the initial value to
// obtain "pseudo" Mandelbrot sets.
// That means, the input value can be interpreted
// as a 4 dimensional value.
// And ChaosPro is able to calculate fractals
// based on 4 dimensional values.
// What I do here is to extract the inital quaternion
// into two complex numbers and calculate a Mandelbrot
// set based on those two numbers. Many other formulas
// can be adjusted like that to obtain true 3D images.
// Whether it makes sense, whether it produces
// beautilful images, you decide!
complex cPixel,cStart,cZ;
parameter real Bailout;
parameter real Slice;
parameter complex a1,a2;
complex c;
real w1,w2,w3;

	void init(void)
	{
		w1=real(hiquat(pixel));
		w2=imag(hiquat(pixel));
		w3=real(loquat(pixel));
		cStart=hiquat(pixel);
		c=a1+(a2-a1)*w3;
		cPixel=hiquat(pixel);
		cZ=cPixel;
		if (w3<-Slice)
		{
			cZ=Bailout;
		}
	}
	void loop(void)
	{
		cZ=cZ*cZ*cZ+c;
		z=hiquat(cZ)+c;
	}
	bool bailout(void)
	{
		return(|cZ| <= Bailout);
	}
	void description(void)
	{
		Bailout.default=16;
		this.maxiter=20;
		this.title="Julia Object (Power=3)";

		Slice.default=1;
		Slice.caption="Slice";
		Slice.hint="Lets you cut through the object...";

		a1.default=(0.3,0);
		a1.caption="Starting point";
		a1.hint="Specifies the starting position of slice";

		a2.default=(0.3,1);
		a2.caption="End point";
		a2.hint="Specifies the end position of slice";
	}
}


CPTiera_Mandelbrot {
parameter complex criticalpoint;
parameter complex power;
parameter real bailout,bailin;
parameter complex d;
parameter int fractaltype,subtype;
complex c,z1,t;
bool bContinue;
parameter int bailoutmode;
parameter real bailoutvar;
parameter bool testinf,testfin,testcyc;
complex z_old,z_cyc;
int maxiter_2;
real dmax,dmin;

	void init(void)
	{
		bContinue=true;
		c=criticalpoint;
		shared_var=0;
		if (subtype=="manowar")
		{
			z1=pixel;
		}
		if (fractaltype==0)
		{
			z=pixel;
		}
		else
		{
			if (subtype=="Magnet 2")
			{
				z=criticalpoint;
			}
			else if (subtype=="c*fn1(z)" || subtype=="Barnsley1" || subtype=="Barnsley2" || subtype=="Barnsley3" || subtype=="fn(z)+fn(pixel)")
			{
				z=criticalpoint+pixel;
			}
			else if (subtype=="lambda")
			{
				z=0.5+criticalpoint;
			}
			else
			{
				z=criticalpoint+pixel;
			}
			c=pixel;
		}
		if (subtype=="cmplxmarks")
		{
			// c hoch (d-1) berechnen...
			t=c^(d-1);
		}
		maxiter_2=maxiter/2-1;
		dmin=sqrt(|pixel|)-bailin;
		dmax=sqrt(|pixel|)+bailin;
	}
	void loop(void)
	{
		z_old=z;
		if (numiter==maxiter_2)
		{
			z_cyc=z;
		}
		if (subtype=="z^2+c")
		{
			z=z^2 + c;
		}
		else if (subtype=="z^3+c")
		{
			z=z^3 + c;
		}
		else if (subtype=="exp(z)-z-c")
		{
			z=exp(z)-z-c;
		}
		else if (subtype=="Magnet 1")
		{
			z= sqr( ( z*z+(c-1) ) / ( 2*z+(c-2) ) );
		}
		else if (subtype=="Magnet 2")
		{
			z= sqr( ( z^3+3*(c-1)*z+(c-1)*(c-2) ) / ( 3*z^2+3*(c-2)*z+(c-1)*(c-2)+1 ) );
		}
		else if (subtype=="c*fn1(z)")
		{
			z=c*fn1(z);
		}
		else if (subtype=="Barnsley1")
		{
			if (real(z)>=0) {
				z=(z-1)*c;
			}
			else {
				z=(z+1)*c;
			}
		}
		else if (subtype=="Barnsley2")
		{
			if (real(z)*imag(c)+imag(z)*real(c)>=0) {
				z=(z-1)*c;
			}
			else {
				z=(z+1)*c;
			}
		}
		else if (subtype=="Barnsley3")
		{
			if (real(z)>=0) {
				z=z*z-1;
			}
			else {
				z=z*z-1+c*real(z);
			}
		}
		else if (subtype=="SQR(fn)+c")
		{
			z=sqr(fn1(z))+c;
		}
		else if (subtype=="SQR(1/fn)+c")
		{
			z=sqr(1/fn1(z))+c;
		}
		else if (subtype=="fn(z)+fn(pixel)")
		{
			z=fn1(z)+c*fn2(pixel);
		}
		else if (subtype=="fn(z*z)")
		{
			z=fn1(z*z);
		}
		else if (subtype=="fn*fn")
		{
			z=fn1(z)*fn2(z);
		}
		else if (subtype=="fn*z+z")
		{
			z=c*fn1(z)*z+d*z;
		}
		else if (subtype=="fn+fn")
		{
			z=c*fn1(z)+d*fn2(z);
		}
		else if (subtype=="lambda")
		{
			z=z=c*z*(1-z);
		}
		else if (subtype=="lambda*(fn||fn)")
		{
			if (|z|<real(d)) {
				z=c*fn1(z);
			}
			else {
				z=c*fn2(z);
			}
		}
		else if (subtype=="lambda+(fn||fn)")
		{
			if (|z|<real(d)) {
				z=c+fn1(z);
			}
			else {
				z=c+fn2(z);
			}
		}
		else if (subtype=="fn+exp")
		{
			z=fn1(z)+exp(z)+c;
		}
		else if (subtype=="cmplxmarks")
		{
			z=t*z*z+c;
		}
		else if (subtype=="zpower")
		{
			z=z^d+c;
		}
		else if (subtype=="zzpwr")
		{
			z=z^z+z^real(d)+c;
		}
		else if (subtype=="manowar")
		{
			t=z;
			z=z*z+z1+c;
			z1=t;
		}
		else if (subtype=="fn+zsqrd")
		{
			z=fn1(z)+z^2+c;
		}
		bContinue=true;
		if (bailoutmode=="mod")
		{
			if (testinf) {
				if (sqr(real(z))+bailoutvar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (sqr(real(z_old)-real(z))+bailoutvar*sqr(imag(z_old)-imag(z))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>maxiter_2 && sqr(real(z_cyc)-real(z))+bailoutvar*sqr(imag(z_cyc)-imag(z))<bailin) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="real")
		{
			if (testinf) {
				if (sqr(real(z))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (sqr(real(z_old)-real(z))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>maxiter_2 && sqr(real(z_cyc)-real(z))<bailin) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="imag")
		{
			if (testinf) {
				if (sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (sqr(imag(z_old)-imag(z))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>maxiter_2 && sqr(imag(z_cyc)-imag(z))<bailin) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="or")
		{
			if (testinf) {
				if (sqr(real(z))>bailout || bailoutvar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (sqr(real(z_old)-real(z))<bailin || bailoutvar*sqr(imag(z_old)-imag(z))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>maxiter_2 && (sqr(real(z_cyc)-real(z))<bailin || bailoutvar*sqr(imag(z_cyc)-imag(z))<bailin) ) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="and")
		{
			if (testinf) {
				if (sqr(real(z))>bailout && bailoutvar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (sqr(real(z_old)-real(z))<bailin && bailoutvar*sqr(imag(z_old)-imag(z))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>maxiter_2 && sqr(real(z_cyc)-real(z))<bailin && bailoutvar*sqr(imag(z_cyc)-imag(z))<bailin ) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="manh")
		{
			if (testinf) {
				if (  sqr(abs(real(z))+bailoutvar*abs(imag(z)))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (sqr(abs(real(z_old)-real(z))+bailoutvar*abs(imag(z_old)-imag(z)))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>=maxiter_2 && sqr(abs(real(z_cyc)-real(z))+bailoutvar*abs(imag(z_cyc)-imag(z)))<bailin ) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="manr")
		{
			if (testinf) {
				if (  sqr(real(z)+bailoutvar*imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (sqr((real(z_old)-real(z))+bailoutvar*(imag(z_old)-imag(z)))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>=maxiter_2 && sqr((real(z_cyc)-real(z))+bailoutvar*(imag(z_cyc)-imag(z)))<bailin ) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="lauw")
		{
			if (testinf) {
				if (  abs(real(z))+bailoutvar*abs(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testfin) {
				if (abs(real(z_old)-real(z))+bailoutvar*abs(imag(z_old)-imag(z))<bailin) {
					bContinue=false;
				}
			
			}
			if (testcyc) {
				if (numiter>=maxiter_2 && (abs(real(z_cyc)-real(z))+bailoutvar*abs(imag(z_cyc)-imag(z)))<bailin ) {
					bContinue=false;
				}
			
			}
		}
		else if (bailoutmode=="P-Ring")
		{
			t=sqrt(|z|);
			if (  t<dmax && t>dmin) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue && shared_var<1);
	}
	void description(void)
	{
		this.title = "Tierazon Fractals";

		fractaltype.caption="Fractal Type";
		fractaltype.default=1;
		fractaltype.enum="Julia Set\nMandelbrot Set";

		subtype.caption="Formula";
		subtype.default=0;
		subtype.enum="z^2+c\nz^3+c\nexp(z)-z-c\nMagnet 1\nMagnet 2\nc*fn1(z)\nBarnsley1\nBarnsley2\nBarnsley3\nSQR(fn)+c\nSQR(1/fn)+c\nfn(z)+fn(pixel)\nfn(z*z)\nfn*fn\nfn*z+z\nfn+fn\nlambda\nlambda*(fn||fn)\nlambda+(fn||fn)\nfn+exp\ncmplxmarks\nzpower\nzzpwr\nmanowar\nfn+zsqrd\n";
		

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";

		bailin.caption = "Bailin Value";
		bailin.default = 0.08;
		bailin.min = 0.000000000000000000000000001;
		bailin.hint = "Defines the bailin radius: As soon as a pixel falls inside a circle with this radius, the iteration stops.";

		criticalpoint.caption="Critical Point";
		criticalpoint.default=(0,0);
		criticalpoint.hint="Specifies the critical point of the formula";

		d.caption="Parameter 2";
		d.default=(0,0);
		d.hint="Specifies the end position of slice";

		bailoutmode.caption="Bailout Test";
		bailoutmode.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr\nlauw\nP-Ring";
		bailoutmode.default=0;
		
		bailoutvar.caption="Variable";
		bailoutvar.default=1.0;
		
		testinf.caption="Infinity";
		testinf.default=true;
		
		testfin.caption="Finite";
		testfin.default=false;
		
		testcyc.caption="Cycle";
		testcyc.default=false;
	}
}

CP_JulMand24
{
parameter complex perturb,julparm;
parameter int fractaltype;
parameter shared int subtype;
parameter real bailout;
real bailoutValue;
shared float dtmp;
shared float t1;
bool bBailedOut;
shared int iOutside;
shared int ftype;

	void init_once(void)
	{
		ftype=fractaltype;
		bailoutValue=bailout;
		if (iOutside>0)
		{
			bailoutValue=sqrt(bailout);
		}
	}
	void init(void)
	{
		if (fractaltype=="Julia")
		{
			z=pixel;
		}
		else
		{
			z=perturb;
		}
		dtmp=0;
	}
	void loop(void)
	{
		if (fractaltype=="Julia")
		{
			t1=|z|;
			if (subtype=="z^2+c")
			{
				z=z^2+julparm;
			}
			else
			{
				z=z^3+julparm;
			}
		}
		else
		{
			t1=|z|;
			if (subtype=="z^2+c")
			{
				z=z^2+pixel;
			}
			else
			{
				z=z^3+pixel;
			}
		}
		if (iOutside>0) {
			if (t1<=bailoutValue) {
				bBailedOut=true;
			}
			else {
				bBailedOut=false;
			}
		}
		else {
			if (dtmp<=bailoutValue)
			{
				bBailedOut=true;
				dtmp=t1;
			}
			else
			{
				bBailedOut=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bBailedOut);
	}
	void description(void)
	{
		this.title="Julia/Mandel";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=250;
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		fractaltype.caption="Type";
		fractaltype.enum="Julia\nMandel";
		fractaltype.default=0;
		
		subtype.caption="Formula";
		subtype.default=1;
		subtype.enum="z^2+c\nz^3+c";
		
		perturb.caption="Perturbation";
		perturb.default=(0,0);
		perturb.hint="Start value for iteration, also called perturbation";
		perturb.visible=(fractaltype=="Mandel");

		julparm.caption="c";
		julparm.default=(0.31,0.61);
		julparm.hint="Julia Parameter";
		julparm.visible=(fractaltype=="Julia");
		
		bailout.caption="Bailout";
		bailout.default=1000;
	}
}



CP_JulMand8
{
parameter complex perturb,julparm;
parameter int fractaltype;
parameter int subtype;
parameter real bailout;
parameter real bailin;
parameter int bailoutTest;
parameter float bailoutVar;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter complex iterparm2;
complex lz,cyc;
int Maxit_2;
real dmax,dmin,zabs;
complex iterparm1;
complex a1,a2;
parameter real shift;
complex tmp;
parameter int iShift;
shared real formulaBailout;

	void init_once(void)
	{
		formulaBailout=bailout;
	}
	void init(void)
	{
		if (subtype=="manowar")
		{
			tmp=pixel;
		}
		if (fractaltype=="Julia")
		{
			z=pixel;
			iterparm1=julparm;
		}
		else
		{
			iterparm1=pixel;
			if (subtype==4)
			{
				z=perturb;
			}
			else if (subtype==5 || subtype==6 || subtype==7 || subtype==8 || subtype==11)
			{
				z=pixel+perturb;
			}
			else if (subtype==16)
			{
				z=perturb+0.5;
			}
			else
			{
				z=perturb+pixel;
			}
		}
		if (subtype=="cmplxmarks")
		{
			tmp=iterparm1^(iterparm2-1);
		}
		dmax=cabs(pixel)+bailin;
		dmin=cabs(pixel)-bailin;
		bContinue=true;
		Maxit_2=maxiter-maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (subtype=="z^2+c")
		{
			z=z^2+iterparm1;
		}
		else if (subtype=="z^3+c")
		{
			z=z^3+iterparm1;
		}
		else if (subtype=="exp(z)-z-c")
		{
			z=exp(z)-z-iterparm1;
		}
		else if (subtype=="Magnet 1")
		{
			z=sqr((z*z+(iterparm1-1))/( 2*z+(iterparm1-2) ));
		}
		else if (subtype=="Magnet 2")
		{
			a1=z^3+3*(iterparm1-1)*z+(iterparm1-1)*(iterparm1-2);
			a2=3*z^2+3*(iterparm1-2)*z+(iterparm1-1)*(iterparm1-2)+1;
			z=sqr(a1/a2);
		}
		else if (subtype=="c*fn1(z)")
		{
			z=iterparm1*fn1(z);
		}
		else if (subtype=="Barnsley1")
		{
			if (real(z)>=0) {
				z=(z-1)*iterparm1;
			}
			else {
				z=(z+1)*iterparm1;
			}
		}
		else if (subtype=="Barnsley2")
		{
			if (real(z)*imag(iterparm1)+imag(z)*real(iterparm1)>=0) {
				z=(z-1)*iterparm1;
			}
			else {
				z=(z+1)*iterparm1;
			}
		}
		else if (subtype=="Barnsley3")
		{
			if (real(z)>=0) {
				z=z*z-1;
			}
			else {
				z=z*z-1+real(z)*iterparm1;
			}
		}
		else if (subtype=="SQR(fn)+c")
		{
			z=fn1(z)^2+iterparm1;
		}
		else if (subtype=="SQR(1/fn)+c")
		{
			z=1/sqr(fn1(z))+iterparm1;
		}
		else if (subtype=="fn(z)+fn(pixel)")
		{
			z=fn1(z)+iterparm2*fn2(iterparm1);
		}
		else if (subtype=="fn(z*z)")
		{
			z=fn1(z*z);
		}
		else if (subtype=="fn*fn")
		{
			z=fn1(z)*fn2(z);
		}
		else if (subtype=="fn*z+z")
		{
			z=iterparm1*fn1(z)*z+iterparm2*z;
		}
		else if (subtype=="fn+fn")
		{
			z=iterparm1*fn1(z)+iterparm2*fn2(z);
		}
		else if (subtype=="lambda")
		{
			z=iterparm1*z*(1-z);
		}
		else if (subtype=="lambda*(fn||fn)")
		{
			if (|z|<shift) {
				z=iterparm1*fn1(z);
			}
			else {
				z=iterparm1*fn2(z);
			}
		}
		else if (subtype=="lambda+(fn||fn)")
		{
			if (|z|<shift) {
				z=iterparm1+fn1(z);
			}
			else {
				z=iterparm1+fn2(z);
			}
		}
		else if (subtype=="fn+exp")
		{
			z=fn1(z)+exp(z)+iterparm1;
		}
		else if (subtype=="cmplxmarks")
		{
			z=tmp*z*z+iterparm1;
		}
		else if (subtype=="zpower")
		{
			z=z^iterparm2+iterparm1;
		}
		else if (subtype=="zzpwr")
		{
			z=z^z+z^iShift+iterparm1;
		}
		else if (subtype=="manowar")
		{
			a1=z;
			z=z^2+tmp+iterparm1;
			tmp=a1;
		}
		else if (subtype=="fn+zsqrd")
		{
			z=fn1(z)+z^2+iterparm1;
		}
		if (bailoutTest=="mod") {
			if (testInf) {
				if (sqr(real(z))+bailoutVar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))+bailoutVar*sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (numiter>Maxit_2 && sqr(real(cyc-z))+bailoutVar*sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="real") {
			if (sqr(real(z))>bailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="imag") {
			if (sqr(imag(z))>bailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="or") {
			if (testInf) {
				if (sqr(real(z))>bailout || bailoutVar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || bailoutVar*sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || bailoutVar*sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="and") {
			if (testInf) {
				if (sqr(real(z))>bailout && bailoutVar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && bailoutVar*sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && bailoutVar*sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+bailoutVar*abs(imag(z)))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+bailoutVar*abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+bailoutVar*abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="manr") {
			if (testInf) {
				if (sqr(real(z)+bailoutVar*imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+bailoutVar*imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+bailoutVar*imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="lauw") {
			if (testInf) {
				if (abs(real(z))+bailoutVar*abs(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (abs(real(lz-z))+bailoutVar*abs(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (abs(real(cyc-z))+bailoutVar*abs(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="P-Ring") {
			zabs=cabs(z);
			if (zabs>dmin && zabs<dmax) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="Julia8/Mandel8";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=250;
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		fractaltype.caption="Type";
		fractaltype.enum="Julia\nMandel";
		fractaltype.default=0;
		
		subtype.caption="Formula";
		subtype.default=1;
		subtype.enum="z^2+c\nz^3+c\nexp(z)-z-c\nMagnet 1\nMagnet 2\nc*fn1(z)\nBarnsley1\nBarnsley2\nBarnsley3\nSQR(fn)+c\nSQR(1/fn)+c\nfn(z)+fn(pixel)\nfn(z*z)\nfn*fn\nfn*z+z\nfn+fn\nlambda\nlambda*(fn||fn)\nlambda+(fn||fn)\nfn+exp\ncmplxmarks\nzpower\nzzpwr\nmanowar\nfn+zsqrd";
		
		perturb.caption="Perturbation";
		perturb.default=(0,0);
		perturb.hint="Start value for iteration, also called perturbation";
		perturb.visible=(fractaltype=="Mandel");

		julparm.caption="c";
		julparm.default=(0.3,0.6);
		julparm.hint="Julia Parameter";
		julparm.visible=(fractaltype=="Julia");
		
		bailout.caption="Bailout";
		bailout.default=4;

		bailin.caption="Bailin";
		bailin.default=0.08;
		
		bailoutTest.caption="Test";
		bailoutTest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr\nlauw\nP-Ring";
		bailoutTest.default=0;
		
		bailoutVar.caption="Variable";
		bailoutVar.default=1.0;
		
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;
		
		fn1.caption="Function 1";
		fn1.default="sin";
		fn1.visible=(subtype=="c*fn1(z)" || subtype=="fn(z)+fn(pixel)" || subtype=="SQR(fn)+c" || subtype=="SQR(1/fn)+c" || subtype=="fn(z*z)" || subtype=="fn*fn" || subtype=="fn*z+z" || subtype=="fn+fn" || subtype=="lambda*(fn||fn)" || subtype=="lambda+(fn||fn)" || subtype=="fn+exp" || subtype=="fn+zsqrd");

		fn2.caption="Function 2";
		fn2.default="sin";
		fn2.visible=(subtype=="fn(z)+fn(pixel)" || subtype=="fn*fn" || subtype=="fn+fn" || subtype=="lambda*(fn||fn)" || subtype=="lambda+(fn||fn)");
		
		iterparm2.caption="d";
		iterparm2.visible=(subtype=="fn(z)+fn(pixel)" || subtype=="fn*z+z" || subtype=="fn+fn" || subtype=="cmplxmarks" || subtype=="zpower");
		
		shift.caption="Modulus";
		shift.default=0;
		shift.visible=(subtype=="lambda*(fn||fn)" || subtype=="lambda+(fn||fn)");
		
		iShift.caption="Power";
		iShift.default=1;
		iShift.visible=(subtype=="zzpwr");
		
	}
}



CP_FractInt
{
parameter complex perturb,julparm;
parameter int fractaltype;
parameter int subtype;
parameter real bailout;
parameter real bailin;
parameter int bailoutTest;
parameter float bailoutVar;
bool bContinue;
parameter bool testInf;
parameter bool testFin;
parameter bool testCyc;
parameter complex iterparm2;
complex lz,cyc;
int Maxit_2;
real dmax,dmin,zabs;
complex iterparm1;
complex a1,a2;
parameter real shift;
complex tmp;
parameter int iShift;
shared real formulaBailout;

	void init_once(void)
	{
		formulaBailout=bailout;
	}
	void init(void)
	{
		if (subtype=="manowar")
		{
			tmp=pixel;
		}
		if (fractaltype=="Julia")
		{
			z=pixel;
			iterparm1=julparm;
		}
		else
		{
			iterparm1=pixel;
			if (subtype==4)
			{
				z=perturb;
			}
			else if (subtype==5 || subtype==6 || subtype==7 || subtype==8 || subtype==11)
			{
				z=pixel+perturb;
			}
			else if (subtype==16)
			{
				z=perturb+0.5;
			}
			else
			{
				z=perturb+pixel;
			}
		}
		if (subtype=="cmplxmarks")
		{
			tmp=iterparm1^(iterparm2-1);
		}
		dmax=cabs(pixel)+bailin;
		dmin=cabs(pixel)-bailin;
		bContinue=true;
		Maxit_2=maxiter/2;
	}
	void loop(void)
	{
		lz=z;
		if (testCyc) {
			if (numiter==Maxit_2) {
				cyc=z;
			}
		}
		if (subtype=="z^2+c")
		{
			z=z^2+iterparm1;
		}
		else if (subtype=="z^3+c")
		{
			z=z^3+iterparm1;
		}
		else if (subtype=="exp(z)-z-c")
		{
			z=exp(z)-z-iterparm1;
		}
		else if (subtype=="Magnet 1")
		{
			z=sqr((z*z+(iterparm1-1))/( 2*z+(iterparm1-2) ));
		}
		else if (subtype=="Magnet 2")
		{
			a1=z^3+3*(iterparm1-1)*z+(iterparm1-1)*(iterparm1-2);
			a2=3*z^2+3*(iterparm1-2)*z+(iterparm1-1)*(iterparm1-2)+1;
			z=sqr(a1/a2);
		}
		else if (subtype=="c*fn1(z)")
		{
			z=iterparm1*fn1(z);
		}
		else if (subtype=="Barnsley1")
		{
			if (real(z)>=0) {
				z=(z-1)*iterparm1;
			}
			else {
				z=(z+1)*iterparm1;
			}
		}
		else if (subtype=="Barnsley2")
		{
			if (real(z)*imag(iterparm1)+imag(z)*real(iterparm1)>=0) {
				z=(z-1)*iterparm1;
			}
			else {
				z=(z+1)*iterparm1;
			}
		}
		else if (subtype=="Barnsley3")
		{
			if (real(z)>=0) {
				z=z*z-1;
			}
			else {
				z=z*z-1+real(z)*iterparm1;
			}
		}
		else if (subtype=="SQR(fn)")
		{
			z=fn1(z)^2;
		}
		else if (subtype=="SQR(1/fn)+c")
		{
			z=1/sqr(fn1(z))+iterparm1;
		}
		else if (subtype=="fn(z)+fn(pixel)")
		{
			z=fn1(z)+iterparm2*fn2(iterparm1);
		}
		else if (subtype=="fn(z*z)")
		{
			z=fn1(z*z);
		}
		else if (subtype=="fn*fn")
		{
			z=fn1(z)*fn2(z);
		}
		else if (subtype=="fn*z+z")
		{
			z=iterparm1*fn1(z)*z+iterparm2*z;
		}
		else if (subtype=="fn+fn")
		{
			z=iterparm1*fn1(z)+iterparm2*fn2(z);
		}
		else if (subtype=="lambda")
		{
			z=iterparm1*z*(1-z);
		}
		else if (subtype=="lambda*(fn||fn)")
		{
			if (|z|<shift) {
				z=iterparm1*fn1(z);
			}
			else {
				z=iterparm1*fn2(z);
			}
		}
		else if (subtype=="lambda+(fn||fn)")
		{
			if (|z|<shift) {
				z=iterparm1+fn1(z);
			}
			else {
				z=iterparm1+fn2(z);
			}
		}
		else if (subtype=="fn+exp")
		{
			z=fn1(z)+exp(z)+iterparm1;
		}
		else if (subtype=="cmplxmarks")
		{
			z=tmp*z*z+iterparm1;
		}
		else if (subtype=="zpower")
		{
			z=z^iterparm2+iterparm1;
		}
		else if (subtype=="zzpwr")
		{
			z=z^z+z^iShift+iterparm1;
		}
		else if (subtype=="manowar")
		{
			a1=z;
			z=z^2+tmp+iterparm1;
			tmp=a1;
		}
		else if (subtype=="fn+zsqrd")
		{
			z=fn1(z)+z^2+iterparm1;
		}
		else if (subtype=="lambdafn")
		{
			z=iterparm1*fn1(z);
		}
		if (bailoutTest=="mod") {
			if (testInf) {
				if (sqr(real(z))+bailoutVar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))+bailoutVar*sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc) {
				if (sqr(real(cyc-z))+bailoutVar*sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="real") {
			if (sqr(real(z))>bailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="imag") {
			if (sqr(imag(z))>bailout) {
				bContinue=false;
			}
			if (testFin) {
				if (sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="or") {
			if (testInf) {
				if (sqr(real(z))>bailout || bailoutVar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin || bailoutVar*sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin || bailoutVar*sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="and") {
			if (testInf) {
				if (sqr(real(z))>bailout && bailoutVar*sqr(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z))<bailin && bailoutVar*sqr(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z))<bailin && bailoutVar*sqr(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="manh") {
			if (testInf) {
				if (sqr(abs(real(z))+bailoutVar*abs(imag(z)))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(abs(real(lz-z))+bailoutVar*abs(imag(lz-z)))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(abs(real(cyc-z))+bailoutVar*abs(imag(cyc-z)))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="manr") {
			if (testInf) {
				if (sqr(real(z)+bailoutVar*imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (sqr(real(lz-z)+bailoutVar*imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (sqr(real(cyc-z)+bailoutVar*imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="lauw") {
			if (testInf) {
				if (abs(real(z))+bailoutVar*abs(imag(z))>bailout) {
					bContinue=false;
				}
			}
			if (testFin) {
				if (abs(real(lz-z))+bailoutVar*abs(imag(lz-z))<bailin) {
					bContinue=false;
				}
			}
			if (testCyc && numiter>=Maxit_2) {
				if (abs(real(cyc-z))+bailoutVar*abs(imag(cyc-z))<bailin) {
					bContinue=false;
				}
			}
		}
		else if (bailoutTest=="P-Ring") {
			zabs=cabs(z);
			if (zabs>dmin && zabs<dmax) {
				bContinue=false;
			}
		}
	}
	bool bailout(void)
	{
		return(bContinue);
	}
	void description(void)
	{
		this.title="FractInt Formulas";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=250;
		this.periodicity=0;
		this.helpfile="http://www.chaospro.de/";
		
		fractaltype.caption="Type";
		fractaltype.enum="Julia\nMandel";
		fractaltype.default=0;
		
		subtype.caption="Formula";
		subtype.default=1;
		subtype.enum="z^2+c\nz^3+c\nexp(z)-z-c\nMagnet 1\nMagnet 2\nc*fn1(z)\nBarnsley1\nBarnsley2\nBarnsley3\nSQR(fn)\nSQR(1/fn)+c\nfn(z)+fn(pixel)\nfn(z*z)\nfn*fn\nfn*z+z\nfn+fn\nlambda\nlambda*(fn||fn)\nlambda+(fn||fn)\nfn+exp\ncmplxmarks\nzpower\nzzpwr\nmanowar\nfn+zsqrd\nlambdafn";

		perturb.caption="Perturbation";
		perturb.default=(0,0);
		perturb.hint="Start value for iteration, also called perturbation";
		perturb.visible=(fractaltype=="Mandel");

		julparm.caption="c";
		julparm.default=(0.3,0.6);
		julparm.hint="Julia Parameter";
		julparm.visible=(fractaltype=="Julia");
		
		bailout.caption="Bailout";
		bailout.default=4;

		bailin.caption="Bailin";
		bailin.default=0.08;
		
		bailoutTest.caption="Test";
		bailoutTest.enum="mod\nreal\nimag\nor\nand\nmanh\nmanr\nlauw\nP-Ring";
		bailoutTest.default=0;
		
		bailoutVar.caption="Variable";
		bailoutVar.default=1.0;
		
		testInf.caption="Infinite";
		testInf.default=true;
		
		testFin.caption="Finite";
		testFin.default=false;
		
		testCyc.caption="Cycle";
		testCyc.default=false;
		
		fn1.caption="Function 1";
		fn1.default="sin";
		fn1.visible=(subtype=="c*fn1(z)" || subtype=="fn(z)+fn(pixel)" || subtype=="SQR(fn)" || subtype=="SQR(1/fn)+c" || subtype=="fn(z*z)" || subtype=="fn*fn" || subtype=="fn*z+z" || subtype=="fn+fn" || subtype=="lambda*(fn||fn)" || subtype=="lambda+(fn||fn)" || subtype=="fn+exp" || subtype=="fn+zsqrd" || subtype=="lambdafn");

		fn2.caption="Function 2";
		fn2.default="sin";
		fn2.visible=(subtype=="fn(z)+fn(pixel)" || subtype=="fn*fn" || subtype=="fn+fn" || subtype=="lambda*(fn||fn)" || subtype=="lambda+(fn||fn)");
		
		iterparm2.caption="d";
		iterparm2.visible=(subtype=="fn(z)+fn(pixel)" || subtype=="fn*z+z" || subtype=="fn+fn" || subtype=="cmplxmarks" || subtype=="zpower");
		
		shift.caption="Modulus";
		shift.default=0;
		shift.visible=(subtype=="lambda*(fn||fn)" || subtype=="lambda+(fn||fn)");
		
		iShift.caption="Power";
		iShift.default=1;
		iShift.visible=(subtype=="zzpwr");
		
	}
}


compBif
{
parameter int subtype;
parameter real start;
parameter real A;
parameter int settle;
bool bCalculated[width];
float val[width,height];
real settledPopulation;
int idx;
real population,growth;
real bottom,top;
int ix,iy;
shared real pixColor;

	void init_once(void)
	{
		// clear the array
		for (idx=0;idx<width;idx=idx+1)
		{
			bCalculated[idx]=false;
		}
		for (iy=0;iy<height;iy=iy+1)
		{
			for (ix=0;ix<width;ix=ix+1)
			{
				val[ix,iy]=-1000;
			}
		}
		top=imag(corner_lefttop);
		bottom=imag(corner_rightbottom);
	}
	void init(void)
	{
		if (!bCalculated[x])
		{
			bCalculated[x]=true;
			population=start;
			growth=real(pixel);
			for (idx=0;idx<settle;idx=idx+1)
			{
				if (subtype=="R*Fn(z)*(1-Fn(z))")
				{
					population=growth*fn1(population)*(1-fn1(population));
				}
				else if (subtype=="z+R*Fn(z)*(1-Fn(z))")
				{
					population=population+growth*fn1(population)*(1-fn1(population));
				}
				else if (subtype=="z+R*Fn(PI*z)")
				{
					population=population+growth*fn1(pi*population);
				}
				else if (subtype=="R*Fn(PI*z)")
				{
					population=growth*fn1(pi*population);
				}
				else if (subtype=="R*Fn(z)^2-1")
				{
					population=growth*fn1(population)^2-1;
				}
				else if (subtype=="R*z/(1+z)^A")
				{
					population=growth*population/(1+population)^A;
				}
			}
			settledPopulation=population;
			for (idx=0;idx<maxiter;idx=idx+1)
			{
				if (subtype=="R*Fn(z)*(1-Fn(z))")
				{
					population=growth*fn1(population)*(1-fn1(population));
				}
				else if (subtype=="z+R*Fn(z)*(1-Fn(z))")
				{
					population=population+growth*fn1(population)*(1-fn1(population));
				}
				else if (subtype=="z+R*Fn(PI*z)")
				{
					population=population+growth*fn1(pi*population);
				}
				else if (subtype=="R*Fn(PI*z)")
				{
					population=growth*fn1(pi*population);
				}
				else if (subtype=="R*Fn(z)^2-1")
				{
					population=growth*fn1(population)^2-1;
				}
				else if (subtype=="R*z/(1+z)^A")
				{
					population=growth*population/(1+population)^A;
				}
				iy=trunc((population-top)*(height-1)/(bottom-top)+1);
				if (iy>=0 && iy<height && x<width)
				{
					val[x,iy]=idx;
				}
				if (abs(population-settledPopulation)<0.000000001)
				{
					break;
				}
			}
		}
		if (val[x,y]==-1000)
		{
			pixColor=-1000;
		}
		else
		{
			pixColor=(10+val[x,y])/252;
		}
	}
	void loop(void)
	{
	}
	bool bailout(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Bifurcation";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(0,0);
		this.angle=0;
		this.maxiter=500;
		this.periodicity=0;
		this.helpfile="formulas.html";

		start.caption="Start";
		start.default=0.5;
		
		settle.caption="Settle";
		settle.default=100;
		
		subtype.caption="Formula";
		subtype.enum="R*Fn(z)*(1-Fn(z))\nz+R*Fn(z)*(1-Fn(z))\nz+R*Fn(PI*z)\nR*Fn(PI*z)\nR*Fn(z)^2-1\nR*z/(1+z)^A";
		subtype.default=0;
		
		fn1.caption="Function";
		fn1.default="sin";
		
		A.caption="A";
		A.default=2;
		A.visible=(subtype=="R*z/(1+z)^A");
	}
}


compLyap
{
parameter int subtype;
parameter real start;
parameter real A;
parameter int settle;
parameter int sequence;
int idx;
real seqVal[30];
int digit,numDigits,pos;
real zx,dx,r,t1,LyaExp;
bool continueIteration;
shared real pixColor;

	void init(void)
	{
		numDigits=log10(sequence);
		seqVal[numDigits+1]=1234567;
		idx=sequence;
		for (;numDigits>=0;numDigits=numDigits-1)
		{
			digit=idx-trunc(idx/10)*10;
			if (digit==1)
			{
				seqVal[numDigits]=real(pixel);
			}
			else
			{
				seqVal[numDigits]=imag(pixel);
			}
			idx=(idx-digit)/10;			
		}
		zx=start;
		pos=0;
		for (idx=0;idx<settle;idx=idx+1)
		{
			r=seqVal[pos];
			pos=pos+1;
			if (r==1234567)
			{
				pos=1;
				r=seqVal[0];
			}
			if (subtype=="r*x*(1-x)") {
				zx=r*zx*(1.0-zx);
			}
			else if (subtype=="x+r*x*(1-x)") {
				zx=zx*(1+r*(1.0-zx));
			}
			else if (subtype=="r*sin(PI*x)") {
				zx=r*sin(pi*zx);
			}
			else if (subtype=="x+r*sin(PI*x)") {
				zx=zx+r*sin(pi*zx);
			}
			else if (subtype=="a*sin(x+r)^2") {
				zx=A*sqr(sin(zx+r));
			}
		}
		LyaExp=1;
		continueIteration=true;
	}		
	void loop(void)
	{
		if (continueIteration)
		{
			r=seqVal[pos];
			pos=pos+1;
			if (r==1234567)
			{
				pos=1;
				r=seqVal[0];
			}
			if (subtype=="r*x*(1-x)") {
				dx=abs(r-2*r*zx);
				zx=r*zx*(1.0-zx);
			}
			else if (subtype=="x+r*x*(1-x)") {
				dx=abs(1+r-2*r*zx);
				zx=zx*(1+r*(1.0-zx));
			}
			else if (subtype=="r*sin(PI*x)") {
				dx=abs(r*pi*cos(pi*zx));
				zx=r*sin(pi*zx);
			}
			else if (subtype=="x+r*sin(PI*x)") {
				dx=abs(1+r*pi*cos(pi*zx));
				zx=zx+r*sin(pi*zx);
			}
			else if (subtype=="a*sin(x+r)^2") {
				t1=sin(zx+r);
				dx=abs(2*A*t1*cos(zx+r));
				zx=A*t1*t1;
			}

			LyaExp=LyaExp*dx;
			pixColor=LyaExp;
			if (abs(LyaExp)>1E20)
			{
				continueIteration=false;
			}
		}
	}
	bool bailout(void)
	{
		return(true);
	}
	void description(void)
	{
		this.title="Lyapunov";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(0,0);
		this.magn=0.25;
		this.angle=0;
		this.maxiter=70;
		this.periodicity=0;
		this.helpfile="formulas.html";

		subtype.caption="Formula";
		subtype.enum="r*x*(1-x)\nx+r*x*(1-x)\nr*sin(PI*x)\nx+r*sin(PI*x)\na*sin(x+r)^2";
		subtype.default=0;
		
		start.caption="Start";
		start.default=0.5;
		
		settle.caption="Settle";
		settle.default=30;
		
		A.caption="A";
		A.default=2;
		
		sequence.caption="Sequence";
		sequence.default=21;
	}
}



Mandelbrotnew {
parameter real bailout;
parameter complex i2;
real a,b,c;
complex z1,ibase;

	void init(void)
	{
		z=0;
		ibase=sqrt(i2);
	}
	void loop(void)
	{
		a=0;
		a=perlinNoise(-3.7+a+1000,-187.99+1000,78.99+1000);
		a=real(z);
		b=imag(z);
		z=a^2+i2*b^2+flip(2*a*b) + pixel;
		
	}
	bool bailout(void)
	{
		return(|z| <= bailout);
	}
	void description(void)
	{
		this.title = "Mandelbrotnew";

		i2.caption = "i^2";
		i2.default = (-1,0);
		i2.hint = "Choose the exponent of the iteration formula for the Julia set.\nHigher (int-) values just lead to some kind of rotation symmetry. So try fractional or even complex numbers.";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
	}
}





mathematica
{
parameter complex perturb;
parameter real bailout;
real px,py;

	void init(void)
	{
		z=pixel;
	}
	real TriNum(real t)
	{
		return ((t* (t + 1))/2);
	}
	void loop(void)
	{
		px=real(pixel);
		py=imag(pixel);
		z=sin(z/((TriNum(cabs(px + (sqrt(8*cabs(px) + 1) - 1)/2)) - TriNum(cabs(px + sqrt(cabs(2*px))))) + flip(py)));
	}
	bool bailout(void)
	{
		return(|z|<bailout);
	}
	void description(void)
	{
		this.title="Mathematica";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(1,3);
		this.angle=0;
		this.maxiter=250;
		this.periodicity=0;
		this.helpfile="formulas.html";
		perturb.caption="Perturbation";
		perturb.default=(0,0);
		perturb.hint="Start value for iteration, also called perturbation";
		
		bailout.caption="Bailout";
		bailout.default= 31381059609;
		bailout.hint="default value is 9^11";
	}
}


Pixel_Dummy {
// A dummy formula which always bails out, i.e. does nothing: The whole area is just "outside" and the coloring formula
// is used.
	void init(void)
	{
	}
	void loop(void)
	{
		// Nothing to do here...
	}
	bool bailout(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title = "NOP Formula";
	}
}

