comment{The follwing fractals present `mixes' of two fractal formulae. In
each step both values are calculated and the one with the smaller (or
the larger) modulus is chosen. This can, of course, be expanded to using 
more than two different formulae.

Bernd Lehnhoff 2004 
f.b.lehnhoff@gmx.de

Contents
--------

Minimal22: Julia-Sets z(n+1) = z(n)^2 + c or z(n)^2 + f(c) and corresponding
               M-Sets, with several functions f, smaller modulus chosen.
Maximal22: as before, but larger value chosen.

Minimal32: Julia-Sets z(n+1) = z(n)^3 + c or z(n)^3 + f(c) and corresponding
               M-Sets, with several functions f, smaller modulus chosen.
Maximal32: as before, but larger value chosen,

Minimal23: Julia-Sets z(n+1) = z(n)^2 + c or z(n)^2 + w2*c or z(n)^2 + w3 * c,
               with w2 = (-1, sqrt(3))/2, w3 = -(1, sqrt(3))/2 and 
               corresponding M-Sets, smaller modulus chosen.
Maximal23: as before, but larger value chosen.

MiniDrift2: Julia-Sets z(n+1) = (z(n)+drift)^2 + c or (z(n)-drift)^2 + c and
               corresponding M-Sets, smaller modulus chosen.
MaxiDrift2: as before, but larger value chosen.

MiniDrift3: Julia-Sets z(n+1) = (z(n)+drift)^3 + c or (z(n)+w2*drift)^3 + c                
               or (z(n)+w3*drift)^3 + c (w2, w3 as above) and corresponding 
               M-Sets, smaller modulus chosen.
MaxiDrift3: as before, but larger value chosen.

MiniJuliaMix2: Julibrot: Mix of a standard M-set with a standard Julia set,
               Double-Julia:  Mix of two different standard J-sets,
               smaller modulus chosen.
MaxiJuliaMix2: as before, but larger value chosen.
}


Minimal22 {
parameter int frmltype, settype; 
real bailout;
parameter complex seed;
complex q, u, v, cu, cv;

  void init(void)
  {
    z = pixel;
    if (settype=="Mandel")
    {
      cu = pixel;
      bailout = 16;
    }
    else
    {
      cu = seed;
      bailout = 16 + |seed|;
    }  
    if (frmltype=="PlusMinus")
    {
      cv = -cu;
    }
    else if (frmltype=="Conjugate")
    {
      cv = conj(cu);
    }
    else if (frmltype=="MandelImag")
    {
      cv = (0,1) * cu;
    }  
  }
  void loop(void)
  {
    q = z * z;
    u = q + cu;
    v = q + cv;
    if (|u|<|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "z^2+c 2Min";

    frmltype.caption = "Formula";
    frmltype.enum = "PlusMinus\nPlusMinus\nConjugate\nImag";
    frmltype.default = 0;
    frmltype.hint = "Please select an iteration formula for use.";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;
    settype.hint = "M-Set or J-Set of formula";

    seed.caption = "Julia seed";
    seed.default = (1.942970066189358, 0.00243291259162907);
    seed.hint = "Change this value as you like.";
    seed.visible = (settype=="Julia");
  }
}


Maximal22 {
parameter int frmltype, settype; 
real bailout;
parameter complex seed;
complex q, u, v, cu, cv;

  void init(void)
  {
    z = pixel;
    if (settype=="Mandel")
    {
      cu = pixel;
      bailout = 16;
    }
    else
    {
      cu = seed;
      bailout = 16 + |seed|;
    }  
    if (frmltype=="PlusMinus")
    {
      cv = -cu;
    }
    else if (frmltype=="Conjugate")
    {
      cv = conj(cu);
    }
    else if (frmltype=="MandelImag")
    {
      cv = (0,1) * cu;
    }  
  }
  void loop(void)
  {
    q = z * z;
    u = q + cu;
    v = q + cv;
    if (|u|>|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "z^2+c 2Max";

    frmltype.caption = "Formula";
    frmltype.enum = "PlusMinus\nPlusMinus\nConjugate\nImag";
    frmltype.default = 0;
    frmltype.hint = "Please select an iteration formula for use.";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;
    settype.hint = "M-Set or J-Set of formula";

    seed.caption = "Julia seed";
    seed.default = (0.275, 0.169);
    seed.hint = "Change this value as you like.";
    seed.visible = (settype=="Julia");
  }
}


Maximal32 {
parameter int frmltype, settype; 
real bailout;
parameter complex seed;
complex q, u, v, cu, cv;

  void init(void)
  {
    z = pixel;
    if (settype=="Mandel")
    {
      cu = pixel;
      bailout = 16;
    }
    else
    {
      cu = seed;
      bailout = 16 + |seed|;
    }  
    if (frmltype=="PlusMinus")
    {
      cv = -cu;
    }
    else if (frmltype=="Conjugate")
    {
      cv = conj(cu);
    }
    else if (frmltype=="MandelImag")
    {
      cv = (0,1) * cu;
    }  
  }
  void loop(void)
  {
    q = z * z * z;
    u = q + cu;
    v = q + cv;
    if (|u|<|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "z^3+c 2Min";

    frmltype.caption = "Formula";
    frmltype.enum = "PlusMinus\nPlusMinus\nConjugate\nImag";
    frmltype.default = 0;
    frmltype.hint = "Please select an iteration formula for use.";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;
    settype.hint = "M-Set or J-Set of formula";

    seed.caption = "Julia seed";
    seed.default = (1.942970066189358, 0.00243291259162907);
    seed.hint = "Change this value as you like.";
    seed.visible = (settype=="Julia");
  }
}


Maximal32 {
parameter int frmltype, settype;
real bailout;
parameter complex seed;
complex q, u, v, cu, cv;

  void init(void)
  {
    z = pixel;
    if (settype=="Mandel")
    {
      cu = pixel;
      bailout = 16;
    }
    else
    {
      cu = seed;
      bailout = 16 + |seed|;
    }  
    if (frmltype=="PlusMinus")
    {
      cv = -cu;
    }
    else if (frmltype=="Conjugate")
    {
      cv = conj(cu);
    }
    else if (frmltype=="MandelImag")
    {
      cv = (0,1) * cu;
    }  
  }
  void loop(void)
  {
    q = z * z * z;
    u = q + cu;
    v = q + cv;
    if (|u|>|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "z^3+c 2Max";

    frmltype.caption = "Formula";
    frmltype.enum = "PlusMinus\nPlusMinus\nConjugate\nImag";
    frmltype.default = 0;
    frmltype.hint = "Please select an iteration formula for use.";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;
    settype.hint = "M-Set or J-Set of formula";

    seed.caption = "Julia seed";
    seed.default = (0.007304273855799383,0.4085678664661656);
    seed.hint = "Change this value as you like.";
    seed.visible = (settype=="Julia");
  }
}


Minimal23 {
parameter int frmltype; 
real bailout, au, av, aw, mz;
parameter complex seed;
complex q, u, v, w, cu, cv, cw, hz;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelPlusMinus")
    {
      cu = pixel;
      cv = (-.5,0.8660125403784)*pixel;
      cw = (-.5,-0.8660125403784)*pixel;

      bailout = 16;
    }
    else if (frmltype=="JuliaPlusMinus")
    {
      cu = seed;
      cv = (-.5,0.8660125403784)*seed;
      cv = (-.5,-0.8660125403784)*seed;
      bailout = 16 + |seed|;
    }
  }
  void loop(void)
  {
    q = z * z;
    u = q + cu;
    au = |u|;
    v = q + cv;
    av = |v|;
    w = q + cw;
    aw = |w|;
    if (au<av)
    {
      hz = u;
      mz = au;
    }
    else
    {
      hz = v;
      mz = av;
    }
    if (aw<mz)
    {
      z = w;
      mz = aw;
    }
    else
    {
      z = hz;
    }
  }
  bool bailout(void)
  {
    return(mz < bailout);
  }
  void description(void)
  {
    this.title = "z^2+c 3Min";
    frmltype.caption = "Formula";
    frmltype.enum = "MandelPlusMinus\nJuliaPlusMinus";
    frmltype.hint = "Please select an iteration formula for use.";
    seed.caption = "Julia seed";
    seed.default = (1.942970066189358, 0.00243291259162907);
    seed.hint = ". Change this value as you like.";
  }
}


Maximal23 {
parameter int frmltype; 
real bailout, au, av, aw, mz;
parameter complex seed;
complex q, u, v, w, cu, cv, cw, hz;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelPlusMinus")
    {
      cu = pixel;
      cv = (-.5,0.8660125403784)*pixel;
      cw = (-.5,-0.8660125403784)*pixel;

      bailout = 16;
    }
    else if (frmltype=="JuliaPlusMinus")
    {
      cu = seed;
      cv = (-.5,0.8660125403784)*seed;
      cv = (-.5,-0.8660125403784)*seed;
      bailout = 16 + |seed|;
    }
  }
  void loop(void)
  {
    q = z * z;
    u = q + cu;
    au = |u|;
    v = q + cv;
    av = |v|;
    w = q + cw;
    aw = |w|;
    if (au>av)
    {
      hz = u;
      mz = au;
    }
    else
    {
      hz = v;
      mz = av;
    }
    if (aw>mz)
    {
      z = w;
      mz = aw;
    }
    else
    {
      z = hz;
    }
  }
  bool bailout(void)
  {
    return(mz < bailout);
  }
  void description(void)
  {
    this.title = "z^2+c 3Max";
    frmltype.caption = "Formula";
    frmltype.enum = "MandelPlusMinus\nJuliaPlusMinus";
    frmltype.hint = "Please select an iteration formula for use.";
    seed.caption = "Julia seed";
    seed.default = (0.1459326154231977,0.2394607831578948);
    seed.hint = "Only relevant for Julia sets. Change this value as you like.";
  }
}


Minimal33 {
parameter int frmltype; 
real bailout, au, av, aw, mz;
parameter complex seed;
complex q, u, v, w, cu, cv, cw, hz;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelPlusMinus")
    {
      cu = pixel;
      cv = (-.5,0.8660125403784)*pixel;
      cw = (-.5,-0.8660125403784)*pixel;

      bailout = 16;
    }
    else if (frmltype=="JuliaPlusMinus")
    {
      cu = seed;
      cv = (-.5,0.8660125403784)*seed;
      cv = (-.5,-0.8660125403784)*seed;
      bailout = 16 + |seed|;
    }
  }
  void loop(void)
  {
    q = z * z * z;
    u = q + cu;
    au = |u|;
    v = q + cv;
    av = |v|;
    w = q + cw;
    aw = |w|;
    if (au<av)
    {
      hz = u;
      mz = au;
    }
    else
    {
      hz = v;
      mz = av;
    }
    if (aw<mz)
    {
      z = w;
      mz = aw;
    }
    else
    {
      z = hz;
    }
  }
  bool bailout(void)
  {
    return(mz < bailout);
  }
  void description(void)
  {
    this.title = "z^3+c 3Min";
    frmltype.caption = "Formula";
    frmltype.enum = "MandelPlusMinus\nJuliaPlusMinus";
    frmltype.hint = "Please select an iteration formula for use.";
    seed.caption = "Julia seed";
    seed.default = (1.942970066189358, 0.00243291259162907);
    seed.hint = "Only relevant for Julia sets. Change this value as you like.";
  }
}


Maximal33 {
parameter int frmltype; 
real bailout, au, av, aw, mz;
parameter complex seed;
complex q, u, v, w, cu, cv, cw, hz;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelPlusMinus")
    {
      cu = pixel;
      cv = (-.5,0.8660125403784)*pixel;
      cw = (-.5,-0.8660125403784)*pixel;

      bailout = 16;
    }
    else if (frmltype=="JuliaPlusMinus")
    {
      cu = seed;
      cv = (-.5,0.8660125403784)*seed;
      cv = (-.5,-0.8660125403784)*seed;
      bailout = 16 + |seed|;
    }
  }
  void loop(void)
  {
    q = z * z * z;
    u = q + cu;
    au = |u|;
    v = q + cv;
    av = |v|;
    w = q + cw;
    aw = |w|;
    if (au>av)
    {
      hz = u;
      mz = au;
    }
    else
    {
      hz = v;
      mz = av;
    }
    if (aw>mz)
    {
      z = w;
      mz = aw;
    }
    else
    {
      z = hz;
    }
  }
  bool bailout(void)
  {
    return(mz < bailout);
  }
  void description(void)
  {
    this.title = "z^3+c 3Max";
    frmltype.caption = "Formula";
    frmltype.enum = "MandelPlusMinus\nJuliaPlusMinus";
    frmltype.hint = "Please select an iteration formula for use.";
    seed.caption = "Julia seed";
    seed.default = (1.942970066189358, 0.00243291259162907);
    seed.hint = "Only relevant for Julia sets. Change this value as you like.";
  }
}


MiniDrift2 {
parameter int frmltype;
real bailout;
parameter complex seed, drift;
complex u, v, c;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelDrift")
    {
      c = pixel;
    }
    else if (frmltype=="JuliaDrift")
    {
      c = seed;
    }
    bailout = 16 + |drift|;
  }
  void loop(void)
  {
    u = (z + drift) * (z + drift) + c;
    v = (z - drift) * (z - drift) + c;
    if (|u|<|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "(z-d)^2+c 2Min";

    frmltype.caption = "Formula";
    frmltype.enum = "MandelDrift\nJuliaDrift";
    frmltype.hint = "Please select an iteration formula for use.";

    seed.caption = "Julia seed";
    seed.default = (0.275, 0.169);
    seed.hint = "Only relevant for Julia sets. Change this value as you like.";

    drift.caption = "Perturbation of sets";
    drift.default = (1.5, 0);
    drift.hint = "Change this value as you like. It should not be zero.";    
  }
}


MaxiDrift2 {
parameter int frmltype;
real bailout;
parameter complex seed, drift;
complex u, v, c;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelDrift")
    {
      c = pixel;
    }
    else if (frmltype=="JuliaDrift")
    {
      c = seed;
    }
    bailout = 16 + |drift|;
  }
  void loop(void)
  {
    u = (z + drift) * (z + drift) + c;
    v = (z - drift) * (z - drift) + c;
    if (|u|>|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "(z-d)^2+c 2Max";

    frmltype.caption = "Formula";
    frmltype.enum = "MandelDrift\nJuliaDrift";
    frmltype.hint = "Please select an iteration formula for use.";

    seed.caption = "Julia seed";
    seed.default = (0.01495028213166155, 0.007311165413533884);
    seed.hint = "Only relevant for Julia sets. Change this value as you like.";

    drift.caption = "Perturbation of sets";
    drift.default = (0.26, 0);
    drift.hint = "Change this value as you like. It should not be zero.";  
  }
}


MiniDrift3 {
parameter int frmltype;
real bailout, au, av, aw, mz;
parameter complex seed, drift, drift2, drift3;
complex c, u, v, w, hz;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelDrift")
    {
      c = pixel;
    }
    else if (frmltype=="JuliaDrift")
    {
      c = seed;
    }
    drift2 = (-.5,0.8660125403784)*drift;
    drift3 = (-.5,-0.8660125403784)*drift;
    bailout = 16 + |drift|;
  }
  void loop(void)
  {
    u = (z - drift)^3 + c;
    au = |u|;
    v = (z - drift2)^3 + c;
    av = |v|;
    w = (z - drift3)^3 + c;
    aw = |w|;
    if (au<av)
    {
      hz = u;
      mz = au;
    }
    else
    {
      hz = v;
      mz = av;
    }
    if (aw<mz)
    {
      z = w;
      mz = aw;
    }
    else
    {
      z = hz;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "(z-d)^3+c 3Min";

    frmltype.caption = "Formula";
    frmltype.enum = "MandelDrift\nJuliaDrift";
    frmltype.hint = "Please select an iteration formula for use.";

    seed.caption = "Julia seed";
    seed.default = (0.275, 0.169);
    seed.hint = "Only relevant for Julia sets. Change this value as you like.";

    drift.caption = "Perturbation of sets";
    drift.default = (1, 0);
    drift.hint = "Change this value as you like. It should not be zero.";
  }
}


MaxiDrift3 {
parameter int frmltype;
real bailout, au, av, aw, mz;
parameter complex seed, drift, drift2, drift3;
complex c, u, v, w, hz;

  void init(void)
  {
    z = pixel;
    if (frmltype=="MandelDrift")
    {
      c = pixel;
    }
    else if (frmltype=="JuliaDrift")
    {
      c = seed;
    }
    drift2 = (-.5,0.8660125403784)*drift;
    drift3 = (-.5,-0.8660125403784)*drift;
    bailout = 16 + |drift|;
  }
  void loop(void)
  {
    u = (z - drift)^3 + c;
    au = |u|;
    v = (z - drift2)^3 + c;
    av = |v|;
    w = (z - drift3)^3 + c;
    aw = |w|;
    if (au>av)
    {
      hz = u;
      mz = au;
    }
    else
    {
      hz = v;
      mz = av;
    }
    if (aw>mz)
    {
      z = w;
      mz = aw;
    }
    else
    {
      z = hz;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "(z-d)^3 3Max";

    frmltype.caption = "Formula";
    frmltype.enum = "MandelDrift\nJuliaDrift";
    frmltype.hint = "Please select an iteration formula for use.";

    seed.caption = "Julia seed";
    seed.default = (0.275, 0.169);
    seed.hint = "Only relevant for Julia sets. Change this value as you like.";

    drift.caption = "Perturbation of sets";
    drift.default = (1, 0);
    drift.hint = "Change this value as you like. It should not be zero.";    
  }
}


MiniJuliaMix2 {
parameter int frmltype; 
real bailout;
parameter complex seed, seed2;
complex q, u, v, cu, cv;

  void init(void)
  {
    z = pixel;
    cv = seed;
    bailout = 16 + |seed|;
    if (frmltype=="Julibrot")
    {
      cu = pixel;
    }
    else if (frmltype=="DoubleJulia")
    {
      cu = seed2;
      if(cu==cv)
      {
        cu = cu + flip(0.1);
      }
     bailout = bailout + |cu|;
   }
  }
  void loop(void)
  {
    q = z * z;
    u = q + cu;
    v = q + cv;
    if (|u|<|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "JuliaMix Min";
    frmltype.caption = "Formula";
    frmltype.enum = "Julibrot\nDoubleJulia";
    frmltype.hint = "Please select an iteration formula for use.";
    
    seed.caption = "Seed of first Julia set";
    seed.default = (0.27,0.625);
    seed.hint = "Change this value as you like.";

    seed2.caption = "JSeed of second Julia set";
    seed2.default = (0.54,-1.485);
    seed2.visible = frmltype=="DoubleJulia";
    seed2.hint = "Change this value as you like.";
  }
}


MaxiJuliaMix2 {
parameter int frmltype; 
real bailout;
parameter complex seed, seed2;
complex q, u, v, cu, cv;

  void init(void)
  {
    z = pixel;
    cv = seed;
    bailout = 16 + |seed|;
    if (frmltype=="Julibrot")
    {
      cu = pixel;
    }
    else if (frmltype=="DoubleJulia")
    {
      cu = seed2;
      if(cu==cv)
      {
        cu = cu + flip(0.1);
      }
     bailout = bailout + |cu|;
   }
  }
  void loop(void)
  {
    q = z * z;
    u = q + cu;
    v = q + cv;
    if (|u|>|v|)
    {
      z = u;
    }
    else
    {
      z = v;
    }
   }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "Juliamix Max";
    frmltype.caption = "Formula";
    frmltype.enum = "Julibrot\nDoubleJulia";
    frmltype.hint = "Please select an iteration formula for use.";
    
    seed.caption = "Seed of 1st Julia set";
    seed.default = (-0.75,0.0625);
    seed.hint = "Change this value as you like.";

    seed2.caption = "Seed of 2nd Julia set";
    seed2.default = (1.5,0.25);
    seed2.visible = frmltype=="DoubleJulia";
    seed2.hint = "Change this value as you like. It should not be equal to the first seed.";
  }
}
