comment{The follwing fractals were derived from Heron's formula for
calculating square roots with an added perturbation. You should switch
off periodicity algorithms, when using them. As default value for the 
power (p1) I have used p1 = 2, though complex powers are possibly
even more interesting.

Bernd Lehnhoff 2004 
f.b.lehnhoff@gmx.de
}


Luna {
  parameter complex p1, p2, p3;
  parameter int settype;
  complex c, u, v;
  real r;
  void init(void)
  {
    if (((real(p1)==0) || (real(p1)==1)) && (imag(p1)==0))
    {
      p1 = 2;
    }
    if ((real(p2)==0) && (imag(p2)==0))
    {
      p2 = 0.5;
    }
    if (settype=="Mandel")
    {
      c = pixel;
    }
    else
    {
      c = p3;
    }
    v = pixel;
  }
  void loop(void)
  {
    u = v;
    v = u - u / p1 * (1 - (c / u)^p1) + p2;
    r = log10(|v - u|);
  }
  bool bailout(void)
  {
    return(r >= -12);
  }
  void description(void)
  {
    this.title = "Luna";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;

    p1.caption = "Degree of root";
    p1.default = (2,0);
    p1.hint = "Change this value as you like (<> 0 and <> 1).";

    p2.caption = "Perturbation";
    p2.default = (0.5,0);
    p2.hint = "Change this value as you like.\nIt must not be equal to zero!";

    p3.caption = "Radicand";
    p3.default = (1,0);
    p3.hint = "Change this value as you like.\nIt should not be equal to zero!";
    p3.visible = (settype=="Julia");
  }
}


NovaLuna {
  parameter complex p1, p2, p3;
  parameter int settype;
  complex c, d, u, v, w;
  real r;

  void init(void)
  {
    if (((real(p1)==0) || (real(p1)==1)) && (imag(p1)==0))
    {
      p1 = 2;
    }
    if ((real(p2)==0) && (imag(p2)==0))
    {
      p2 = 0.5;
    }
    if (settype=="Mandel")
    {
      c = pixel;
    }
    else
    {
      c = p3;
    }
    v = pixel;
    d = .5 * (p1 - 1) / p1;
  }
  void loop(void)
  {
    u = v;
    w = 1 - (c / u)^p1;
    v = u - u / p1 * w * (1 + d * w) + p2;
    r = log10(|v - u|);
  }
  bool bailout(void)
  {
    return(r >= -12);
  }
  void description(void)
  {
    this.title = "NovaLuna";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;

    p1.caption = "Degree of root";
    p1.default = (2,0);
    p1.hint = "Change this value as you like (<> 0 and <> 1).";

    p2.caption = "Perturbation";
    p2.default = (0.5,0);
    p2.hint = "Change this value as you like.\nIt must not be equal to zero!";

    p3.caption = "Radicand";
    p3.default = (1,0);
    p3.hint = "Change this value as you like.\nIt should not be equal to zero!";
    p3.visible = (settype=="Julia");
  }
}


Lyra {
  parameter complex p1, p2, p3;
  parameter int settype;
  complex c, d, u, v;
  real r;

  void init(void)
  {
    if (((real(p1)==0) || (real(p1)==1)) && (imag(p1)==0))
    {
      p1 = 2;
    }
    if ((real(p2)==0) && (imag(p2)==0))
    {
      p2 = 0.5;
    }
    if (settype=="Mandel")
    {
      c = pixel;
    }
    else
    {
      c = p3;
    }
    v = pixel;
    d = p1 - 1;
  }
  void loop(void)
  {
    u = v;
    v = (p1 * u) / ((u / c)^p1 + d) + p2;
    r = log10(|v - u|);
  }
  bool bailout(void)
  {
    return(r >= -12);
  }
  void description(void)
  {
    this.title = "Lyra";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;

    p1.caption = "Degree of root";
    p1.default = (2,0);
    p1.hint = "Change this value as you like (<> 0 and <> 1).";

    p2.caption = "Perturbation";
    p2.default = (0.5,0);
    p2.hint = "Change this value as you like.\nIt must not be equal to zero!";

    p3.caption = "Radicand";
    p3.default = (1,0);
    p3.hint = "Change this value as you like.\nIt should not be equal to zero!";
    p3.visible = (settype=="Julia");
  }
}


AntiLuna {
  parameter complex p1, p2, p3;
  parameter int settype;
  complex c, u, v;
  real r;

  void init(void)
  {
    if (((real(p1)==0) || (real(p1)==1)) && (imag(p1)==0))
    {
      p1 = 2;
    }
    if ((real(p3)==0) && (imag(p3)==0))
    {
      p3 = 1;
    }
    if (settype=="Mandel")
    {
      c = pixel - p3;
    }
    else
    {
      if ((real(p2)==0) && (imag(p2)==0))
      {
        p2 = 0.5;
      }
      c = p2 - p3;
      if (c==0)
      {
        c = p3 / 2;
      }
    }
    v = pixel; 
  }
  void loop(void)
  {
    u = v;
    v = u - u / p1 * (1 - (p3 / u)^p1) + c;
    r = log10(|v - u|);
  }
  bool bailout(void)//
  {
    return(r >= -12);
  }
  void description(void)
  {
    this.title = "Anti-Luna";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;

    p1.caption = "Degree of root";
    p1.default = (2,0);
    p1.hint = "Change this value as you like (<> 0 and <> 1).";

    p2.caption = "Perturbation";
    p2.default = (0.5,0);
    p2.hint = "Change this value as you like.\nIt must not be equal to zero!";
    p2.visible = (settype=="Julia");

    p3.caption = "Radicand";
    p3.default = (1,0);
    p3.hint = "Change this value as you like.\nIt should not be equal to zero!";
  }
}


SinusLuna {
  parameter complex p1, p2;
  parameter int settype;
  complex c, u, v;
  real r;

  void init(void)
  {
    if (((real(p1)==0) || (real(p1)==1)) && (imag(p1)==0))
    {
      p1 = 2;
    }
    if ((real(p2)==0) && (imag(p2)==0))
    {
      p2 = 0.5;
    }
    if (settype=="Mandel")
    {
      c = sin(pixel);
    }
    else
    {
      c = sin(p2);
    }
    v = pixel;
  }
  void loop(void)
  {
    u = v;
    v = u - (sin(u) - c) / cos(u) + p2;
    r = log10(|v - u|);
  }
  bool bailout(void)//**
  {
    return(r >= -12);
  }
  void description(void)
  {
    this.title = "Sinus-Luna";

    settype.caption = "Set type";
    settype.enum = "Mandel\nJulia";
    settype.default = 0;

    p1.caption = "Degree of root";
    p1.default = (2,0);
    p1.hint = "Change this value as you like (<> 0 and <> 1).";

    p2.caption = "Perturbation";
    p2.default = (0.5,0);
    p2.hint = "Change this value as you like.\nIt must not be equal to zero!";
    p2.visible = (settype=="Julia");
  }
}