comment{The follwing fractals present `cross-breedings' of quadratic and
cubic Mandelbrot and Julia sets. Feel free to add more of these.

Bernd Lehnhoff 2004 
f.b.lehnhoff@gmx.de

Contents
--------

Mandelbastards: Hybrids of quadratic and cubic Mandelbrot sets.

Juliabastards:  Hybrids of quadratic and cubic Julia sets.
}


Mandelbastards {
parameter int frmltype; 
parameter real bailout;
complex c, q;

  void init(void)
  {
    c = pixel;
    z = pixel;
  }
  void loop(void)
  {
    q = z * z;
    if (frmltype=="R2R3")
    {
      z = real(q) + flip(real(z*q)) + c;
    }
    else if (frmltype=="R2I3")
    {
      z = real(q) + flip(imag(z*q)) + c;
    }
    else if (frmltype=="I2R3")
    {
      z = imag(q) + flip(real(z*q)) + c;
    }
    else if (frmltype=="I2I3")
    {
      z = imag(q) + flip(imag(z*q)) + c;
    }
    else if (frmltype=="R3R2")
    {
      z = real(z*q) + flip(real(q)) + c;
    }
    else if (frmltype=="R3I2")
    {
      z = real(z*q) + flip(imag(q)) + c;
    }
    else if (frmltype=="I3R2")
    {
      z = imag(z*q) + flip(real(q)) + c;
    }
    else if (frmltype=="I3I2")
    {
      z = imag(z*q) + flip(imag(q)) + c;
    }
  }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "Mandelbastarde";
    frmltype.caption = "Formula";
    frmltype.enum = "R2R3\nR2I3\nI2R3\nI2I3\nR3R2\nR3I2\nI3R2\nI3I2";
    frmltype.hint = "Please select an iteration formula for use.";
    bailout.caption = "Bailout value";
    bailout.default = 25;
    bailout.hint = "Change this value as you like; it should be >= 16.";
  }
}


Juliabastards {
parameter int frmltype;
parameter complex seed; 
parameter real bailout;
complex c, q;

  void init(void)
  {
    c = seed;
    z = pixel;
  }
  void loop(void)
  {
    q = z * z;
    if (frmltype=="R2R3")
    {
      z = real(q) + flip(real(z*q)) + c;
    }
    else if (frmltype=="R2I3")
    {
      z = real(q) + flip(imag(z*q)) + c;
    }
    else if (frmltype=="I2R3")
    {
      z = imag(q) + flip(real(z*q)) + c;
    }
    else if (frmltype=="I2I3")
    {
      z = imag(q) + flip(imag(z*q)) + c;
    }
    else if (frmltype=="R3R2")
    {
      z = real(z*q) + flip(real(q)) + c;
    }
    else if (frmltype=="R3I2")
    {
      z = real(z*q) + flip(imag(q)) + c;
    }
    else if (frmltype=="I3R2")
    {
      z = imag(z*q) + flip(real(q)) + c;
    }
    else if (frmltype=="I3I2")
    {
      z = imag(z*q) + flip(imag(q)) + c;
    }
  }
  bool bailout(void)
  {
    return(|z|< bailout);
  }
  void description(void)
  {
    this.title = "Juliabastarde";

    frmltype.caption = "Formula";
    frmltype.enum = "R2R3\nR2I3\nI2R3\nI2I3\nR3R2\nR3I2\nI3R2\nI3I2";
    frmltype.hint = "Please select an iteration formula for use.";

    seed.caption = "Julia seed";
    seed.default = (0.3, 0.6);
    seed.hint = "Change this value as you like; it should be <> 0.";

    bailout.caption = "Bailout value";
    bailout.default = 25;
    bailout.hint = "Change this value as you like; it should be >= 16.";
  }
}
