comment
{
  In this file there are two example formula files. They simply
  generate the stanard Mandelbrot or Julia fractal.
}

Lorenz(ATTRACTOR)
{
parameter real a,b,c,delta;
shared real dx,dy,dz;
shared vector zOld;
parameter vector z_init;
real t,_x,_y,_z;
real deltax;

	void init(void)
	{
		z=z_init;
		deltax=delta;
	}
	void loop(void)
	{
		zOld=z;
		_x=partx(z);
		_y=party(z);
		_z=partz(z);
		dx=a*(_y-_x);
		dy=_x*(b-_z)-_y;
		dz=-c*_z+_x*_y;
		t=sqrt(dx*dx+dy*dy+dz*dz);
		if (t>0) {
			if (deltax==0) {
				deltax=delta;
			}
			if (deltax>0 && t*deltax>delta*2)
			{
				deltax=deltax/2;
			}
			if (deltax>0 && t*deltax<0.5*delta)
			{
				deltax=deltax*2;
			}
		}		
		z=z+deltax*vector(dx,dy,dz);
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Lorenz";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.helpfile="formulas.html";
		
		z_init.caption="Z Init";
		z_init.default=(0.1,0.2,0.3);
		
		delta.default=0.01;
		
		a.default=10;
		a.randomizable=true;
		a.min=0;
		a.max=20;
		b.default=28;
		b.randomizable=true;
		b.min=0;
		b.max=30;
		c.default=2.666;
		c.randomizable=true;
		c.min=0;
		c.max=20;
	}
}





Polynomial_AB(ATTRACTOR)
{
parameter real p1,p3,p5;
parameter vector addVector;
real xNew,yNew,zNew;
real xOld,yOld,zOld;

	void init(void)
	{
		z=(0,0,0);
	}
	void loop(void)
	{
		xOld=partx(z);
		yOld=party(z);
		zOld=partz(z);
		xNew=yOld-zOld*(p1+yOld);
		yNew=zOld-xOld*(p3+zOld);
		zNew=xOld-yOld*(p5+xOld);
		z=vector(xNew,yNew,zNew)+addVector;
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Polynomial A/B";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.maxiter=2000;
		addVector.caption="Displace";
		addVector.default=(0.963,-0.00699,0.018);
		addVector.randomizable=true;
		addVector.min=(-1.2,-1.2,-1.2);
		addVector.max=(1.2,1.2,1.2);

		p1.caption="P1";
		p1.default=0.602;
		p1.randomizable=true;
		p1.min=-1.2;
		p1.max=1.2;

		p3.caption="P3";
		p3.default=0.554;
		p3.randomizable=true;
		p3.min=-1.2;
		p3.max=1.2;

		p5.caption="P5";
		p5.default=0.292;
		p5.randomizable=true;
		p5.min=-1.2;
		p5.max=1.2;
	}
}

Polynomial_C(ATTRACTOR)
{
parameter real p1,p2,p3,p4,p5,p7,p8,p9,p10,p11,p13,p14,p15,p16,p17;
parameter vector addVector;
real xNew,yNew,zNew;
real xOld,yOld,zOld;

	void init(void)
	{
		z=(0,0,0);
	}
	void loop(void)
	{
		xOld=partx(z);
		yOld=party(z);
		zOld=partz(z);
		xNew=xOld*(p1+p2*xOld+p3*yOld)+yOld*(p4+p5*yOld);
		yNew=yOld*(p7+p8*yOld+p9*zOld)+zOld*(p10+p11*zOld);
		zNew=zOld*(p13+p14*zOld+p15*xOld)+xOld*(p16+p17*xOld);
		
		z=vector(xNew,yNew,zNew)+addVector;
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Polynomial C";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.maxiter=20000;
		addVector.caption="Displace";
		addVector.default=(0.382,-0.915,0.259);
		addVector.randomizable=true;
		addVector.min=(-2,-2,-2);
		addVector.max=(2,2,2);

		p1.caption="P1";
		p1.default=0.169;
		p1.randomizable=true;
		p1.min=-2;
		p1.max=2;

		p2.caption="P2";
		p2.default=0.729;
		p2.randomizable=true;
		p2.min=-2;
		p2.max=2;

		p3.caption="P3";
		p3.default=0.125;
		p3.randomizable=true;
		p3.min=-2;
		p3.max=2;

		p4.caption="P4";
		p4.default=-0.235;
		p4.randomizable=true;
		p4.min=-2;
		p4.max=2;

		p5.caption="P5";
		p5.default=-1.156;
		p5.randomizable=true;
		p5.min=-2;
		p5.max=2;

		p7.caption="P7";
		p7.default=0.281;
		p7.randomizable=true;
		p7.min=-2;
		p7.max=2;

		p8.caption="P8";
		p8.default=0.136;
		p8.randomizable=true;
		p8.min=-2;
		p8.max=2;

		p9.caption="P9";
		p9.default=0.75;
		p9.randomizable=true;
		p9.min=-2;
		p9.max=2;

		p10.caption="P10";
		p10.default=0.448;
		p10.randomizable=true;
		p10.min=-2;
		p10.max=2;

		p11.caption="P11";
		p11.default=0.306;
		p11.randomizable=true;
		p11.min=-2;
		p11.max=2;

		p13.caption="P13";
		p13.default=-0.212;
		p13.randomizable=true;
		p13.min=-2;
		p13.max=2;

		p14.caption="P14";
		p14.default=0.172;
		p14.randomizable=true;
		p14.min=-2;
		p14.max=2;

		p15.caption="P15";
		p15.default=-1.124;
		p15.randomizable=true;
		p15.min=-2;
		p15.max=2;

		p16.caption="P16";
		p16.default=-1.087;
		p16.randomizable=true;
		p16.min=-2;
		p16.max=2;

		p17.caption="P17";
		p17.default=-0.926;
		p17.randomizable=true;
		p17.min=-2;
		p17.max=2;
	}
}

Pickover(ATTRACTOR)
{
parameter real A,B,C,D;
real xNew,yNew,zNew;
real xO,yO,zO;
shared vector zOld;

	void init(void)
	{
		z=(1,1,1);
	}
	void loop(void)
	{
		zOld=z;
		xO=partx(z);
		yO=party(z);
		zO=partz(z);
		xNew=sin(A*yO)-zO*cos(B*xO);
		yNew=zO*sin(C*xO)-cos(D*yO);
		zNew=sin(xO);
		
		z=vector(xNew,yNew,zNew);
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Pickover";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.maxiter=20000;

		A.caption="A";
		A.default=1;
		A.randomizable=true;
		A.min=-3;
		A.max=3;

		B.caption="B";
		B.default=1.8;
		B.randomizable=true;
		B.min=-3;
		B.max=3;
     
		C.caption="C";
		C.default=0.71;
		C.randomizable=true;
		C.min=-3;
		C.max=3;

		D.caption="D";
		D.default=1.51;
		D.randomizable=true;
		D.min=-3;
		D.max=3;

	}
}










ChaoticFlow(ATTRACTOR)
{
parameter real m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12;
parameter int op0,op1,op2,op4,op5,op6,op8,op9,op10;
parameter real dT;
real xOld,yOld,zOld;
real xNew,yNew,zNew;

	void init(void)
	{
		z=(0.3,0.6,0.1);
	}
	void loop(void)
	{
		xOld=partx(z);
		yOld=party(z);
		zOld=partz(z);
		xNew=0;
		yNew=0;
		zNew=0;
		if (op0=="-") {
			xNew=m0*xOld;
		} else if (op0=="x") {
			xNew=m0*xOld*xOld;
		} else if (op0=="y") {
			xNew=m0*yOld*xOld;
		} else if (op0=="z") {
			xNew=m0*zOld*xOld;
		}
		if (op1=="-") {
			xNew=xNew+m1*yOld;
		} else if (op1=="x") {
			xNew=xNew+m1*xOld*yOld;
		} else if (op1=="y") {
			xNew=xNew+m1*yOld*yOld;
		} else if (op1=="z") {
			xNew=xNew+m1*zOld*yOld;
		}
		if (op2=="-") {
			xNew=xNew+m2*zOld;
		} else if (op2=="x") {
			xNew=xNew+m2*xOld*zOld;
		} else if (op2=="y") {
			xNew=xNew+m2*yOld*zOld;
		} else if (op2=="z") {
			xNew=xNew+m2*zOld*zOld;
		}
		xNew=xNew+m3;

		if (op4=="-") {
			yNew=yNew+m4*xOld;
		} else if (op4=="x") {
			yNew=yNew+m4*xOld*xOld;
		} else if (op4=="y") {
			yNew=yNew+m4*yOld*xOld;
		} else if (op4=="z") {
			yNew=yNew+m4*zOld*xOld;
		}
		if (op5=="-") {
			yNew=yNew+m5*yOld;
		} else if (op5=="x") {
			yNew=yNew+m5*xOld*yOld;
		} else if (op5=="y") {
			yNew=yNew+m5*yOld*yOld;
		} else if (op5=="z") {
			yNew=yNew+m5*zOld*yOld;
		}
		if (op6=="-") {
			yNew=yNew+m6*zOld;
		} else if (op6=="x") {
			yNew=yNew+m6*xOld*zOld;
		} else if (op6=="y") {
			yNew=yNew+m6*yOld*zOld;
		} else if (op6=="z") {
			yNew=yNew+m6*zOld*zOld;
		}
		yNew=yNew+m7;

		if (op8=="-") {
			zNew=zNew+m8*xOld;
		} else if (op8=="x") {
			zNew=zNew+m8*xOld*xOld;
		} else if (op8=="y") {
			zNew=zNew+m8*yOld*xOld;
		} else if (op8=="z") {
			zNew=zNew+m8*zOld*xOld;
		}
		if (op9=="-") {
			zNew=zNew+m9*yOld;
		} else if (op9=="x") {
			zNew=zNew+m9*xOld*yOld;
		} else if (op9=="y") {
			zNew=zNew+m9*yOld*yOld;
		} else if (op9=="z") {
			zNew=zNew+m9*zOld*yOld;
		}
		if (op10=="-") {
			zNew=zNew+m10*zOld;
		} else if (op10=="x") {
			zNew=zNew+m10*xOld*zOld;
		} else if (op10=="y") {
			zNew=zNew+m10*yOld*zOld;
		} else if (op10=="z") {
			zNew=zNew+m10*zOld*zOld;
		}
		zNew=zNew+m11;
		
		z=z+dT*vector(xNew,yNew,zNew);
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Chaotic Flow";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.helpfile="formulas.html";
		
		m0.caption="m0";
		m0.default=0;
		m0.min=-1;
		m0.max=1;
		m0.randomizable=true;

		op0.caption="Op 0";
		op0.enum="-\nx\ny\nz";
		op0.min=0;
		op0.max=3;
		op0.randomizable=true;

		m1.caption="m1";
		m1.default=0;
		m1.min=-1;
		m1.max=1;
		m1.randomizable=true;

		op1.caption="Op 1";
		op1.enum="-\nx\ny\nz";
		op1.min=0;
		op1.max=3;
		op1.randomizable=true;
		
		m2.caption="m2";
		m2.default=0;
		m2.min=-1;
		m2.max=1;
		m2.randomizable=true;

		op2.caption="Op 2";
		op2.enum="-\nx\ny\nz";
		op2.min=0;
		op2.max=3;
		op2.randomizable=true;

		m3.caption="m3";
		m3.default=0;
		m3.min=-1;
		m3.max=1;
		m3.randomizable=true;
		
		separator.label1.caption="";

		m4.caption="m4";
		m4.default=0;
		m4.min=-1;
		m4.max=1;
		m4.randomizable=true;

		op4.caption="Op 4";
		op4.enum="-\nx\ny\nz";
		op4.min=0;
		op4.max=3;
		op4.randomizable=true;
		
		m5.caption="m5";
		m5.default=0;
		m5.min=-1;
		m5.max=1;
		m5.randomizable=true;
		
		op5.caption="Op 5";
		op5.enum="-\nx\ny\nz";
		op5.min=0;
		op5.max=3;
		op5.randomizable=true;

		m6.caption="m6";
		m6.default=0;
		m6.min=-1;
		m6.max=1;
		m6.randomizable=true;
		
		op6.caption="Op 6";
		op6.enum="-\nx\ny\nz";
		op6.min=0;
		op6.max=3;
		op6.randomizable=true;
		
		m7.caption="m7";
		m7.default=0;
		m7.min=-1;
		m7.max=1;
		m7.randomizable=true;
		
		separator.label2.caption="";
		
		m8.caption="m8";
		m8.default=0;
		m8.min=-1;
		m8.max=1;
		m8.randomizable=true;

		op8.caption="Op 8";
		op8.enum="-\nx\ny\nz";
		op8.min=0;
		op8.max=3;
		op8.randomizable=true;
		
		m9.caption="m9";
		m9.default=0;
		m9.min=-1;
		m9.max=1;
		m9.randomizable=true;
		op9.caption="Op 9";
		op9.enum="-\nx\ny\nz";
		op9.min=0;
		op9.max=3;
		op9.randomizable=true;
		
		m10.caption="m10";
		m10.default=0;
		m10.min=-1;
		m10.max=1;
		m10.randomizable=true;
		
		op10.caption="Op 10";
		op10.enum="-\nx\ny\nz";
		op10.min=0;
		op10.max=3;
		op10.randomizable=true;

		m11.caption="m11";
		m11.default=0;
		m11.min=-1;
		m11.max=1;
		m11.randomizable=true;
		
		dT.caption="dT";
		dT.default=0;
		dT.min=0;
		dT.max=1;
		dT.randomizable=true;
		
		
	}
}
