comment
{
  In this file there are two example formula files. They simply
  generate the stanard Mandelbrot or Julia fractal.
}

perlinFBM(ATTRACTOR)
{
real stepInv;
real kCnt;
parameter real scaleStart;
vector noiseResult3;
vector noiseSum3,noisePos;
real freq,fbmOctaveMult;
parameter vector fbmOffset;
parameter double fbmScale;
parameter real fbmOctaves;
parameter double fbmStep;

	void init(void)
	{
	}
	void loop(void)
	{
		noisePos=fbmScale*z+fbmOffset;
		
		freq= scaleStart;
		noiseSum3 = vector(0,0,0);
		kCnt=fbmOctaves;
		stepInv=1/fbmStep;
		while (kCnt>0) {
			
			noiseResult3=freq*perlinNoise3(partx(noisePos),party(noisePos),partz(noisePos));
			if (kCnt<1) {
				fbmOctaveMult=kCnt;
			} else {
				fbmOctaveMult=1;
			}
			
			noiseSum3 = noiseSum3 + fbmOctaveMult*noiseResult3;

			freq = freq * fbmStep;
			noisePos = stepInv*noisePos;
			kCnt=kCnt-1;
		}
		z=z+noiseSum3;
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Perlin based FBM";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.center=(1,3);
		this.angle=0;
		this.maxiter=15000;
		this.periodicity=0;
		this.helpfile="formulas.html";

		scaleStart.caption="Scale";
		scaleStart.default=0.1;
		scaleStart.hint="Sets the initial scale of the noise. 0 means no noise at all, the higher the more noise.";
		
		fbmOffset.caption = "Offset";
		fbmOffset.default =  (0,0,0);
		fbmOffset.hint = "This is the offset of the random pattern. Lets you shift the pattern in the 3D space.";
 
		fbmScale.caption = "Scale Factor";
		fbmScale.default =  1.0;
		fbmScale.hint = "This is the overall scale of the noise.";
 
		fbmStep.caption = "Scale Step";
		fbmStep.default =  0.5;
		fbmStep.hint = "This is the step in scale between noise iterations.";
 
		fbmOctaves.caption = "Octaves";
		fbmOctaves.default =  5;
		fbmOctaves.min = 0;
		fbmOctaves.hint = "This is the number of iterations of the noise formula.";
 
	}
}


LinTrans(ATTRACTOR)
{
parameter vector m1,m2,m3,v1;

	void init(void)
	{
	}
	void loop(void)
	{
		z = vector(z*m1,z*m2,z*m3)+v1;
	}
	bool stop(void)
	{
		return(false);
	}

	void description(void)
	{
		this.title="Linear Transformation";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.helpfile="formulas.html";

		m1.caption="Matrix Row 1";
		m1.default=(1,0,0);

		m2.caption="Matrix Row 2";
		m2.default=(0,1,0);

		m3.caption="Matrix Row 3";
		m3.default=(0,0,1);

		v1.caption="Vector";
		v1.default=(0,0,0);
	}
}

LinTransV2(ATTRACTOR)
{
parameter vector matrix1_x,matrix1_y,matrix1_z;
parameter vector vector1;
vector matrix_x,matrix_y,matrix_z;
vector multmatrix_x,multmatrix_y,multmatrix_z;
double sa,ca,sb,cb,sc,cc,sx,sy,sz,cx,cy,cz,scalex,scaley,scalez;

	void init(void)
	{
		// At first the scaling

		scalex=partx(matrix1_x);
		scaley=party(matrix1_x);
		scalez=partz(matrix1_x);
		
		sa=sin(-partx(matrix1_y)*pi/180);
		sb=sin(-party(matrix1_y)*pi/180);
		sc=sin(-partz(matrix1_y)*pi/180);
		ca=cos(-partx(matrix1_y)*pi/180);
		cb=cos(-party(matrix1_y)*pi/180);
		cc=cos(-partz(matrix1_y)*pi/180);

		sx=sin(partx(matrix1_z)*pi/180);
		sy=sin(party(matrix1_z)*pi/180);
		sz=sin(partz(matrix1_z)*pi/180);
		cx=cos(partx(matrix1_z)*pi/180);
		cy=cos(party(matrix1_z)*pi/180);
		cz=cos(partz(matrix1_z)*pi/180);
		
		// now construct the matrix multiplication in multmatrix_x,multmatrix_y, multmatrix_z, it must be transposed later on.

		matrix_x=vector((cb*cy+sb*cx*sy)*cz+sb*sx*sz,(cb*cy+sb*cx*sy)*sz-sb*sx*cz,-cb*sy+sb*cx*cy);
		matrix_y=vector((sc*cy+cc*sx*sy)*cz-cc*cx*sz,(sc*cy+cc*sx*sy)*sz+cc*cx*cz,-sc*sy+cc*sx*cy);
		matrix_z=vector((sa*sc*cy+(sa*cc*sx+ca*cx)*sy)*cz-(sa*cc*cx-ca*sx)*sz,(sa*sc*cy+(sa*cc*sx+ca*cx)*sy)*sz+(sa*cc*cx-ca*sx)*cz,sa*sc*sy+(sa*cc*sx+ca*cx)*cy);
		matrix_x=scalex*matrix_x;
		matrix_y=scaley*matrix_y;
		matrix_z=scalez*matrix_z;

		// Now transpose it...
		multmatrix_x=vector(partx(matrix_x),partx(matrix_y),partx(matrix_z));
		multmatrix_y=vector(party(matrix_x),party(matrix_y),party(matrix_z));
		multmatrix_z=vector(partz(matrix_x),partz(matrix_y),partz(matrix_z));
	}
	void loop(void)
	{
		z=vector(z*multmatrix_x,z*multmatrix_y,z*multmatrix_z)+vector1;
	}
	bool stop(void)
	{
		return(false);
	}
	real scale(void)
	{
		return partx(matrix1_x)*party(matrix1_x)*partz(matrix1_x);
	}
	void description(void)
	{
		this.title="Scale, Shear, Rotate, Displace";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.helpfile="formulas.html";

		
		matrix1_x.caption="Scale X/Y/Z";
		matrix1_x.default=(1,1,1);
		matrix1_x.hint="Lets you specify the scale in x, y and z direction";
		matrix1_x.min=(-1E10,-1E10,-1E10);
		matrix1_x.max=(1E10,1E10,1E10);
		matrix1_x.randomizable=true;
		matrix1_x.randomizeMin=-1;
		matrix1_x.randomizeMax=1;
		
		matrix1_y.caption="Shear X/Y/Z";
		matrix1_y.default=(0,0,0);
		matrix1_y.hint="Lets you specify the shear in in x, y and z direction";
		matrix1_y.min=(-1E10,-1E10,-1E10);
		matrix1_y.max=(1E10,1E10,1E10);
		matrix1_y.randomizable=true;
		matrix1_y.randomizeMin=-360;
		matrix1_y.randomizeMax=360;

		matrix1_z.caption="Rotate X/Y/Z";
		matrix1_z.default=(0,0,0);
		matrix1_z.hint="Lets you specify the rotation around x, y and z axis";
		matrix1_y.min=(-1E10,-1E10,-1E10);
		matrix1_y.max=(1E10,1E10,1E10);
		matrix1_z.randomizable=true;
		matrix1_z.randomizeMin=-360;
		matrix1_z.randomizeMax=360;

		vector1.caption="Vector";
		vector1.default=(0,0,0);
		vector1.hint="Allows to apply a displacement";
		vector1.randomizable=true;
		vector1.randomizeMin=-3;
		vector1.randomizeMax=3;
	}
}





Sinusoid(ATTRACTOR)
{
parameter real fX,fY,fZ;
real tx,ty,tz;

	void init(void)
	{
	}
	void loop(void)
	{
		tx=partx(z)*fX;
		ty=party(z)*fY;
		tz=partz(z)*fZ;
		z = vector(sin(tx),sin(ty),sin(tz));
	}
	real scale(void)
	{
		return 0.1;
	}
	void description(void)
	{
		this.title="Sinusoid";

		fX.caption="Factor X";
		fX.default=1;
		fX.hint="Lets you specify the multiplication factor in X direction";
		fX.min=0;
		fX.max=1E10;

		fY.caption="Factor Y";
		fY.default=1;
		fY.hint="Lets you specify the multiplication factor in Y direction";
		fY.min=0;
		fY.max=1E10;

		fZ.caption="Factor Z";
		fZ.default=1;
		fZ.hint="Lets you specify the multiplication factor in Z direction";
		fZ.min=0;
		fZ.max=1E10;
	}
}


Spherical(ATTRACTOR)
{
parameter real fX,fY,fZ;
real tx,ty,tz;
real r2;

	void init(void)
	{
	}
	void loop(void)
	{
		r2=1.0/|z|;
		tx=partx(z)*fX;
		ty=party(z)*fY;
		tz=partz(z)*fZ;
		z = vector(r2*tx,r2*ty,r2*tz);
	}
	real scale(void)
	{
		return 0.1;
	}
	void description(void)
	{
		this.title="Spherical";

		fX.caption="Factor X";
		fX.default=1;
		fX.hint="Lets you specify the multiplication factor in X direction";
		fX.min=0;
		fX.max=1E10;

		fY.caption="Factor Y";
		fY.default=1;
		fY.hint="Lets you specify the multiplication factor in Y direction";
		fY.min=0;
		fY.max=1E10;

		fZ.caption="Factor Z";
		fZ.default=1;
		fZ.hint="Lets you specify the multiplication factor in Z direction";
		fZ.min=0;
		fZ.max=1E10;
	}
}

Swirl(ATTRACTOR)
{
parameter real fX,fY,fZ;
real tx,ty,tz;
real r2;

	void init(void)
	{
	}
	void loop(void)
	{
		r2=|z|;
		tx=partx(z);
		ty=party(z);
		tz=partz(z);
		z = vector(tx*sin(fX*r2)-ty*cos(fX*r2),tx*cos(fY*r2)+ty*sin(fY*r2),tz*sin(fZ*r2)-ty*cos(fZ*r2));
	}
	real scale(void)
	{
		return 0.1;
	}
	void description(void)
	{
		this.title="Swirl";

		fX.caption="Factor X";
		fX.default=1;
		fX.hint="Lets you specify the multiplication factor in X direction";
		fX.min=-1E10;
		fX.max=1E10;

		fY.caption="Factor Y";
		fY.default=1;
		fY.hint="Lets you specify the multiplication factor in Y direction";
		fY.min=-1E10;
		fY.max=1E10;

		fZ.caption="Factor Z";
		fZ.default=1;
		fZ.hint="Lets you specify the multiplication factor in Z direction";
		fZ.min=-1E10;
		fZ.max=1E10;
	}
}


Horseshoe(ATTRACTOR)
{
real tx,ty,tz;
real r;

	void init(void)
	{
	}
	void loop(void)
	{
		r=1.0/cabs(z);
		tx=partx(z);
		ty=party(z);
		tz=partz(z);
		z = vector(r*(tx^2-ty^2),r*4*tx*ty*tz,r*(tz^2-ty^2));
	}
	real scale(void)
	{
		return 0.7;
	}
	void description(void)
	{
		this.title="Horseshoe";
	}
}

Polar(ATTRACTOR)
{
real tx,ty,tz;
real r;
real phi,theta1,theta2;

	void init(void)
	{
	}
	void loop(void)
	{
		r=cabs(z);
		tx=partx(z);
		ty=party(z);
		tz=partz(z);
		theta1=atan2(ty + flip(tx));
		theta2=atan2(tz + flip(tx));
		z = vector(theta1/pi,r-1,theta2/pi);
	}
	real scale(void)
	{
		return 0.7;
	}
	void description(void)
	{
		this.title="Polar";
	}
}

Handkerchief(ATTRACTOR)
{
real tx,ty,tz;
real r;
real phi,theta1,theta2;

	void init(void)
	{
	}
	void loop(void)
	{
		r=cabs(z);
		tx=partx(z);
		ty=party(z);
		tz=partz(z);
		theta1 = atan2(ty + flip(tx));
		theta2 = atan2(tz + flip(ty));
		z = vector(r*sin(theta1+r),r*cos(theta1-r),r*sin(theta2+r)); // r*sin(theta2+r));
	}
	real scale(void)
	{
		return 0.7;
	}
	void description(void)
	{
		this.title="Handkerchief";
	}
}

Heart(ATTRACTOR)
{
real tx,ty,tz;
real r;
real phi,theta1,theta2;

	void init(void)
	{
	}
	void loop(void)
	{
		// r=cabs(z);
		tx=partx(z);
		ty=party(z);
		tz=partz(z);
		r=sqrt(tx^2+ty^2);
		theta1 = atan2(ty + flip(tx));
		theta2 = atan2(tz + flip(ty));
		z = r*vector(sin(theta1*r),-cos(theta1*r),0);
	}
	real scale(void)
	{
		return 0.7;
	}
	void description(void)
	{
		this.title="Heart";
	}
}



Tile(ATTRACTOR)
{
real tx,ty,tz;
parameter int cloneMode;
parameter int numClones,numClonesX,numClonesY,numClonesZ;
parameter real spaceBetweenClones;
parameter real cloneSizePercent;
real cloneSize;
real cloneX,cloneY,cloneZ;
parameter real a;
parameter real turns,outer_rad;
real tt,xt,yt,zt;

	void init(void)
	{
		cloneSize=cloneSizePercent*0.01;
	}
	void loop(void)
	{
		tx=partx(z);
		ty=party(z);
		tz=partz(z);
		if (cloneMode=="Cube") {
			cloneX=floor(random.real()*numClonesX)*spaceBetweenClones-spaceBetweenClones*(numClonesX-1)*0.5;
			cloneY=floor(random.real()*numClonesY)*spaceBetweenClones-spaceBetweenClones*(numClonesY-1)*0.5;
			cloneZ=floor(random.real()*numClonesZ)*spaceBetweenClones-spaceBetweenClones*(numClonesZ-1)*0.5;
			// angenommen, das Objekt ist zentriert um den Nullpunkt
			// numClones=1 ==> es wird einfach nur verkleinert
			// numClones=2 ==> 
			tx=cloneX+tx*cloneSize;
			ty=cloneY+ty*cloneSize;
			tz=cloneZ+tz*cloneSize;
		} else if (cloneMode=="Sphere") {
			tt=floor(random.real()*numClones)/numClones*pi;
			xt = outer_rad * 0.5*cos(turns*2*tt) * sin(tt);
			yt = outer_rad * 0.5*sin(turns*2*tt) * sin(tt);
			zt = outer_rad * 0.5*cos(tt);
			tx=xt+tx*cloneSize;
			ty=yt+ty*cloneSize;
			tz=zt+tz*cloneSize;
		}
		z = vector(tx,ty,tz);
	}
	real scale(void)
	{
		return 0.7;
	}
	void description(void)
	{
		this.title="Tile";
		
		cloneMode.caption="Clone Shape";
		cloneMode.enum="Cube\nSphere\nPyramid\nStar";
		cloneMode.default=0;

		numClonesX.caption="Num. Clones X";
		numClonesX.default=5;
		numClonesX.hint="Here you can define the number of clones to create along the x axis";
		numClonesX.min=1;
		numClonesX.max=1E10;
		numClonesX.visible=(cloneMode=="Cube");

		numClonesY.caption="Num. Clones Y";
		numClonesY.default=5;
		numClonesY.hint="Here you can define the number of clones to create along the y axis";
		numClonesY.min=1;
		numClonesY.max=1E10;
		numClonesY.visible=(cloneMode=="Cube");

		numClonesZ.caption="Num. Clones Z";
		numClonesZ.default=5;
		numClonesZ.hint="Here you can define the number of clones to create along the z axis";
		numClonesZ.min=1;
		numClonesZ.max=1E10;
		numClonesZ.visible=(cloneMode=="Cube");

		spaceBetweenClones.caption="Distance";
		spaceBetweenClones.default=0.2;
		spaceBetweenClones.hint="Distance between two clones. Should be in unit length";
		spaceBetweenClones.min=-1E10;
		spaceBetweenClones.max=1E10;
		spaceBetweenClones.visible=(cloneMode=="Cube");
		
		cloneSizePercent.caption="Clone size [%]";
		cloneSizePercent.default=10;
		cloneSizePercent.hint="Specifies the clone size relative to the original object in percent. Thus 10 means: Each clone is 10% the size of the original object";
		cloneSizePercent.min=0;
		cloneSizePercent.max=1E10;
		cloneSizePercent.visible=(cloneMode=="Cube");
		
		numClones.caption="Number of Clones";
		numClones.default=200;
		numClones.hint="Here you can define the number of clones to create along the spiral path on the sphere";
		numClones.min=1;
		numClones.max=1E10;
		numClones.visible=(cloneMode=="Sphere");
		
		outer_rad.caption="Radius";
		outer_rad.default=1;
		outer_rad.hint="Specifies the radius of the sphere on which the clones are placed";
		outer_rad.min=0;
		outer_rad.max=1E10;
		outer_rad.visible=(cloneMode=="Sphere");

		turns.caption="Twists";
		turns.default=13;
		turns.hint="Specifies the number of twists of the spiral on the sphere.";
		turns.min=1;
		turns.max=1E10;
		turns.visible=(cloneMode=="Sphere");
		
		
		
	}
}
