comment
{
  Flame Component formulas
}

Flame_Fnx(ATTRACTOR)
{
real tx,ty;
real vx,vy;
real a,r,r1,r2,c1,c2,n0,n1,m0,m1,nx,ny,dx,dy,dx2,bdiff;
real nx1,nx2,ny1,ny2,t,sinr,cosr,t_rnd,sina,cosa,tmpr,ang,tanr;
real rndG,ra,rz,tmpa,sa,ca;
real sl,cr,icr;
real r_factor,theta,phi,b,amp,diff,t1,t2,myrnd;
real l1_11,l1_12,l1_21,l1_22,l2_11,l2_12,l2_21,l2_22;
real v1_1,v1_2,v2_1,v2_2;
parameter bool addTx;
parameter complex l1_1,l1_2,v1,l2_1,l2_2,v2;
parameter real weightLinear,weightSinusoidal,weightSpherical,weightSwirl,weightHorseshoe,weightPolar,weightHandkerchief,weightHeart,weightDisc;
parameter real weightSpiral,weightHyperbolic,weightDiamond,weightEx,weightJulia,weightBent,weightWaves,weightFisheye,weightPopcorn;
parameter real weightExponential,weightPower,weightCosine,weightRings,weightFan,weightBlob,weightPdj,weightFan2,weightRings2,weightEyefish,weightBubble;
parameter real weightCylinder,weightPerspective,weightNoise,weightJuliaN_generic,weightJuliaScope_generic,weightBlur,weightGaussian,weightRadial_blur;
parameter real weightPie,weightNgon,weightCurl,weightRectangles,weightArch,weightTangent,weightSquare,weightRays,weightBlade,weightSecant2;
parameter real weightTwintrian,weightCross,weightDisc2,weightSupershape,weightFlower,weightConic,weightParabola;
// parameters for the different transformations
parameter real blob_high,blob_low,blob_waves;
parameter real pdj_a,pdj_b,pdj_c,pdj_d;
parameter real fan2_x,fan2_y;
parameter real rings2_val;
parameter real perspective_dist,perspective_angle;
parameter int juliaN_power;
parameter real juliaN_dist;
parameter int juliaScope_power;
parameter real juliaScope_dist;
parameter real radialBlur_angle;
parameter int pie_slices;
parameter real pie_thickness,pie_rotation;
parameter int ngon_sides;
parameter real ngon_power,ngon_circle,ngon_corners;
parameter real curl_c1,curl_c2;
parameter real rectangles_x,rectangles_y;
parameter real disc2_rot,disc2_twist;
parameter int supershape_m;
parameter real supershape_rnd,supershape_n1,supershape_n2,supershape_n3,supershape_holes;
parameter real flower_petals,flower_holes;
parameter real conic_eccen,conic_holes;
parameter real parabola_width,parabola_height;
real eps;
real precalc_sqrt,precalc_atan,precalc_sina,precalc_cosa,M_1_PI,precalc_atanyx;
real seedJulia,seedNoise,seedJuliaN,seedJuliaScope,seedBlur,seedGaussian,seedRadialBlur,seedPie,seedArch,seedSquare,seedRays,seedBlade,seedTwintrian,seedSupershape,seedFlower,seedConic,seedParabola;
real waves_dx2,waves_dy2;
real persp_vsin,persp_vfcos;
real juliaN_rN,juliaN_cn;
real juliaScope_rN,juliaScope_cn;
real radialBlur_spinvar,radialBlur_zoomvar;
real disc2_timespi,disc2_sinadd,disc2_cosadd;
real supershape_pm_4,supershape_pneg1_n1;

	void init(void)
	{
		eps = 1E-10;
		M_1_PI=1/pi;
		seedJulia=1526;
		seedNoise=19283;
		seedJuliaN=99182;
		seedJuliaScope=1827373;
		seedBlur=4648103;
		seedGaussian=998172;
		seedRadialBlur=3918293;
		seedPie=787776112;
		seedArch=9817272;
		seedSquare=7716276;
		seedRays=5988788;
		seedBlade=3355244;
		seedTwintrian=7988761;
		seedSupershape=8909895634;
		seedFlower=881729288;
		seedConic=7716662;
		seedParabola=988273;
		seedJulia=random(seedJulia);
		seedNoise=random(seedNoise);
		seedJuliaN=random(seedJuliaN);
		seedJuliaScope=random(seedJuliaScope);
		seedBlur=random(seedBlur);
		seedGaussian=random(seedGaussian);
		seedRadialBlur=random(seedRadialBlur);
		seedPie=random(seedPie);
		seedArch=random(seedArch);
		seedSquare=random(seedSquare);
		seedRays=random(seedRays);
		seedBlade=random(seedBlade);
		seedTwintrian=random(seedTwintrian);
		seedSupershape=random(seedSupershape);
		seedFlower=random(seedFlower);
		seedConic=random(seedConic);
		seedParabola=random(seedParabola);

		l1_11=real(l1_1);
		l1_21=imag(l1_1);
		l1_12=real(l1_2);
		l1_22=imag(l1_2);
		
		v1_1=real(v1);
		v1_2=imag(v1);

		l2_11=real(l2_1);
		l2_21=imag(l2_1);
		l2_12=real(l2_2);
		l2_22=imag(l2_2);
		
		v2_1=real(v2);
		v2_2=imag(v2);
		
		if (weightWaves>0) {
			waves_dx2 = 1.0/(v1_1 * v1_1 + eps);
			waves_dy2 = 1.0/(v1_2 * v1_2 + eps);
		}
		if (weightPerspective>0) {
			t = perspective_angle*pi/2;
			persp_vsin = sin(t);
			persp_vfcos = perspective_dist * cos(t);
		}
		if (weightJuliaN_generic>0) {
			juliaN_rN = abs(juliaN_power);
			juliaN_cn = juliaN_dist/juliaN_power/2;
		}
		if (weightJuliaScope_generic>0) {
			juliaScope_rN = abs(juliaScope_power);
			juliaScope_cn = juliaScope_dist/juliaScope_power/2;
		}
		if (weightRadial_blur>0) {
			radialBlur_spinvar = sin(radialBlur_angle * pi / 2);
			radialBlur_zoomvar = cos(radialBlur_angle * pi / 2);
		}
		if (weightDisc2>0) {
			disc2_timespi = disc2_rot * pi;
			
			disc2_sinadd = sin(disc2_twist);
			disc2_cosadd = cos(disc2_twist) - 1;
			
			if (disc2_twist > 2 * pi) {
				a = (1 + disc2_twist - 2*pi);
				disc2_cosadd = disc2_cosadd*a;
				disc2_sinadd = disc2_sinadd*a;
			}
			
			if (disc2_twist < -2 * pi) {
				a = (1 + disc2_twist + 2*pi);
				disc2_cosadd = disc2_cosadd*a;
				disc2_sinadd = disc2_sinadd*a;
			}
		}
		if (weightSupershape>0) {
			supershape_pm_4 = supershape_m / 4.0;
			supershape_pneg1_n1 = -1.0 / supershape_n1;
		}			

		
	}
	void loop(void)
	{
		tx=partx(z);
		ty=party(z);
		
		// zuerst die affine Transformation
		
		vx = l1_11*tx + l1_12*ty + v1_1;
		vy = l1_21*tx + l1_22*ty + v1_2;
		
		tx=vx;
		ty=vy;
		
		// dann die entsprechenden anderen Transformationen
		vx = 0;
		vy = 0;
		if (weightHorseshoe>0 || weightPolar>0 || weightHandkerchief>0 || weightHeart>0 || weightDisc>0 || weightSpiral>0 || weightHyperbolic>0 || weightDiamond>0 || weightEx>0 || weightFisheye>0 || weightPower>0 || weightRings>0 || weightFan>0 || weightBlob>0 || weightFan2>0 || weightRings2>0 || weightEyefish>0 || weightRadial_blur>0 || weightBlade>0 || weightSecant2>0 || weightTwintrian>0 || weightSupershape>0 || weightParabola>0) {
			precalc_sqrt = sqrt(tx*tx + ty*ty);
		}
		if (weightPolar>0 || weightHandkerchief>0 || weightHeart>0 || weightDisc>0 || weightSpiral>0 || weightHyperbolic>0 || weightDiamond>0 || weightEx>0 || weightJulia>0 || weightPower>0 || weightRings>0 || weightFan>0 || weightBlob>0 || weightFan2>0 || weightRings2>0 || weightDisc2>0) {
			if (tx<-eps || tx>eps || ty<-eps || ty>eps) {
				precalc_atan = atan2(ty + flip(tx));
			} else {
				precalc_atan=0;
			}
			if (weightSpiral>0 || weightHyperbolic>0 || weightDiamond>0 || weightPower>0 || weightRings>0 || weightBlob>0 || weightRings2>0) {
				precalc_sina = sin(precalc_atan);
				precalc_cosa = cos(precalc_atan);
			}
		}
		if (weightJuliaN_generic>0 || weightJuliaScope_generic>0 || weightRadial_blur>0 || weightNgon>0 || weightSupershape>0 || weightFlower>0 || weightConic>0) {
			if (ty<-eps || ty>eps || tx<-eps || tx>eps) {
				precalc_atanyx = atan2(tx + flip(ty));
			} else {
				precalc_atanyx=0;
			}
		}


		
		if (weightLinear>0) {
			// linear
			vx = vx + weightLinear*tx;
			vy = vy + weightLinear*ty;
		}
		
		if (weightSinusoidal>0) {
			// sinusoidal
			vx = vx + weightSinusoidal*sin(tx);
			vy = vy + weightSinusoidal*sin(ty);
		}
		
		if (weightSpherical>0) {
			// Spherical
			r2 = weightSpherical/(tx*tx + ty*ty + eps);
			vx = vx + r2*tx;
			vy = vy + r2*ty;
		}
		
		if (weightSwirl>0) {
			// swirl
			r2 = tx*tx + ty*ty;
			c1 = sin(r2);
			c2 = cos(r2);
			vx = vx + weightSwirl*(c1*tx - c2*ty);
			vy = vy + weightSwirl*(c2*tx + c1*ty);
		}
		
		if (weightHorseshoe>0) {
			// horseshoe
			r = weightHorseshoe / (precalc_sqrt + eps);
			vx = vx + (tx-ty)*(tx+ty)*r;
			vy = vy + 2*tx*ty*r;
		}

      
		if (weightPolar>0) {
			// polar
			vx = vx + weightPolar * (precalc_atan * M_1_PI);
			vy = vy + weightPolar * (precalc_sqrt - 1.0);
		}

		if (weightHandkerchief>0) {
			vx = vx + weightHandkerchief * precalc_sqrt * sin(precalc_atan+precalc_sqrt);
			vy = vy + weightHandkerchief * precalc_sqrt * cos(precalc_atan-precalc_sqrt);
		}
    
		if (weightHeart>0) {
			// heart-shaped box
			a = precalc_sqrt * precalc_atan;
			r = weightHeart * precalc_sqrt;

			vx = vx + r * sin(a);
			vy = vy + (-r) * cos(a);
		}
		
		if (weightDisc>0) {
			a = precalc_atan * M_1_PI;
			r = pi * precalc_sqrt;

			vx = vx + weightDisc * sin(r) * a;
			vy = vy + weightDisc * cos(r) * a;
		}
		if (weightSpiral>0) {
			r = precalc_sqrt + eps;
			r1 = weightSpiral/r;

			vx = vx + r1 * (precalc_cosa + sin(r));
			vy = vy + r1 * (precalc_sina - cos(r));
		}
		if (weightHyperbolic>0) {
			r = precalc_sqrt + eps;

			vx = vx + weightHyperbolic * precalc_sina / r;
			vy = vy + weightHyperbolic * precalc_cosa * r;
		}
		if (weightDiamond>0) {
			r = precalc_sqrt;

			vx = vx + weightDiamond * precalc_sina * cos(r);
			vy = vy + weightDiamond * precalc_cosa * sin(r);
		}
		if (weightEx>0) {
			a = precalc_atan;
			r = precalc_sqrt;

			n0 = sin(a+r);
			n1 = cos(a-r);

			m0 = n0 * n0 * n0 * r;
			m1 = n1 * n1 * n1 * r;

			vx = vx + weightEx * (m0 + m1);
			vy = vy + weightEx * (m0 - m1);
		}
		if (weightJulia>0) {
			a = 0.5 * precalc_atan;

			seedJulia=random(seedJulia);
			if (seedJulia>0) {
				a = a + pi;
			}
			r = weightJulia * sqrt(sqrt(tx * tx + ty * ty));
			vx = vx + r * cos(a);
			vy = vy + r * sin(a);
		}
		
		if (weightBent>0) {
			if (tx < 0.0) {
				n0 = tx * 2.0;
			} else {
				n0 = tx;
			}
			if (ty < 0.0) {
				n1 = ty / 2.0;
			} else {
				n1 = ty;
			}

			vx = vx + weightBent * n0;
			vy = vy + weightBent * n1;
		}
		if (weightWaves>0) {
			nx = tx + l1_12 * sin( ty * waves_dx2 );
			ny = ty + l1_22 * sin( tx * waves_dy2 );
			
			vx = vx + weightWaves * nx;
			vy = vy + weightWaves * ny;
		}
		if (weightFisheye>0) {
			r = precalc_sqrt;
			
			r = 2 * weightFisheye / (r+1);
			
			vx = vx + r * ty;
			vy = vy + r * tx;
		}
		if (weightPopcorn>0) {
			dx = tan(3*ty);
			dy = tan(3*tx);
			
			nx = tx + v1_1 * sin(dx);
			ny = ty + v1_2 * sin(dy);
			
			vx = vx + weightPopcorn * nx;
			vy = vy + weightPopcorn * ny;
		}
		if (weightExponential>0) {
			dx = weightExponential * exp(tx - 1.0);
			dy = pi * ty;
			
			vx = vx + dx * cos(dy);
			vy = vy + dx * sin(dy);
		}
		if (weightPower>0) {
			r = weightPower * (precalc_sqrt^precalc_sina);
			
			vx = vx + r * precalc_cosa;
			vy = vy + r * precalc_sina;
		}
		if (weightCosine>0) {
		   a = tx * pi;
		   nx =  cos(a) * cosh(ty);
		   ny = -sin(a) * sinh(ty);
		
		   vx = vx + weightCosine * nx;
		   vy = vy + weightCosine * ny;
		}
		if (weightRings>0) {
		   dx = v1_1 * v1_1 + eps;
		   r = precalc_sqrt;
		   r = weightRings * (((r+dx)%(2*dx)) - dx + r * (1 - dx));
		
		   vx = vx + r * precalc_cosa;
		   vy = vy + r * precalc_sina;
		}
		if (weightFan>0) {
		   dx = pi * (v1_1 * v1_1 + eps);
		   dy = v1_2;
		   dx2 = 0.5 * dx;
		
		   a = precalc_atan;
		   r = weightFan * precalc_sqrt;
		
			if ( (a+dy)%dx > dx2) {
				a = a-dx2;
			} else {
				a = a +dx2;
			}
		
		   vx = vx + r * cos(a);
		   vy = vy + r * sin(a);
		}
		if (weightBlob>0) {
		   r = precalc_sqrt;
		   a = precalc_atan;
		   bdiff = blob_high - blob_low;
		
		   r = r * (blob_low + bdiff * (0.5 + 0.5 * sin(blob_waves * a)));
		
		   vx = vx + weightBlob * precalc_sina * r;
		   vy = vy + weightBlob * precalc_cosa * r;
		}
		if (weightPdj>0) {
			nx1 = cos(pdj_b * tx);
			nx2 = sin(pdj_c * tx);
			ny1 = sin(pdj_a * ty);
			ny2 = cos(pdj_d * ty);
			
			vx = vx + weightPdj * (ny1 - nx1);
			vy = vy + weightPdj * (nx2 - ny2);
		}
		if (weightFan2>0) {
			dy = fan2_y;
			dx = pi * (fan2_x * fan2_x + eps);
			dx2 = 0.5 * dx;
			a = precalc_atan;
			r = weightFan2 * precalc_sqrt;
			
			t = a + dy - dx * trunc((a+dy)/dx);
			
			if (t>dx2) {
				a = a-dx2;
			} else {
				a = a+dx2;
			}
			
			vx = vx + r * sin(a);
			vy = vy + r * cos(a);
		}
		if (weightRings2>0) {
			r = precalc_sqrt;
			dx = rings2_val * rings2_val + eps;
			
			r = r -2*dx*trunc((r+dx)/(2*dx)) + r * (1-dx);
			
			vx = vx + weightRings2 * precalc_sina * r;
			vy = vy + weightRings2 * precalc_cosa * r;
		}
		if (weightEyefish>0) {
			r = (weightEyefish * 2.0) / (precalc_sqrt + 1.0);
			
			vx = vx + r*tx;
			vy = vy + r*ty;
		}
		if (weightBubble>0) {
			r = weightBubble / (0.25 * (tx*tx + ty*ty) + 1);
			
			vx = vx + r*tx;
			vy = vy + r*ty;
		}
		if (weightCylinder>0) {
			vx = vx + weightCylinder * sin(tx);
			vy = vy + weightCylinder * ty;
		}
		if (weightPerspective>0) {
			t = 1.0/(perspective_dist - ty * persp_vsin + eps);
			
			vx = vx + weightPerspective * perspective_dist * tx * t;
			vy = vy + weightPerspective * persp_vfcos * ty * t;
		}
		if (weightNoise>0) {
			
			seedNoise=random(seedNoise);

			t = abs(seedNoise)/randomrange * 2 * pi;
			sinr = sin(t);
			cosr = cos(t);
			
			seedNoise=random(seedNoise);
			r = weightNoise * abs(seedNoise)/randomrange;
			
			vx = vx + tx * r * cosr;
			vy = vy + ty * r * sinr;
		}
		if (weightJuliaN_generic>0) {
			seedJuliaN=random(seedJuliaN);

			t_rnd = trunc(juliaN_rN*abs(seedJuliaN)/randomrange);
			
			t = (precalc_atanyx + 2 * pi * t_rnd) / juliaN_power;
			
			sina = sin(t);
			cosa = cos(t);
			
			r = weightJuliaN_generic * (tx*tx + ty*ty)^juliaN_cn;
			
			vx = vx + r * cosa;
			vy = vy + r * sina;
		}
		if (weightJuliaScope_generic>0) {
			seedJuliaScope=random(seedJuliaScope);
			
			t_rnd = trunc(juliaScope_rN * abs(seedJuliaScope)/randomrange);
			
			if ((t_rnd%2) == 0) {
				tmpr = (2 * pi * t_rnd + precalc_atanyx) / juliaScope_power;
			} else {
				tmpr = (2 * pi * t_rnd - precalc_atanyx) / juliaScope_power;
			}
			
			sina = sin(tmpr);
			cosa = cos(tmpr);
			
			r = weightJuliaScope_generic * (tx*tx + ty*ty)^juliaScope_cn;
			
			vx = vx + r * cosa;
			vy = vy + r * sina;
		}
		if (weightBlur>0) {
			seedBlur=random(seedBlur);
			tmpr = abs(seedBlur)/randomrange * 2 * pi;
			sinr = sin(tmpr);
			cosr = cos(tmpr);
			
			seedBlur=random(seedBlur);
			r = weightBlur * abs(seedBlur)/randomrange;
			
			vx = vx + r * cosr;
			vy = vy + r * sinr;
		}
		if (weightGaussian>0) {
			seedGaussian=random(seedGaussian);
		
		   ang = abs(seedGaussian)/randomrange * 2 * pi;
		
		   sina = sin(ang);
		   cosa = cos(ang);
		
			seedGaussian=random(seedGaussian);
			n0=abs(seedGaussian)/randomrange;
			seedGaussian=random(seedGaussian);
			n1=abs(seedGaussian)/randomrange;
			seedGaussian=random(seedGaussian);
			m0=abs(seedGaussian)/randomrange;
			seedGaussian=random(seedGaussian);
			m1=abs(seedGaussian)/randomrange;
			
		   r = weightGaussian * ( n0 + n1 + m0 + m1 - 2.0 );
		
		   vx = vx + r * cosa;
		   vy = vy + r * sina;
		}
		if (weightRadial_blur>0) {
			seedRadialBlur=random(seedRadialBlur);
			m0=abs(seedRadialBlur)/randomrange;
			seedRadialBlur=random(seedRadialBlur);
			m1=abs(seedRadialBlur)/randomrange;
			seedRadialBlur=random(seedRadialBlur);
			n0=abs(seedRadialBlur)/randomrange;
			seedRadialBlur=random(seedRadialBlur);
			n1=abs(seedRadialBlur)/randomrange;
			
			rndG = weightRadial_blur * (m0 + m1 + n0 + n1 - 2.0);
			
			/* Calculate angle & zoom */
			ra = precalc_sqrt;
			tmpa = precalc_atanyx + radialBlur_spinvar*rndG;
			sa = sin(tmpa);
			ca = cos(tmpa);
			rz = radialBlur_zoomvar * rndG - 1;
			
			vx = vx + ra * ca + rz * tx;
			vy = vy + ra * sa + rz * ty;
		}
		if (weightPie>0) {
			seedPie=random(seedPie);
			m0=abs(seedPie)/randomrange;
			seedPie=random(seedPie);
			m1=abs(seedPie)/randomrange;
			
			sl = trunc(m0 * pie_slices + 0.5);
			a = pie_rotation + 2*pi*(sl+m1*pie_thickness) / pie_slices;
			seedPie=random(seedPie);
			n0=abs(seedPie)/randomrange;
			r = weightPie * n0;
			
			vx = vx + r * cos(a);
			vy = vy + r * sin(a);
		}
		if (weightNgon>0) {
			r_factor = (tx*tx + ty*ty)^(ngon_power/2);
			
			theta = precalc_atanyx;
			b = 2*pi/ngon_sides;
			
			phi = theta - (b*floor(theta/b));
			if (phi > b/2) {
				phi = phi - b;
			}
			
			amp = ngon_corners * (1.0 / (cos(phi) + eps) - 1.0) + ngon_circle;
			amp = amp/(r_factor + eps);
			
			vx = vx + weightNgon * tx * amp;
			vy = vy + weightNgon * ty * amp;
		}
		if (weightCurl>0) {
			nx = 1.0 + curl_c1 * tx + curl_c2 * (tx*tx - ty*ty);
			ny = curl_c1*ty + 2*curl_c2*tx*ty;
			
			r = weightCurl / (nx*nx + ny*ny);
			
			vx = vx + (tx*nx + ty*ny)*r;
			vy = vy + (ty*nx - tx*ny)*r;
		}
		if (weightRectangles>0) {
			if (rectangles_x==0) {
				vx = vx + weightRectangles * tx;
			} else {
				vx = vx + weightRectangles * ((2 * floor(tx / rectangles_x) + 1) * rectangles_x - tx);
			}
			
			if (rectangles_y==0) {
				vy = vy + weightRectangles * ty;
			} else {
				vy = vy + weightRectangles * ((2 * floor(ty / rectangles_y) + 1) * rectangles_y - ty);
			}
		}
		if (weightArch>0) {
			seedArch=random(seedArch);
			m0=abs(seedArch)/randomrange;

			ang = m0 * weightArch * pi;
			sinr = sin(ang);
			cosr = cos(ang);
			
			vx = vx + weightArch * sinr;
			vy = vy + weightArch * (sinr*sinr)/cosr;
		}
		if (weightTangent>0) {
			vx = vx + weightTangent * sin(tx)/cos(ty);
			vy = vy + weightTangent * tan(ty);
		}
		if (weightSquare>0) {
			seedSquare=random(seedSquare);
			m0=abs(seedSquare)/randomrange;
			seedSquare=random(seedSquare);
			m1=abs(seedSquare)/randomrange;
			vx = vx + weightSquare * (m0 - 0.5);
			vy = vy + weightSquare * (m1 - 0.5);
		}
		if (weightRays>0) {
			seedRays=random(seedRays);
			m0=abs(seedRays)/randomrange;
			
			ang = weightRays * m0 * pi;
			r = weightRays/(tx*tx+ty*ty + eps);
			tanr = weightRays*tan(ang)*r;
			
			vx = vx + tanr * cos(tx);
			vy = vy + tanr * sin(ty);
		}
		if (weightBlade>0) {
			seedBlade=random(seedBlade);
			m0=abs(seedBlade)/randomrange;

			r = m0 * weightBlade * precalc_sqrt;
			sinr = sin(r);
			cosr = cos(r);
			
			vx = vx + weightBlade * tx * (cosr + sinr);
			vy = vy + weightBlade * tx * (cosr - sinr);
		}
		if (weightSecant2>0) {
			r = weightSecant2 * precalc_sqrt;
			cr = cos(r);
			icr = 1.0/cr;
			
			vx = vx + weightSecant2*tx;
			
			if (cr<0) {
				vy = vy + weightSecant2*(icr + 1);
			} else {
				vy = vy + weightSecant2*(icr - 1);
			}
		}
		if (weightTwintrian>0) {
			seedTwintrian=random(seedTwintrian);
			m0=abs(seedTwintrian)/randomrange;

			r = m0 * weightTwintrian * precalc_sqrt;
			sinr = sin(r);
			cosr = cos(r);
			diff = log10(sinr*sinr)+cosr;
			
			if (diff<-1e10 || diff>1e10) {
				diff = -30;
			}
			
			vx = vx + weightTwintrian * tx * diff;
			vy = vy + weightTwintrian * tx * (diff - sinr*pi);
		}
		if (weightCross>0) {
			a = tx*tx - ty*ty;
			r = weightCross * sqrt(1.0 / (a*a+eps));
			
			vx = vx + tx * r;
			vy = vy + ty * r;
		}
		if (weightDisc2>0) {
			t = disc2_timespi * (tx + ty);
			sinr = sin(t);
			cosr = cos(t);
			r = weightDisc2 * precalc_atan / pi;
			
			vx = vx + (sinr + disc2_cosadd) * r;
			vy = vy + (cosr + disc2_sinadd) * r;
		}
		if (weightSupershape>0) {
			seedSupershape=random(seedSupershape);
			m0=abs(seedSupershape)/randomrange;

			theta = supershape_pm_4 * precalc_atanyx + pi/4;
			
			t1 = abs(cos(theta));
			t1 = t1^supershape_n2;
			
			t2 = abs(sin(theta));
			t2 = t2^supershape_n3;
			
			myrnd = supershape_rnd;
			
			r = weightSupershape * ( (myrnd*m0 + (1-myrnd)*precalc_sqrt) - supershape_holes) * (t1+t2)^supershape_pneg1_n1 / precalc_sqrt;
			
			vx = vx + r * tx;
			vy = vy + r * ty;
		}
		if (weightFlower>0) {
			seedFlower=random(seedFlower);
			m0=abs(seedFlower)/randomrange;

			theta = precalc_atanyx;
			r = weightFlower * (m0 - flower_holes)*cos(flower_petals*theta);
			
			vx = vx + r * cos(theta);
			vy = vy + r * sin(theta);
		}
		if (weightConic>0) {
			seedConic=random(seedConic);
			m0=abs(seedConic)/randomrange;

			theta = precalc_atanyx;
			r = weightConic * (m0 - conic_holes) * conic_eccen / (1 + conic_eccen*cos(theta));
			
			vx = vx + r * cos(theta);
			vy = vy + r * sin(theta);
		}
		if (weightParabola>0) {
			r = precalc_sqrt;
			seedParabola=random(seedParabola);
			m0=abs(seedParabola)/randomrange;
			seedParabola=random(seedParabola);
			m1=abs(seedParabola)/randomrange;
			
			vx = vx + parabola_height * weightParabola * sin(r) * sin(r) * m0;
			vy = vy + parabola_width * weightParabola * cos(r) * m1;
		}

		if (addTx) {
			tx=tx+vx;
			ty=ty+vy;
		} else {
			tx=vx;
			ty=vy;
		}
		
		// dann noch eine affine Transformation
		
		vx = l2_11*tx + l2_12*ty + v2_1;
		vy = l2_21*tx + l2_22*ty + v2_2;
		
		tx=vx;
		ty=vy;
		
		z = vector(tx,ty,0);
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="Superfunction";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.helpfile="formulas.html";

		addTx.caption="Add Mode";
		addTx.default=true;
		
		l1_1.caption="Matrix Row 1";
		l1_1.default=(1,0);
		l1_1.min=-10;
		l1_1.max=10;
		l1_1.randomizable=true;
		l1_1.randomizeMin=-1;
		l1_1.randomizeMax=1;
		

		l1_2.caption="Matrix Row 2";
		l1_2.default=(0,1);
		l1_2.min=-10;
		l1_2.max=10;
		l1_2.randomizable=true;
		l1_2.randomizeMin=-1;
		l1_2.randomizeMax=1;

		v1.caption="Vector";
		v1.default=(0,0);
		v1.min=-10;
		v1.max=10;
		v1.randomizable=true;
		v1.randomizeMin=-1;
		v1.randomizeMax=1;
		
		weightLinear.caption="Weight Linear";
		weightLinear.default=0;
		weightLinear.min=0;
		weightLinear.max=1;
		weightLinear.randomizable=(weightLinear>0);
		weightLinear.randomizationType=1;
		weightLinear.randomizeMin=0;
		weightLinear.randomizeMax=1;

		weightSinusoidal.caption="Weight Sinusoidal";
		weightSinusoidal.default=0;
		weightSinusoidal.min=0;
		weightSinusoidal.max=1;
		weightSinusoidal.randomizable=(weightSinusoidal>0);
		weightSinusoidal.randomizationType=1;
		weightSinusoidal.randomizeMin=0;
		weightSinusoidal.randomizeMax=1;

		weightSpherical.caption="Weight Spherical";
		weightSpherical.default=0;
		weightSpherical.min=0;
		weightSpherical.max=1;
		weightSpherical.randomizable=(weightSpherical>0);
		weightSpherical.randomizationType=1;
		weightSpherical.randomizeMin=0;
		weightSpherical.randomizeMax=1;
		
		weightSwirl.caption="Weight Swirl";
		weightSwirl.default=0;
		weightSwirl.min=0;
		weightSwirl.max=1;
		weightSwirl.randomizable=(weightSwirl>0);
		weightSwirl.randomizationType=1;
		weightSwirl.randomizeMin=0;
		weightSwirl.randomizeMax=1;
		
		weightHorseshoe.caption="Weight Horseshoe";
		weightHorseshoe.default=0;
		weightHorseshoe.min=0;
		weightHorseshoe.max=1;
		weightHorseshoe.randomizable=(weightHorseshoe>0);
		weightHorseshoe.randomizationType=1;
		weightHorseshoe.randomizeMin=0;
		weightHorseshoe.randomizeMax=1;
		
		weightPolar.caption="Weight Polar";
		weightPolar.default=0;
		weightPolar.min=0;
		weightPolar.max=1;
		weightPolar.randomizable=(weightPolar>0);
		weightPolar.randomizationType=1;
		weightPolar.randomizeMin=0;
		weightPolar.randomizeMax=1;
		
		weightHandkerchief.caption="Weight Handkerchief";
		weightHandkerchief.default=0;
		weightHandkerchief.min=0;
		weightHandkerchief.max=1;
		weightHandkerchief.randomizable=(weightHandkerchief>0);
		weightHandkerchief.randomizationType=1;
		weightHandkerchief.randomizeMin=0;
		weightHandkerchief.randomizeMax=1;
		
		weightHeart.caption="Weight Heart-Shaped Box";
		weightHeart.default=0;
		weightHeart.min=0;
		weightHeart.max=1;
		weightHeart.randomizable=(weightHeart>0);
		weightHeart.randomizationType=1;
		weightHeart.randomizeMin=0;
		weightHeart.randomizeMax=1;
		
		weightDisc.caption="Weight World in a Sphere";
		weightDisc.default=0;
		weightDisc.min=0;
		weightDisc.max=1;
		weightDisc.randomizable=(weightDisc>0);
		weightDisc.randomizationType=1;
		weightDisc.randomizeMin=0;
		weightDisc.randomizeMax=1;

		weightSpiral.caption="Weight Spiral";
		weightSpiral.default=0;
		weightSpiral.min=0;
		weightSpiral.max=1;
		weightSpiral.randomizable=(weightSpiral>0);
		weightSpiral.randomizationType=1;
		weightSpiral.randomizeMin=0;
		weightSpiral.randomizeMax=1;

		weightHyperbolic.caption="Weight Hyperbolic";
		weightHyperbolic.default=0;
		weightHyperbolic.min=0;
		weightHyperbolic.max=1;
		weightHyperbolic.randomizable=(weightHyperbolic>0);
		weightHyperbolic.randomizationType=1;
		weightHyperbolic.randomizeMin=0;
		weightHyperbolic.randomizeMax=1;
		weightHyperbolic.randomizeMin=0;
		weightHyperbolic.randomizeMax=1;

		weightDiamond.caption="Weight Diamond";
		weightDiamond.default=0;
		weightDiamond.min=0;
		weightDiamond.max=1;
		weightDiamond.randomizable=(weightDiamond>0);
		weightDiamond.randomizationType=1;
		weightDiamond.randomizeMin=0;
		weightDiamond.randomizeMax=1;

		weightEx.caption="Weight Ex";
		weightEx.default=0;
		weightEx.min=0;
		weightEx.max=1;
		weightEx.randomizable=(weightEx>0);
		weightEx.randomizationType=1;
		weightEx.randomizeMin=0;
		weightEx.randomizeMax=1;

		weightJulia.caption="Weight Julia";
		weightJulia.default=0;
		weightJulia.min=0;
		weightJulia.max=1;
		weightJulia.randomizable=(weightJulia>0);
		weightJulia.randomizationType=1;
		weightJulia.randomizeMin=0;
		weightJulia.randomizeMax=1;

		weightBent.caption="Weight Bent";
		weightBent.default=0;
		weightBent.min=0;
		weightBent.max=1;
		weightBent.randomizable=(weightBent>0);
		weightBent.randomizationType=1;
		weightBent.randomizeMin=0;
		weightBent.randomizeMax=1;

		weightWaves.caption="Weight Waves";
		weightWaves.default=0;
		weightWaves.min=0;
		weightWaves.max=1;
		weightWaves.randomizable=(weightWaves>0);
		weightWaves.randomizationType=1;
		weightWaves.randomizeMin=0;
		weightWaves.randomizeMax=1;

		weightFisheye.caption="Weight Fisheye";
		weightFisheye.default=0;
		weightFisheye.min=0;
		weightFisheye.max=1;
		weightFisheye.randomizable=(weightFisheye>0);
		weightFisheye.randomizationType=1;
		weightFisheye.randomizeMin=0;
		weightFisheye.randomizeMax=1;

		weightPopcorn.caption="Weight Popcorn";
		weightPopcorn.default=0;
		weightPopcorn.min=0;
		weightPopcorn.max=1;
		weightPopcorn.randomizable=(weightPopcorn>0);
		weightPopcorn.randomizationType=1;
		weightPopcorn.randomizeMin=0;
		weightPopcorn.randomizeMax=1;

		weightExponential.caption="Weight Exponential";
		weightExponential.default=0;
		weightExponential.min=0;
		weightExponential.max=1;
		weightExponential.randomizable=(weightExponential>0);
		weightExponential.randomizationType=1;
		weightExponential.randomizeMin=0;
		weightExponential.randomizeMax=1;

		weightPower.caption="Weight Power";
		weightPower.default=0;
		weightPower.min=0;
		weightPower.max=1;
		weightPower.randomizable=(weightPower>0);
		weightPower.randomizationType=1;
		weightPower.randomizeMin=0;
		weightPower.randomizeMax=1;

		weightCosine.caption="Weight Cosine";
		weightCosine.default=0;
		weightCosine.min=0;
		weightCosine.max=1;
		weightCosine.randomizable=(weightCosine>0);
		weightCosine.randomizationType=1;
		weightCosine.randomizeMin=0;
		weightCosine.randomizeMax=1;

		weightRings.caption="Weight Rings";
		weightRings.default=0;
		weightRings.min=0;
		weightRings.max=1;
		weightRings.randomizable=(weightRings>0);
		weightRings.randomizationType=1;
		weightRings.randomizeMin=0;
		weightRings.randomizeMax=1;

		weightFan.caption="Weight Fan";
		weightFan.default=0;
		weightFan.min=0;
		weightFan.max=1;
		weightFan.randomizable=(weightFan>0);
		weightFan.randomizationType=1;
		weightFan.randomizeMin=0;
		weightFan.randomizeMax=1;

		weightBlob.caption="Weight Blob";
		weightBlob.default=0;
		weightBlob.min=0;
		weightBlob.max=1;
		weightBlob.randomizable=(weightBlob>0);
		weightBlob.randomizationType=1;
		weightBlob.randomizeMin=0;
		weightBlob.randomizeMax=1;

		blob_high.caption="Blob high";
		blob_high.default=1;
		blob_high.min=0;
		blob_high.max=100;
		blob_high.randomizable=(weightBlob>0);
		blob_high.visible=weightBlob>0;
		blob_high.randomizeMin=0;
		blob_high.randomizeMax=2;

		blob_low.caption="Blob low";
		blob_low.default=0;
		blob_low.min=0;
		blob_low.max=100;
		blob_low.randomizable=(weightBlob>0);
		blob_low.visible=weightBlob>0;
		blob_low.randomizeMin=0;
		blob_low.randomizeMax=2;

		blob_waves.caption="Blob waves";
		blob_waves.default=1;
		blob_waves.min=0;
		blob_waves.max=100;
		blob_waves.randomizable=(weightBlob>0);
		blob_waves.visible=weightBlob>0;
		blob_waves.randomizeMin=0;
		blob_waves.randomizeMax=10;

		weightPdj.caption="Weight Pdj";
		weightPdj.default=0;
		weightPdj.min=0;
		weightPdj.max=1;
		weightPdj.randomizable=(weightPdj>0);
		weightPdj.randomizationType=1;
		weightPdj.randomizeMin=0;
		weightPdj.randomizeMax=1;
		
		pdj_a.caption="a";
		pdj_a.default=1.34;
		pdj_a.min=-100;
		pdj_a.max=100;
		pdj_a.randomizable=(weightPdj>0);
		pdj_a.visible=weightPdj>0;
		pdj_a.randomizeMin=-3;
		pdj_a.randomizeMax=3;

		pdj_b.caption="b";
		pdj_b.default=-2.71;
		pdj_b.min=-100;
		pdj_b.max=100;
		pdj_b.randomizable=(weightPdj>0);
		pdj_b.visible=weightPdj>0;
		pdj_b.randomizeMin=-3;
		pdj_b.randomizeMax=3;

		pdj_c.caption="c";
		pdj_c.default=0.34;
		pdj_c.min=-100;
		pdj_c.max=100;
		pdj_c.randomizable=(weightPdj>0);
		pdj_c.visible=weightPdj>0;
		pdj_c.randomizeMin=-3;
		pdj_c.randomizeMax=3;

		pdj_d.caption="d";
		pdj_d.default=2.19;
		pdj_d.min=-100;
		pdj_d.max=100;
		pdj_d.randomizable=(weightPdj>0);
		pdj_d.visible=weightPdj>0;
		pdj_d.randomizeMin=-3;
		pdj_d.randomizeMax=3;

		weightFan2.caption="Weight Fan2";
		weightFan2.default=0;
		weightFan2.min=0;
		weightFan2.max=1;
		weightFan2.randomizable=(weightFan2>0);
		weightFan2.randomizationType=1;
		weightFan2.randomizeMin=0;
		weightFan2.randomizeMax=1;

		fan2_x.caption="X";
		fan2_x.default=0.13;
		fan2_x.min=-1;
		fan2_x.max=1;
		fan2_x.randomizable=(weightFan2>0);
		fan2_x.visible=weightFan2>0;
		fan2_x.randomizeMin=-1;
		fan2_x.randomizeMax=1;

		fan2_y.caption="Y";
		fan2_y.default=-0.87;
		fan2_y.min=-1;
		fan2_y.max=1;
		fan2_y.randomizable=(weightFan2>0);
		fan2_y.visible=weightFan2>0;
		fan2_y.randomizeMin=-1;
		fan2_y.randomizeMax=1;
		
		weightRings2.caption="Weight Rings2";
		weightRings2.default=0;
		weightRings2.min=0;
		weightRings2.max=1;
		weightRings2.randomizable=(weightRings2>0);
		weightRings2.randomizationType=1;
		weightRings2.randomizeMin=0;
		weightRings2.randomizeMax=1;

		rings2_val.caption="p";
		rings2_val.default=1.77;
		rings2_val.min=0;
		rings2_val.max=2;
		rings2_val.randomizable=(weightRings2>0);
		rings2_val.visible=weightRings2>0;
		rings2_val.randomizeMin=0;
		rings2_val.randomizeMax=2;


		weightEyefish.caption="Weight Eyefish";
		weightEyefish.default=0;
		weightEyefish.min=0;
		weightEyefish.max=1;
		weightEyefish.randomizable=(weightEyefish>0);
		weightEyefish.randomizationType=1;
		weightEyefish.randomizeMin=0;
		weightEyefish.randomizeMax=1;

		weightBubble.caption="Weight Bubble";
		weightBubble.default=0;
		weightBubble.min=0;
		weightBubble.max=1;
		weightBubble.randomizable=(weightBubble>0);
		weightBubble.randomizationType=1;
		weightBubble.randomizeMin=0;
		weightBubble.randomizeMax=1;

		weightCylinder.caption="Weight Cylinder";
		weightCylinder.default=0;
		weightCylinder.min=0;
		weightCylinder.max=1;
		weightCylinder.randomizable=(weightCylinder>0);
		weightCylinder.randomizationType=1;
		weightCylinder.randomizeMin=0;
		weightCylinder.randomizeMax=1;

		weightPerspective.caption="Weight Perspective";
		weightPerspective.default=0;
		weightPerspective.min=0;
		weightPerspective.max=1;
		weightPerspective.randomizable=(weightPerspective>0);
		weightPerspective.randomizationType=1;
		weightPerspective.randomizeMin=0;
		weightPerspective.randomizeMax=1;

		perspective_dist.caption="Distance";
		perspective_dist.default=2;
		perspective_dist.min=1;
		perspective_dist.max=3;
		perspective_dist.randomizable=(weightPerspective>0);
		perspective_dist.visible=weightPerspective>0;
		perspective_dist.randomizeMin=1;
		perspective_dist.randomizeMax=3;

		perspective_angle.caption="Angle";
		perspective_angle.default=0.24;
		perspective_angle.min=0;
		perspective_angle.max=1;
		perspective_angle.randomizable=(weightPerspective>0);
		perspective_angle.visible=weightPerspective>0;
		perspective_angle.randomizeMin=0;
		perspective_angle.randomizeMax=1;
		
		weightNoise.caption="Weight Noise";
		weightNoise.default=0;
		weightNoise.min=0;
		weightNoise.max=1;
		weightNoise.randomizable=(weightNoise>0);
		weightNoise.randomizationType=1;
		weightNoise.randomizeMin=0;
		weightNoise.randomizeMax=1;

		weightJuliaN_generic.caption="Weight JuliaN";
		weightJuliaN_generic.default=0;
		weightJuliaN_generic.min=0;
		weightJuliaN_generic.max=1;
		weightJuliaN_generic.randomizable=(weightJuliaN_generic>0);
		weightJuliaN_generic.randomizationType=1;
		weightJuliaN_generic.randomizeMin=0;
		weightJuliaN_generic.randomizeMax=1;

		juliaN_power.caption="Power";
		juliaN_power.default=2;
		juliaN_power.min=2;
		juliaN_power.max=100;
		juliaN_power.randomizable=(weightJuliaN_generic>0);
		juliaN_power.visible=weightJuliaN_generic>0;
		juliaN_power.randomizeMin=2;
		juliaN_power.randomizeMax=12;

		juliaN_dist.caption="Distance";
		juliaN_dist.default=1;
		juliaN_dist.min=0;
		juliaN_dist.max=10;
		juliaN_dist.randomizable=(weightJuliaN_generic>0);
		juliaN_dist.visible=weightJuliaN_generic>0;
		juliaN_dist.randomizeMin=0;
		juliaN_dist.randomizeMax=10;

		weightJuliaScope_generic.caption="Weight JuliaScope_generic";
		weightJuliaScope_generic.default=0;
		weightJuliaScope_generic.min=0;
		weightJuliaScope_generic.max=1;
		weightJuliaScope_generic.randomizable=(weightJuliaScope_generic>0);
		weightJuliaScope_generic.randomizationType=1;
		weightJuliaScope_generic.randomizeMin=0;
		weightJuliaScope_generic.randomizeMax=1;

		juliaScope_power.caption="Power";
		juliaScope_power.default=2;
		juliaScope_power.min=2;
		juliaScope_power.max=100;
		juliaScope_power.randomizable=(weightJuliaScope_generic>0);
		juliaScope_power.visible=weightJuliaScope_generic>0;
		juliaScope_power.randomizeMin=2;
		juliaScope_power.randomizeMax=12;

		juliaScope_dist.caption="Distance";
		juliaScope_dist.default=1;
		juliaScope_dist.min=0;
		juliaScope_dist.max=10;
		juliaScope_dist.randomizable=(weightJuliaScope_generic>0);
		juliaScope_dist.visible=weightJuliaScope_generic>0;
		juliaScope_dist.randomizeMin=0;
		juliaScope_dist.randomizeMax=10;

		weightBlur.caption="Weight Blur";
		weightBlur.default=0;
		weightBlur.min=0;
		weightBlur.max=1;
		weightBlur.randomizable=(weightBlur>0);
		weightBlur.randomizationType=1;
		weightBlur.randomizeMin=0;
		weightBlur.randomizeMax=1;

		weightGaussian.caption="Weight Gaussian";
		weightGaussian.default=0;
		weightGaussian.min=0;
		weightGaussian.max=1;
		weightGaussian.randomizable=(weightGaussian>0);
		weightGaussian.randomizationType=1;
		weightGaussian.randomizeMin=0;
		weightGaussian.randomizeMax=1;

		weightRadial_blur.caption="Weight radial blur";
		weightRadial_blur.default=0;
		weightRadial_blur.min=0;
		weightRadial_blur.max=1;
		weightRadial_blur.randomizable=(weightRadial_blur>0);
		weightRadial_blur.randomizationType=1;
		weightRadial_blur.randomizeMin=0;
		weightRadial_blur.randomizeMax=1;

		radialBlur_angle.caption="Angle";
		radialBlur_angle.default=0.08;
		radialBlur_angle.min=0;
		radialBlur_angle.max=1;
		radialBlur_angle.randomizable=(weightRadial_blur>0);
		radialBlur_angle.visible=weightRadial_blur>0;
		radialBlur_angle.randomizeMin=0;
		radialBlur_angle.randomizeMax=1;

		weightPie.caption="Weight Pie";
		weightPie.default=0;
		weightPie.min=0;
		weightPie.max=1;
		weightPie.randomizable=(weightPie>0);
		weightPie.randomizationType=1;
		weightPie.randomizeMin=0;
		weightPie.randomizeMax=1;

		pie_slices.caption="Slices";
		pie_slices.default=3;
		pie_slices.min=0;
		pie_slices.max=10;
		pie_slices.randomizable=(weightPie>0);
		pie_slices.visible=weightPie>0;
		pie_slices.randomizeMin=0;
		pie_slices.randomizeMax=10;

		pie_thickness.caption="Thickness";
		pie_thickness.default=0.3;
		pie_thickness.min=0;
		pie_thickness.max=1;
		pie_thickness.randomizable=(weightPie>0);
		pie_thickness.visible=weightPie>0;
		pie_thickness.randomizeMin=0;
		pie_thickness.randomizeMax=1;

		pie_rotation.caption="Rotation";
		pie_rotation.default=1.0471975511965977461542144610932;
		pie_rotation.min=-100;
		pie_rotation.max=100;
		pie_rotation.randomizable=(weightPie>0);
		pie_rotation.visible=weightPie>0;
		pie_rotation.randomizeMin=-6.283185307179586476925286766559;
		pie_rotation.randomizeMax=6.283185307179586476925286766559;

		weightNgon.caption="Weight Ngon";
		weightNgon.default=0;
		weightNgon.min=0;
		weightNgon.max=1;
		weightNgon.randomizable=(weightNgon>0);
		weightNgon.randomizationType=1;
		weightNgon.randomizeMin=0;
		weightNgon.randomizeMax=1;

		ngon_sides.caption="Sides";
		ngon_sides.default=7;
		ngon_sides.min=3;
		ngon_sides.max=33;
		ngon_sides.randomizable=(weightNgon>0);
		ngon_sides.visible=weightNgon>0;
		ngon_sides.randomizeMin=3;
		ngon_sides.randomizeMax=33;

		ngon_power.caption="Power";
		ngon_power.default=3;
		ngon_power.min=1;
		ngon_power.max=10;
		ngon_power.randomizable=(weightNgon>0);
		ngon_power.visible=weightNgon>0;
		ngon_power.randomizeMin=1;
		ngon_power.randomizeMax=10;

		ngon_circle.caption="Circle";
		ngon_circle.default=1.5;
		ngon_circle.min=0;
		ngon_circle.max=3;
		ngon_circle.randomizable=(weightNgon>0);
		ngon_circle.visible=weightNgon>0;
		ngon_circle.randomizeMin=0;
		ngon_circle.randomizeMax=3;

		ngon_corners.caption="Corners";
		ngon_corners.default=0.08;
		ngon_corners.min=0;
		ngon_corners.max=6;
		ngon_corners.randomizable=(weightNgon>0);
		ngon_corners.visible=weightNgon>0;
		ngon_corners.randomizeMin=0;
		ngon_corners.randomizeMax=6;

		weightCurl.caption="Weight Curl";
		weightCurl.default=0;
		weightCurl.min=0;
		weightCurl.max=1;
		weightCurl.randomizable=(weightCurl>0);
		weightCurl.randomizationType=1;
		weightCurl.randomizeMin=0;
		weightCurl.randomizeMax=1;

		curl_c1.caption="c1";
		curl_c1.default=0.3;
		curl_c1.min=0;
		curl_c1.max=1;
		curl_c1.randomizable=(weightCurl>0);
		curl_c1.visible=weightCurl>0;
		curl_c1.randomizeMin=0;
		curl_c1.randomizeMax=1;

		curl_c2.caption="c2";
		curl_c2.default=0.6;
		curl_c2.min=0;
		curl_c2.max=1;
		curl_c2.randomizable=(weightCurl>0);
		curl_c2.visible=weightCurl>0;
		curl_c2.randomizeMin=0;
		curl_c2.randomizeMax=1;

		weightRectangles.caption="Weight Rectangles";
		weightRectangles.default=0;
		weightRectangles.min=0;
		weightRectangles.max=1;
		weightRectangles.randomizable=(weightRectangles>0);
		weightRectangles.randomizationType=1;
		weightRectangles.randomizeMin=0;
		weightRectangles.randomizeMax=1;

		rectangles_x.caption="x";
		rectangles_x.default=0.3;
		rectangles_x.min=0;
		rectangles_x.max=1;
		rectangles_x.randomizable=(weightRectangles>0);
		rectangles_x.visible=weightRectangles>0;
		rectangles_x.randomizeMin=0;
		rectangles_x.randomizeMax=1;

		rectangles_y.caption="y";
		rectangles_y.default=0.6;
		rectangles_y.min=0;
		rectangles_y.max=1;
		rectangles_y.randomizable=(weightRectangles>0);
		rectangles_y.visible=weightRectangles>0;
		rectangles_y.randomizeMin=0;
		rectangles_y.randomizeMax=1;

		weightArch.caption="Weight Arch";
		weightArch.default=0;
		weightArch.min=0;
		weightArch.max=1;
		weightArch.randomizable=(weightArch>0);
		weightArch.randomizationType=1;
		weightArch.randomizeMin=0;
		weightArch.randomizeMax=1;

		weightTangent.caption="Weight Tangent";
		weightTangent.default=0;
		weightTangent.min=0;
		weightTangent.max=1;
		weightTangent.randomizable=(weightTangent>0);
		weightTangent.randomizationType=1;
		weightTangent.randomizeMin=0;
		weightTangent.randomizeMax=1;

		weightSquare.caption="Weight Square";
		weightSquare.default=0;
		weightSquare.min=0;
		weightSquare.max=1;
		weightSquare.randomizable=(weightSquare>0);
		weightSquare.randomizationType=1;
		weightSquare.randomizeMin=0;
		weightSquare.randomizeMax=1;

		weightRays.caption="Weight Rays";
		weightRays.default=0;
		weightRays.min=0;
		weightRays.max=1;
		weightRays.randomizable=(weightRays>0);
		weightRays.randomizationType=1;
		weightRays.randomizeMin=0;
		weightRays.randomizeMax=1;

		weightBlade.caption="Weight Blade";
		weightBlade.default=0;
		weightBlade.min=0;
		weightBlade.max=1;
		weightBlade.randomizable=(weightBlade>0);
		weightBlade.randomizationType=1;
		weightBlade.randomizeMin=0;
		weightBlade.randomizeMax=1;

		weightSecant2.caption="Weight Secant2";
		weightSecant2.default=0;
		weightSecant2.min=0;
		weightSecant2.max=1;
		weightSecant2.randomizable=(weightSecant2>0);
		weightSecant2.randomizationType=1;
		weightSecant2.randomizeMin=0;
		weightSecant2.randomizeMax=1;

		weightTwintrian.caption="Weight Twintrian";
		weightTwintrian.default=0;
		weightTwintrian.min=0;
		weightTwintrian.max=1;
		weightTwintrian.randomizable=(weightTwintrian>0);
		weightTwintrian.randomizationType=1;
		weightTwintrian.randomizeMin=0;
		weightTwintrian.randomizeMax=1;

		weightCross.caption="Weight Cross";
		weightCross.default=0;
		weightCross.min=0;
		weightCross.max=1;
		weightCross.randomizable=(weightCross>0);
		weightCross.randomizationType=1;
		weightCross.randomizeMin=0;
		weightCross.randomizeMax=1;

		weightDisc2.caption="Weight Disc2";
		weightDisc2.default=0;
		weightDisc2.min=0;
		weightDisc2.max=1;
		weightDisc2.randomizable=(weightDisc2>0);
		weightDisc2.randomizationType=1;
		weightDisc2.randomizeMin=0;
		weightDisc2.randomizeMax=1;

		disc2_rot.caption="Rotation";
		disc2_rot.default=0.23;
		disc2_rot.min=0;
		disc2_rot.max=100;
		disc2_rot.randomizable=(weightDisc2>0);
		disc2_rot.visible=weightDisc2>0;
		disc2_rot.randomizeMin=0;
		disc2_rot.randomizeMax=0.5;

		disc2_twist.caption="Twist";
		disc2_twist.default=0.43;
		disc2_twist.min=-10;
		disc2_twist.max=10;
		disc2_twist.randomizable=(weightDisc2>0);
		disc2_twist.visible=weightDisc2>0;
		disc2_twist.randomizeMin=0;
		disc2_twist.randomizeMax=0.5;

		weightSupershape.caption="Weight Supershape";
		weightSupershape.default=0;
		weightSupershape.min=0;
		weightSupershape.max=1;
		weightSupershape.randomizable=(weightSupershape>0);
		weightSupershape.randomizationType=1;
		weightSupershape.randomizeMin=0;
		weightSupershape.randomizeMax=1;

		supershape_rnd.caption="Random";
		supershape_rnd.default=0.43;
		supershape_rnd.min=0;
		supershape_rnd.max=1;
		supershape_rnd.randomizable=(weightSupershape>0);
		supershape_rnd.visible=weightSupershape>0;
		supershape_rnd.randomizeMin=0;
		supershape_rnd.randomizeMax=1;

		supershape_m.caption="m";
		supershape_m.default=3;
		supershape_m.min=0;
		supershape_m.max=6;
		supershape_m.randomizable=(weightSupershape>0);
		supershape_m.visible=weightSupershape>0;
		supershape_m.randomizeMin=0;
		supershape_m.randomizeMax=6;

		supershape_n1.caption="n1";
		supershape_n1.default=23;
		supershape_n1.min=0;
		supershape_n1.max=40;
		supershape_n1.randomizable=(weightSupershape>0);
		supershape_n1.visible=weightSupershape>0;
		supershape_n1.randomizeMin=0;
		supershape_n1.randomizeMax=40;

		supershape_n2.caption="n2";
		supershape_n2.default=7;
		supershape_n2.min=0;
		supershape_n2.max=20;
		supershape_n2.randomizable=(weightSupershape>0);
		supershape_n2.visible=weightSupershape>0;
		supershape_n2.randomizeMin=0;
		supershape_n2.randomizeMax=20;

		supershape_n3.caption="n3";
		supershape_n3.default=7;
		supershape_n3.min=0;
		supershape_n3.max=20;
		supershape_n3.randomizable=(weightSupershape>0);
		supershape_n3.visible=weightSupershape>0;
		supershape_n3.randomizeMin=0;
		supershape_n3.randomizeMax=20;
		
		supershape_holes.caption="Holes";
		supershape_holes.default=17;
		supershape_holes.min=0;
		supershape_holes.max=20;
		supershape_holes.randomizable=(weightSupershape>0);
		supershape_holes.visible=weightSupershape>0;
		supershape_holes.randomizeMin=0;
		supershape_holes.randomizeMax=20;

		weightFlower.caption="Weight Flower";
		weightFlower.default=0;
		weightFlower.min=0;
		weightFlower.max=1;
		weightFlower.randomizable=(weightFlower>0);
		weightFlower.randomizationType=1;
		weightFlower.randomizeMin=0;
		weightFlower.randomizeMax=1;

		flower_petals.caption="Petals";
		flower_petals.default=2.7;
		flower_petals.min=0;
		flower_petals.max=4;
		flower_petals.randomizable=(weightFlower>0);
		flower_petals.visible=weightFlower>0;
		flower_petals.randomizeMin=0;
		flower_petals.randomizeMax=4;

		flower_holes.caption="Holes";
		flower_holes.default=0.44;
		flower_holes.min=0;
		flower_holes.max=1;
		flower_holes.randomizable=(weightFlower>0);
		flower_holes.visible=weightFlower>0;
		flower_holes.randomizeMin=0;
		flower_holes.randomizeMax=1;
	
		weightConic.caption="Weight Conic";
		weightConic.default=0;
		weightConic.min=0;
		weightConic.max=1;
		weightConic.randomizable=(weightConic>0);
		weightConic.randomizationType=1;
		weightConic.randomizeMin=0;
		weightConic.randomizeMax=1;

		conic_eccen.caption="Eccentricity";
		conic_eccen.default=0.22;
		conic_eccen.min=0;
		conic_eccen.max=1;
		conic_eccen.randomizable=(weightConic>0);
		conic_eccen.visible=weightConic>0;
		conic_eccen.randomizeMin=0;
		conic_eccen.randomizeMax=1;

		conic_holes.caption="Holes";
		conic_holes.default=0.67;
		conic_holes.min=0;
		conic_holes.max=1;
		conic_holes.randomizable=(weightConic>0);
		conic_holes.visible=weightConic>0;
		conic_holes.randomizeMin=0;
		conic_holes.randomizeMax=1;

		weightParabola.caption="Weight Parabola";
		weightParabola.default=0;
		weightParabola.min=0;
		weightParabola.max=1;
		weightParabola.randomizable=(weightParabola>0);
		weightParabola.randomizationType=1;
		weightParabola.randomizeMin=0;
		weightParabola.randomizeMax=1;

		parabola_width.caption="Width";
		parabola_width.default=1.2;
		parabola_width.min=0;
		parabola_width.max=100;
		parabola_width.randomizable=(weightParabola>0);
		parabola_width.visible=weightParabola>0;
		parabola_width.randomizeMin=0.5;
		parabola_width.randomizeMax=1.5;

		parabola_height.caption="Height";
		parabola_height.default=1.7;
		parabola_height.min=0;
		parabola_height.max=100;
		parabola_height.randomizable=(weightParabola>0);
		parabola_height.visible=weightParabola>0;
		parabola_height.randomizeMin=0.5;
		parabola_height.randomizeMax=1.5;

		l2_1.caption="Matrix Row 1";
		l2_1.default=(1,0);
		l2_1.min=-1;
		l2_1.max=1;
		l2_1.randomizable=true;
		l2_1.randomizeMin=-1;
		l2_1.randomizeMax=1;

		l2_2.caption="Matrix Row 2";
		l2_2.default=(0,1);
		l2_2.min=-1;
		l2_2.max=1;
		l2_2.randomizable=true;
		l2_2.randomizeMin=-1;
		l2_2.randomizeMax=1;

		v2.caption="Vector";
		v2.default=(0,0);
		v2.min=-1;
		v2.max=1;
		v2.randomizable=true;
		v2.randomizeMin=-1;
		v2.randomizeMax=1;
	}
}

Flame_3DFnx(ATTRACTOR)
{
real tx,ty,tz;
real vx,vy,vz;
real a,r,r1,r2,c1,c2,c3,n0,n1,n2,m0,m1,m2,nx,ny,nz,dx,dy,dz,dx2,bdiff;
real nx1,nx2,ny1,ny2,t,sinr,cosr,t_rnd,sina,cosa,tmpr,ang,tanr;
real rndG,ra,rz,tmpa,sa,ca;
real sl,cr,icr;
real r_factor,theta,phi,b,amp,diff,t1,t2,myrnd;
real l1_11,l1_12,l1_13,l1_21,l1_22,l1_23,l1_31,l1_32,l1_33;
real l2_11,l2_12,l2_13,l2_21,l2_22,l2_23,l2_31,l2_32,l2_33;
real v1_1,v1_2,v1_3,v2_1,v2_2,v2_3;
parameter int randMode;
parameter vector l1_1,l1_2,l1_3,v1,l2_1,l2_2,l2_3,v2;
parameter real weightLinear,weightSinusoidal,weightSpherical,weightSwirl,weightHorseshoe,weightPolar,weightHandkerchief,weightHeart,weightDisc;
parameter real weightSpiral,weightHyperbolic,weightDiamond,weightEx,weightJulia,weightBent,weightWaves,weightFisheye,weightPopcorn;
parameter real weightExponential,weightPower,weightCosine,weightRings,weightFan,weightBlob,weightPdj,weightFan2,weightRings2,weightEyefish,weightBubble;
parameter real weightCylinder,weightPerspective,weightNoise,weightJuliaN_generic,weightJuliaScope_generic,weightBlur,weightGaussian,weightRadial_blur;
parameter real weightPie,weightNgon,weightCurl,weightRectangles,weightArch,weightTangent,weightSquare,weightRays,weightBlade,weightSecant2;
parameter real weightTwintrian,weightCross,weightDisc2,weightSupershape,weightFlower,weightConic,weightParabola;
parameter bool addTx;
// parameters for the different transformations
parameter real blob_high,blob_low,blob_waves;
parameter real pdj_a,pdj_b,pdj_c,pdj_d;
parameter real fan2_x,fan2_y;
parameter real rings2_val;
parameter real perspective_dist,perspective_angle;
parameter int juliaN_power;
parameter real juliaN_dist;
parameter int juliaScope_power;
parameter real juliaScope_dist;
parameter real radialBlur_angle;
parameter int pie_slices;
parameter real pie_thickness,pie_rotation;
parameter int ngon_sides;
parameter real ngon_power,ngon_circle,ngon_corners;
parameter real curl_c1,curl_c2;
parameter real rectangles_x,rectangles_y;
parameter real disc2_rot,disc2_twist;
parameter int supershape_m;
parameter real supershape_rnd,supershape_n1,supershape_n2,supershape_n3,supershape_holes;
parameter real flower_petals,flower_holes;
parameter real conic_eccen,conic_holes;
parameter real parabola_width,parabola_height;
real eps;
real precalc_sqrt,precalc_atanxy,precalc_atanxz,precalc_atanyz,precalc_sina,precalc_cosa,precalc_sinb,precalc_cosb,M_1_PI,precalc_atanyx;
real seedJulia,seedNoise,seedJuliaN,seedJuliaScope,seedBlur,seedGaussian,seedRadialBlur,seedPie,seedArch,seedSquare,seedRays,seedBlade,seedTwintrian,seedSupershape,seedFlower,seedConic,seedParabola;
real waves_dx2,waves_dy2,waves_dz2;
real persp_vsin,persp_vfcos;
real juliaN_rN,juliaN_cn;
real juliaScope_rN,juliaScope_cn;
real radialBlur_spinvar,radialBlur_zoomvar;
real disc2_timespi,disc2_sinadd,disc2_cosadd;
real supershape_pm_4,supershape_pneg1_n1;

	void init(void)
	{
		eps = 1E-10;
		M_1_PI=1/pi;
		seedJulia=1526;
		seedNoise=19283;
		seedJuliaN=99182;
		seedJuliaScope=1827373;
		seedBlur=4648103;
		seedGaussian=998172;
		seedRadialBlur=3918293;
		seedPie=787776112;
		seedArch=9817272;
		seedSquare=7716276;
		seedRays=5988788;
		seedBlade=3355244;
		seedTwintrian=7988761;
		seedSupershape=8909895634;
		seedFlower=881729288;
		seedConic=7716662;
		seedParabola=988273;
		seedJulia=random(seedJulia);
		seedNoise=random(seedNoise);
		seedJuliaN=random(seedJuliaN);
		seedJuliaScope=random(seedJuliaScope);
		seedBlur=random(seedBlur);
		seedGaussian=random(seedGaussian);
		seedRadialBlur=random(seedRadialBlur);
		seedPie=random(seedPie);
		seedArch=random(seedArch);
		seedSquare=random(seedSquare);
		seedRays=random(seedRays);
		seedBlade=random(seedBlade);
		seedTwintrian=random(seedTwintrian);
		seedSupershape=random(seedSupershape);
		seedFlower=random(seedFlower);
		seedConic=random(seedConic);
		seedParabola=random(seedParabola);

		l1_11=partx(l1_1);
		l1_21=party(l1_1);
		l1_31=partz(l1_1);
		
		l1_12=partx(l1_2);
		l1_22=party(l1_2);
		l1_32=partz(l1_2);

		l1_13=partx(l1_3);
		l1_23=party(l1_3);
		l1_33=partz(l1_3);
		
		v1_1=partx(v1);
		v1_2=party(v1);
		v1_3=partz(v1);

		l2_11=partx(l2_1);
		l2_21=party(l2_1);
		l2_31=partz(l2_1);
		
		l2_12=partx(l2_2);
		l2_22=party(l2_2);
		l2_32=partz(l2_2);

		l2_13=partx(l2_3);
		l2_23=party(l2_3);
		l2_33=partz(l2_3);
		
		v2_1=partx(v2);
		v2_2=party(v2);
		v2_3=partz(v2);
		
		if (weightWaves>0) {
			waves_dx2 = 1.0/(v1_1 * v1_1 + eps);
			waves_dy2 = 1.0/(v1_2 * v1_2 + eps);
			waves_dz2 = 1.0/(v1_3 * v1_3 + eps);
		}
		if (weightPerspective>0) {
			t = perspective_angle*pi/2;
			persp_vsin = sin(t);
			persp_vfcos = perspective_dist * cos(t);
		}
		if (weightJuliaN_generic>0) {
			juliaN_rN = abs(juliaN_power);
			juliaN_cn = juliaN_dist/juliaN_power/2;
		}
		if (weightJuliaScope_generic>0) {
			juliaScope_rN = abs(juliaScope_power);
			juliaScope_cn = juliaScope_dist/juliaScope_power/2;
		}
		if (weightRadial_blur>0) {
			radialBlur_spinvar = sin(radialBlur_angle * pi / 2);
			radialBlur_zoomvar = cos(radialBlur_angle * pi / 2);
		}
		if (weightDisc2>0) {
			disc2_timespi = disc2_rot * pi;
			
			disc2_sinadd = sin(disc2_twist);
			disc2_cosadd = cos(disc2_twist) - 1;
			
			if (disc2_twist > 2 * pi) {
				a = (1 + disc2_twist - 2*pi);
				disc2_cosadd = disc2_cosadd*a;
				disc2_sinadd = disc2_sinadd*a;
			}
			
			if (disc2_twist < -2 * pi) {
				a = (1 + disc2_twist + 2*pi);
				disc2_cosadd = disc2_cosadd*a;
				disc2_sinadd = disc2_sinadd*a;
			}
		}
		if (weightSupershape>0) {
			supershape_pm_4 = supershape_m / 4.0;
			supershape_pneg1_n1 = -1.0 / supershape_n1;
		}			

		
	}
	void loop(void)
	{
		tx=partx(z);
		ty=party(z);
		tz=partz(z);
		
		// zuerst die affine Transformation
		
		vx = l1_11*tx + l1_12*ty + l1_13*tz + v1_1;
		vy = l1_21*tx + l1_22*ty + l1_23*tz + v1_2;
		vz = l1_31*tx + l1_32*ty + l1_33*tz + v1_3;
		
		tx=vx;
		ty=vy;
		tz=vz;
		
		// dann die entsprechenden anderen Transformationen
		vx = 0;
		vy = 0;
		vz = 0;
		if (weightHorseshoe>0 || weightPolar>0 || weightHandkerchief>0 || weightHeart>0 || weightDisc>0 || weightSpiral>0 || weightHyperbolic>0 || weightDiamond>0 || weightEx>0 || weightFisheye>0 || weightPower>0 || weightRings>0 || weightFan>0 || weightBlob>0 || weightFan2>0 || weightRings2>0 || weightEyefish>0 || weightRadial_blur>0 || weightBlade>0 || weightSecant2>0 || weightTwintrian>0 || weightSupershape>0 || weightParabola>0) {
			precalc_sqrt = sqrt(tx*tx + ty*ty + tz*tz);
		}
		if (weightPolar>0 || weightHandkerchief>0 || weightHeart>0 || weightDisc>0 || weightSpiral>0 || weightHyperbolic>0 || weightDiamond>0 || weightEx>0 || weightJulia>0 || weightPower>0 || weightRings>0 || weightFan>0 || weightBlob>0 || weightFan2>0 || weightRings2>0 || weightDisc2>0) {
			if (tx<-eps || tx>eps || ty<-eps || ty>eps || tz<-eps || tz>eps) {
				precalc_atanxy = atan2(ty + flip(tx));
				precalc_atanxz = atan2(tz + flip(tx));
				precalc_atanyz = atan2(tz + flip(ty));
			} else {
				precalc_atanxy=0;
				precalc_atanxy=0;
			}
			if (weightSpiral>0 || weightHyperbolic>0 || weightDiamond>0 || weightPower>0 || weightRings>0 || weightBlob>0 || weightRings2>0) {
				precalc_sina = sin(precalc_atanxy);
				precalc_cosa = cos(precalc_atanxy);
				precalc_sinb = sin(precalc_atanxz);
				precalc_cosb = cos(precalc_atanxz);
			}
		}
		if (weightJuliaN_generic>0 || weightJuliaScope_generic>0 || weightRadial_blur>0 || weightNgon>0 || weightSupershape>0 || weightFlower>0 || weightConic>0) {
			if (ty<-eps || ty>eps || tx<-eps || tx>eps) {
				precalc_atanyx = (atan2(tx + flip(ty)) + atan2(tx + flip(tz)))/2;
			} else {
				precalc_atanyx=0;
			}
		}


		
		if (weightLinear>0) {
			// linear
			vx = vx + weightLinear*tx;
			vy = vy + weightLinear*ty;
			vz = vz + weightLinear*tz;
		}
		
		if (weightSinusoidal>0) {
			// sinusoidal
			vx = vx + weightSinusoidal*sin(tx);
			vy = vy + weightSinusoidal*sin(ty);
			vy = vz + weightSinusoidal*sin(tz);
		}
		
		if (weightSpherical>0) {
			// Spherical
			r2 = weightSpherical/(tx*tx + ty*ty + tz*tz + eps);
			vx = vx + r2*tx;
			vy = vy + r2*ty;
			vz = vz + r2*tz;
		}
		
		if (weightSwirl>0) {
			// swirl
			r2 = tx*tx + ty*ty + tz*tz;
			c1 = sin(r2);
			c2 = cos(r2);
			c3 = sin(r2)*cos(r2);
			vx = vx + weightSwirl*(c1*tx - c2*ty + c3*tz);
			vy = vy + weightSwirl*(c2*tx + c3*ty - c1*tz);
			vz = vz + weightSwirl*(c3*tx + c1*ty - c2*tz);
		}
		
		if (weightHorseshoe>0) {
			// horseshoe
			r = weightHorseshoe / (precalc_sqrt + eps);
			vx = vx + (tx-ty)*(tx+ty)*r;
			vy = vy + 2*tx*ty*r;
			vz = vz - 2*tz*ty*r;
		}

      
		if (weightPolar>0) {
			// polar
			vx = vx + weightPolar * (precalc_atanxy * M_1_PI);
			vy = vy + weightPolar * (precalc_sqrt - 1.0);
			vz = vz + weightPolar * (precalc_atanxz * M_1_PI);
		}

		if (weightHandkerchief>0) {
			vx = vx + weightHandkerchief * precalc_sqrt * sin(precalc_atanxy+precalc_sqrt);
			vy = vy + weightHandkerchief * precalc_sqrt * cos(precalc_atanxy-precalc_sqrt);
			vz = vz + weightHandkerchief * precalc_sqrt * cos(precalc_atanxz-precalc_sqrt);
		}
    
		if (weightHeart>0) {
			// heart-shaped box
			a = precalc_sqrt * precalc_atanxy;
			r = weightHeart * precalc_sqrt;

			vx = vx + r * sin(a);
			vy = vy + (-r) * cos(a);
			vz = vz + r * sin(a);
		}
		
		if (weightDisc>0) {
			a = precalc_atanxy * M_1_PI;
			r = pi * precalc_sqrt;

			vx = vx + weightDisc * sin(r) * a;
			vy = vy + weightDisc * cos(r) * a;
			vz = vz + weightDisc * cos(r)*sin(r) * a;
		}
		if (weightSpiral>0) {
			r = precalc_sqrt + eps;
			r1 = weightSpiral/r;

			vx = vx + r1 * (precalc_cosa + sin(r));
			vy = vy + r1 * (precalc_sina - cos(r));
			vz = vz + r1 * (precalc_sina*precalc_sina + cos(r));
		}
		if (weightHyperbolic>0) {
			r = precalc_sqrt + eps;

			vx = vx + weightHyperbolic * precalc_sina / r;
			vy = vy + weightHyperbolic * precalc_cosa * r;
			vz = vz + weightHyperbolic * precalc_cosb * r + weightHyperbolic * precalc_sinb / r;
		}
		if (weightDiamond>0) {
			r = precalc_sqrt;

			vx = vx + weightDiamond * precalc_sina * cos(r);
			vy = vy + weightDiamond * precalc_cosa * sin(r);
			vz = vz + weightDiamond * precalc_sinb * cos(r);
		}
		if (weightEx>0) {
			a = precalc_atanxy;
			r = precalc_sqrt;

			n0 = sin(a+r);
			n1 = cos(a-r);
			n2 = sin(precalc_atanxz + r);

			m0 = n0 * n0 * n0 * r;
			m1 = n1 * n1 * n1 * r;
			m2 = n2 * n2 * n2 * r;

			vx = vx + weightEx * (m0 + m1 + m2);
			vy = vy + weightEx * (m0 - m1 - m2);
			vz = vz + weightEx * (m0 + m1 - m2);
		}
		if (weightJulia>0) {
			a = 0.5 * precalc_atanxy;
			b = 0.5 * precalc_atanxz;

			seedJulia=random(seedJulia);
			if (seedJulia>0) {
				a = a + pi;
			}
			seedJulia=random(seedJulia);
			if (seedJulia>0) {
				b = b + pi;
			}
			r = weightJulia * sqrt(sqrt(tx*tx + ty*ty + tz*tz));
			vx = vx + r * cos(a);
			vy = vy + r * sin(a);
			vz = vz + r * sin(b);
		}
		
		if (weightBent>0) {
			if (tx < 0.0) {
				n0 = tx * 2.0;
			} else {
				n0 = tx;
			}
			if (ty < 0.0) {
				n1 = ty / 2.0;
			} else {
				n1 = ty;
			}
			if (tz < 0.0) {
				n2 = tz / 2.0;
			} else {
				n2 = tz;
			}

			vx = vx + weightBent * n0;
			vy = vy + weightBent * n1;
			vz = vz + weightBent * n2;
		}
		if (weightWaves>0) {
			nx = tx + l1_12 * sin( ty * waves_dx2 );
			ny = ty + l1_22 * sin( tz * waves_dy2 );
			nz = tz + l1_32 * sin( tx * waves_dz2 );
			
			vx = vx + weightWaves * nx;
			vy = vy + weightWaves * ny;
			vz = vz + weightWaves * nz;
		}
		if (weightFisheye>0) {
			r = precalc_sqrt;
			
			r = 2 * weightFisheye / (r+1);
			
			vx = vx + r * ty + r*tz;
			vy = vy + r * tx + r*tz;
			vz = vz + r * tx + r*ty;
		}
		if (weightPopcorn>0) {
			dx = tan(3*ty);
			dy = tan(3*tx);
			dz = tan(3*tz);
			
			nx = tx + v1_1 * sin(dx);
			ny = ty + v1_2 * sin(dy);
			nz = tz + v1_3 * sin(dz);
			
			vx = vx + weightPopcorn * nx;
			vy = vy + weightPopcorn * ny;
			vz = vz + weightPopcorn * nz;
		}
		if (weightExponential>0) {
			dx = weightExponential * exp(tx - 1.0);
			dy = pi * ty;
			dz = weightExponential * exp(tz - 1.0);
			
			vx = vx + dx * cos(dy)+dz*sin(dy);
			vy = vy + dx * sin(dy)+dz*cos(dy);
			vz = vz + dy * sin(dx)+dz*sin(dx);
		}
		if (weightPower>0) {
			r = weightPower * (precalc_sqrt^precalc_sina);
			
			vx = vx + r * precalc_cosa;
			vy = vy + r * precalc_sina;
			vz = vz + r * precalc_sinb;
		}
		if (weightCosine>0) {
		   a = tx * pi;
		   nx =  cos(a) * cosh(ty);
		   ny = -sin(a) * sinh(ty);
		   nz = -cos(a) * sinh(tz);
		
		   vx = vx + weightCosine * nx;
		   vy = vy + weightCosine * ny;
		   vz = vz + weightCosine * nz;
		}
		if (weightRings>0) {
		   dx = v1_1 * v1_1 + eps;
		   r = precalc_sqrt;
		   r = weightRings * (((r+dx)%(2*dx)) - dx + r * (1 - dx));
		
		   vx = vx + r * precalc_cosa;
		   vy = vy + r * precalc_sina;
		   vz = vz + r * precalc_sinb;
		}
		if (weightFan>0) {
			dx = pi * (v1_1 * v1_1 + eps);
			dy = v1_2;
			dx2 = 0.5 * dx;
		
			a = precalc_atanxy;
			r = weightFan * precalc_sqrt;
		
			if ( (a+dy)%dx > dx2) {
				a = a-dx2;
			} else {
				a = a +dx2;
			}
		
			vx = vx + r * cos(a);
			vy = vy + r * sin(a);
			vz = vz + r * cos(a);
		}
		if (weightBlob>0) {
		   r = precalc_sqrt;
		   a = precalc_atanxy;
		   bdiff = blob_high - blob_low;
		
		   r = r * (blob_low + bdiff * (0.5 + 0.5 * sin(blob_waves * a)));
		
		   vx = vx + weightBlob * precalc_sina * r;
		   vy = vy + weightBlob * precalc_cosa * r;
		   vz = vz + weightBlob * precalc_cosb * r;
		}
		if (weightPdj>0) {
			nx1 = cos(pdj_b * tx);
			nx2 = sin(pdj_c * tx);
			ny1 = sin(pdj_a * ty);
			ny2 = cos(pdj_d * ty);
			
			vx = vx + weightPdj * (ny1 - nx1);
			vy = vy + weightPdj * (nx2 - ny2);
			vz = vz + weightPdj * (nx2 - ny1);
		}
		if (weightFan2>0) {
			dy = fan2_y;
			dx = pi * (fan2_x * fan2_x + eps);
			dx2 = 0.5 * dx;
			a = precalc_atanxy;
			r = weightFan2 * precalc_sqrt;
			
			t = a + dy - dx * trunc((a+dy)/dx);
			
			if (t>dx2) {
				a = a-dx2;
			} else {
				a = a+dx2;
			}
			
			vx = vx + r * sin(a);
			vy = vy + r * cos(a);
			vz = vz + r * cos(a);
		}
		if (weightRings2>0) {
			r = precalc_sqrt;
			dx = rings2_val * rings2_val + eps;
			
			r = r -2*dx*trunc((r+dx)/(2*dx)) + r * (1-dx);
			
			vx = vx + weightRings2 * precalc_sina * r;
			vy = vy + weightRings2 * precalc_cosa * r;
			vz = vz + weightRings2 * precalc_cosa * r;
		}
		if (weightEyefish>0) {
			r = (weightEyefish * 2.0) / (precalc_sqrt + 1.0);
			
			vx = vx + r*tx;
			vy = vy + r*ty;
			vz = vz + r*tz;
		}
		if (weightBubble>0) {
			r = weightBubble / (0.25 * (tx*tx + ty*ty + tz*tz) + 1);
			
			vx = vx + r*tx;
			vy = vy + r*ty;
			vz = vz + r*tz;
		}
		if (weightCylinder>0) {
			vx = vx + weightCylinder * sin(tx);
			vy = vy + weightCylinder * ty;
			vz = vz + weightCylinder * cos(tz);
		}
		if (weightPerspective>0) {
			t = 1.0/(perspective_dist - ty * persp_vsin + eps);
			
			vx = vx + weightPerspective * perspective_dist * tx * t;
			vy = vy + weightPerspective * persp_vfcos * ty * t;
		}
		if (weightNoise>0) {
			
			seedNoise=random(seedNoise);

			t = abs(seedNoise)/randomrange * 2 * pi;
			sinr = sin(t);
			cosr = cos(t);
			
			seedNoise=random(seedNoise);
			r = weightNoise * abs(seedNoise)/randomrange;
			
			vx = vx + tx * r * cosr;
			vy = vy + ty * r * sinr;
			vz = vz + tz * r * sinr;
		}
		if (weightJuliaN_generic>0) {
			seedJuliaN=random(seedJuliaN);

			t_rnd = trunc(juliaN_rN*abs(seedJuliaN)/randomrange);
			
			t = (precalc_atanyx + 2 * pi * t_rnd) / juliaN_power;
			
			sina = sin(t);
			cosa = cos(t);
			
			r = weightJuliaN_generic * (tx*tx + ty*ty)^juliaN_cn;
			
			vx = vx + r * cosa;
			vy = vy + r * sina;
			vz = vz + r * cosa;
		}
		if (weightJuliaScope_generic>0) {
			seedJuliaScope=random(seedJuliaScope);
			
			t_rnd = trunc(juliaScope_rN * abs(seedJuliaScope)/randomrange);
			
			if ((t_rnd%2) == 0) {
				tmpr = (2 * pi * t_rnd + precalc_atanyx) / juliaScope_power;
			} else {
				tmpr = (2 * pi * t_rnd - precalc_atanyx) / juliaScope_power;
			}
			
			sina = sin(tmpr);
			cosa = cos(tmpr);
			
			r = weightJuliaScope_generic * (tx*tx + ty*ty)^juliaScope_cn;
			
			vx = vx + r * cosa;
			vy = vy + r * sina;
			vz = vz + r * cosa;
		}
		if (weightBlur>0) {
			seedBlur=random(seedBlur);
			tmpr = abs(seedBlur)/randomrange * 2 * pi;
			sinr = sin(tmpr);
			cosr = cos(tmpr);
			
			seedBlur=random(seedBlur);
			r = weightBlur * abs(seedBlur)/randomrange;
			
			vx = vx + r * cosr;
			vy = vy + r * sinr;
			vz = vz + r * sinr;
		}
		if (weightGaussian>0) {
			seedGaussian=random(seedGaussian);
		
			ang = abs(seedGaussian)/randomrange * 2 * pi;
		
			sina = sin(ang);
			cosa = cos(ang);
		
			seedGaussian=random(seedGaussian);
			n0=abs(seedGaussian)/randomrange;
			seedGaussian=random(seedGaussian);
			n1=abs(seedGaussian)/randomrange;
			seedGaussian=random(seedGaussian);
			m0=abs(seedGaussian)/randomrange;
			seedGaussian=random(seedGaussian);
			m1=abs(seedGaussian)/randomrange;
			
		   r = weightGaussian * ( n0 + n1 + m0 + m1 - 2.0 );
		
		   vx = vx + r * cosa;
		   vy = vy + r * sina;
		   vz = vz + r * sina;
		}
		if (weightRadial_blur>0) {
			seedRadialBlur=random(seedRadialBlur);
			m0=abs(seedRadialBlur)/randomrange;
			seedRadialBlur=random(seedRadialBlur);
			m1=abs(seedRadialBlur)/randomrange;
			seedRadialBlur=random(seedRadialBlur);
			n0=abs(seedRadialBlur)/randomrange;
			seedRadialBlur=random(seedRadialBlur);
			n1=abs(seedRadialBlur)/randomrange;
			
			rndG = weightRadial_blur * (m0 + m1 + n0 + n1 - 2.0);
			
			/* Calculate angle & zoom */
			ra = precalc_sqrt;
			tmpa = precalc_atanyx + radialBlur_spinvar*rndG;
			sa = sin(tmpa);
			ca = cos(tmpa);
			rz = radialBlur_zoomvar * rndG - 1;
			
			vx = vx + ra * ca + rz * tx;
			vy = vy + ra * sa + rz * ty;
			vz = vz + ra * sa + rz * tz;
		}
		if (weightPie>0) {
			seedPie=random(seedPie);
			m0=abs(seedPie)/randomrange;
			seedPie=random(seedPie);
			m1=abs(seedPie)/randomrange;
			
			sl = trunc(m0 * pie_slices + 0.5);
			a = pie_rotation + 2*pi*(sl+m1*pie_thickness) / pie_slices;
			seedPie=random(seedPie);
			n0=abs(seedPie)/randomrange;
			r = weightPie * n0;
			
			vx = vx + r * cos(a);
			vy = vy + r * sin(a);
			vz = vz + r * sin(a);
		}
		if (weightNgon>0) {
			r_factor = (tx*tx + ty*ty)^(ngon_power/2);
			
			theta = precalc_atanyx;
			b = 2*pi/ngon_sides;
			
			phi = theta - (b*floor(theta/b));
			if (phi > b/2) {
				phi = phi - b;
			}
			
			amp = ngon_corners * (1.0 / (cos(phi) + eps) - 1.0) + ngon_circle;
			amp = amp/(r_factor + eps);
			
			vx = vx + weightNgon * tx * amp;
			vy = vy + weightNgon * ty * amp;
			vz = vz + weightNgon * tz * amp;
		}
		if (weightCurl>0) {
			nx = 1.0 + curl_c1 * tx + curl_c2 * (tx*tx - ty*ty);
			ny = curl_c1*ty + 2*curl_c2*tx*ty;
			nz = curl_c1*tz + 2*curl_c2*tz*ty;
			
			r = weightCurl / (nx*nx + ny*ny + nz*nz);
			
			vx = vx + (tx*nx + ty*ny)*r;
			vy = vy + (ty*nx - tx*ny)*r;
			vz = vz + (tz*nx - tz*ny)*r;
		}
		if (weightRectangles>0) {
			if (rectangles_x==0) {
				vx = vx + weightRectangles * tx;
			} else {
				vx = vx + weightRectangles * ((2 * floor(tx / rectangles_x) + 1) * rectangles_x - tx);
			}
			
			if (rectangles_y==0) {
				vy = vy + weightRectangles * ty;
			} else {
				vy = vy + weightRectangles * ((2 * floor(ty / rectangles_y) + 1) * rectangles_y - ty);
			}
		}
		if (weightArch>0) {
			seedArch=random(seedArch);
			m0=abs(seedArch)/randomrange;

			ang = m0 * weightArch * pi;
			sinr = sin(ang);
			cosr = cos(ang);
			
			vx = vx + weightArch * sinr;
			vy = vy + weightArch * (sinr*sinr)/cosr;
		}
		if (weightTangent>0) {
			vx = vx + weightTangent * sin(tx)/cos(ty);
			vy = vy + weightTangent * tan(ty);
		}
		if (weightSquare>0) {
			seedSquare=random(seedSquare);
			m0=abs(seedSquare)/randomrange;
			seedSquare=random(seedSquare);
			m1=abs(seedSquare)/randomrange;
			vx = vx + weightSquare * (m0 - 0.5);
			vy = vy + weightSquare * (m1 - 0.5);
		}
		if (weightRays>0) {
			seedRays=random(seedRays);
			m0=abs(seedRays)/randomrange;
			
			ang = weightRays * m0 * pi;
			r = weightRays/(tx*tx+ty*ty + eps);
			tanr = weightRays*tan(ang)*r;
			
			vx = vx + tanr * cos(tx);
			vy = vy + tanr * sin(ty);
		}
		if (weightBlade>0) {
			seedBlade=random(seedBlade);
			m0=abs(seedBlade)/randomrange;

			r = m0 * weightBlade * precalc_sqrt;
			sinr = sin(r);
			cosr = cos(r);
			
			vx = vx + weightBlade * tx * (cosr + sinr);
			vy = vy + weightBlade * tx * (cosr - sinr);
			vz = vz + weightBlade * tx * (cosr * sinr);
		}
		if (weightSecant2>0) {
			r = weightSecant2 * precalc_sqrt;
			cr = cos(r);
			icr = 1.0/cr;
			
			vx = vx + weightSecant2*tx;
			
			if (cr<0) {
				vy = vy + weightSecant2*(icr + 1);
			} else {
				vy = vy + weightSecant2*(icr - 1);
			}
		}
		if (weightTwintrian>0) {
			seedTwintrian=random(seedTwintrian);
			m0=abs(seedTwintrian)/randomrange;

			r = m0 * weightTwintrian * precalc_sqrt;
			sinr = sin(r);
			cosr = cos(r);
			diff = log10(sinr*sinr)+cosr;
			
			if (diff<-1e10 || diff>1e10) {
				diff = -30;
			}
			
			vx = vx + weightTwintrian * tx * diff;
			vy = vy + weightTwintrian * tx * (diff - sinr*pi);
		}
		if (weightCross>0) {
			a = tx*tx - ty*ty;
			r = weightCross * sqrt(1.0 / (a*a+eps));
			
			vx = vx + tx * r;
			vy = vy + ty * r;
		}
		if (weightDisc2>0) {
			t = disc2_timespi * (tx + ty);
			sinr = sin(t);
			cosr = cos(t);
			r = weightDisc2 * precalc_atanxy / pi;
			
			vx = vx + (sinr + disc2_cosadd) * r;
			vy = vy + (cosr + disc2_sinadd) * r;
		}
		if (weightSupershape>0) {
			seedSupershape=random(seedSupershape);
			m0=abs(seedSupershape)/randomrange;

			theta = supershape_pm_4 * precalc_atanyx + pi/4;
			
			t1 = abs(cos(theta));
			t1 = t1^supershape_n2;
			
			t2 = abs(sin(theta));
			t2 = t2^supershape_n3;
			
			myrnd = supershape_rnd;
			
			r = weightSupershape * ( (myrnd*m0 + (1-myrnd)*precalc_sqrt) - supershape_holes) * (t1+t2)^supershape_pneg1_n1 / precalc_sqrt;
			
			vx = vx + r * tx;
			vy = vy + r * ty;
		}
		if (weightFlower>0) {
			seedFlower=random(seedFlower);
			m0=abs(seedFlower)/randomrange;

			theta = precalc_atanyx;
			r = weightFlower * (m0 - flower_holes)*cos(flower_petals*theta);
			
			vx = vx + r * cos(theta);
			vy = vy + r * sin(theta);
		}
		if (weightConic>0) {
			seedConic=random(seedConic);
			m0=abs(seedConic)/randomrange;

			theta = precalc_atanyx;
			r = weightConic * (m0 - conic_holes) * conic_eccen / (1 + conic_eccen*cos(theta));
			
			vx = vx + r * cos(theta);
			vy = vy + r * sin(theta);
		}
		if (weightParabola>0) {
			r = precalc_sqrt;
			seedParabola=random(seedParabola);
			m0=abs(seedParabola)/randomrange;
			seedParabola=random(seedParabola);
			m1=abs(seedParabola)/randomrange;
			
			vx = vx + parabola_height * weightParabola * sin(r) * sin(r) * m0;
			vy = vy + parabola_width * weightParabola * cos(r) * m1;
		}
		if (addTx) {
			tx=tx+vx;
			ty=ty+vy;
			tz=tz+vz;
		} else {
			tx=vx;
			ty=vy;
			tz=vz;
		}
		
		// dann noch eine affine Transformation
		vx = l2_11*tx + l2_12*ty + l2_13*tz;
		vy = l2_21*tx + l2_22*ty + l2_23*tz;
		vz = l2_31*tx + l2_32*ty + l2_33*tz;
		
		z = vector(vx,vy,vz)+v2;
	}
	bool stop(void)
	{
		return(false);
	}
	void description(void)
	{
		this.title="3D Superfunction";
		this.helpfile = "ChaosPro.chm";
		this.helptopic = "Iteration Formula";
		this.helpfile="formulas.html";

		// Single mode which is currently implemented: Keep, which means: Each function whose weight is non zero should be randomized.
		randMode.caption="Randomization";
		randMode.enum="Keep";
		randMode.default=0;
		randMode.randomizable=false;
		
		addTx.caption="Add Mode";
		addTx.default=true;

		l1_1.caption="Matrix Row 1";
		l1_1.default=(1,0,0);
		l1_1.min=-1;
		l1_1.max=1;
		l1_1.randomizable=true;

		l1_2.caption="Matrix Row 2";
		l1_2.default=(0,1,0);
		l1_2.min=-1;
		l1_2.max=1;
		l1_2.randomizable=true;

		l1_3.caption="Matrix Row 3";
		l1_3.default=(0,0,1);
		l1_3.min=-1;
		l1_3.max=1;
		l1_3.randomizable=true;

		v1.caption="Vector";
		v1.default=(0,0,0);
		v1.min=-1;
		v1.max=1;
		v1.randomizable=true;
		
		weightLinear.caption="Weight Linear";
		weightLinear.default=0;
		weightLinear.min=0;
		weightLinear.max=1;
		weightLinear.randomizable=(weightLinear>0);
		weightLinear.randomizationType=1;

		weightSinusoidal.caption="Weight Sinusoidal";
		weightSinusoidal.default=0;
		weightSinusoidal.min=0;
		weightSinusoidal.max=1;
		weightSinusoidal.randomizable=(weightSinusoidal>0);
		weightSinusoidal.randomizationType=1;

		weightSpherical.caption="Weight Spherical";
		weightSpherical.default=0;
		weightSpherical.min=0;
		weightSpherical.max=1;
		weightSpherical.randomizable=(weightSpherical>0);
		weightSpherical.randomizationType=1;
		
		weightSwirl.caption="Weight Swirl";
		weightSwirl.default=0;
		weightSwirl.min=0;
		weightSwirl.max=1;
		weightSwirl.randomizable=(weightSwirl>0);
		weightSwirl.randomizationType=1;
		
		weightHorseshoe.caption="Weight Horseshoe";
		weightHorseshoe.default=0;
		weightHorseshoe.min=0;
		weightHorseshoe.max=1;
		weightHorseshoe.randomizable=(weightHorseshoe>0);
		weightHorseshoe.randomizationType=1;
		
		weightPolar.caption="Weight Polar";
		weightPolar.default=0;
		weightPolar.min=0;
		weightPolar.max=1;
		weightPolar.randomizable=(weightPolar>0);
		weightPolar.randomizationType=1;
		
		weightHandkerchief.caption="Weight Handkerchief";
		weightHandkerchief.default=0;
		weightHandkerchief.min=0;
		weightHandkerchief.max=1;
		weightHandkerchief.randomizable=(weightHandkerchief>0);
		weightHandkerchief.randomizationType=1;
		
		weightHeart.caption="Weight Heart-Shaped Box";
		weightHeart.default=0;
		weightHeart.min=0;
		weightHeart.max=1;
		weightHeart.randomizable=(weightHeart>0);
		weightHeart.randomizationType=1;
		
		weightDisc.caption="Weight World in a Sphere";
		weightDisc.default=0;
		weightDisc.min=0;
		weightDisc.max=1;
		weightDisc.randomizable=(weightDisc>0);
		weightDisc.randomizationType=1;

		weightSpiral.caption="Weight Spiral";
		weightSpiral.default=0;
		weightSpiral.min=0;
		weightSpiral.max=1;
		weightSpiral.randomizable=(weightSpiral>0);
		weightSpiral.randomizationType=1;

		weightHyperbolic.caption="Weight Hyperbolic";
		weightHyperbolic.default=0;
		weightHyperbolic.min=0;
		weightHyperbolic.max=1;
		weightHyperbolic.randomizable=(weightHyperbolic>0);
		weightHyperbolic.randomizationType=1;

		weightDiamond.caption="Weight Diamond";
		weightDiamond.default=0;
		weightDiamond.min=0;
		weightDiamond.max=1;
		weightDiamond.randomizable=(weightDiamond>0);
		weightDiamond.randomizationType=1;

		weightEx.caption="Weight Ex";
		weightEx.default=0;
		weightEx.min=0;
		weightEx.max=1;
		weightEx.randomizable=(weightEx>0);
		weightEx.randomizationType=1;

		weightJulia.caption="Weight Julia";
		weightJulia.default=0;
		weightJulia.min=0;
		weightJulia.max=1;
		weightJulia.randomizable=(weightJulia>0);
		weightJulia.randomizationType=1;

		weightBent.caption="Weight Bent";
		weightBent.default=0;
		weightBent.min=0;
		weightBent.max=1;
		weightBent.randomizable=(weightBent>0);
		weightBent.randomizationType=1;

		weightWaves.caption="Weight Waves";
		weightWaves.default=0;
		weightWaves.min=0;
		weightWaves.max=1;
		weightWaves.randomizable=(weightWaves>0);
		weightWaves.randomizationType=1;

		weightFisheye.caption="Weight Fisheye";
		weightFisheye.default=0;
		weightFisheye.min=0;
		weightFisheye.max=1;
		weightFisheye.randomizable=(weightFisheye>0);
		weightFisheye.randomizationType=1;

		weightPopcorn.caption="Weight Popcorn";
		weightPopcorn.default=0;
		weightPopcorn.min=0;
		weightPopcorn.max=1;
		weightPopcorn.randomizable=(weightPopcorn>0);
		weightPopcorn.randomizationType=1;

		weightExponential.caption="Weight Exponential";
		weightExponential.default=0;
		weightExponential.min=0;
		weightExponential.max=1;
		weightExponential.randomizable=(weightExponential>0);
		weightExponential.randomizationType=1;

		weightPower.caption="Weight Power";
		weightPower.default=0;
		weightPower.min=0;
		weightPower.max=1;
		weightPower.randomizable=(weightPower>0);
		weightPower.randomizationType=1;

		weightCosine.caption="Weight Cosine";
		weightCosine.default=0;
		weightCosine.min=0;
		weightCosine.max=1;
		weightCosine.randomizable=(weightCosine>0);
		weightCosine.randomizationType=1;

		weightRings.caption="Weight Rings";
		weightRings.default=0;
		weightRings.min=0;
		weightRings.max=1;
		weightRings.randomizable=(weightRings>0);
		weightRings.randomizationType=1;

		weightFan.caption="Weight Fan";
		weightFan.default=0;
		weightFan.min=0;
		weightFan.max=1;
		weightFan.randomizable=(weightFan>0);
		weightFan.randomizationType=1;

		weightBlob.caption="Weight Blob";
		weightBlob.default=0;
		weightBlob.min=0;
		weightBlob.max=1;
		weightBlob.randomizable=(weightBlob>0);
		weightBlob.randomizationType=1;

		blob_high.caption="Blob high";
		blob_high.default=1;
		blob_high.min=0;
		blob_high.max=2;
		blob_high.randomizable=(weightBlob>0);
		blob_high.visible=weightBlob>0;

		blob_low.caption="Blob low";
		blob_low.default=0;
		blob_low.min=0;
		blob_low.max=2;
		blob_low.randomizable=(weightBlob>0);
		blob_low.visible=weightBlob>0;

		blob_waves.caption="Blob waves";
		blob_waves.default=1;
		blob_waves.min=0;
		blob_waves.max=10;
		blob_waves.randomizable=(weightBlob>0);
		blob_waves.visible=weightBlob>0;

		weightPdj.caption="Weight Pdj";
		weightPdj.default=0;
		weightPdj.min=0;
		weightPdj.max=1;
		weightPdj.randomizable=(weightPdj>0);
		weightPdj.randomizationType=1;
		
		pdj_a.caption="a";
		pdj_a.default=1.34;
		pdj_a.min=-3;
		pdj_a.max=3;
		pdj_a.randomizable=(weightPdj>0);
		pdj_a.visible=weightPdj>0;

		pdj_b.caption="b";
		pdj_b.default=-2.71;
		pdj_b.min=-3;
		pdj_b.max=3;
		pdj_b.randomizable=(weightPdj>0);
		pdj_b.visible=weightPdj>0;

		pdj_c.caption="c";
		pdj_c.default=0.34;
		pdj_c.min=-3;
		pdj_c.max=3;
		pdj_c.randomizable=(weightPdj>0);
		pdj_c.visible=weightPdj>0;

		pdj_d.caption="d";
		pdj_d.default=2.19;
		pdj_d.min=-3;
		pdj_d.max=3;
		pdj_d.randomizable=(weightPdj>0);
		pdj_d.visible=weightPdj>0;

		weightFan2.caption="Weight Fan2";
		weightFan2.default=0;
		weightFan2.min=0;
		weightFan2.max=1;
		weightFan2.randomizable=(weightFan2>0);
		weightFan2.randomizationType=1;

		fan2_x.caption="X";
		fan2_x.default=0.13;
		fan2_x.min=-1;
		fan2_x.max=1;
		fan2_x.randomizable=(weightFan2>0);
		fan2_x.visible=weightFan2>0;

		fan2_y.caption="Y";
		fan2_y.default=-0.87;
		fan2_y.min=-1;
		fan2_y.max=1;
		fan2_y.randomizable=(weightFan2>0);
		fan2_y.visible=weightFan2>0;
		
		weightRings2.caption="Weight Rings2";
		weightRings2.default=0;
		weightRings2.min=0;
		weightRings2.max=1;
		weightRings2.randomizable=(weightRings2>0);
		weightRings2.randomizationType=1;

		rings2_val.caption="p";
		rings2_val.default=1.77;
		rings2_val.min=0;
		rings2_val.max=2;
		rings2_val.randomizable=(weightRings2>0);
		rings2_val.visible=weightRings2>0;


		weightEyefish.caption="Weight Eyefish";
		weightEyefish.default=0;
		weightEyefish.min=0;
		weightEyefish.max=1;
		weightEyefish.randomizable=(weightEyefish>0);
		weightEyefish.randomizationType=1;

		weightBubble.caption="Weight Bubble";
		weightBubble.default=0;
		weightBubble.min=0;
		weightBubble.max=1;
		weightBubble.randomizable=(weightBubble>0);
		weightBubble.randomizationType=1;

		weightCylinder.caption="Weight Cylinder";
		weightCylinder.default=0;
		weightCylinder.min=0;
		weightCylinder.max=1;
		weightCylinder.randomizable=(weightCylinder>0);
		weightCylinder.randomizationType=1;

		weightPerspective.caption="Weight Perspective";
		weightPerspective.default=0;
		weightPerspective.min=0;
		weightPerspective.max=1;
		weightPerspective.randomizable=(weightPerspective>0);
		weightPerspective.randomizationType=1;

		perspective_dist.caption="Distance";
		perspective_dist.default=2;
		perspective_dist.min=1;
		perspective_dist.max=3;
		perspective_dist.randomizable=(weightPerspective>0);
		perspective_dist.visible=weightPerspective>0;

		perspective_angle.caption="Angle";
		perspective_angle.default=0.24;
		perspective_angle.min=0;
		perspective_angle.max=1;
		perspective_angle.randomizable=(weightPerspective>0);
		perspective_angle.visible=weightPerspective>0;
		
		weightNoise.caption="Weight Noise";
		weightNoise.default=0;
		weightNoise.min=0;
		weightNoise.max=1;
		weightNoise.randomizable=(weightNoise>0);
		weightNoise.randomizationType=1;

		weightJuliaN_generic.caption="Weight JuliaN";
		weightJuliaN_generic.default=0;
		weightJuliaN_generic.min=0;
		weightJuliaN_generic.max=1;
		weightJuliaN_generic.randomizable=(weightJuliaN_generic>0);
		weightJuliaN_generic.randomizationType=1;

		juliaN_power.caption="Power";
		juliaN_power.default=2;
		juliaN_power.min=2;
		juliaN_power.max=12;
		juliaN_power.randomizable=(weightJuliaN_generic>0);
		juliaN_power.visible=weightJuliaN_generic>0;

		juliaN_dist.caption="Distance";
		juliaN_dist.default=1;
		juliaN_dist.min=0;
		juliaN_dist.max=10;
		juliaN_dist.randomizable=(weightJuliaN_generic>0);
		juliaN_dist.visible=weightJuliaN_generic>0;

		weightJuliaScope_generic.caption="Weight JuliaScope_generic";
		weightJuliaScope_generic.default=0;
		weightJuliaScope_generic.min=0;
		weightJuliaScope_generic.max=1;
		weightJuliaScope_generic.randomizable=(weightJuliaScope_generic>0);
		weightJuliaScope_generic.randomizationType=1;

		juliaScope_power.caption="Power";
		juliaScope_power.default=2;
		juliaScope_power.min=2;
		juliaScope_power.max=12;
		juliaScope_power.randomizable=(weightJuliaScope_generic>0);
		juliaScope_power.visible=weightJuliaScope_generic>0;

		juliaScope_dist.caption="Distance";
		juliaScope_dist.default=1;
		juliaScope_dist.min=0;
		juliaScope_dist.max=10;
		juliaScope_dist.randomizable=(weightJuliaScope_generic>0);
		juliaScope_dist.visible=weightJuliaScope_generic>0;

		weightBlur.caption="Weight Blur";
		weightBlur.default=0;
		weightBlur.min=0;
		weightBlur.max=1;
		weightBlur.randomizable=(weightBlur>0);
		weightBlur.randomizationType=1;

		weightGaussian.caption="Weight Gaussian";
		weightGaussian.default=0;
		weightGaussian.min=0;
		weightGaussian.max=1;
		weightGaussian.randomizable=(weightGaussian>0);
		weightGaussian.randomizationType=1;

		weightRadial_blur.caption="Weight radial blur";
		weightRadial_blur.default=0;
		weightRadial_blur.min=0;
		weightRadial_blur.max=1;
		weightRadial_blur.randomizable=(weightRadial_blur>0);
		weightRadial_blur.randomizationType=1;

		radialBlur_angle.caption="Angle";
		radialBlur_angle.default=0.08;
		radialBlur_angle.min=0;
		radialBlur_angle.max=1;
		radialBlur_angle.randomizable=(weightRadial_blur>0);
		radialBlur_angle.visible=weightRadial_blur>0;

		weightPie.caption="Weight Pie";
		weightPie.default=0;
		weightPie.min=0;
		weightPie.max=1;
		weightPie.randomizable=(weightPie>0);
		weightPie.randomizationType=1;

		pie_slices.caption="Slices";
		pie_slices.default=3;
		pie_slices.min=0;
		pie_slices.max=10;
		pie_slices.randomizable=(weightPie>0);
		pie_slices.visible=weightPie>0;

		pie_thickness.caption="Thickness";
		pie_thickness.default=0.3;
		pie_thickness.min=0;
		pie_thickness.max=1;
		pie_thickness.randomizable=(weightPie>0);
		pie_thickness.visible=weightPie>0;

		pie_rotation.caption="Rotation";
		pie_rotation.default=1.0471975511965977461542144610932;
		pie_rotation.min=-6.283185307179586476925286766559;
		pie_rotation.max=6.283185307179586476925286766559;
		pie_rotation.randomizable=(weightPie>0);
		pie_rotation.visible=weightPie>0;

		weightNgon.caption="Weight Ngon";
		weightNgon.default=0;
		weightNgon.min=0;
		weightNgon.max=1;
		weightNgon.randomizable=(weightNgon>0);
		weightNgon.randomizationType=1;

		ngon_sides.caption="Sides";
		ngon_sides.default=7;
		ngon_sides.min=3;
		ngon_sides.max=33;
		ngon_sides.randomizable=(weightNgon>0);
		ngon_sides.visible=weightNgon>0;

		ngon_power.caption="Power";
		ngon_power.default=3;
		ngon_power.min=1;
		ngon_power.max=10;
		ngon_power.randomizable=(weightNgon>0);
		ngon_power.visible=weightNgon>0;

		ngon_circle.caption="Circle";
		ngon_circle.default=1.5;
		ngon_circle.min=0;
		ngon_circle.max=3;
		ngon_circle.randomizable=(weightNgon>0);
		ngon_circle.visible=weightNgon>0;

		ngon_corners.caption="Corners";
		ngon_corners.default=0.08;
		ngon_corners.min=0;
		ngon_corners.max=6;
		ngon_corners.randomizable=(weightNgon>0);
		ngon_corners.visible=weightNgon>0;

		weightCurl.caption="Weight Curl";
		weightCurl.default=0;
		weightCurl.min=0;
		weightCurl.max=1;
		weightCurl.randomizable=(weightCurl>0);
		weightCurl.randomizationType=1;

		curl_c1.caption="c1";
		curl_c1.default=0.3;
		curl_c1.min=0;
		curl_c1.max=1;
		curl_c1.randomizable=(weightCurl>0);
		curl_c1.visible=weightCurl>0;

		curl_c2.caption="c2";
		curl_c2.default=0.6;
		curl_c2.min=0;
		curl_c2.max=1;
		curl_c2.randomizable=(weightCurl>0);
		curl_c2.visible=weightCurl>0;

		weightRectangles.caption="Weight Rectangles";
		weightRectangles.default=0;
		weightRectangles.min=0;
		weightRectangles.max=1;
		weightRectangles.randomizable=(weightRectangles>0);
		weightRectangles.randomizationType=1;

		rectangles_x.caption="x";
		rectangles_x.default=0.3;
		rectangles_x.min=0;
		rectangles_x.max=1;
		rectangles_x.randomizable=(weightRectangles>0);
		rectangles_x.visible=weightRectangles>0;

		rectangles_y.caption="y";
		rectangles_y.default=0.6;
		rectangles_y.min=0;
		rectangles_y.max=1;
		rectangles_y.randomizable=(weightRectangles>0);
		rectangles_y.visible=weightRectangles>0;

		weightArch.caption="Weight Arch";
		weightArch.default=0;
		weightArch.min=0;
		weightArch.max=1;
		weightArch.randomizable=(weightArch>0);
		weightArch.randomizationType=1;

		weightTangent.caption="Weight Tangent";
		weightTangent.default=0;
		weightTangent.min=0;
		weightTangent.max=1;
		weightTangent.randomizable=(weightTangent>0);
		weightTangent.randomizationType=1;

		weightSquare.caption="Weight Square";
		weightSquare.default=0;
		weightSquare.min=0;
		weightSquare.max=1;
		weightSquare.randomizable=(weightSquare>0);
		weightSquare.randomizationType=1;

		weightRays.caption="Weight Rays";
		weightRays.default=0;
		weightRays.min=0;
		weightRays.max=1;
		weightRays.randomizable=(weightRays>0);
		weightRays.randomizationType=1;

		weightBlade.caption="Weight Blade";
		weightBlade.default=0;
		weightBlade.min=0;
		weightBlade.max=1;
		weightBlade.randomizable=(weightBlade>0);
		weightBlade.randomizationType=1;

		weightSecant2.caption="Weight Secant2";
		weightSecant2.default=0;
		weightSecant2.min=0;
		weightSecant2.max=1;
		weightSecant2.randomizable=(weightSecant2>0);
		weightSecant2.randomizationType=1;

		weightTwintrian.caption="Weight Twintrian";
		weightTwintrian.default=0;
		weightTwintrian.min=0;
		weightTwintrian.max=1;
		weightTwintrian.randomizable=(weightTwintrian>0);
		weightTwintrian.randomizationType=1;

		weightCross.caption="Weight Cross";
		weightCross.default=0;
		weightCross.min=0;
		weightCross.max=1;
		weightCross.randomizable=(weightCross>0);
		weightCross.randomizationType=1;

		weightDisc2.caption="Weight Disc2";
		weightDisc2.default=0;
		weightDisc2.min=0;
		weightDisc2.max=1;
		weightDisc2.randomizable=(weightDisc2>0);
		weightDisc2.randomizationType=1;

		disc2_rot.caption="Rotation";
		disc2_rot.default=0.23;
		disc2_rot.min=0;
		disc2_rot.max=0.5;
		disc2_rot.randomizable=(weightDisc2>0);
		disc2_rot.visible=weightDisc2>0;

		disc2_twist.caption="Twist";
		disc2_twist.default=0.43;
		disc2_twist.min=0;
		disc2_twist.max=0.5;
		disc2_twist.randomizable=(weightDisc2>0);
		disc2_twist.visible=weightDisc2>0;

		weightSupershape.caption="Weight Supershape";
		weightSupershape.default=0;
		weightSupershape.min=0;
		weightSupershape.max=1;
		weightSupershape.randomizable=(weightSupershape>0);
		weightSupershape.randomizationType=1;

		supershape_rnd.caption="Random";
		supershape_rnd.default=0.43;
		supershape_rnd.min=0;
		supershape_rnd.max=1;
		supershape_rnd.randomizable=(weightSupershape>0);
		supershape_rnd.visible=weightSupershape>0;

		supershape_m.caption="m";
		supershape_m.default=3;
		supershape_m.min=0;
		supershape_m.max=6;
		supershape_m.randomizable=(weightSupershape>0);
		supershape_m.visible=weightSupershape>0;

		supershape_n1.caption="n1";
		supershape_n1.default=23;
		supershape_n1.min=0;
		supershape_n1.max=40;
		supershape_n1.randomizable=(weightSupershape>0);
		supershape_n1.visible=weightSupershape>0;

		supershape_n2.caption="n2";
		supershape_n2.default=7;
		supershape_n2.min=0;
		supershape_n2.max=20;
		supershape_n2.randomizable=(weightSupershape>0);
		supershape_n2.visible=weightSupershape>0;

		supershape_n3.caption="n3";
		supershape_n3.default=7;
		supershape_n3.min=0;
		supershape_n3.max=20;
		supershape_n3.randomizable=(weightSupershape>0);
		supershape_n3.visible=weightSupershape>0;
		
		supershape_holes.caption="Holes";
		supershape_holes.default=17;
		supershape_holes.min=0;
		supershape_holes.max=20;
		supershape_holes.randomizable=(weightSupershape>0);
		supershape_holes.visible=weightSupershape>0;

		weightFlower.caption="Weight Flower";
		weightFlower.default=0;
		weightFlower.min=0;
		weightFlower.max=1;
		weightFlower.randomizable=(weightFlower>0);
		weightFlower.randomizationType=1;

		flower_petals.caption="Petals";
		flower_petals.default=2.7;
		flower_petals.min=0;
		flower_petals.max=4;
		flower_petals.randomizable=(weightFlower>0);
		flower_petals.visible=weightFlower>0;

		flower_holes.caption="Holes";
		flower_holes.default=0.44;
		flower_holes.min=0;
		flower_holes.max=1;
		flower_holes.randomizable=(weightFlower>0);
		flower_holes.visible=weightFlower>0;
		
		weightConic.caption="Weight Conic";
		weightConic.default=0;
		weightConic.min=0;
		weightConic.max=1;
		weightConic.randomizable=(weightConic>0);
		weightConic.randomizationType=1;

		conic_eccen.caption="Eccentricity";
		conic_eccen.default=0.22;
		conic_eccen.min=0;
		conic_eccen.max=1;
		conic_eccen.randomizable=(weightConic>0);
		conic_eccen.visible=weightConic>0;

		conic_holes.caption="Holes";
		conic_holes.default=0.67;
		conic_holes.min=0;
		conic_holes.max=1;
		conic_holes.randomizable=(weightConic>0);
		conic_holes.visible=weightConic>0;

		weightParabola.caption="Weight Parabola";
		weightParabola.default=0;
		weightParabola.min=0;
		weightParabola.max=1;
		weightParabola.randomizable=(weightParabola>0);
		weightParabola.randomizationType=1;

		parabola_width.caption="Width";
		parabola_width.default=1.2;
		parabola_width.min=0.5;
		parabola_width.max=1.5;
		parabola_width.randomizable=(weightParabola>0);
		parabola_width.visible=weightParabola>0;

		parabola_height.caption="Height";
		parabola_height.default=1.7;
		parabola_height.min=0.5;
		parabola_height.max=1.5;
		parabola_height.randomizable=(weightParabola>0);
		parabola_height.visible=weightParabola>0;

		l2_1.caption="Matrix Row 1";
		l2_1.default=(1,0,0);
		l2_1.min=-1;
		l2_1.max=1;
		l2_1.randomizable=true;

		l2_2.caption="Matrix Row 2";
		l2_2.default=(0,1,0);
		l2_2.min=-1;
		l2_2.max=1;
		l2_2.randomizable=true;

		l2_3.caption="Matrix Row 3";
		l2_3.default=(0,0,1);
		l2_3.min=-1;
		l2_3.max=1;
		l2_3.randomizable=true;

		v2.caption="Vector";
		v2.default=(0,0,0);
		v2.min=-1;
		v2.max=1;
		v2.randomizable=true;
	}
}






