comment
{
  Just a test formula for distance estimation
}

Mandel3DDE_MP_TEST(QUATERNION) {
parameter int n;
parameter real bailout;
parameter complex ep;
real sx,sy,sz;
real dzx,dzy,dzz,Rdz,thdz,phdz;
real nx,ny,nz,nw;
real r,theta,phi,r2,r3,a,b;
real rp2,rp4;
real pixelr,pixeli,pixelj;
parameter complex a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19,a20;
quaternion p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,p20;
int ex,ey;
parameter real threshold;

	void debugDistances(void)
	{
		if (real(screenpixel)==ex && imag(screenpixel)==ey) {
			if (currentRayIndex==0) {
				a1=complex(a,0.3);
				p1=pixel;
			} else if (currentRayIndex==1) {
				a2=complex(a,0.3);
				p2=pixel;
			} else if (currentRayIndex==2) {
				a3=complex(a,0.3);
				p3=pixel;
			} else if (currentRayIndex==3) {
				a4=complex(a,0.3);
				p4=pixel;
			} else if (currentRayIndex==4) {
				a5=complex(a,0.3);
				p5=pixel;
			} else if (currentRayIndex==5) {
				a6=complex(a,0.3);
				p6=pixel;
			} else if (currentRayIndex==6) {
				a7=complex(a,0.3);
				p7=pixel;
			} else if (currentRayIndex==7) {
				a8=complex(a,0.3);
				p8=pixel;
			} else if (currentRayIndex==8) {
				a9=complex(a,0.3);
				p9=pixel;
			} else if (currentRayIndex==9) {
				a10=complex(a,0.3);
				p10=pixel;
			} else if (currentRayIndex==10) {
				a11=complex(a,0.3);
				p11=pixel;
			} else if (currentRayIndex==11) {
				a12=complex(a,0.3);
				p12=pixel;
			} else if (currentRayIndex==12) {
				a13=complex(a,0.3);
				p13=pixel;
			} else if (currentRayIndex==13) {
				a14=complex(a,0.3);
				p14=pixel;
			} else if (currentRayIndex==14) {
				a15=complex(a,0.3);
				p15=pixel;
			} else if (currentRayIndex==15) {
				a16=complex(a,0.3);
				p16=pixel;
			} else if (currentRayIndex==16) {
				a17=complex(a,0.3);
				p17=pixel;
			} else if (currentRayIndex==17) {
				a18=complex(a,0.3);
				p18=pixel;
			} else if (currentRayIndex==18) {
				a19=complex(a,0.3);
				p19=pixel;
			} else if (currentRayIndex==19) {
				a20=complex(a,0.3);
				p20=pixel;
			}
			if (hasBeenHit) {
				// Object hit!
				a1=real(a1)+flip(cabs(p1-pixel));
				a2=real(a2)+flip(cabs(p2-pixel));
				a3=real(a3)+flip(cabs(p3-pixel));
				a4=real(a4)+flip(cabs(p4-pixel));
				a5=real(a5)+flip(cabs(p5-pixel));
				a6=real(a6)+flip(cabs(p6-pixel));
				a7=real(a7)+flip(cabs(p7-pixel));
				a8=real(a8)+flip(cabs(p8-pixel));
				a9=real(a9)+flip(cabs(p9-pixel));
				a10=real(a10)+flip(cabs(p10-pixel));
				a11=real(a11)+flip(cabs(p11-pixel));
				a12=real(a12)+flip(cabs(p12-pixel));
				a13=real(a13)+flip(cabs(p13-pixel));
				a14=real(a14)+flip(cabs(p14-pixel));
				a15=real(a15)+flip(cabs(p15-pixel));
				a16=real(a16)+flip(cabs(p16-pixel));
				a17=real(a17)+flip(cabs(p17-pixel));
				a18=real(a18)+flip(cabs(p18-pixel));
				a19=real(a19)+flip(cabs(p19-pixel));
				a20=real(a20)+flip(cabs(p20-pixel));
			}
		}
	}

	void init(void)
	{
		// prevent compiler from eliminating parameter variables a1 to a20 (read from them)
		z=a1+a2+a3+a4+a5+a6+a7+a8+a9+a10+a11+a12+a13+a14+a15+a16+a17+a18+a19+a20;
		z=quaternion(0,0,0,0);
		
		// we basically iterate sx/sy/sz instead of z...
		sx=part_r(z);
		sy=part_i(z);
		sz=part_j(z);

		pixelr=part_r(pixel);
		pixeli=part_i(pixel);
		pixelj=part_j(pixel);
		dzx=1;
		dzy=0;
		dzz=0;
		ex=real(ep);
		ey=imag(ep);
	}
	void loop(void)
	{
		// Let's iterate dzx/dzy/dzz: First calculate the coords of it
		Rdz=sqrt(dzx*dzx+dzy*dzy+dzz*dzz);
		thdz=atan2(sqrt(dzx^2+dzy^2)+flip(dzz));
		phdz=atan2(dzy+flip(dzx));

		// Let's iterate dzx/dzy/dzz: Now calculate some intermediate values
		r2=sqrt(sx^2+sy^2+sz^2);
		theta=atan2(sqrt(sx^2+sy^2)+flip(sz));
		phi=atan2(sy+flip(sx));
		rp2=r2^2;
		rp4=rp2^2;
		r=8*rp4*rp2*r2*Rdz;
			
		rp2=sin(thdz+7*theta);

		// Let's iterate dzx/dzy/dzz: And finally assign the new values to dzx/dzy/dzz
		dzx= r*rp2*cos(phdz+7*phi)+1;
		dzy= r*rp2*sin(phdz+7*phi);
		dzz= r*cos(thdz+7*theta);
		
		// Iterate sx/sy/sz (i.e. z itself): Calculate intermediate values
		r3=sqr(sqr(sqr(r2)));
		rp2=sin(n*theta);
		// Iterate sx/sy/sz (i.e. z itself): Calculate new values
		nx=r3*rp2*cos(n*phi);
		ny=r3*rp2*sin(n*phi);
		nz=r3*cos(n*theta);
		
		// Iterate sx/sy/sz (i.e. z itself): Assign them!
		sx=nx+pixelr;
		sy=ny+pixeli;
		sz=nz+pixelj;

		// Now distance estimation: In case the pixel bailed out, calculate distance
		if (sx*sx+sy*sy+sz*sz>bailout) {

			// Some experiments from me...none of these works perfectly...feel free to experiment
			
			//a=r2*0.1*log(r2)/Rdz;
			// r2=sqrt(sx^2+sy^2+sz^2);
			//a=sqrt(|r2|/|Rdz|);
			a = 0.2*sqrt(7)*log(r2)*sqrt(r2)/Rdz;
			//a = 0.1*log(bailout)*log(r2)*sqrt(r2)/(Rdz);
			
			// Done distance estimation...now just compare with the threshold...setting it to 0 tells ChaosPro
			// that object has been hit (same as if maxiter has been reached)
			if (a<threshold) {
				a=0;
			}
			// assign it to the final variable...
			estimatedDistance=a;
			
			// and now for displaying the distances...this is only for debugging purposes...
			debugDistances();
		}
		z=quaternion(sx,sy,sz,0);
	}
	bool bailout(void)
	{
		return(sx*sx+sy*sy+sz*sz<bailout);
	}

	void description(void)
	{
		this.title = "Mandel 3D DE";

		bailout.caption = "Bailout Value";
		bailout.default = 4.0;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.";
		
		n.caption="Power";
		n.default=3;
		n.min=2;
		n.hint="Power: Choose 3 to 8 for faster calculation";
		
		threshold.caption="Threshold";
		threshold.default=0.001;
		threshold.min=0;
		threshold.max=10000;

		separator.exam.caption="Estimated distances";

		ep.caption="Pixel to examine";
		ep.hint="Specifies the window pixel which should be examined: Specified in coordinates from 0/0=bottom left corner upto width/height, for example 240/240 is the center";
		
		a1.caption="Loop 1: E<>A";
		a1.hint="Estimated distance compared to real distance";
		a2.caption="Loop 2: E<>A";
		a2.hint="Estimated distance compared to real distance";
		a3.caption="Loop 3: E<>A";
		a3.hint="Estimated distance compared to real distance";
		a4.caption="Loop 4: E<>A";
		a4.hint="Estimated distance compared to real distance";
		a5.caption="Loop 5: E<>A";
		a5.hint="Estimated distance compared to real distance";
		a6.caption="Loop 6: E<>A";
		a6.hint="Estimated distance compared to real distance";
		a7.caption="Loop 7: E<>A";
		a7.hint="Estimated distance compared to real distance";
		a8.caption="Loop 8: E<>A";
		a8.hint="Estimated distance compared to real distance";
		a9.caption="Loop 9: E<>A";
		a9.hint="Estimated distance compared to real distance";
		a10.caption="Loop 10: E<>A";
		a10.hint="Estimated distance compared to real distance";
		a11.caption="Loop 11: E<>A";
		a11.hint="Estimated distance compared to real distance";
		a12.caption="Loop 12: E<>A";
		a12.hint="Estimated distance compared to real distance";
		a13.caption="Loop 13: E<>A";
		a13.hint="Estimated distance compared to real distance";
		a14.caption="Loop 14: E<>A";
		a14.hint="Estimated distance compared to real distance";
		a15.caption="Loop 15: E<>A";
		a15.hint="Estimated distance compared to real distance";
		a16.caption="Loop 16: E<>A";
		a16.hint="Estimated distance compared to real distance";
		a17.caption="Loop 17: E<>A";
		a17.hint="Estimated distance compared to real distance";
		a18.caption="Loop 18: E<>A";
		a18.hint="Estimated distance compared to real distance";
		a19.caption="Loop 19: E<>A";
		a19.hint="Estimated distance compared to real distance";
		a20.caption="Loop 20: E<>A";
		a20.hint="Estimated distance compared to real distance";
	}
}
